/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.jobexecutor;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfDBUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cache.WfCacheHelper;
import kd.bos.workflow.engine.impl.cmd.job.JobHandleStrategyFactory;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobStateEnum;
import kd.bos.workflow.engine.runtime.ExecuteJob;
import kd.bos.workflow.relservice.BusinessObjectQueryHelper;

public class JobDAO {
    private static final String FBIZTRACENO = " FBIZTRACENO";
    private static final String KEYWORD_UPDATE = "update ";
    private static final String KEY_WHERE_FID = " where fid = ?";
    private static final String KEYWORD_FROM = " from ";
    private static final String FIELD_FRETRIES = "  FRETRIES,";
    private static final String FIELD_FEXECUTOR = "  FEXECUTOR,";
    private static final String FIELD_FROOTJOBID = "  FROOTJOBID,";
    private static final String FIELD_FSOURCE = "  FSOURCE,";
    private static final String FIELD_FSTATE = "  FSTATE,";
    private static final String FIELD_FROOTTRACENO = "  FROOTTRACENO,";
    private static final String FIELD_FMODIFYDATE = "  FMODIFYDATE,";
    private static final String FIELD_FCREATEDATE = "  FCREATEDATE,";
    private static final String FIELD_FELEMENTID = "  FELEMENTID,";
    private static final String FIELD_FENTITYNUMBER = "  FENTITYNUMBER,";
    private static final String FIELD_FOPERATION = "  FOPERATION,";
    private static final String FIELD_FBUSINESSKEY = "  FBUSINESSKEY,";
    private static final String FIELD_FHANDLERCFG = "  FHANDLERCFG,";
    private static final String FIELD_FHANDLERTYPE = "  FHANDLERTYPE,";
    private static final String FIELD_FEXCEPTIONMSG = "  FEXCEPTIONMSG,";
    private static final String FIELD_FPROCDEFID = "  FPROCDEFID,";
    private static final String FIELD_FPROCESSINSTANCEID = "  FPROCESSINSTANCEID,";
    private static final String FIELD_FEXECUTIONID = "  FEXECUTIONID,";
    private static final String FIELD_FLOCKOWNERID = "  FLOCKOWNERID,";
    private static final String FIELD_FLOCKEXPTIME = "  FLOCKEXPTIME,";
    private static final String FIELD_FTYPE = "  FTYPE,";
    private static final String FIELD_FID = "  FID,";
    protected static Log logger = LogFactory.getLog(JobDAO.class);
    public static final String JOBTABLENAME = "t_wf_jobrecord";
    private static final String CREATEJOBSQL = "CREATE TABLE t_wf_jobrecord (  FID bigint NOT NULL DEFAULT 0,  FTYPE varchar(30) NOT NULL DEFAULT ' ',  FLOCKEXPTIME datetime DEFAULT NULL,  FLOCKOWNERID varchar(100) NOT NULL DEFAULT ' ',  FEXCLUSIVE char(1) DEFAULT NULL,  FEXECUTIONID bigint NOT NULL DEFAULT 0,  FPROCESSINSTANCEID bigint NOT NULL DEFAULT 0,  FPROCDEFID bigint NOT NULL DEFAULT 0,  FRETRIES int NOT NULL DEFAULT 3,  FEXCEPTIONMSG NCLOB ,  FDUEDATE datetime DEFAULT NULL,    FREPEAT varchar(30) NOT NULL DEFAULT ' ',  FHANDLERTYPE varchar(30) NOT NULL DEFAULT ' ',  FHANDLERCFG NCLOB,  FBUSINESSKEY varchar(36) NOT NULL DEFAULT ' ',  FOPERATION varchar(100) NOT NULL DEFAULT ' ',  FENTITYNUMBER varchar(50) NOT NULL DEFAULT ' ',  FELEMENTID varchar(80) NOT NULL DEFAULT ' ',  FCREATEDATE datetime DEFAULT NULL,  FMODIFYDATE datetime DEFAULT NULL,  FSRCJOBID bigint NOT NULL DEFAULT 0,  FROOTTRACENO varchar(100) NOT NULL DEFAULT ' ',  FExecutor varchar(100) NOT NULL DEFAULT ' ',  FSUCCESS char(1) NOT NULL DEFAULT '0',  fendtime datetime DEFAULT NULL,  fduration bigint NOT NULL DEFAULT 0,  fstate varchar(100) NOT NULL DEFAULT ' ',  FSOURCE varchar(100) NOT NULL DEFAULT ' ',  FROOTJOBID bigint NOT NULL DEFAULT 0,  FBIZTRACENO varchar(255) NOT NULL DEFAULT ' ',  FORGUNITID BIGINT NOT NULL DEFAULT 0 ,  FORGVIEWID VARCHAR(50) NOT NULL DEFAULT ' '  )";
    private static final String ADDPRIMARYKEY = "ALTER TABLE t_wf_jobrecord ADD CONSTRAINT pk_job1 PRIMARY KEY (FID)";
    private static final String INSERTJOBSQL = "insert into t_wf_jobrecord(  FID,  FTYPE,  FLOCKEXPTIME,  FLOCKOWNERID,  FEXECUTIONID,  FPROCESSINSTANCEID,  FPROCDEFID,  FEXCEPTIONMSG,  FHANDLERTYPE,  FHANDLERCFG,  FBUSINESSKEY,  FOPERATION,  FENTITYNUMBER,  FELEMENTID,  FCREATEDATE,  FMODIFYDATE,  FROOTTRACENO,  FSTATE,  FSOURCE,  FROOTJOBID,FRETRIES, FBIZTRACENO) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    private static final String SELECT = "select ";
    private static final String FTYPE = "FTYPE";
    private static final String CANNOT_FIND_TABLE = "cannot find t_wf_jobrecord in %s";
    private static final String SELECT_COMMENT_FIELDS = "  FID," + "  FTYPE," + "  FLOCKEXPTIME," + "  FLOCKOWNERID," + "  FEXECUTIONID," + "  FPROCESSINSTANCEID," + "  FPROCDEFID," + "  FEXCEPTIONMSG," + "  FHANDLERTYPE," + "  FHANDLERCFG," + "  FBUSINESSKEY," + "  FOPERATION," + "  FENTITYNUMBER," + "  FELEMENTID," + "  FCREATEDATE," + "  FMODIFYDATE," + "  FROOTTRACENO," + "  FSTATE," + "  FSOURCE," + "  FROOTJOBID," + "  FRETRIES," + "  FEXECUTOR," + " FBIZTRACENO";
    private static final String IDX_WF_JOBRECORD_LOCKSTATE = "IDX_WF_JOBRECORD_LOCKSTATE";
    private static final String LOCKTIME = "FLOCKEXPTIME,FSTATE";
    private static final String WFJOBRECORD = "t_wf_jobrecord";
    private static final String SQLWF = String.format("IF NOT EXISTS (SELECT 1 FROM KSQL_INDEXES WHERE KSQL_INDNAME = '%s') CREATE INDEX %s ON %s ( %s );", "IDX_WF_JOBRECORD_LOCKSTATE", "IDX_WF_JOBRECORD_LOCKSTATE", "t_wf_jobrecord", "FLOCKEXPTIME,FSTATE");
    private static final String IDX_WF_JOBREC_BUSKEY_STATE = "IDX_WF_JOBREC_BUSKEY_STATE";
    private static final String IDX_WF_JOBRECORD_EXECUTION = "IDX_WF_JOBRECORD_EXECUTION";
    private static final String IDX_WF_JOBRECORD_HANDLERTYPE = "IDX_WF_JOBRECORD_HANDLERTYPE";
    private static final String IDX_WF_JOBRECORD_PROCDEF = "IDX_WF_JOBRECORD_PROCDEF";
    private static final String IDX_WF_JOBRECORD_PROCINST = "IDX_WF_JOBRECORD_PROCINST";
    private static final String IDX_WF_JOBRECORD_ROOTJOBID = "IDX_WF_JOBRECORD_ROOTJOBID";
    private static final String BUSINESSKEY = "FBUSINESSKEY,FSTATE";
    private static final String HANDLERTYPE = "FHANDLERTYPE";
    private static final String EXECUTIONID = "FEXECUTIONID";
    private static final String PROCDEFID = "FPROCDEFID";
    private static final String PROCESSINSTANCEID = "FPROCESSINSTANCEID";
    private static final String ROOTJOBID = "FROOTJOBID";
    private static final String SQLWF1 = String.format("IF NOT EXISTS (SELECT 1 FROM KSQL_INDEXES WHERE KSQL_INDNAME = '%s') CREATE INDEX %s ON %s ( %s );", "IDX_WF_JOBREC_BUSKEY_STATE", "IDX_WF_JOBREC_BUSKEY_STATE", "t_wf_jobrecord", "FBUSINESSKEY,FSTATE");
    private static final String SQLWF2 = String.format("IF NOT EXISTS (SELECT 1 FROM KSQL_INDEXES WHERE KSQL_INDNAME = '%s') CREATE INDEX %s ON %s ( %s );", "IDX_WF_JOBRECORD_EXECUTION", "IDX_WF_JOBRECORD_EXECUTION", "t_wf_jobrecord", "FEXECUTIONID");
    private static final String SQLWF3 = String.format("IF NOT EXISTS (SELECT 1 FROM KSQL_INDEXES WHERE KSQL_INDNAME = '%s') CREATE INDEX %s ON %s ( %s );", "IDX_WF_JOBRECORD_HANDLERTYPE", "IDX_WF_JOBRECORD_HANDLERTYPE", "t_wf_jobrecord", "FHANDLERTYPE");
    private static final String SQLWF4 = String.format("IF NOT EXISTS (SELECT 1 FROM KSQL_INDEXES WHERE KSQL_INDNAME = '%s') CREATE INDEX %s ON %s ( %s );", "IDX_WF_JOBRECORD_PROCDEF", "IDX_WF_JOBRECORD_PROCDEF", "t_wf_jobrecord", "FPROCDEFID");
    private static final String SQLWF5 = String.format("IF NOT EXISTS (SELECT 1 FROM KSQL_INDEXES WHERE KSQL_INDNAME = '%s') CREATE INDEX %s ON %s ( %s );", "IDX_WF_JOBRECORD_PROCINST", "IDX_WF_JOBRECORD_PROCINST", "t_wf_jobrecord", "FPROCESSINSTANCEID");
    private static final String SQLWF6 = String.format("IF NOT EXISTS (SELECT 1 FROM KSQL_INDEXES WHERE KSQL_INDNAME = '%s') CREATE INDEX %s ON %s ( %s );", "IDX_WF_JOBRECORD_ROOTJOBID", "IDX_WF_JOBRECORD_ROOTJOBID", "t_wf_jobrecord", "FROOTJOBID");

    public void insert(List<JobEntity> jobs, String operation, String entityNumber) {
        MainEntityType entity = MetadataServiceHelper.getDataEntityType((String)entityNumber);
        ArrayList<Object[]> params = new ArrayList<Object[]>(jobs.size());
        for (JobEntity job : jobs) {
            job.setSource(JobHandleStrategyFactory.genenateSource(entity.getDBRouteKey()));
            params.add(this.getInsertParam(job, operation, entityNumber));
        }
        if (!params.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.of((String)entity.getDBRouteKey()), (String)INSERTJOBSQL, params);
        }
    }

    public Collection<DynamicObject> createTableAndFilter(String operation, String entityNumber, Map<String, DynamicObject> objsMap) {
        if (objsMap == null || objsMap.isEmpty()) {
            return Collections.emptyList();
        }
        MainEntityType entity = BusinessObjectQueryHelper.getDataEntityType((String)entityNumber);
        if (!DBRoute.workflow.getRouteKey().equalsIgnoreCase(entity.getDBRouteKey())) {
            WfCacheHelper.putJobSourceOfDBRouteKey(entity.getDBRouteKey());
        }
        WfCacheHelper.putJobSourceOfAppId(entity.getAppId());
        boolean exist = WfCacheHelper.existWfJobRecordTable(entity.getDBRouteKey());
        if (!exist) {
            boolean existTable = DB.exitsTable((DBRoute)DBRoute.of((String)entity.getDBRouteKey()), (String)"t_wf_jobrecord");
            if (!existTable) {
                DB.execute((DBRoute)DBRoute.of((String)entity.getDBRouteKey()), (String)CREATEJOBSQL, (Object[])new Object[0]);
                DB.execute((DBRoute)DBRoute.of((String)entity.getDBRouteKey()), (String)ADDPRIMARYKEY, (Object[])new Object[0]);
                DB.execute((DBRoute)DBRoute.of((String)entity.getDBRouteKey()), (String)SQLWF, (Object[])new Object[0]);
                DB.execute((DBRoute)DBRoute.of((String)entity.getDBRouteKey()), (String)SQLWF1, (Object[])new Object[0]);
                DB.execute((DBRoute)DBRoute.of((String)entity.getDBRouteKey()), (String)SQLWF2, (Object[])new Object[0]);
                DB.execute((DBRoute)DBRoute.of((String)entity.getDBRouteKey()), (String)SQLWF3, (Object[])new Object[0]);
                DB.execute((DBRoute)DBRoute.of((String)entity.getDBRouteKey()), (String)SQLWF4, (Object[])new Object[0]);
                DB.execute((DBRoute)DBRoute.of((String)entity.getDBRouteKey()), (String)SQLWF5, (Object[])new Object[0]);
                DB.execute((DBRoute)DBRoute.of((String)entity.getDBRouteKey()), (String)SQLWF6, (Object[])new Object[0]);
                WfCacheHelper.putWfJobRecordTable(entity.getDBRouteKey(), Boolean.TRUE);
                return objsMap.values();
            }
            WfCacheHelper.putWfJobRecordTable(entity.getDBRouteKey(), Boolean.TRUE);
        }
        return objsMap.values();
    }

    private String getBusinessKeys(List<String> subList) {
        String businessKeys = "";
        if (subList == null || subList.isEmpty()) {
            return businessKeys;
        }
        StringBuilder businesskeysSB = new StringBuilder();
        businesskeysSB.append('(');
        for (String s : subList) {
            businesskeysSB.append('\'').append(s).append('\'').append(',');
        }
        if (businesskeysSB.length() > 1) {
            businessKeys = businesskeysSB.substring(0, businesskeysSB.length() - 1) + ")";
        }
        return businessKeys;
    }

    private Object[] getInsertParam(JobEntity job, String operation, String entityNumber) {
        Long id = job.getId();
        if (WfUtils.isEmpty(job.getRootJobId())) {
            job.setRootJobId(id);
        }
        Date date = WfUtils.now();
        return new Object[]{id, this.rightVal(job.getJobType()), job.getLockExpirationTime(), this.rightVal(job.getLockOwnerId()), this.rightVal(job.getExecutionId()), this.rightVal(job.getProcessInstanceId()), this.rightVal(job.getProcessDefinitionId()), this.rightVal(job.getExceptionMessage()), this.rightVal(job.getJobHandlerType()), this.rightVal(job.getJobHandlerConfiguration()), this.rightVal(job.getBusinessKey()), this.rightVal(operation), this.rightVal(entityNumber), this.rightVal(job.getElementId()), date, date, this.rightVal(job.getRootTraceNo()), JobStateEnum.CREATED.getNumber(), this.rightVal(job.getSource()), this.rightVal(job.getRootJobId()), job.getRetries(), this.rightVal(job.getBizTraceNo())};
    }

    private String rightVal(String val) {
        return WfUtils.isEmpty(val) ? " " : val;
    }

    private Long rightVal(Long val) {
        return val == null ? Long.valueOf(0L) : val;
    }

    public JobStateEnum getJobStatus(Long id, String dbRoute) {
        StringBuilder sb = new StringBuilder();
        sb.append("select fstate from ").append("t_wf_jobrecord").append(KEY_WHERE_FID);
        String status = (String)DB.query((DBRoute)DBRoute.of((String)dbRoute), (String)sb.toString(), (Object[])new Object[]{id}, (ResultSetHandler)new ResultSetHandler<String>(){

            public String handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    return rs.getString("fstate");
                }
                return null;
            }
        });
        if (status != null) {
            return JobStateEnum.valueOf(JobStateEnum.class, status);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteJob(JobEntity jobEntity) {
        String dbKey = JobHandleStrategyFactory.getDBRouteKey(jobEntity.getSource());
        if (!DBRoute.workflow.getRouteKey().equals(dbKey)) {
            String sql = "delete from t_wf_jobrecord where fid = ?";
            TXHandle h = TX.beginNew();
            try {
                DB.execute((DBRoute)DBRoute.of((String)dbKey), (String)sql, (Object[])new Object[]{jobEntity.getId()});
            }
            catch (Exception e) {
                h.markRollback();
                logger.warn(String.format("\u5220\u9664\u8fdc\u7aef\u5e93\u4e2d\u7684job[%s]\u5931\u8d25.", jobEntity.getId()));
            }
            finally {
                h.end();
            }
        }
    }

    public JobEntity findById(Long id, String dbKey) {
        String sql = SELECT + SELECT_COMMENT_FIELDS + KEYWORD_FROM + "t_wf_jobrecord" + KEY_WHERE_FID;
        return (JobEntity)DB.query((DBRoute)DBRoute.of((String)dbKey), (String)sql, (Object[])new Object[]{id}, (ResultSetHandler)new ResultSetHandler<JobEntity>(){

            public JobEntity handle(ResultSet rs) throws SQLException {
                JobEntityImpl job = null;
                if (rs.next()) {
                    job = new JobEntityImpl();
                    JobDAO.this.setJobInfo(rs, job);
                }
                return job;
            }
        });
    }

    public boolean exist(Long id, String routeKey) {
        try (DataSet ds = DB.queryDataSet((String)"dbKey.exist", (DBRoute)DBRoute.of((String)routeKey), (String)"select fid from t_wf_jobrecord where fid = ?", (Object[])new Object[]{id});){
            if (ds != null && ds.iterator().hasNext()) {
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    public List<JobEntity> findByBusinessKey(String businessKey, String dbKey) {
        boolean exist = WfCacheHelper.existWfJobRecordTable(dbKey);
        if (!exist) {
            boolean existTable = DB.exitsTable((DBRoute)DBRoute.of((String)dbKey), (String)"t_wf_jobrecord");
            if (!existTable) {
                WfCacheHelper.removeJobSourceOfDBRouteKey(dbKey);
                logger.debug(String.format(CANNOT_FIND_TABLE, dbKey));
                return Collections.emptyList();
            }
            WfCacheHelper.putWfJobRecordTable(dbKey, Boolean.TRUE);
        }
        String sql = SELECT + SELECT_COMMENT_FIELDS + KEYWORD_FROM + "t_wf_jobrecord" + " where fbusinesskey = ?";
        return (List)DB.query((DBRoute)DBRoute.of((String)dbKey), (String)sql, (Object[])new Object[]{businessKey}, (ResultSetHandler)new ResultSetHandler<List<JobEntity>>(){

            public List<JobEntity> handle(ResultSet rs) throws SQLException {
                JobEntityImpl job = null;
                ArrayList<JobEntity> ret = new ArrayList<JobEntity>(16);
                while (rs.next()) {
                    String jobType = rs.getString(JobDAO.FTYPE);
                    job = "event".equals(jobType) ? new JobEntityImpl("evt_job") : new JobEntityImpl();
                    JobDAO.this.setJobInfo(rs, job);
                    ret.add(job);
                }
                return ret;
            }
        });
    }

    public List<JobEntity> findRunningAddressJobByBusinessKey(String businessKey, String dbKey) {
        boolean exist = WfCacheHelper.existWfJobRecordTable(dbKey);
        if (!exist) {
            boolean existTable = DB.exitsTable((DBRoute)DBRoute.of((String)dbKey), (String)"t_wf_jobrecord");
            if (!existTable) {
                WfCacheHelper.removeJobSourceOfDBRouteKey(dbKey);
                logger.debug(String.format(CANNOT_FIND_TABLE, dbKey));
                return Collections.emptyList();
            }
            WfCacheHelper.putWfJobRecordTable(dbKey, Boolean.TRUE);
        }
        String sql = SELECT + SELECT_COMMENT_FIELDS + KEYWORD_FROM + "t_wf_jobrecord" + " WHERE FBUSINESSKEY = ? AND FHANDLERTYPE = ? AND FSTATE NOT IN (?, ?)";
        return (List)DB.query((DBRoute)DBRoute.of((String)dbKey), (String)sql, (Object[])new Object[]{businessKey, "address-process-event", JobStateEnum.COMPLETED.getNumber(), JobStateEnum.ERRORED.getNumber()}, (ResultSetHandler)new ResultSetHandler<List<JobEntity>>(){

            public List<JobEntity> handle(ResultSet rs) throws SQLException {
                JobEntityImpl job = null;
                ArrayList<JobEntity> ret = new ArrayList<JobEntity>(16);
                while (rs.next()) {
                    String jobType = rs.getString(JobDAO.FTYPE);
                    job = "event".equals(jobType) ? new JobEntityImpl("evt_job") : new JobEntityImpl();
                    JobDAO.this.setJobInfo(rs, job);
                    ret.add(job);
                }
                return ret;
            }
        });
    }

    public List<JobEntity> findExpiredJobs(String dbKey) {
        boolean exist = WfCacheHelper.existWfJobRecordTable(dbKey);
        if (!exist) {
            boolean existTable = DB.exitsTable((DBRoute)DBRoute.of((String)dbKey), (String)"t_wf_jobrecord");
            if (!existTable) {
                WfCacheHelper.removeJobSourceOfDBRouteKey(dbKey);
                logger.debug(String.format(CANNOT_FIND_TABLE, dbKey));
                return Collections.emptyList();
            }
            WfCacheHelper.putWfJobRecordTable(dbKey, Boolean.TRUE);
        }
        Object val = WfConfigurationUtil.getConfigCenterVal("acquire.limit");
        int limit = 50;
        try {
            if (val != null) {
                limit = Integer.parseInt(String.valueOf(val));
            }
        }
        catch (Exception e) {
            logger.error("val\u5728limit\u7c7b\u578b\u8f6c\u6362\u65f6\u51fa\u9519\uff01\u539f\u56e0\uff1a%s" + e.getMessage());
        }
        String sql = SELECT + String.format("top %s ", limit) + SELECT_COMMENT_FIELDS + KEYWORD_FROM + "t_wf_jobrecord" + " where FLOCKEXPTIME >= ? and FLOCKEXPTIME <= ? and fstate in ('created','received','executing') order by FLOCKEXPTIME asc ";
        try {
            Date date = WfUtils.now();
            val = WfConfigurationUtil.getConfigCenterVal("acquireStep");
            int step = 3;
            try {
                if (val != null) {
                    step = Integer.parseInt(String.valueOf(val));
                }
            }
            catch (Exception e) {
                logger.warn(e.getMessage());
            }
            Date startTime = new Date(date.getTime() - (long)step * 24L * 60L * 60L * 1000L);
            logger.debug(String.format("findExpiredJobs in databse[%s]", dbKey));
            return (List)DB.query((DBRoute)DBRoute.of((String)dbKey), (String)sql, (Object[])new Object[]{startTime, date}, (ResultSetHandler)new ResultSetHandler<List<JobEntity>>(){

                public List<JobEntity> handle(ResultSet rs) throws SQLException {
                    ArrayList<JobEntity> ret = new ArrayList<JobEntity>(16);
                    while (rs.next()) {
                        JobEntityImpl job = new JobEntityImpl();
                        JobDAO.this.setJobInfo(rs, job);
                        ret.add(job);
                    }
                    return ret;
                }
            });
        }
        catch (Exception e) {
            if (e instanceof KDException && ((KDException)((Object)e)).getErrorCode() != null && "bos.sQLTableNotExist".equalsIgnoreCase(((KDException)((Object)e)).getErrorCode().getCode())) {
                WfCacheHelper.removeJobSourceOfDBRouteKey(dbKey);
            }
            logger.error(WfUtils.getExceptionStacktrace(e));
            return Collections.emptyList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(String dbKey, JobEntity entity) {
        String sql = "update t_wf_jobrecord set FLOCKEXPTIME = ?,FLOCKOWNERID = ?,FRETRIES=?,FSTATE = ? where fid = ?";
        try (TXHandle h = TX.requiresNew();){
            DB.execute((DBRoute)DBRoute.of((String)dbKey), (String)sql, (Object[])new Object[]{entity.getLockExpirationTime(), entity.getLockOwnerId(), entity.getRetries(), entity.getState(), entity.getId()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(String dbKey, List<Object[]> params) {
        String sql = "update t_wf_jobrecord set FLOCKEXPTIME = ?,FLOCKOWNERID = ?,FRETRIES=?,FSTATE = ? where fid = ? and fstate in ('created','received','executing')";
        try (TXHandle h = TX.requiresNew();){
            WfDBUtils.executeBatch(DBRoute.of((String)dbKey), sql, params, 100);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateState(String dbKey, ExecuteJob entity) {
        String sql = "update t_wf_jobrecord set FEXECUTOR = ?,FSTATE = ?,FROOTTRACENO=? where fid = ?";
        try (TXHandle h = TX.requiresNew();){
            DB.execute((DBRoute)DBRoute.of((String)dbKey), (String)sql, (Object[])new Object[]{entity.getExecutor(), entity.getState(), entity.getRootTraceNo(), entity.getId()});
        }
    }

    private void setJobInfo(ResultSet rs, JobEntity job) throws SQLException {
        job.setId(rs.getLong("FID"));
        job.setJobType(rs.getString(FTYPE));
        job.setLockExpirationTime(rs.getDate("FLOCKEXPTIME"));
        job.setLockOwnerId(rs.getString("FLOCKOWNERID"));
        job.setExecutionId(rs.getLong(EXECUTIONID));
        job.setProcessDefinitionId(rs.getLong(PROCDEFID));
        job.setProcessInstanceId(rs.getLong(PROCESSINSTANCEID));
        job.setExceptionMessage(rs.getString("FEXCEPTIONMSG"));
        job.setJobHandlerType(rs.getString(HANDLERTYPE));
        job.setJobHandlerConfiguration(rs.getString("FHANDLERCFG"));
        job.setBusinessKey(rs.getString("FBUSINESSKEY"));
        job.setOperation(rs.getString("FOPERATION"));
        job.setEntityNumber(rs.getString("FENTITYNUMBER"));
        job.setElementId(rs.getString("FELEMENTID"));
        job.setCreateDate(rs.getTimestamp("FCREATEDATE"));
        job.setModifyDate(rs.getTimestamp("FMODIFYDATE"));
        job.setRootTraceNo(rs.getString("FROOTTRACENO"));
        job.setState(rs.getString("FSTATE"));
        job.setSource(rs.getString("FSOURCE"));
        job.setRootJobId(rs.getLong(ROOTJOBID));
        job.setRetries(rs.getInt("FRETRIES"));
        job.setBizTraceNo(rs.getString("FBIZTRACENO"));
        job.setExecutor(rs.getString("FEXECUTOR"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateErrorMsg(String dbKey, Long taskId, String error) {
        String sql = "update t_wf_jobrecord set FEXCEPTIONMSG = ? where fid = ?";
        TXHandle h = TX.beginNew();
        try {
            DB.execute((DBRoute)DBRoute.of((String)dbKey), (String)sql, (Object[])new Object[]{error, taskId});
        }
        catch (Exception e) {
            h.markRollback();
            logger.warn(String.format("\u66f4\u65b0job[%s]\u9519\u8bef\u4fe1\u606f\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a[%s]", taskId, e.getMessage()));
        }
        finally {
            h.end();
        }
    }

    public List<ExecuteJob> findByIds(List<Long> ids, String dbKey) {
        if (ids == null || ids.size() == 0) {
            return null;
        }
        int size = ids.size();
        final ArrayList<ExecuteJob> list = new ArrayList<ExecuteJob>(size);
        if (size == 1) {
            list.add(this.findById(ids.get(0), dbKey));
            return list;
        }
        StringBuilder sql = new StringBuilder();
        sql.append(SELECT).append(SELECT_COMMENT_FIELDS).append(KEYWORD_FROM).append("t_wf_jobrecord").append(" where fid in (");
        int length = ids.size();
        for (int i = 0; i < length; ++i) {
            sql.append(" ?");
            if (i == length - 1) continue;
            sql.append(',');
        }
        sql.append(')');
        return (List)DB.query((DBRoute)DBRoute.of((String)dbKey), (String)sql.toString(), (Object[])ids.toArray(), (ResultSetHandler)new ResultSetHandler<List<ExecuteJob>>(){

            public List<ExecuteJob> handle(ResultSet rs) throws SQLException {
                JobEntityImpl job = null;
                while (rs.next()) {
                    job = new JobEntityImpl();
                    JobDAO.this.setJobInfo(rs, job);
                    list.add(job);
                }
                return list;
            }
        });
    }
}

