/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.jobexecutor;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.JobDispatchBatchResult;
import kd.bos.schedule.api.JobDispatcher;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.MessageInfo;
import kd.bos.schedule.api.MessageType;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.workflow.bpmn.model.CallActivity;
import kd.bos.workflow.devopos.ProcessNotExistPoJo;
import kd.bos.workflow.devopos.ProcessNotExistReasonEnum;
import kd.bos.workflow.devopos.WorkflowDevopsService;
import kd.bos.workflow.devopos.info.IndicatorInfo;
import kd.bos.workflow.engine.ProcessEngines;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfSuspendUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.event.ActivitiEventType;
import kd.bos.workflow.engine.delegate.event.impl.ActivitiEventBuilder;
import kd.bos.workflow.engine.impl.asyncexecutor.AsyncExecutor;
import kd.bos.workflow.engine.impl.asyncexecutor.schedule.WfJobHandler;
import kd.bos.workflow.engine.impl.bpmn.behavior.TaskBehaviorUtil;
import kd.bos.workflow.engine.impl.bpmn.listener.AddressJobFailListner;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.cmd.SuspendProcessInstanceCmd;
import kd.bos.workflow.engine.impl.cmd.entity.SaveEntityCmd;
import kd.bos.workflow.engine.impl.cmd.job.EventTriggerCmd;
import kd.bos.workflow.engine.impl.cmd.job.JobHandleStrategy;
import kd.bos.workflow.engine.impl.cmd.job.JobHandleStrategyFactory;
import kd.bos.workflow.engine.impl.cmd.system.SendMessageToAdminsCmd;
import kd.bos.workflow.engine.impl.cmd.system.SendMessageToCreator;
import kd.bos.workflow.engine.impl.cmd.system.entity.HandlerConfig;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandConfig;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.jobexecutor.DeadLetterJobHandler;
import kd.bos.workflow.engine.impl.jobexecutor.FailedJobCommandFactory;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelType;
import kd.bos.workflow.engine.impl.persistence.entity.job.AbstractJobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.DeadLetterJobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobStateEnum;
import kd.bos.workflow.engine.impl.persistence.entity.management.ManagementConstants;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntityManager;
import kd.bos.workflow.engine.impl.util.RuntimeUtil;
import kd.bos.workflow.engine.runtime.ExecuteJob;
import kd.bos.workflow.exception.ExceptionUtil;
import kd.bos.workflow.exception.WFEngineException;
import kd.bos.workflow.exception.WFErrorCode;
import kd.bos.workflow.exception.WFSubProcessException;
import kd.bos.workflow.service.WfTraceType;
import kd.bos.workflow.service.WorkflowService;

public class JobUtil {
    private static Log log = LogFactory.getLog(JobUtil.class);

    public static void sendJobToMQ(List<JobEntity> jobs) {
        if (jobs != null && !jobs.isEmpty()) {
            if (!WfUtils.isSyncRun()) {
                JobUtil.dispatchMqBatch(jobs);
            } else {
                for (JobEntity job : jobs) {
                    JobUtil.executeJob(job);
                }
            }
        }
    }

    private static void dispatchMqBatch(List<JobEntity> jobs) {
        StringBuilder sb = new StringBuilder();
        ArrayList<JobInfo> jobInfos = new ArrayList<JobInfo>(jobs.size());
        for (JobEntity job : jobs) {
            if (job == null) continue;
            jobInfos.add(JobUtil.getJobInfo(job));
            sb.append("[id=").append(job.getId()).append(", type=").append(job.getJobHandlerType()).append(", rootId=").append(job.getRootJobId()).append("],");
        }
        try {
            int successSizes = jobs.size();
            JobDispatcher dispatcher = (JobDispatcher)ServiceFactory.getService(JobDispatcher.class);
            JobDispatchBatchResult result = dispatcher.dispatchBatch(jobInfos.toArray(new JobInfo[0]));
            if (!result.isSuccess()) {
                successSizes -= result.getFailTasks().size();
                sb.append("error to send jobs taskIds[").append(WfUtils.listToString(result.getFailTasks(), ",").equals("]"));
            }
            JobUtil.collectSendingToMqJobs("asyncMessageMinutelySend", successSizes);
            log.debug("successfully to send jobs[" + sb + "] to MQ!");
        }
        catch (Exception e) {
            log.error(String.format("error occurs when sending job[%s],error is [%s],stack is [%s]", sb, e.getMessage(), WfUtils.getExceptionStacktrace(e)));
        }
    }

    public static void sendJobToMQ(JobEntity job) {
        if (!WfUtils.isSyncRun()) {
            ArrayList<JobEntity> jobs = new ArrayList<JobEntity>(1);
            jobs.add(job);
            JobUtil.dispatchMqBatch(jobs);
        } else {
            JobUtil.executeJob(job);
        }
    }

    private static JobInfo getJobInfo(JobEntity job) {
        JobInfo message = new JobInfo();
        message.setJobType(JobType.WORKFLOW);
        message.setName(job.getJobHandlerType());
        message.setRunByUserId(Long.parseLong(RequestContext.get().getUserId()));
        message.setTaskClassname("kd.bos.workflow.engine.Task");
        boolean independent = WfConfigurationUtil.isDeployIdependent();
        String entityNumber = job.getEntityNumber();
        if (!independent && WfUtils.isNotEmpty(entityNumber)) {
            String appId = JobUtil.getEntityAppId(entityNumber);
            if (appId != null) {
                message.setAppId(appId);
            } else {
                message.setAppId("wf");
            }
            log.debug(String.format("------------------------------appId sendJobToMq:[%s-%s-%s]", job.getId(), message.getAppId(), appId == null ? "" : appId));
        } else if (!independent && Instance.isAppSplit()) {
            String jobHandlerConfiguration;
            if ("simpleJob".equalsIgnoreCase(job.getAppNumForSubApp())) {
                JobHandleStrategy strategy = JobHandleStrategyFactory.getJobHandleStrategy(job.getSource(), "");
                strategy.setProcessEngineConfiguration((ProcessEngineConfigurationImpl)ProcessEngines.getDefaultProcessEngine().getProcessEngineConfiguration());
                job = (JobEntity)strategy.findJob(job.getId(), true);
            }
            if (WfUtils.isNotEmpty(jobHandlerConfiguration = job.getJobHandlerConfiguration())) {
                Map configuration = (Map)SerializationUtils.fromJsonString((String)jobHandlerConfiguration, Map.class);
                message.setAppId((String)configuration.get("appId"));
            }
            if (message.getAppId() == null) {
                message.setAppId("wf");
            }
        } else {
            message.setAppId("wf");
            log.debug(String.format("------------------------------appId sendJobToMq:[%s-%s]", job.getId(), message.getAppId()));
        }
        message.setNumber(String.format("WF_%s_SKDJ_S", job.getId()));
        message.setId(String.valueOf(job.getId()));
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("job", JobUtil.simplifyJob(job));
        message.setParams(params);
        return message;
    }

    private static String getEntityAppId(String entityNumber) {
        String appId = null;
        boolean isNoCodeBill = false;
        FormConfig formConfig = null;
        try {
            MainEntityType entity;
            formConfig = FormMetadataCache.getFormConfig((String)entityNumber);
            appId = formConfig.getAppId();
            isNoCodeBill = "nocodebill".equalsIgnoreCase(formConfig.getModelType());
            if (isNoCodeBill) {
                return "bos";
            }
            if (appId == null && (entity = EntityMetadataCache.getDataEntityType((String)entityNumber)) != null) {
                appId = entity.getAppId();
            }
        }
        catch (Exception e) {
            log.error(String.format("getFormConfig error. EntityNumber: %s, Error: %s", entityNumber, WfUtils.getExceptionStacktrace(e)));
        }
        return appId;
    }

    public static Object simplifyJob(JobEntity job) {
        HashMap<String, Object> ret = new HashMap<String, Object>(50);
        ret.put("id", job.getId());
        ret.put("jobHandlerType", job.getJobHandlerType());
        String source = job.getSource();
        ret.put("source", source);
        if (JobUtil.checkIsNeedSendAllMessage(job)) {
            ret.put("businessKey", job.getBusinessKey());
            ret.put("operation", job.getOperation());
            ret.put("jobType", job.getJobType());
            ret.put("executionId", job.getExecutionId());
            ret.put("jobHandlerConfiguration", job.getJobHandlerConfiguration());
            ret.put("processInstanceId", job.getProcessInstanceId());
            ret.put("processDefinitionId", job.getProcessDefinitionId());
            ret.put("entityNumber", job.getEntityNumber());
            ret.put("lockOwnerId", job.getLockOwnerId());
            ret.put("retries", job.getRetries());
            ret.put("elementId", job.getElementId());
            ret.put("repeat", job.getRepeat());
            ret.put("dueDate", job.getDuedate());
            ret.put("srcJobId", job.getSrcJobId());
            ret.put("rootTraceNo", job.getRootTraceNo());
            ret.put("executor", job.getExecutor());
            ret.put("success", job.isSuccess());
            ret.put("endtime", job.getEndTime());
            ret.put("duration", job.getDuration());
            ret.put("state", job.getState());
            ret.put("rootJobId", job.getRootJobId());
            ret.put("biztraceno", job.getBizTraceNo());
        }
        return ret;
    }

    private static boolean checkIsNeedSendAllMessage(JobEntity job) {
        String source = job.getSource();
        if (WfUtils.isNotEmpty(source) && source.startsWith("MQ")) {
            return true;
        }
        return "async-devops-testmqschedule-job".equals(job.getJobHandlerType()) || "async-devops-recoversyserror-job".equals(job.getJobHandlerType());
    }

    public static JobEntity extraToJobEntity(Map jsonObject) {
        JobEntityImpl job = new JobEntityImpl();
        job.setId((Long)jsonObject.get("id"));
        job.setBusinessKey((String)jsonObject.get("businessKey"));
        job.setOperation((String)jsonObject.get("operation"));
        job.setJobType((String)jsonObject.get("jobType"));
        job.setJobHandlerType((String)jsonObject.get("jobHandlerType"));
        job.setExecutionId((Long)jsonObject.get("executionId"));
        job.setJobHandlerConfiguration((String)jsonObject.get("jobHandlerConfiguration"));
        job.setEntityNumber((String)jsonObject.get("entityNumber"));
        job.setProcessInstanceId((Long)jsonObject.get("processInstanceId"));
        job.setProcessDefinitionId((Long)jsonObject.get("processDefinitionId"));
        job.setRetries((Integer)jsonObject.get("retries"));
        job.setLockOwnerId((String)jsonObject.get("lockOwnerId"));
        job.setElementId((String)jsonObject.get("elementId"));
        job.setRepeat((String)jsonObject.get("repeat"));
        job.setDuedate((Date)jsonObject.get("dueDate"));
        job.setSrcJobId((Long)jsonObject.get("srcJobId"));
        job.setRootTraceNo((String)jsonObject.get("rootTraceNo"));
        job.setSource((String)jsonObject.get("source"));
        job.setState((String)jsonObject.get("state"));
        job.setDuration((Long)jsonObject.get("duration"));
        job.setEndTime((Date)jsonObject.get("endtime"));
        job.setSuccess((Boolean)jsonObject.get("success"));
        job.setExecutor((String)jsonObject.get("executor"));
        job.setRootJobId((Long)jsonObject.get("rootJobId"));
        return job;
    }

    public static void setJobLockProperty(ExecuteJob entity, ProcessEngineConfigurationImpl processEngineConfiguration, AsyncExecutor asyncExecutor) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(processEngineConfiguration.getClock().getCurrentTime());
        gregorianCalendar.add(12, processEngineConfiguration.getAsyncJobLockTimeInMinutes());
        entity.setLockExpirationTime(gregorianCalendar.getTime());
        entity.setLockOwnerId(asyncExecutor.getLockOwner());
    }

    public static void handleFailedJob(final ProcessEngineConfigurationImpl processEngineConfiguration, final ExecuteJob job, final Throwable exception) {
        if (WfUtils.isTesting() && job instanceof JobEntity) {
            ((JobEntity)job).setExceptionMessage(WfUtils.getExceptionStacktrace(exception));
            ((JobEntity)job).setState(JobStateEnum.ERRORED.getNumber());
            ((JobEntity)job).setEndTime(WfUtils.now());
            job.setDuration(((JobEntity)job).getEndTime().getTime() - job.getCreateDate().getTime());
            ((JobEntity)job).setSuccess(false);
            processEngineConfiguration.getCommandExecutor().execute(new SaveEntityCmd<ExecuteJob>(job));
            processEngineConfiguration.getCommandExecutor().execute(new Command<Void>(){

                @Override
                public Void execute(CommandContext commandContext) {
                    DeadLetterJobEntity newJobEntity = processEngineConfiguration.getJobManager().moveJobToDeadLetterJob(job, exception);
                    DeadLetterJobHandler.handleDeadLetterJob(newJobEntity, commandContext);
                    return null;
                }
            });
            return;
        }
        processEngineConfiguration.getCommandExecutor().execute(new Command<Void>(){

            @Override
            public Void execute(CommandContext commandContext) {
                WFEngineException engineException = ExceptionUtil.createContextException(exception, job);
                CommandConfig commandConfig = processEngineConfiguration.getCommandExecutor().getDefaultConfig().transactionRequiresNew();
                FailedJobCommandFactory failedJobCommandFactory = commandContext.getFailedJobCommandFactory();
                if (job.getProcessDefinitionId() == null) {
                    job.setProcessDefinitionId(engineException.getProcessDefId());
                }
                Command<Object> cmd = failedJobCommandFactory.getCommand(job, (Throwable)((Object)engineException));
                AbstractJobEntity newJobEntity = (AbstractJobEntity)processEngineConfiguration.getCommandExecutor().execute(commandConfig, cmd);
                if (newJobEntity instanceof DeadLetterJobEntity && RuntimeUtil.needHandleException(job.getJobHandlerType()) && job instanceof JobEntity) {
                    this.doProcessError(processEngineConfiguration, (JobEntity)job, exception, commandContext, engineException, newJobEntity);
                }
                if (commandContext.getEventDispatcher().isEnabled()) {
                    try {
                        commandContext.getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createAsyncMessageEvent(ActivitiEventType.JOB_EXECUTION_FAILURE, job.getJobHandlerType(), job.getJobHandlerConfiguration(), job, (Throwable)((Object)engineException)));
                    }
                    catch (Exception ignore) {
                        log.warn("Exception occurred while dispatching job failure event, ignoring.", (Throwable)ignore);
                    }
                }
                return null;
            }

            private void doProcessError(ProcessEngineConfigurationImpl processEngineConfiguration2, JobEntity job2, Throwable exception2, CommandContext commandContext, WFEngineException engineException, AbstractJobEntity newJobEntity) {
                boolean suspendProc;
                ExecutionEntity exec = null;
                boolean bizFlow = WfUtils.isNotEmpty(job2.getProcessInstanceId()) && (exec = (ExecutionEntity)commandContext.getExecutionEntityManager().findById(job2.getProcessInstanceId())) != null && ModelType.BizFlow.name().equalsIgnoreCase(exec.getProcessType());
                boolean bl = suspendProc = engineException.needsSuspendProinstance() && !bizFlow;
                if ("address-process-event".equals(job2.getJobHandlerType())) {
                    String configuration = job2.getJobHandlerConfiguration();
                    Map payload = (Map)SerializationUtils.fromJsonString((String)configuration, Map.class);
                    Map variables = (Map)payload.get("variables");
                    Object o = variables.get("jobAction");
                    commandContext.addCloseListener(new AddressJobFailListner(job2));
                    if (!"createSubProcess".equals(o)) {
                        this.logProcessNotExist(job2);
                    }
                }
                if (engineException != null && engineException.needsSuspendProinstance() && suspendProc) {
                    DeadLetterJobHandler.handleDeadLetterJob(newJobEntity, commandContext);
                    this.suspendParentProcess(job2, exception2, commandContext);
                    DeadLetterJobHandler.recordDurationDetail(commandContext, (DeadLetterJobEntity)newJobEntity);
                    WfSuspendUtil.sendMessageToAdmin(commandContext, job2, engineException);
                    if (job2.getProcessInstanceId() != null) {
                        WfSuspendUtil.sendMessageToStartUser(commandContext, job2);
                    } else {
                        new SendMessageToCreator(job2, (DeadLetterJobEntity)newJobEntity, engineException).execute(commandContext);
                    }
                    if (commandContext.getProcessEngineConfiguration().isEnableBecEventDispatcher()) {
                        HashMap<String, Object> jsonMap = new HashMap<String, Object>();
                        ExecutionEntity execut = (ExecutionEntity)commandContext.getExecutionEntityManager().findById(job2.getProcessInstanceId());
                        if (execut != null) {
                            jsonMap.put("billNo", execut.getBillNo());
                        }
                        new EventTriggerCmd("wf.AfterProcessErrorSuspendEvent", newJobEntity, jsonMap).execute(commandContext);
                    }
                } else if (engineException != null && engineException.needsSendAlarmMsg()) {
                    new SendMessageToAdminsCmd(job2, false, engineException).execute(commandContext);
                    if (job2.getProcessInstanceId() != null) {
                        WfSuspendUtil.sendMessageToStartUser(commandContext, job2);
                    } else {
                        new SendMessageToCreator(job2, (DeadLetterJobEntity)newJobEntity, engineException).execute(commandContext);
                    }
                }
            }

            private void logProcessNotExist(JobEntity job2) {
                try {
                    String entityNumber = job2.getEntityNumber();
                    WorkflowDevopsService devopsService = WorkflowDevopsService.create();
                    boolean needLogProcessNotExist = devopsService.needLogProcessNotExist(entityNumber);
                    if (!needLogProcessNotExist) {
                        return;
                    }
                    ProcessNotExistPoJo poJo = new ProcessNotExistPoJo();
                    DynamicObject businessModel = BusinessDataServiceHelper.loadSingle((Object)job2.getBusinessKey(), (String)entityNumber);
                    poJo.setErrorReason(ProcessNotExistReasonEnum.ERROR_ADDRESS);
                    poJo.setBusinessKey(job2.getBusinessKey());
                    poJo.setEntityNumber(entityNumber);
                    String billNo = TaskBehaviorUtil.getTaskBillNo(entityNumber, businessModel);
                    poJo.setBillno(billNo);
                    poJo.setOperate(job2.getOperation());
                    String configuration = job2.getJobHandlerConfiguration();
                    ObjectMapper JSON2 = new ObjectMapper();
                    Map map = (Map)JSON2.readValue(configuration, (TypeReference)new TypeReference<Map<String, Object>>(){});
                    poJo.setVariables(JSON2.writeValueAsString(map.get("variables")));
                    Long initiator = HandlerConfig.build(job2).acquireInitiator();
                    poJo.setSubmitterId(initiator);
                    poJo.setSubmitTime(WfUtils.now());
                    poJo.setDeadLetterId(job2.getId());
                    poJo.setEntraBillName((ILocaleString)businessModel.getDataEntityType().getDisplayName());
                    Long alarmMsgLogId = devopsService.notifySubmitterProcessNotEntered(businessModel, poJo);
                    poJo.setAlarmMsgSendLogId(alarmMsgLogId);
                    devopsService.logProcessNotExist(poJo);
                }
                catch (Exception e) {
                    log.debug("I have been try my best to build it......" + e.getMessage());
                }
            }

            private void suspendParentProcess(JobEntity job2, Throwable exception2, CommandContext commandContext) {
                ExecutionEntity superExecution = null;
                ExecutionEntityManager entityManager = commandContext.getExecutionEntityManager();
                ExecutionEntity execution = (ExecutionEntity)entityManager.findById(job2.getExecutionId());
                if (execution != null && (superExecution = execution.getSuperExecution()) != null && ManagementConstants.ACTIVE.getStateCode().equals(superExecution.getSuspensionState()) && superExecution.getCurrentFlowElement() instanceof CallActivity) {
                    WFSubProcessException newException = new WFSubProcessException(null, WFErrorCode.subProcessException(), new Object[]{exception2.getMessage()});
                    ILocaleString suspendReason = WfUtils.getMultiLangValue(newException.getMessage());
                    if (ModelType.AuditFlow.name().equalsIgnoreCase(superExecution.getProcessType())) {
                        new SuspendProcessInstanceCmd(superExecution.getProcessInstanceId(), suspendReason, newException.getType()).execute(commandContext);
                    } else {
                        DeadLetterJobEntity dd = commandContext.getJobManager().createParentBizFlowDonothingDeadLetterJob(superExecution, suspendReason);
                        commandContext.getDeadLetterJobEntityManager().insert(dd);
                    }
                } else {
                    log.debug(String.format("execution is null or current element is not CallActivity or parent process is bizflow! %s", job2.getExecutionId()));
                }
            }
        });
    }

    private static void executeJob(JobEntity job) {
        WfJobHandler jobHandler = new WfJobHandler();
        JobInfo jobInfo = JobUtil.getJobInfo(job);
        RequestContext context = RequestContext.get();
        MessageInfo messageInfo = JobUtil.getMessageInfo(context, jobInfo);
        jobHandler.execute(context, messageInfo, messageInfo.fetchJobInfo());
    }

    private static MessageInfo getMessageInfo(RequestContext context, JobInfo jobInfo) {
        MessageInfo messageInfo = new MessageInfo();
        messageInfo.setTitle("JOB");
        messageInfo.setTaskId(jobInfo.getId());
        messageInfo.setMessageType(MessageType.WorkFlowJOB);
        messageInfo.setTenantId(context.getTenantId());
        messageInfo.setAccountId(context.getAccountId());
        HashMap<String, JobInfo> body = new HashMap<String, JobInfo>();
        body.put("job", jobInfo);
        messageInfo.setBody(body);
        return messageInfo;
    }

    public static boolean isInJobThread() {
        return WfTraceType.get() != null && WfTraceType.get().getJobInfo() != null && WfTraceType.get().getJobInfo().getCurrentJobId() != null;
    }

    public static boolean isCurrentThreadJob(Long jobId) {
        if (JobUtil.isInJobThread()) {
            return WfTraceType.get().getJobInfo().getCurrentJobId().equals(jobId);
        }
        return false;
    }

    protected static WorkflowService getWFService() {
        return (WorkflowService)kd.bos.workflow.service.impl.ServiceFactory.getService(WorkflowService.class);
    }

    @Deprecated
    public static void sendMqDirect(List<? extends ExecuteJob> jobs) {
    }

    @Deprecated
    public static void sendRetryMqDirect(List<? extends ExecuteJob> jobs) {
    }

    private static void collectSendingToMqJobs(String captureNumber, int size) {
        if (size < 1) {
            return;
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmm");
        String dimValue = format.format(WfUtils.now());
        IndicatorInfo indicatorInfo = new IndicatorInfo(captureNumber, (Object)dimValue, size, true);
        WorkflowDevopsService.create().exceutionDataCollection(indicatorInfo);
    }
}

