/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.jobexecutor;

import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.message.api.MessageChannels;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.jobexecutor.AbstractJobHandler;
import kd.bos.workflow.engine.impl.persistence.entity.detaillog.DetailLogEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.engine.msg.MessageServiceUtil;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.bos.workflow.exception.ExceptionUtil;
import kd.bos.workflow.exception.WFErrorCode;
import kd.bos.workflow.exception.WFMessageServiceException;

public class MessageJobHandler
extends AbstractJobHandler {
    public static final String CONTEXT = "context";
    public static final String MODEL = "model";
    public static final String SERVICE_KEY = "service";
    public static final String TYPE = "async-msg";

    @Override
    public String getType() {
        return TYPE;
    }

    public String getName() {
        return ResManager.loadKDString((String)"\u901a\u77e5", (String)"MessageJobHandler_0", (String)"bos-wf-engine", (Object[])new Object[0]);
    }

    @Override
    public void execute(JobEntity job, String configuration, ExecutionEntity execution, CommandContext commandContext) {
        try {
            Map<String, Object> payload = this.restoreContext(configuration);
            String jsonModel = (String)payload.get(MODEL);
            MessageInfo model = MessageServiceUtil.getMessageInfoFromString(jsonModel);
            MessageCenterServiceHelper.sendMessage((MessageInfo)model);
            MessageJobHandler.recordNoCodeFlowDetailLog(model, payload, commandContext);
        }
        catch (WFMessageServiceException e) {
            throw e;
        }
        catch (KDException e) {
            throw ExceptionUtil.createWFMessageServiceException(job, e);
        }
        catch (Exception e) {
            throw ExceptionUtil.createWFMessageServiceException(job, e, WFErrorCode.messageJobHandlerException(), new Object[0]);
        }
    }

    private static void recordNoCodeFlowDetailLog(MessageInfo model, Map<String, Object> payload, CommandContext commandContext) {
        if (!"NoCodeFlow".equalsIgnoreCase(model.getSource())) {
            return;
        }
        JSONObject context = JSONObject.parseObject((String)((String)payload.get(CONTEXT)));
        String elementId = context.getString("elementId");
        if (elementId.contains("NotifyTask")) {
            String[] channels;
            Long processInstanceId = context.getLong("processInstanceId");
            Long processDefinitionId = context.getLong("processDefinitionId");
            FlowElement flowElement = ProcessDefinitionUtil.getBpmnModel(processDefinitionId, processInstanceId).getFlowElement(elementId);
            String activityName = flowElement.getName();
            String businessKey = context.getString("businessKey");
            String entityNumber = context.getString("entityNumber");
            String notifyType = model.getNotifyType();
            if (!notifyType.contains(MessageChannels.MC.getNumber())) {
                notifyType = notifyType + "," + MessageChannels.MC.getNumber();
            }
            for (String channel : channels = notifyType.split(",")) {
                DetailLogEntityImpl detailLog = new DetailLogEntityImpl();
                detailLog.setProcInstId(processInstanceId);
                detailLog.setProcDefId(processDefinitionId);
                detailLog.setEntityNumber(entityNumber);
                detailLog.setBusinessKey(businessKey);
                detailLog.setActivityId(elementId);
                detailLog.setActivityName((ILocaleString)new LocaleString(activityName));
                detailLog.setMessageId(model.getId());
                detailLog.setChannel(channel);
                detailLog.setCreateDate(model.getSendTime());
                detailLog.setType("message");
                commandContext.getDetailLogEntityManager().recordDetailLog(commandContext, detailLog);
            }
        }
    }
}

