/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.jobexecutor;

import java.util.ArrayList;
import java.util.List;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.engine.impl.cfg.TransactionPropagation;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandConfig;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.interceptor.CommandContextCloseListener;
import kd.bos.workflow.engine.impl.interceptor.CommandExecutor;
import kd.bos.workflow.engine.impl.jobexecutor.IJobScheduleCallback;
import kd.bos.workflow.engine.impl.jobexecutor.JobUtil;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntityManager;

public class ScheduleJobAddedNotification
implements CommandContextCloseListener {
    private List<JobEntity> jobs = new ArrayList<JobEntity>();
    private IJobScheduleCallback closedCallback;
    private Log log = LogFactory.getLog(this.getClass());

    public ScheduleJobAddedNotification(JobEntity job, IJobScheduleCallback closeCallback) {
        this(job);
        this.closedCallback = closeCallback;
    }

    public ScheduleJobAddedNotification(JobEntity job) {
        this.jobs.add(job);
    }

    public ScheduleJobAddedNotification(List<JobEntity> jobs) {
        this.jobs.addAll(jobs);
    }

    @Override
    public void closed(CommandContext commandContext) {
        CommandExecutor commandExecutor = commandContext.getProcessEngineConfiguration().getCommandExecutor();
        CommandConfig commandConfig = new CommandConfig(false, TransactionPropagation.REQUIRES_NEW);
        commandExecutor.execute(commandConfig, new Command<Void>(){

            @Override
            public Void execute(CommandContext commandContext) {
                JobUtil.sendJobToMQ(ScheduleJobAddedNotification.this.jobs);
                return null;
            }
        });
    }

    @Override
    public void closing(CommandContext commandContext) {
        if (this.closedCallback != null && !this.closedCallback.isValidate()) {
            JobEntityManager jobEntityManager = commandContext.getJobEntityManager();
            for (JobEntity job : this.jobs) {
                jobEntityManager.delete(job);
            }
        }
    }

    @Override
    public void afterSessionsFlush(CommandContext commandContext) {
        this.log.debug("afterSessionsFlush...");
    }

    @Override
    public void closeFailure(CommandContext commandContext) {
        this.log.debug("closeFailure...");
    }
}

