/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.jobexecutor;

import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.bizflow.util.BizFlowUtil;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.jobexecutor.AbstractJobHandler;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelType;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.EventSubscriptionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.EventSubscriptionEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.exception.WFEngineException;
import kd.bos.workflow.exception.WFErrorCode;

public class StartProcessEventJobHandler
extends AbstractJobHandler {
    public static final String TYPE = "start-process-event";
    private Log log = LogFactory.getLog(StartProcessEventJobHandler.class);

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void execute(JobEntity job, String configuration, ExecutionEntity execution, CommandContext commandContext) {
        String businessKey;
        this.log.info("execute start process job ,id is [ " + job.getId() + "]");
        Map<String, Object> payload = this.restoreContext(configuration);
        BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModelByProcDefId(job.getProcessDefinitionId());
        if (bpmnModel != null) {
            String processType = bpmnModel.getMainProcess().getProcessType();
            businessKey = job.getBusinessKey();
            String processInstanceId = "";
            if (ModelType.AuditFlow.name().equals(processType)) {
                processInstanceId = commandContext.getExecutionEntityManager().inProcess(businessKey);
            } else if (!ModelType.NoCodeFlow.name().equals(processType)) {
                processInstanceId = commandContext.getExecutionEntityManager().inSameProcess(businessKey, job.getProcessDefinitionId());
            }
            boolean inProcess = WfUtils.isNotEmpty(processInstanceId);
            if ("createSubProcess".equals(payload.get("jobAction"))) {
                inProcess = false;
            }
            if (inProcess) {
                this.log.info(String.format("the processInstance[%s] of businesskey[%s] is exist!", processInstanceId, businessKey));
                job.setExceptionMessage(String.format("the processInstance[%s] of businesskey[%s] is exist!", processInstanceId, businessKey));
                return;
            }
        }
        String entityNumber = (String)payload.get("_entityNumber_");
        businessKey = (String)payload.get("_businessKey_");
        BizFlowUtil.setBizTraceNo(commandContext, entityNumber, businessKey, payload, job, BizFlowUtil.isBizFlow(bpmnModel));
        Long subscriptId = (Long)WfUtils.pop(payload, "_CONFIGURATIONID_");
        EventSubscriptionEntityManager eventSubscriptionEntityManager = commandContext.getEventSubscriptionEntityManager();
        this.log.info(String.format("eventSubscriptionEntityManager job[%s],subscriptid[%s]", job.getId(), subscriptId));
        EventSubscriptionEntity eventSubscriptionEntity = (EventSubscriptionEntity)eventSubscriptionEntityManager.findById(subscriptId);
        if (eventSubscriptionEntity == null) {
            this.log.info(String.format("execute in " + this.getClass().getName() + ",eventSubscriptionEntity is null,job[%s]", job.getId()));
            throw new WFEngineException(null, WFErrorCode.cannotFindSignal(), new Object[]{subscriptId});
        }
        eventSubscriptionEntityManager.eventReceived(eventSubscriptionEntity, payload, false);
    }
}

