/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.jobexecutor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.RPAProcParam;
import kd.bos.workflow.bpmn.model.RPATask;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.VariableScope;
import kd.bos.workflow.engine.impl.calculator.ExpressionCalculatorUtil;
import kd.bos.workflow.engine.impl.cmd.startup.BusinessModelVariableScope;
import kd.bos.workflow.engine.impl.db.EntityQueryBuilder;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.jobexecutor.AbstractJobHandler;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.TrdProcRelationEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.TrdProcRelationEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.task.CommentEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.CommentEntityManager;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.engine.impl.util.RPAUtil;
import kd.bos.workflow.exception.WFErrorCode;
import kd.bos.workflow.exception.WFRPAException;

public class StartRPAProcessJobHandler
extends AbstractJobHandler {
    public static final String TYPE = "start-rpa-process";

    @Override
    public void execute(JobEntity job, String configuration, ExecutionEntity execution, CommandContext commandContext) {
        try {
            String elementId = job.getElementId();
            Long processInstanceId = job.getProcessInstanceId();
            Long processDefinitionId = job.getProcessDefinitionId();
            BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(processDefinitionId, processInstanceId);
            RPATask rpaTask = (RPATask)bpmnModel.getFlowElement(elementId);
            String procCode = rpaTask.getRpaProcCode();
            String robotId = rpaTask.getRpaRobotId();
            List<Map<String, String>> params = this.getRPAProcParams(execution, job.getBusinessKey(), rpaTask);
            Map payload = (Map)SerializationUtils.fromJsonString((String)configuration, Map.class);
            Long actInstId = (Long)payload.get("actInstId");
            this.log.debug(String.format("invoke rpaService addTask, procCode: %s, robotId: %s", procCode, robotId));
            String rpaTaskId = (String)DispatchServiceHelper.invokeBizService((String)"rpac", (String)"rpacp", (String)"RpaService", (String)"addTask", (Object[])new Object[]{procCode, robotId, "", params});
            this.updateTrdProcRelationAndComment(commandContext, job, actInstId, rpaTaskId);
        }
        catch (Exception e) {
            this.log.error(WfUtils.getExceptionStacktrace(e));
            throw new WFRPAException(e, WFErrorCode.startRPAProcessError(), e.getMessage());
        }
    }

    private void updateTrdProcRelationAndComment(CommandContext commandContext, JobEntity job, Long actInstId, String rpaTaskId) {
        Long procInstId = job.getProcessInstanceId();
        TrdProcRelationEntityManager manager = commandContext.getTrdProcRelationEntityManager();
        EntityQueryBuilder queryBuilder = manager.createQueryBuilder();
        queryBuilder.addFilter("procinstid", procInstId);
        queryBuilder.addFilter("actinstid", actInstId);
        List relations = manager.findByQueryBuilder(queryBuilder);
        if (!relations.isEmpty()) {
            TrdProcRelationEntity relation = (TrdProcRelationEntity)relations.get(0);
            relation.setRelationValue(rpaTaskId);
            manager.update(relation);
            CommentEntityManager commentManager = commandContext.getCommentEntityManager();
            CommentEntity commentEntity = (CommentEntity)commentManager.findById(relation.getCommentId());
            commentEntity.setTime(WfUtils.now());
            commentEntity.setMessage(RPAUtil.getStartRPAProcText());
            commentEntity.setGroupId(rpaTaskId);
            commentManager.update(commentEntity);
            RPAUtil.recordOperationLog(commandContext, commentEntity);
        } else {
            this.log.debug(String.format("relation not found. procInstId: %s, actInstId: %s", procInstId, actInstId));
        }
    }

    private List<Map<String, String>> getRPAProcParams(ExecutionEntity execution, String businessKey, RPATask rpaTask) {
        ArrayList<Map<String, String>> params = new ArrayList<Map<String, String>>(16);
        List<RPAProcParam> rpaProcParams = rpaTask.getRpaProcParams();
        if (rpaProcParams == null || rpaProcParams.isEmpty()) {
            return params;
        }
        DynamicObject dynamicObject = WfUtils.findBusinessObject(businessKey, rpaTask.getEntityNumber());
        VariableScope variableScope = null;
        variableScope = execution != null ? execution : new BusinessModelVariableScope(dynamicObject);
        for (RPAProcParam procParam : rpaProcParams) {
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("Name", procParam.getName());
            param.put("Desc", procParam.getDesc());
            param.put("Type", procParam.getType());
            param.put("IsEmpty", procParam.isRequired() ? "1" : "0");
            String expression = procParam.getExpression();
            String expressionValue = null;
            if (WfUtils.isNotEmpty(expression)) {
                Object value = ExpressionCalculatorUtil.parseValue(dynamicObject, variableScope, String.format("${%s}", expression), null);
                if (value != null) {
                    expressionValue = String.valueOf(value);
                }
            } else {
                expressionValue = procParam.getConstant();
            }
            param.put("Value", expressionValue);
            params.add(param);
        }
        return params;
    }

    @Override
    public String getType() {
        return TYPE;
    }
}

