/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.jobexecutor;

import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.jobexecutor.AbstractJobHandler;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelType;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.util.taskrule.VerifyConditionUtils;
import kd.bos.workflow.exception.WFErrorCode;
import kd.bos.workflow.exception.WFTaskException;

public class TaskTransferJobHandler
extends AbstractJobHandler {
    public static final String TYPE = "async-taskTransfer";
    private static Log logger = LogFactory.getLog(TaskTransferJobHandler.class);

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void execute(JobEntity job, String configuration, ExecutionEntity execution, CommandContext commandContext) {
        try {
            Map<String, Object> payload = this.restoreContext(configuration);
            Long taskId = (Long)WfUtils.normalizeId(payload.get("taskId"));
            TaskEntity task = (TaskEntity)commandContext.getTaskEntityManager().findById(taskId);
            if (task == null) {
                logger.debug(String.format("\u4efb\u52a1[%s]\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664\u6216\u8005\u88ab\u64a4\u56de.", taskId));
                job.setExceptionMessage(String.format(ResManager.loadKDString((String)"\u4efb\u52a1\u201c%s\u201d\u672a\u627e\u5230\uff0c\u53ef\u80fd\u5df2\u5220\u9664\u6216\u64a4\u56de\u3002", (String)"TaskTransferJobHandler_1", (String)"bos-wf-engine", (Object[])new Object[0]), taskId));
                return;
            }
            if (ModelType.NoCodeFlow.name().equalsIgnoreCase(task.getProcessType())) {
                return;
            }
            Object obj = WfUtils.normalizeId(payload.get("assigneeid"));
            Long assigneeId = obj instanceof Integer ? Long.valueOf(obj.toString()) : (obj instanceof Long ? (Long)obj : Long.valueOf(Long.parseLong(obj.toString())));
            WfUtils.restoreRequestContext(job.getJobHandlerConfiguration(), String.valueOf(assigneeId));
            VerifyConditionUtils.verifyConditionsAndExecute(taskId, assigneeId);
        }
        catch (Exception e) {
            throw new WFTaskException(e, WFErrorCode.taskRuleAnalysisError(), e.getMessage());
        }
    }
}

