/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.jobexecutor;

import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.engine.delegate.event.ActivitiEventType;
import kd.bos.workflow.engine.delegate.event.impl.ActivitiEventBuilder;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.jobexecutor.JobHandler;
import kd.bos.workflow.engine.impl.jobexecutor.TimerEventHandler;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.engine.timing.IProcessStarter;
import kd.bos.workflow.engine.timing.ProcessStarterFactory;
import kd.bos.workflow.engine.timing.TimingStartProcessParam;
import kd.bos.workflow.exception.WFEngineException;

public class TimerStartEventJobHandler
extends TimerEventHandler
implements JobHandler {
    private Log log = LogFactory.getLog(this.getClass());
    public static final String TYPE = "timer-start-event";

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void execute(JobEntity job, String configuration, ExecutionEntity execution, CommandContext commandContext) {
        ProcessDefinitionEntity processDefinitionEntity = ProcessDefinitionUtil.getProcessDefinitionFromDatabase(job.getProcessDefinitionId());
        if (processDefinitionEntity == null) {
            throw new WFEngineException("Could not find process definition needed for timer start event");
        }
        try {
            if (!processDefinitionEntity.isSuspended().booleanValue()) {
                if (commandContext.getEventDispatcher().isEnabled()) {
                    commandContext.getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.TIMER_FIRED, job));
                }
                String activityId = TimerEventHandler.getActivityIdFromConfiguration(configuration);
                this.startProcess(commandContext, processDefinitionEntity, activityId);
            } else {
                this.log.debug("ignoring timer of suspended process definition {}", (Object)processDefinitionEntity.getName());
            }
        }
        catch (RuntimeException e) {
            this.log.error("exception during timer execution", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            this.log.error("exception during timer execution", (Throwable)e);
            throw new WFEngineException("exception during timer execution: " + e.getMessage(), e);
        }
    }

    public void startProcess(CommandContext commandContext, ProcessDefinitionEntity processDefinitionEntity, String activityId) {
        String processType = processDefinitionEntity.getType();
        IProcessStarter starter = ProcessStarterFactory.getProcessStarter(processType);
        TimingStartProcessParam param = new TimingStartProcessParam();
        param.setStartActivityId(activityId);
        param.setProcessDefinition(processDefinitionEntity);
        starter.startProcess(commandContext, param);
    }
}

