/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.jobexecutor;

import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.jobexecutor.AbstractJobHandler;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.util.DynamicFlowUtil;
import kd.bos.workflow.engine.timing.ITimingProcessor;
import kd.bos.workflow.engine.timing.TimingFactory;
import kd.bos.workflow.engine.timing.TimingModelUtil;

public class TimingModelJobHandler
extends AbstractJobHandler {
    public static final String TYPE = "async-timing";
    private final Log log = LogFactory.getLog(this.getClass());

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void execute(JobEntity job, String configuration, ExecutionEntity execution, CommandContext commandContext) {
        if (!this.executionExist(execution, job)) {
            return;
        }
        String elementId = job.getElementId();
        if (!elementId.equals(execution.getCurrentActivityId())) {
            String msg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u8282\u70b9\u4e3a %1$s\uff0c\u4e0e Job\u4e2d\u8282\u70b9 %2$s \u4e0d\u4e00\u81f4\uff0c\u53ef\u80fd\u88ab\u8df3\u8f6c\uff0c\u4e0d\u505a\u4efb\u4f55\u5904\u7406\u3002", (String)"TimingModelJobHandler_1", (String)"bos-wf-engine", (Object[])new Object[0]), execution.getCurrentActivityId(), elementId);
            this.log.debug(msg);
            job.setExceptionMessage(msg);
            return;
        }
        String dynType = DynamicFlowUtil.getDynamicVariableValue(execution, "dynType");
        if ("abortByParentProcessJump".equals(dynType) || "forceAbort".equalsIgnoreCase(dynType)) {
            this.log.debug(String.format("dynType is %s", configuration));
            Context.getAgenda().planTriggerExecutionOperation(execution);
            return;
        }
        Map config = (Map)SerializationUtils.fromJsonString((String)configuration, Map.class);
        String type = (String)config.get("timingType");
        ITimingProcessor processor = TimingFactory.getTimingOperateProcessor(type);
        if (processor != null) {
            TimingModelUtil.execute(processor, commandContext, execution, elementId);
        } else {
            this.log.warn("The processor is null! Configuration: " + configuration);
        }
    }
}

