/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.jobexecutor;

import java.util.ArrayList;
import java.util.List;
import kd.bos.workflow.bpmn.model.BoundaryEvent;
import kd.bos.workflow.bpmn.model.CallActivity;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.FlowNode;
import kd.bos.workflow.bpmn.model.SubProcess;
import kd.bos.workflow.engine.delegate.event.ActivitiEventType;
import kd.bos.workflow.engine.delegate.event.impl.ActivitiEventBuilder;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.jobexecutor.JobHandler;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;

public class TriggerTimerEventJobHandler
implements JobHandler {
    public static final String TYPE = "trigger-timer";

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void execute(JobEntity job, String configuration, ExecutionEntity execution, CommandContext commandContext) {
        Context.getAgenda().planTriggerExecutionOperation(execution);
        if (commandContext.getEventDispatcher().isEnabled()) {
            commandContext.getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.TIMER_FIRED, job));
        }
        if (execution.getCurrentFlowElement() instanceof BoundaryEvent) {
            ArrayList<String> processedElements = new ArrayList<String>();
            this.dispatchExecutionTimeOut(job, execution, processedElements, commandContext);
        }
    }

    protected void dispatchExecutionTimeOut(JobEntity timerEntity, ExecutionEntity execution, List<String> processedElements, CommandContext commandContext) {
        block7: {
            ExecutionEntity subProcessInstance;
            block6: {
                FlowElement currentElement = execution.getCurrentFlowElement();
                if (!(currentElement instanceof BoundaryEvent)) break block6;
                BoundaryEvent boundaryEvent = (BoundaryEvent)execution.getCurrentFlowElement();
                if (!boundaryEvent.isCancelActivity() || boundaryEvent.getAttachedToRef() == null || processedElements.contains(boundaryEvent.getId())) break block7;
                processedElements.add(boundaryEvent.getId());
                ExecutionEntity executionEntity = execution.getParent();
                this.dispatchExecutionTimeOut(timerEntity, executionEntity, processedElements, commandContext);
                break block7;
            }
            if (execution.getCurrentFlowElement() instanceof FlowNode) {
                processedElements.add(execution.getCurrentActivityId());
                this.dispatchActivityTimeOut(timerEntity, (FlowNode)execution.getCurrentFlowElement(), execution, commandContext);
            }
            if (execution.getCurrentFlowElement() instanceof SubProcess) {
                for (ExecutionEntity executionEntity : execution.getExecutions()) {
                    if (processedElements.contains(executionEntity.getCurrentActivityId())) continue;
                    this.dispatchExecutionTimeOut(timerEntity, executionEntity, processedElements, commandContext);
                }
            } else if (execution.getCurrentFlowElement() instanceof CallActivity && (subProcessInstance = commandContext.getExecutionEntityManager().findSubProcessInstanceBySuperExecutionId(execution.getId())) != null) {
                List<? extends ExecutionEntity> list = subProcessInstance.getExecutions();
                for (ExecutionEntity executionEntity : list) {
                    if (processedElements.contains(executionEntity.getCurrentActivityId())) continue;
                    this.dispatchExecutionTimeOut(timerEntity, executionEntity, processedElements, commandContext);
                }
            }
        }
    }

    protected void dispatchActivityTimeOut(JobEntity timerEntity, FlowNode flowNode, ExecutionEntity execution, CommandContext commandContext) {
        commandContext.getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createActivityCancelledEvent(flowNode.getId(), flowNode.getName(), execution.getId(), execution.getProcessInstanceId(), execution.getProcessDefinitionId(), this.parseActivityType(flowNode), timerEntity));
    }

    protected String parseActivityType(FlowNode flowNode) {
        String elementType = flowNode.getClass().getSimpleName();
        elementType = elementType.substring(0, 1).toLowerCase() + elementType.substring(1);
        return elementType;
    }
}

