/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.jobexecutor;

import java.util.HashMap;
import java.util.Map;
import kd.bos.workflow.engine.RuntimeService;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.jobexecutor.AbstractJobHandler;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;

public class WaitEventJobHandler
extends AbstractJobHandler {
    public static final String TYPE = "wait-event";

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void execute(JobEntity job, String configuration, ExecutionEntity execution, CommandContext commandContext) {
        this.log.debug(String.format("execute WaitEventJobHandler... %s %s %s", job.getId(), configuration, execution != null ? execution.getId() : "null"));
        Map<String, Object> config = this.restoreContext(configuration);
        Long subscriptionId = (Long)config.get("subscriptionId");
        String eventType = (String)config.get("type");
        RuntimeService runtimeService = Context.getCommandContext().getProcessEngineConfiguration().getRuntimeService();
        if (WfUtils.isEmpty(subscriptionId)) {
            HashMap<String, Object> payload = new HashMap<String, Object>();
            payload.put("entityNumber", (String)config.get("entityNumber"));
            payload.put("businessKey", (String)config.get("businessKey"));
            payload.putAll(config);
            runtimeService.waitEventReceivedAsync((String)config.get("eventNumber"), null, payload);
        } else if ("waitactions".equals(eventType)) {
            runtimeService.waitActionsEventReceived(subscriptionId, config);
        } else {
            runtimeService.waitEventReceived(subscriptionId, config);
        }
    }
}

