/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.log;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.log.ILogItem;
import kd.bos.workflow.engine.impl.log.IParseLog;
import kd.bos.workflow.engine.impl.log.LogBlock;
import kd.bos.workflow.engine.impl.log.LogContext;
import kd.bos.workflow.relservice.WorkflowUserRelQueryHelper;

public class ParseLog
implements IParseLog {
    protected static Log logger = LogFactory.getLog(ParseLog.class);
    private String patternString = "\\$\\{([a-z\\|0-9]+)\\}";

    @Override
    public String parseLog(LogContext logContext, Map<String, Map<Long, String>> collectorData) {
        StringBuilder logData = new StringBuilder();
        ILogItem logBlock = logContext.getRootLogBlock();
        if (logBlock != null) {
            this.iteratorBlockData(logData, logBlock.getQueue(), logBlock.getLevel(), collectorData);
        }
        return logData.toString();
    }

    @Override
    public String parseLog(LogContext logContext) {
        Map<String, Map<Long, String>> participanrMap = this.fetchParticipantById(logContext);
        return this.parseLog(logContext, participanrMap);
    }

    private void iteratorBlockData(StringBuilder logData, LinkedList<Object> queue, int childCount, Map<String, Map<Long, String>> collectorData) {
        for (Object e : queue) {
            if (e instanceof LogBlock) {
                this.iteratorBlockData(logData, ((LogBlock)e).getQueue(), ((LogBlock)e).getLevel(), collectorData);
                continue;
            }
            if (!(e instanceof StringBuilder)) continue;
            if (childCount <= 0) {
                childCount = 1;
            }
            logData.append("<p style=\"font-size:12px;color:#666666;line-height:21px;font-family:'\u5fae\u8f6f\u96c5\u9ed1';word-break:break-all;text-indent:").append((childCount - 1) * 2).append("em\">");
            String dataRe = this.regularMatchingAndSubstitution(e.toString(), collectorData);
            logData.append(dataRe).append("<br/> </p>");
        }
    }

    public String regularMatchingAndSubstitution(String data, Map<String, Map<Long, String>> participanrMap) {
        if (participanrMap == null || participanrMap.size() == 0) {
            return data;
        }
        StringBuffer re = new StringBuffer();
        try {
            Matcher matcher = Pattern.compile(this.patternString).matcher(data);
            while (matcher.find()) {
                String participantId = matcher.group();
                String subString = data.substring(matcher.start() + 2, matcher.end() - 1);
                String[] str = subString.split("\\|");
                Map<Long, String> id = participanrMap.get(str[0]);
                String name = id.get(Long.valueOf(str[1]));
                matcher.appendReplacement(re, matcher.group().replace(participantId, name != null ? name : str[1]));
            }
            matcher.appendTail(re);
        }
        catch (KDException e) {
            logger.info("regular regularMatching and Substitution is faile" + WfUtils.getExceptionStacktrace(e));
        }
        if (re.length() > 0) {
            return re.toString();
        }
        return data;
    }

    private Map<String, Map<Long, String>> fetchParticipantById(LogContext logContext) {
        Map<String, Set<Object>> participant = logContext.getBasicData();
        if (participant.size() == 0) {
            return null;
        }
        HashMap<String, Map<Long, String>> participanrMap = new HashMap<String, Map<Long, String>>();
        for (Map.Entry<String, Set<Object>> entry : participant.entrySet()) {
            switch (entry.getKey()) {
                case "user": {
                    Map<Long, String> user = this.getUserNameById(entry.getValue());
                    participanrMap.put("user", user);
                    break;
                }
                case "role": {
                    Map<Long, String> role = this.getRoleNameById(entry.getValue());
                    participanrMap.put("role", role);
                    break;
                }
                case "org": {
                    Map<Long, String> org = this.getOrgNameById(entry.getValue());
                    participanrMap.put("org", org);
                    break;
                }
                case "position": {
                    Map<Long, String> positions = this.getPositionNameById(entry.getValue());
                    participanrMap.put("position", positions);
                    break;
                }
                case "reporttype": {
                    Map<Long, String> reportTypes = this.getReportTypes(entry.getValue());
                    participanrMap.put("reporttype", reportTypes);
                    break;
                }
            }
        }
        return participanrMap;
    }

    private List<Long> dataTypeConversion(Set<Object> particiantIds) {
        ArrayList<Long> ids = new ArrayList<Long>();
        for (Object id : particiantIds) {
            if (id instanceof Long) {
                ids.add((Long)id);
                continue;
            }
            ids.add(Long.valueOf((String)id));
        }
        return ids;
    }

    private Map<Long, String> getUserNameById(Set<Object> particiantIds) {
        List users = UserServiceHelper.getUserInfoByID(this.dataTypeConversion(particiantIds));
        HashMap<Long, String> particianpt = new HashMap<Long, String>(users.size());
        for (Map user : users) {
            particianpt.put((Long)user.get("id"), (String)user.get("name"));
        }
        return particianpt;
    }

    private Map<Long, String> getRoleNameById(Set<Object> particiantIds) {
        DynamicObject[] orgs = BusinessDataServiceHelper.load((String)"wf_role", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "in", this.dataTypeConversion(particiantIds))});
        HashMap<Long, String> particianpt = new HashMap<Long, String>(orgs.length);
        for (DynamicObject org : orgs) {
            particianpt.put(org.getLong("id"), org.getString("name"));
        }
        return particianpt;
    }

    private Map<Long, String> getOrgNameById(Set<Object> particiantIds) {
        DynamicObject[] orgs = BusinessDataServiceHelper.load((String)"bos_org", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "in", this.dataTypeConversion(particiantIds))});
        HashMap<Long, String> particianpt = new HashMap<Long, String>(orgs.length);
        for (DynamicObject org : orgs) {
            particianpt.put(org.getLong("id"), org.getString("name"));
        }
        return particianpt;
    }

    private Map<Long, String> getPositionNameById(Set<Object> positionIds) {
        DynamicObject[] positions = BusinessDataServiceHelper.load((String)"bos_position", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "in", this.dataTypeConversion(positionIds))});
        HashMap<Long, String> particianpt = new HashMap<Long, String>(positions.length);
        for (DynamicObject position : positions) {
            particianpt.put(position.getLong("id"), position.getString("name"));
        }
        return particianpt;
    }

    private Map<Long, String> getReportTypes(Set<Object> reportTypeIds) {
        HashMap<Long, String> particianpt = new HashMap<Long, String>();
        try {
            LinkedHashMap<Long, ILocaleString> reportTypes = WorkflowUserRelQueryHelper.getPositionQueryProvider().getReportTypes(new HashSet<Object>());
            reportTypes.forEach((id, name) -> particianpt.put((Long)id, WfUtils.isNotEmpty(name) ? name.toString() : ""));
        }
        catch (Exception e) {
            logger.info(String.format("get position error,the error is : %s", WfUtils.getExceptionStacktrace(e)));
        }
        return particianpt;
    }
}

