/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.log;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.VariableScope;
import kd.bos.workflow.engine.impl.cmd.startup.BusinessModelVariableScope;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.log.ILogItem;
import kd.bos.workflow.engine.impl.log.LogClassType;
import kd.bos.workflow.engine.impl.log.LogContext;
import kd.bos.workflow.engine.impl.log.SceneType;
import kd.bos.workflow.engine.impl.log.listener.ExecuteLogCreateListener;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.pojo.LogMember;
import kd.bos.workflow.service.impl.ServiceFactory;

public class RunTimeLog {
    protected static Log logger = LogFactory.getLog(RunTimeLog.class);

    public static RunTimeLog get() {
        return (RunTimeLog)ServiceFactory.getService(RunTimeLog.class);
    }

    public void init(SceneType sceneType, LogClassType logClassType) {
        if (WfConfigurationUtil.getDisableParseLogCollect()) {
            return;
        }
        try {
            LogContext logContext = new LogContext();
            logContext.setStartParseTime(new Date());
            logContext.setSceneType(sceneType);
            logContext.setLogClassType(logClassType);
            logContext.setParseLog(logClassType.getParseClass());
            logContext.setInsertDB(logClassType.isInsertDB());
            if (Context.getCommandContext().getLogContextMap().size() == 0) {
                logger.debug("init add listener sucess");
                Context.getCommandContext().addCloseListener(new ExecuteLogCreateListener("logCreate"));
            }
            ILogItem rootBlock = this.initLogParseObject(logClassType.getLogClass());
            logContext.setRootLogBlock(rootBlock);
            logContext.addLogItemStack(rootBlock);
            Context.getCommandContext().setLogContext(logContext);
            logger.debug("RuntimeLog init sucess");
        }
        catch (Exception e) {
            logger.debug("RuntimeLog init faile message:" + WfUtils.getExceptionStacktrace(e));
        }
    }

    public void end(VariableScope variableScope) {
        try {
            if (this.getLogContext() == null || variableScope == null) {
                return;
            }
            if (variableScope instanceof ExecutionEntity) {
                this.initLogContextByExecution((ExecutionEntity)variableScope, this.getLogContext());
            } else if (variableScope instanceof BusinessModelVariableScope) {
                this.initLogContextByBusinessModelVariableScope((BusinessModelVariableScope)variableScope, this.getLogContext());
            } else if (variableScope instanceof TaskEntity) {
                TaskEntity taskEntity = (TaskEntity)variableScope;
                this.initLogContextByExecution(taskEntity.getExecution(), this.getLogContext());
            }
            LogContext logContext = Context.getCommandContext().getLogContextList().pop();
            Context.getCommandContext().setLogContextMap(logContext.getSceneType().getType(), logContext);
            logger.debug("RuntimeLog end sucess" + logContext.getActivityName() + logContext.getBusinessKey());
        }
        catch (Exception e) {
            logger.debug("RuntimeLog end faile message:" + WfUtils.getExceptionStacktrace(e));
        }
    }

    private void initLogContextByExecution(ExecutionEntity executionEntity, LogContext logContext) {
        logContext.setActivityId(executionEntity.getActivityId());
        logContext.setActivityName(executionEntity.getActivityName() == null ? null : executionEntity.getActivityName().getLocaleValue());
        logContext.setBillNo(executionEntity.getBillNo());
        logContext.setBusinessKey(executionEntity.getBusinessKey());
        logContext.setProcessDefinitionId(executionEntity.getProcessDefinitionId());
        logContext.setProcessInstanceId(executionEntity.getProcessInstanceId());
        logContext.setTaskId(executionEntity.getCurrentTaskId());
        logContext.setEntityNum(executionEntity.getEntityNumber());
        logContext.setName(executionEntity.getName() == null ? null : executionEntity.getName().getLocaleValue());
        logContext.setSubProcess(executionEntity.getSuperExecutionId() != null && executionEntity.getSuperExecutionId() != 0L);
        logContext.setProcessType(executionEntity.getProcessType());
    }

    private void initLogContextByBusinessModelVariableScope(BusinessModelVariableScope variableScope, LogContext logContext) throws JsonProcessingException {
        if (variableScope.getBusinessKey() == null || variableScope.getEntityNumber() == null) {
            return;
        }
        logContext.setBusinessKey(variableScope.getBusinessKey());
        logContext.setEntityNum(variableScope.getEntityNumber());
        DynamicObject model = variableScope.getModel();
        String billNo = WfUtils.getBillNo(model);
        logContext.setBillNo(billNo);
        String logMemberJSON = (String)variableScope.getVariable("logMember");
        LogMember member = (LogMember)new ObjectMapper().readValue(logMemberJSON, LogMember.class);
        logContext.setName(member.getName());
        logContext.setProcessDefinitionId(member.getProcessDefinitionId());
        logContext.setSubProcess(member.getSub());
    }

    private LogContext getLogContext() {
        CommandContext commandContext = Context.getCommandContext();
        if (commandContext == null) {
            return null;
        }
        return commandContext.getLogContext();
    }

    public void createBlock(String data) {
        LogContext logContext = this.getLogContext();
        if (logContext == null) {
            return;
        }
        ILogItem logBlock = this.initLogParseObject(logContext.getLogClassType().getLogClass());
        if (logBlock == null) {
            logger.debug("create block faile ,logblock is null ");
            return;
        }
        ILogItem currentLogBlock = logContext.getCurrentLogBlock();
        if (currentLogBlock == null) {
            logContext.getRootLogBlock().addQueueLast(logBlock);
            logBlock.setLevel(1);
        } else {
            currentLogBlock.addQueueLast(logBlock);
            logBlock.setLevel(currentLogBlock.getLevel() + 1);
        }
        logBlock.addDataNewLine(data);
        logContext.addLogItemStack(logBlock);
        logContext.setCurrentLogBlock(logBlock);
    }

    public void addlnFirstLog(String data) {
        LogContext logContext = this.getLogContext();
        if (logContext == null) {
            return;
        }
        ILogItem currentLogBlock = logContext.getCurrentLogBlock();
        if (currentLogBlock != null) {
            currentLogBlock.addQueueFirst(new StringBuilder(data));
        }
    }

    public void createBlock() {
        this.createBlock(null);
    }

    private ILogItem initLogParseObject(Class<?> currentLogClass) {
        try {
            return (ILogItem)currentLogClass.newInstance();
        }
        catch (ReflectiveOperationException e) {
            logger.debug("initLogParseObject is faile  " + WfUtils.getExceptionStacktrace(e));
            return null;
        }
    }

    public void endBlock(String data) {
        LogContext logContext = this.getLogContext();
        if (logContext == null || logContext.getCurrentLogBlock() == null) {
            return;
        }
        if (logContext.getCurrentLogBlock().getLevel() == 0) {
            logContext.setCurrentLogBlock(null);
            return;
        }
        ILogItem logChildBlock = logContext.getLogItemStack().pop();
        logChildBlock.addDataNewLine(data);
        if (!logContext.getLogItemStack().empty()) {
            ILogItem logBlock = logContext.getLogItemStack().peek();
            logContext.setCurrentLogBlock(logBlock);
        }
    }

    public void endBlock() {
        this.endBlock(null);
    }

    public void appendLog(String data) {
        LogContext logContext = this.getLogContext();
        if (logContext == null) {
            return;
        }
        ILogItem currentLogBlock = logContext.getCurrentLogBlock();
        currentLogBlock.addData(data);
    }

    public void addlnLog(String data) {
        LogContext logContext = this.getLogContext();
        if (logContext == null) {
            return;
        }
        ILogItem currentLogBlock = logContext.getCurrentLogBlock();
        currentLogBlock.addDataNewLine(data);
    }

    public String collectAndSubstitution(List<?> userIds, String type) {
        LogContext logContext = this.getLogContext();
        if (logContext == null) {
            return null;
        }
        try {
            StringBuilder sb = new StringBuilder();
            if (userIds != null && userIds.size() > 0) {
                Set<Object> participantList = logContext.getBasicData(type);
                if (participantList == null) {
                    participantList = new HashSet<Object>(userIds.size());
                }
                for (Object userid : userIds) {
                    String id;
                    if (userid == null || !WfUtils.isNotEmpty(id = String.valueOf(userid))) continue;
                    if (id.contains(",")) {
                        String[] ids = id.split(",");
                        for (int i = 0; i < ids.length; ++i) {
                            if (ids[i] == null || !WfUtils.isNotEmpty(String.valueOf(ids[i]))) continue;
                            participantList.add(ids[i]);
                            sb.append("${").append(type).append("|").append(String.valueOf(ids[i])).append("},");
                        }
                        continue;
                    }
                    participantList.add(id);
                    sb.append("${").append(type).append("|").append(id).append("},");
                }
                logContext.setBasicData(type, participantList);
            }
            if (sb.length() > 0) {
                return sb.toString().substring(0, sb.length() - 1);
            }
            return sb.toString();
        }
        catch (Exception e) {
            logger.debug("RuntimeLog collectAndSubstitution faile message:" + WfUtils.getExceptionStacktrace(e));
            return null;
        }
    }

    public void setTransientVariable(String key, Object value) {
        LogContext logContext = this.getLogContext();
        if (logContext == null) {
            return;
        }
        logContext.setVariable(key, value);
    }

    public Object getTransientVariable(String key) {
        LogContext logContext = this.getLogContext();
        if (logContext == null) {
            return null;
        }
        return logContext.getVariable(key);
    }
}

