/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.log.builder;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.engine.impl.cmd.startup.BusinessModelVariableScope;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.model.ProcessDefinitionStartInfo;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntity;
import kd.bos.workflow.engine.pojo.AddressProcedure;
import kd.bos.workflow.engine.pojo.SchemePathItem;
import kd.bos.workflow.engine.pojo.record.AlternativeProcess;

public class AddressLogger {
    public static final int MAX_SIZE = 100;
    private AddressProcedure addressProcedure = new AddressProcedure();
    public static final Log kdlog = LogFactory.getLog((String)AddressLogger.class.getName());

    private AddressLogger() {
    }

    public static AddressLogger init(CommandContext commandContext, String businessKey, String operation, DynamicObject bill, String entityNumber) {
        try {
            AddressLogger logger = new AddressLogger();
            logger.setAddressProcedure(new AddressProcedure(businessKey, operation, bill, entityNumber));
            commandContext.addAttribute("AddressLogger", logger);
            return logger;
        }
        catch (Throwable e) {
            kdlog.warn(e);
            return new AddressLogger();
        }
    }

    public AddressLogger logEnteredProcess(Long processDefinitionId) {
        try {
            List<AlternativeProcess> alternativeProcesses = this.addressProcedure.getAlternativeProcesses();
            if (alternativeProcesses == null || alternativeProcesses.isEmpty() || processDefinitionId == null || processDefinitionId == 0L) {
                return this;
            }
            AlternativeProcess alternativeProcess = alternativeProcesses.stream().filter(item -> processDefinitionId.equals(item.getProcessDefinitionId())).findFirst().orElseGet(AlternativeProcess::new);
            if (alternativeProcess.getProcessDefinitionId() != null && alternativeProcess.getProcessDefinitionId() != 0L) {
                this.addressProcedure.setEnteredProcess(alternativeProcess);
            }
            return this;
        }
        catch (Throwable e) {
            kdlog.warn(e);
            return this;
        }
    }

    public static AddressLogger init(CommandContext commandContext) {
        try {
            AddressLogger logger = new AddressLogger();
            commandContext.addAttribute("AddressLogger", logger);
            return logger;
        }
        catch (Throwable e) {
            kdlog.warn(e);
            return new AddressLogger();
        }
    }

    public static AddressLogger get(CommandContext commandContext) {
        try {
            if (commandContext == null) {
                return new AddressLogger();
            }
            AddressLogger addressLogger = (AddressLogger)commandContext.getAttribute("AddressLogger");
            if (addressLogger == null) {
                return new AddressLogger();
            }
            return addressLogger;
        }
        catch (Throwable e) {
            kdlog.warn(e);
            return new AddressLogger();
        }
    }

    public AddressProcedure getAddressProcedure() {
        return this.addressProcedure;
    }

    public AddressLogger setAddressProcedure(AddressProcedure addressProcedure) {
        this.addressProcedure = addressProcedure;
        return this;
    }

    public AddressLogger logSubProcessAddress(ProcessDefinitionEntity def, Map<String, Object> variables) {
        try {
            AlternativeProcess build = AlternativeProcess.build(def);
            build.setParentProcess(variables);
            this.addressProcedure.setEnteredProcess(build);
        }
        catch (Throwable e) {
            kdlog.warn(e);
        }
        return this;
    }

    public AddressLogger logEnteredProcess(ProcessDefinitionStartInfo processDefinition) {
        try {
            this.addressProcedure.setEnteredProcess(AlternativeProcess.build(processDefinition));
        }
        catch (Throwable e) {
            kdlog.warn(e);
        }
        return this;
    }

    public AddressLogger logAddressByOrgStatus(boolean addressByOrg) {
        try {
            this.addressProcedure.setAddressByOrgStatus(addressByOrg);
        }
        catch (Throwable e) {
            kdlog.warn(e);
        }
        return this;
    }

    public AddressLogger logBillMainOrgId(Long billMainOrgId) {
        try {
            this.addressProcedure.setOrgId(billMainOrgId);
        }
        catch (Throwable e) {
            kdlog.warn(e);
        }
        return this;
    }

    public AddressLogger logParentOrgIds(List<Long> parentIds) {
        try {
            this.addressProcedure.setParentOrgIds(new ArrayList<Long>(parentIds));
        }
        catch (Throwable e) {
            kdlog.warn(e);
        }
        return this;
    }

    public AddressLogger logAlternativeProcesses(ProcessDefinitionStartInfo info, Long orgId, String processKey) {
        try {
            List<AlternativeProcess> alternativeProcesses = this.addressProcedure.getAlternativeProcesses();
            if (alternativeProcesses == null) {
                alternativeProcesses = new ArrayList<AlternativeProcess>(0);
                this.addressProcedure.setAlternativeProcesses(alternativeProcesses);
            }
            if (alternativeProcesses.size() > 100) {
                return this;
            }
            AlternativeProcess alternativeProcess = AlternativeProcess.build(info);
            alternativeProcess.setProcessKey(processKey);
            alternativeProcess.setOrgId(orgId);
            alternativeProcesses.add(alternativeProcess);
        }
        catch (Throwable e) {
            kdlog.warn(e);
        }
        return this;
    }

    public AddressLogger logAlternativeProcesses(ProcessDefinitionStartInfo info, Long orgId, Boolean ret, BusinessModelVariableScope bizScope) {
        try {
            List<AlternativeProcess> alternativeProcesses = this.addressProcedure.getAlternativeProcesses();
            if (alternativeProcesses == null) {
                alternativeProcesses = new ArrayList<AlternativeProcess>(0);
                this.addressProcedure.setAlternativeProcesses(alternativeProcesses);
            }
            if (alternativeProcesses.size() >= 100) {
                return this;
            }
            AlternativeProcess alternativeProcess = AlternativeProcess.build(info);
            alternativeProcess.setOrgId(orgId);
            alternativeProcess.setStartConditionStatus(ret);
            alternativeProcess.setParsedCondition(bizScope);
            alternativeProcesses.add(alternativeProcess);
        }
        catch (Throwable e) {
            kdlog.warn(e);
        }
        return this;
    }

    public AddressLogger logFindTheOnlyProcessStatus(boolean only) {
        try {
            this.addressProcedure.setFindTheOnlyProcessStatus(only);
        }
        catch (Throwable e) {
            kdlog.warn(e);
        }
        return this;
    }

    public AddressLogger logAlternativeProcesses(ProcessDefinitionStartInfo info, Boolean ret, BusinessModelVariableScope bizScope) {
        try {
            return this.logAlternativeProcesses(info, null, ret, bizScope);
        }
        catch (Throwable e) {
            kdlog.warn(e);
            return new AddressLogger();
        }
    }

    public AddressLogger logAlternativeProcesses(ProcessDefinitionStartInfo info) {
        try {
            return this.logAlternativeProcesses(info, false, null);
        }
        catch (Throwable e) {
            kdlog.warn(e);
            return new AddressLogger();
        }
    }

    public AddressLogger logAlternativeProcesses(ProcessDefinitionStartInfo info, Long orgId) {
        try {
            return this.logAlternativeProcesses(info, orgId, null);
        }
        catch (Throwable e) {
            kdlog.warn(e);
            return new AddressLogger();
        }
    }

    public AddressLogger logEnteredProcessSchemeList(List<SchemePathItem> items) {
        try {
            AlternativeProcess enteredProcess = Optional.ofNullable(this.addressProcedure.getEnteredProcess()).orElseGet(AlternativeProcess::new);
            enteredProcess.setSchemePathItemList(items);
            return this;
        }
        catch (Throwable e) {
            kdlog.warn(e);
            return new AddressLogger();
        }
    }

    public AddressLogger logEnteredProcessTargetScheme(SchemePathItem item) {
        try {
            AlternativeProcess enteredProcess = Optional.ofNullable(this.addressProcedure.getEnteredProcess()).orElseGet(AlternativeProcess::new);
            enteredProcess.setTargetScheme(item);
            return this;
        }
        catch (Throwable e) {
            kdlog.warn(e);
            return new AddressLogger();
        }
    }

    public void unwanted() {
        try {
            this.addressProcedure.setUnwanted(true);
        }
        catch (Throwable e) {
            kdlog.warn(e);
        }
    }

    public void logEnteredProcess(ProcessDefinitionEntity def) {
        try {
            AlternativeProcess build = AlternativeProcess.build(def);
            this.addressProcedure.setEnteredProcess(build);
        }
        catch (Throwable e) {
            kdlog.warn(e);
        }
    }
}

