/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.log.builder;

import com.google.common.base.Joiner;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.workflow.engine.impl.log.builder.AddressProcedureMultiLang;
import kd.bos.workflow.engine.impl.log.builder.MsgCollector;
import kd.bos.workflow.engine.pojo.record.AlternativeProcess;

public final class CommonCollector
extends MsgCollector {
    @Override
    public String buildMsg() {
        String s2;
        String s1;
        String result = this.addressResult(this.addressProcedure.getEnteredProcess(), this.addressProcedure.getAllowNextParticipant());
        this.log.writeToTempBlock(AddressProcedureMultiLang.LANG_43.getDesc() + result);
        this.log.writeToTempBlock(AddressProcedureMultiLang.LANG_44.getDesc());
        StringBuilder content = this.builder.getHead(this.addressProcedure);
        this.log.writeLog(content.toString());
        this.log.writeToThisBlock(AddressProcedureMultiLang.LANG_39.getDesc());
        List<AlternativeProcess> alternativeProcesses = this.addressProcedure.getAlternativeProcesses();
        List<AlternativeProcess> hasConditionProcessList = this.builder.getHasConditionList(alternativeProcesses);
        List<AlternativeProcess> noConditionProcessList = this.builder.getNoConditionList(alternativeProcesses);
        AlternativeProcess enteredProcess = this.addressProcedure.getEnteredProcess();
        if (hasConditionProcessList != null && !hasConditionProcessList.isEmpty()) {
            List hasConditionProcessMsgList = hasConditionProcessList.stream().map(item -> "\u3010" + item.getNumber() + "\u3011").collect(Collectors.toList());
            String join = Joiner.on((String)"\u3001").join(hasConditionProcessMsgList);
            String hasConditionMsg = "{{" + AddressProcedureMultiLang.LANG_28.getDesc() + join + "\u3002\n" + AddressProcedureMultiLang.LANG_29.getDesc() + "}}";
            this.log.writeLog(hasConditionMsg);
            content.append(hasConditionMsg).append("\n");
            String contentListStr = this.logContentList(hasConditionProcessList);
            content.append(contentListStr);
        } else {
            String desc = AddressProcedureMultiLang.LANG_42.getDesc();
            content.append(desc);
            this.log.writeToThisBlock(desc);
        }
        if (noConditionProcessList.isEmpty() && (enteredProcess == null || enteredProcess.getProcessDefinitionId() == null)) {
            s1 = AddressProcedureMultiLang.LANG_30.getDesc();
            s2 = AddressProcedureMultiLang.LANG_31.getDesc();
            content.append(s1).append(s2);
            this.log.writeToPreBlock(s1 + s2);
            this.log.writeToPreBlock(AddressProcedureMultiLang.LANG_45.getDesc());
            return content.toString();
        }
        if (StringUtils.isEmpty((CharSequence)enteredProcess.getStartCondition())) {
            s1 = AddressProcedureMultiLang.LANG_32.getDesc();
            this.log.writeToPreBlock(s1);
            s2 = String.format(AddressProcedureMultiLang.LANG_33.getDesc(), noConditionProcessList.size());
            String processMsgListStr = this.builder.getProcessMsgListStr(noConditionProcessList);
            content.append(s1);
            content.append(s2);
            this.log.writeToThisBlock(s2 + processMsgListStr);
            content.append(processMsgListStr).append("\n");
        }
        Boolean justAddress = this.addressProcedure.getAllowNextParticipant();
        String schemeMsg = this.builder.getSchemeMsg(enteredProcess.getSchemePathItemList(), enteredProcess.getTargetScheme());
        if (StringUtils.isEmpty((CharSequence)schemeMsg)) {
            String s = this.builder.enteredMsg(enteredProcess, justAddress);
            this.log.writeToPreBlock(s);
            return content.append(s).toString();
        }
        String schemeHead = AddressProcedureMultiLang.LANG_34.getDesc();
        String enteredMsg = this.builder.enteredMsg(enteredProcess, justAddress);
        this.log.writeToPreBlock(schemeHead);
        this.logSchemeList(enteredProcess.getSchemePathItemList(), enteredProcess.getTargetScheme());
        this.log.writeToPreBlock(enteredMsg);
        return content.append(schemeHead).append(schemeMsg).append(enteredMsg).toString();
    }

    public String addressResult(AlternativeProcess enteredAddress, boolean justAddress) {
        if (enteredAddress == null || enteredAddress.isEmpty()) {
            return AddressProcedureMultiLang.LANG_45.getDesc() + "\n";
        }
        return this.builder.enteredMsg(enteredAddress, justAddress);
    }
}

