/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.log.builder;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.workflow.engine.impl.log.builder.AddressProcedureMultiLang;
import kd.bos.workflow.engine.impl.log.builder.OnlyMsgStatus;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelType;
import kd.bos.workflow.engine.pojo.AddressProcedure;
import kd.bos.workflow.engine.pojo.SchemePathItem;
import kd.bos.workflow.engine.pojo.record.AlternativeProcess;

public interface ComponentBuilder {
    public StringBuilder getHead(AddressProcedure var1, OnlyMsgStatus var2);

    default public StringBuilder getHead(AddressProcedure addressProcedure) {
        return this.getHead(addressProcedure, OnlyMsgStatus.FALSE);
    }

    default public String getNoConditionMsg(List<AlternativeProcess> noConditionProcessList, boolean bizFlow) {
        StringBuilder sb = new StringBuilder();
        if (noConditionProcessList.isEmpty()) {
            if (bizFlow) {
                return AddressProcedureMultiLang.LANG_48.getDesc();
            }
            return AddressProcedureMultiLang.LANG_1.getDesc();
        }
        sb.append(String.format(AddressProcedureMultiLang.LANG_2.getDesc(), noConditionProcessList.size()));
        sb.append(this.getProcessMsgListStr(noConditionProcessList)).append("\n");
        if (noConditionProcessList.size() == 1) {
            return sb.toString();
        }
        return sb.append(String.format(AddressProcedureMultiLang.LANG_3.getDesc(), noConditionProcessList.size())).toString();
    }

    default public List<AlternativeProcess> getHasConditionList(List<AlternativeProcess> list) {
        if (list == null) {
            return new ArrayList<AlternativeProcess>(0);
        }
        return list.stream().filter(item -> StringUtils.isNotEmpty((CharSequence)item.getStartCondition())).collect(Collectors.toList());
    }

    default public List<AlternativeProcess> getNoConditionList(List<AlternativeProcess> list) {
        if (list == null) {
            return new ArrayList<AlternativeProcess>(0);
        }
        return list.stream().filter(item -> StringUtils.isEmpty((CharSequence)item.getStartCondition())).collect(Collectors.toList());
    }

    default public String getModelTypeMsg(ModelType modelType) {
        if (ModelType.AuditFlow == modelType) {
            return AddressProcedureMultiLang.LANG_4.getDesc();
        }
        return AddressProcedureMultiLang.LANG_5.getDesc();
    }

    default public String getStartConditionMsg(Boolean b) {
        if (b == null) {
            b = Boolean.FALSE;
        }
        return String.format(AddressProcedureMultiLang.LANG_6.getDesc(), b);
    }

    default public String getSchemaConditionMsg(Boolean b) {
        if (b == null) {
            b = Boolean.FALSE;
        }
        return String.format(AddressProcedureMultiLang.LANG_7.getDesc(), b);
    }

    default public List<String> getContentList(List<AlternativeProcess> list) {
        if (list == null || list.isEmpty()) {
            return new ArrayList<String>(0);
        }
        return list.stream().map(item -> {
            String type = this.getModelTypeMsg(item.getProcessType());
            String format = String.format(AddressProcedureMultiLang.LANG_8.getDesc(), type, item.getProcessName(), item.getStartCondition(), item.getFormatParsedCondition());
            String result = this.getStartConditionMsg(item.getStartConditionStatus());
            format = format + result;
            return format;
        }).collect(Collectors.toList());
    }

    default public String getContentTips(AlternativeProcess item) {
        String type = this.getModelTypeMsg(item.getProcessType());
        return String.format(AddressProcedureMultiLang.LANG_9.getDesc(), type, item.getProcessName(), item.getConditionShowText());
    }

    default public String getContentParserResult(AlternativeProcess item) {
        return String.format("%s", item.getFormatParsedCondition());
    }

    default public String getProcessMsgListStr(List<AlternativeProcess> list) {
        List<String> processMsgList = this.getProcessMsgList(list);
        return Joiner.on((String)"\u3001").join(processMsgList);
    }

    default public List<String> getProcessMsgList(List<AlternativeProcess> list) {
        return list.stream().map(item -> String.format("\u3010%1$s\u3011\u3010%2$s\u3011", this.getModelTypeMsg(item.getProcessType()), item.getProcessName())).collect(Collectors.toList());
    }

    default public String enteredMsg(AlternativeProcess alternativeProcess, boolean justAddress) {
        String type = this.getModelTypeMsg(alternativeProcess.getProcessType());
        if (justAddress) {
            return String.format(AddressProcedureMultiLang.LANG_40.getDesc(), type, alternativeProcess.getProcessName(), this.getSchemaName(alternativeProcess));
        }
        return String.format(AddressProcedureMultiLang.LANG_10.getDesc(), type, alternativeProcess.getProcessName(), this.getSchemaName(alternativeProcess));
    }

    default public String getSchemaName(AlternativeProcess alternativeProcess) {
        if (alternativeProcess == null) {
            return "";
        }
        SchemePathItem targetItem = alternativeProcess.getTargetScheme();
        if (targetItem == null) {
            return AddressProcedureMultiLang.LANG_11.getDesc();
        }
        ILocaleString name = targetItem.getName();
        if (name == null) {
            return AddressProcedureMultiLang.LANG_11.getDesc();
        }
        return name.getLocaleValue();
    }

    default public String getSchemeMsg(List<SchemePathItem> schemePathItemList, SchemePathItem targetItem) {
        if (schemePathItemList == null || targetItem == null || targetItem.getDefaultScheme().booleanValue() && schemePathItemList.size() == 1) {
            return "";
        }
        List collect = schemePathItemList.stream().filter(item -> item.getDefaultScheme() == null || item.getDefaultScheme() == false).map(item -> {
            String format = String.format(AddressProcedureMultiLang.LANG_12.getDesc(), item.getName().getLocaleValue(), item.getSchemeCondition(), item.getParsedCondition());
            return format + this.getSchemaConditionMsg(item.getConditionStatus());
        }).collect(Collectors.toList());
        return Joiner.on((String)"\n").join(collect);
    }

    default public String getSchemeTips(SchemePathItem item) {
        return String.format(AddressProcedureMultiLang.LANG_13.getDesc(), item.getName().getLocaleValue(), item.getShowText());
    }

    default public String getSchemeParserResult(SchemePathItem item) {
        return String.format("%s", item.getFormatParsedCondition());
    }
}

