/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.log.builder;

import com.google.common.base.Splitter;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.workflow.engine.impl.log.LogClassType;
import kd.bos.workflow.engine.impl.log.RunTimeLog;
import kd.bos.workflow.engine.impl.log.SceneType;

public class LogBridge {
    private static final String REGEX_BLOCK = "(?<=\\{\\{)(.*?)(?=}})";
    private final RunTimeLog log;

    public LogBridge() {
        RunTimeLog log = RunTimeLog.get();
        if (log == null) {
            RunTimeLog.get().init(SceneType.ADDRESS_PROCEDURE, LogClassType.ADDRESS_PROCEDURE_LOG_BLOCK);
        }
        this.log = RunTimeLog.get();
    }

    public LogBridge writeLog(String content) {
        Pattern compile = Pattern.compile(REGEX_BLOCK, 32);
        Matcher matcher = compile.matcher(content);
        while (matcher.find()) {
            String block = matcher.group();
            this.writeToNextBlock(block);
        }
        return this;
    }

    public LogBridge writeToPreBlock(String content) {
        this.log.endBlock();
        this.writeToThisBlock(content);
        return this;
    }

    public LogBridge writeToThisBlock(String content) {
        List lines = Splitter.on((String)"\n").splitToList((CharSequence)content);
        for (String line : lines) {
            this.log.addlnLog(line);
        }
        return this;
    }

    public LogBridge writeToNextBlock(String content) {
        this.log.createBlock();
        List lines = Splitter.on((String)"\n").splitToList((CharSequence)content);
        for (String line : lines) {
            this.log.addlnLog(line);
        }
        return this;
    }

    public LogBridge writeToTempBlock(String content) {
        this.log.createBlock();
        List lines = Splitter.on((String)"\n").splitToList((CharSequence)content);
        for (String line : lines) {
            this.log.addlnLog(line);
        }
        this.log.endBlock();
        return this;
    }

    public LogBridge createBlock() {
        this.log.createBlock();
        return this;
    }
}

