/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.log.builder;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.workflow.engine.impl.log.builder.ComponentBuilder;
import kd.bos.workflow.engine.impl.log.builder.LogBridge;
import kd.bos.workflow.engine.pojo.AddressProcedure;
import kd.bos.workflow.engine.pojo.SchemePathItem;
import kd.bos.workflow.engine.pojo.record.AlternativeProcess;

public abstract class MsgCollector {
    protected ComponentBuilder builder;
    protected AddressProcedure addressProcedure;
    protected LogBridge log = new LogBridge();

    public abstract String buildMsg();

    protected String logContentList(List<AlternativeProcess> list) {
        this.log.createBlock();
        ArrayList<String> contentList = new ArrayList<String>(list.size());
        for (AlternativeProcess item : list) {
            String contentTips = this.builder.getContentTips(item);
            String contentParserResult = this.builder.getContentParserResult(item);
            String result = this.builder.getStartConditionMsg(item.getStartConditionStatus());
            this.log.writeToThisBlock(contentTips);
            this.log.writeToTempBlock(contentParserResult);
            this.log.writeToThisBlock(result);
            contentList.add(contentTips + contentParserResult + result);
        }
        return Joiner.on((String)"\n").join(contentList);
    }

    protected String logSchemeList(List<SchemePathItem> schemePathItems, SchemePathItem targetScheme) {
        if (targetScheme.getDefaultScheme().booleanValue() && schemePathItems.size() == 1) {
            return "";
        }
        this.log.createBlock();
        List collect = schemePathItems.stream().filter(item -> item.getDefaultScheme() == null || item.getDefaultScheme() == false).collect(Collectors.toList());
        ArrayList<String> contentList = new ArrayList<String>(schemePathItems.size());
        for (SchemePathItem item2 : collect) {
            String schemeTips = this.builder.getSchemeTips(item2);
            String schemeParserResult = this.builder.getSchemeParserResult(item2);
            String schemaConditionMsg = this.builder.getSchemaConditionMsg(item2.getConditionStatus());
            this.log.writeToThisBlock(schemeTips);
            this.log.writeToTempBlock(schemeParserResult);
            this.log.writeToThisBlock(schemaConditionMsg);
            contentList.add(schemeTips + schemeParserResult + schemaConditionMsg);
        }
        return Joiner.on((String)"\n").join(contentList);
    }

    public void setBuilder(ComponentBuilder builder) {
        this.builder = builder;
    }

    public void setAddressProcedure(AddressProcedure addressProcedure) {
        this.addressProcedure = addressProcedure;
    }
}

