/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.log.builder;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.workflow.engine.impl.log.builder.AddressProcedureMultiLang;
import kd.bos.workflow.engine.impl.log.builder.MsgCollector;
import kd.bos.workflow.engine.impl.log.builder.OnlyMsgStatus;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelType;
import kd.bos.workflow.engine.pojo.AddressProcedure;
import kd.bos.workflow.engine.pojo.record.AlternativeProcess;
import org.apache.commons.collections.CollectionUtils;

public final class OnlyCollector
extends MsgCollector {
    @Override
    public String buildMsg() {
        List<AlternativeProcess> alternativeProcesses = this.addressProcedure.getAlternativeProcesses();
        AlternativeProcess enteredProcess = this.addressProcedure.getEnteredProcess();
        Boolean justAddress = this.addressProcedure.getAllowNextParticipant();
        String result = this.addressResult(alternativeProcesses, enteredProcess, justAddress);
        this.log.writeToTempBlock(AddressProcedureMultiLang.LANG_43.getDesc() + result);
        this.log.writeToTempBlock(AddressProcedureMultiLang.LANG_44.getDesc());
        StringBuilder content = this.builder.getHead(this.addressProcedure, OnlyMsgStatus.UNWANTED);
        this.log.writeLog(content.toString());
        content.append("\n");
        List<AlternativeProcess> bizFlowList = alternativeProcesses.stream().filter(item -> ModelType.BizFlow == item.getProcessType()).collect(Collectors.toList());
        ArrayList workflowList = (ArrayList)CollectionUtils.subtract(alternativeProcesses, bizFlowList);
        boolean bizFlow = Optional.of(this.addressProcedure).map(AddressProcedure::getEnteredProcess).map(AlternativeProcess::getProcessType).orElse(ModelType.AuditFlow) == ModelType.BizFlow;
        this.buildAddressBody(bizFlowList, content, true);
        if (!bizFlow) {
            String open = AddressProcedureMultiLang.LANG_16.getDesc();
            String format = String.format(AddressProcedureMultiLang.LANG_18.getDesc(), open);
            content.append(format);
            this.log.writeToThisBlock(format);
            this.log.writeToThisBlock(AddressProcedureMultiLang.LANG_38.getDesc());
            this.buildAddressBody(workflowList, content, false);
        }
        if (enteredProcess == null || enteredProcess.isEmpty()) {
            return content.toString();
        }
        String schemeMsg = this.builder.getSchemeMsg(enteredProcess.getSchemePathItemList(), enteredProcess.getTargetScheme());
        if (StringUtils.isEmpty((CharSequence)schemeMsg)) {
            String s = this.builder.enteredMsg(enteredProcess, justAddress);
            this.log.writeToPreBlock(s);
            return content.append(s).toString();
        }
        String desc = AddressProcedureMultiLang.LANG_52.getDesc();
        String format = String.format(desc, this.builder.getModelTypeMsg(enteredProcess.getProcessType()), enteredProcess.getProcessName());
        String schemeHead = AddressProcedureMultiLang.LANG_34.getDesc() + "\n";
        String enteredMsg = this.builder.enteredMsg(enteredProcess, justAddress);
        this.log.writeToPreBlock(format + schemeHead);
        this.logSchemeList(enteredProcess.getSchemePathItemList(), enteredProcess.getTargetScheme());
        this.log.writeToPreBlock(enteredMsg);
        return content.append(schemeHead).append(schemeMsg).append(enteredMsg).toString();
    }

    public String addressResult(List<AlternativeProcess> alternativeProcesses, AlternativeProcess enteredProcess, Boolean justAddress) {
        List<AlternativeProcess> hasConditionProcessList = this.builder.getHasConditionList(alternativeProcesses);
        List<AlternativeProcess> noConditionProcessList = this.builder.getNoConditionList(alternativeProcesses);
        List eligibleProcess = hasConditionProcessList.stream().filter(item -> Boolean.TRUE.equals(item.getStartConditionStatus())).collect(Collectors.toList());
        if (enteredProcess != null && !enteredProcess.isEmpty()) {
            return this.builder.enteredMsg(enteredProcess, justAddress);
        }
        if (eligibleProcess.isEmpty() && noConditionProcessList.isEmpty()) {
            return AddressProcedureMultiLang.LANG_45.getDesc();
        }
        if (eligibleProcess.size() > 1) {
            return String.format(AddressProcedureMultiLang.LANG_35.getDesc(), eligibleProcess.size());
        }
        if (noConditionProcessList.size() > 1) {
            return String.format(AddressProcedureMultiLang.LANG_35.getDesc(), noConditionProcessList.size());
        }
        return "";
    }

    public StringBuilder buildAddressBody(List<AlternativeProcess> alternativeProcesses, StringBuilder content, boolean bizFlow) {
        List<AlternativeProcess> hasConditionProcessList = this.builder.getHasConditionList(alternativeProcesses);
        List<AlternativeProcess> noConditionProcessList = this.builder.getNoConditionList(alternativeProcesses);
        List eligibleProcess = hasConditionProcessList.stream().filter(item -> Boolean.TRUE.equals(item.getStartConditionStatus())).collect(Collectors.toList());
        if (hasConditionProcessList != null && !hasConditionProcessList.isEmpty()) {
            List hasConditionProcessMsgList = hasConditionProcessList.stream().map(item -> "\u3010" + item.getNumber() + "\u3011").collect(Collectors.toList());
            String join = Joiner.on((String)"\u3001").join(hasConditionProcessMsgList);
            String s1 = bizFlow ? AddressProcedureMultiLang.LANG_50.getDesc() : AddressProcedureMultiLang.LANG_51.getDesc();
            this.log.writeLog("{{" + s1 + join + "\u3002\n" + AddressProcedureMultiLang.LANG_29.getDesc() + "}}");
            String contentListStr = this.logContentList(hasConditionProcessList);
            content.append(s1).append(join).append("\n");
            content.append(contentListStr).append("\n");
        } else {
            String desc = AddressProcedureMultiLang.LANG_42.getDesc();
            content.append(desc);
            this.log.writeToThisBlock(desc);
        }
        if (eligibleProcess.size() > 1) {
            String format = String.format(AddressProcedureMultiLang.LANG_35.getDesc(), eligibleProcess.size());
            content.append(format);
            this.log.writeToPreBlock(format);
            return content;
        }
        if (eligibleProcess.isEmpty()) {
            String s = bizFlow ? AddressProcedureMultiLang.LANG_46.getDesc() : AddressProcedureMultiLang.LANG_47.getDesc();
            String s2 = this.builder.getNoConditionMsg(noConditionProcessList, bizFlow);
            content.append(s);
            content.append(s2);
            this.log.writeToPreBlock(s + s2);
            if (AddressProcedureMultiLang.LANG_1.getDesc().equals(s2)) {
                this.log.writeToPreBlock(AddressProcedureMultiLang.LANG_45.getDesc());
            }
        }
        return content;
    }
}

