/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.log.builder;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.engine.impl.log.builder.AddressProcedureMultiLang;
import kd.bos.workflow.engine.impl.log.builder.ComponentBuilder;
import kd.bos.workflow.engine.impl.log.builder.OnlyMsgStatus;
import kd.bos.workflow.engine.pojo.AddressProcedure;
import kd.bos.workflow.engine.pojo.OrgInfo;
import kd.bos.workflow.engine.pojo.record.AlternativeProcess;

public final class OrgComponentBuilder
implements ComponentBuilder {
    @Override
    public StringBuilder getHead(AddressProcedure addressProcedure, OnlyMsgStatus only) {
        StringBuilder content = new StringBuilder();
        OrgInfo mainOrgInfo = new OrgInfo();
        List<Object> orgNameByIds = new ArrayList(0);
        if (addressProcedure.getOrgId() == null) {
            content.append("{{").append(AddressProcedureMultiLang.LANG_19.getDesc()).append(AddressProcedureMultiLang.LANG_37.getDesc());
        } else {
            mainOrgInfo = this.findOrgNameById(addressProcedure.getOrgId());
            orgNameByIds = this.findOrgNameByIds(addressProcedure.getParentOrgIds());
            List parentOrgNames = orgNameByIds.stream().map(item -> String.format("\u3010%1$s(%2$s)\u3011", item.getName(), item.getNumber())).collect(Collectors.toList());
            String join = Joiner.on((String)"\u3001").join(parentOrgNames);
            content.append("{{").append(AddressProcedureMultiLang.LANG_19.getDesc());
            content.append(String.format(AddressProcedureMultiLang.LANG_20.getDesc(), mainOrgInfo.getName() + "(" + mainOrgInfo.getNumber() + ")"));
            if (StringUtils.isBlank((CharSequence)join)) {
                join = AddressProcedureMultiLang.LANG_21.getDesc();
            } else {
                content.append(AddressProcedureMultiLang.LANG_22.getDesc());
            }
            content.append(join).append("\u3002").append("\n");
        }
        content.append(AddressProcedureMultiLang.LANG_23.getDesc()).append("}}");
        List alternativeProcesses = Optional.ofNullable(addressProcedure.getAlternativeProcesses()).orElseGet(ArrayList::new);
        content.append(String.format("{{" + AddressProcedureMultiLang.LANG_24.getDesc() + "}}", addressProcedure.getEntityNumber(), addressProcedure.getOperate(), addressProcedure.getOperate(), alternativeProcesses.size()));
        if (OnlyMsgStatus.UNWANTED == only) {
            return content;
        }
        String open = OnlyMsgStatus.TRUE == only ? AddressProcedureMultiLang.LANG_16.getDesc() : AddressProcedureMultiLang.LANG_17.getDesc();
        content.append(String.format("{{" + AddressProcedureMultiLang.LANG_25.getDesc() + "}}", open));
        orgNameByIds.add(mainOrgInfo);
        addressProcedure.setItemsOrgName(orgNameByIds);
        return content;
    }

    private OrgInfo findOrgNameById(Long orgId) {
        QFilter qFilter = new QFilter("id", "=", (Object)orgId);
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"bos_org", (String)"id,name,number", (QFilter[])qFilter.toArray());
        return OrgInfo.from(dynamicObject);
    }

    private List<OrgInfo> findOrgNameByIds(List<Long> ids) {
        QFilter qFilter = new QFilter("id", "in", ids);
        DynamicObjectCollection list = QueryServiceHelper.query((String)"bos_org", (String)"id,name,number", (QFilter[])qFilter.toArray());
        return list.stream().map(OrgInfo::from).collect(Collectors.toList());
    }

    @Override
    public List<String> getContentList(List<AlternativeProcess> list) {
        if (list == null || list.isEmpty()) {
            return new ArrayList<String>(0);
        }
        return list.stream().map(item -> {
            String type = this.getModelTypeMsg(item.getProcessType());
            String format = String.format(AddressProcedureMultiLang.LANG_26.getDesc(), item.getOrgName(), type, item.getProcessName(), item.getStartCondition(), item.getFormatParsedCondition());
            String result = this.getStartConditionMsg(item.getStartConditionStatus());
            format = format + result;
            return format;
        }).collect(Collectors.toList());
    }

    @Override
    public String getContentTips(AlternativeProcess item) {
        String type = this.getModelTypeMsg(item.getProcessType());
        if (StringUtils.isEmpty((CharSequence)item.getOrgName())) {
            return this.getCommonContentTips(item);
        }
        return String.format(AddressProcedureMultiLang.LANG_27.getDesc(), item.getOrgName(), type, item.getProcessName(), item.getConditionShowText());
    }

    public String getCommonContentTips(AlternativeProcess item) {
        String type = this.getModelTypeMsg(item.getProcessType());
        return String.format(AddressProcedureMultiLang.LANG_9.getDesc(), type, item.getProcessName(), item.getConditionShowText());
    }
}

