/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.log.cmd;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.log.SceneType;
import kd.bos.workflow.engine.impl.log.entity.RuntimeParseLogEntity;

public class FindAddressParseLogEntitiesCmd
implements Command<List<RuntimeParseLogEntity>> {
    private final String billnoOrBusinessKey;
    private final String entityNumber;

    public FindAddressParseLogEntitiesCmd(String billnoOrBusinessKey, String entityNumber) {
        this.billnoOrBusinessKey = billnoOrBusinessKey;
        this.entityNumber = entityNumber;
    }

    @Override
    public List<RuntimeParseLogEntity> execute(CommandContext commandContext) {
        if (StringUtils.isBlank((CharSequence)this.billnoOrBusinessKey) || StringUtils.isBlank((CharSequence)this.entityNumber)) {
            return new ArrayList<RuntimeParseLogEntity>();
        }
        QFilter qFilter1 = new QFilter("entitynumber", "=", (Object)this.entityNumber);
        QFilter qFilter2 = new QFilter("opname", "in", (Object)Lists.newArrayList((Object[])new String[]{SceneType.ADDRESS_PROCEDURE.getType(), SceneType.JUST_ADDRESS_PROCEDURE.getType()}));
        QFilter qFilter = new QFilter("billno", "=", (Object)this.billnoOrBusinessKey).or("businesskey", "=", (Object)this.billnoOrBusinessKey);
        QFilter[] qFilters = qFilter1.and(qFilter2).and(qFilter).toArray();
        return commandContext.getParseLogManager().getParseLogListDataByEntityNumANdBillNo(0, 1000, qFilters, "asc");
    }
}

