/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.log.listener;

import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.interceptor.DefaultCommandContextCloseListener;
import kd.bos.workflow.engine.impl.log.LogContext;
import kd.bos.workflow.engine.impl.log.entity.RuntimeParseLogEntityImpl;

public class ExecuteLogCreateListener
extends DefaultCommandContextCloseListener {
    protected static Log logger = LogFactory.getLog(ExecuteLogCreateListener.class);

    public ExecuteLogCreateListener(String aim) {
        super(aim);
    }

    @Override
    public void closing(CommandContext commandContext) {
        try {
            Map<String, List<LogContext>> logContextMap = commandContext.getLogContextMap();
            if (logContextMap == null || logContextMap.size() == 0) {
                return;
            }
            for (Map.Entry<String, List<LogContext>> listEntry : logContextMap.entrySet()) {
                if (listEntry.getValue() == null || listEntry.getValue().size() <= 0) continue;
                for (LogContext logContext : listEntry.getValue()) {
                    String logMsg;
                    if (logContext.isInsertDB()) {
                        logger.debug("insert log success " + logContext.getBusinessKey() + logContext.getActivityName());
                        logMsg = logContext.getParseLog().parseLog(logContext);
                        this.insertLogEntity(logContext, logMsg);
                        continue;
                    }
                    logMsg = logContext.getParseLog().parseLog(logContext, null);
                    logger.debug(logMsg);
                }
            }
        }
        catch (Exception e) {
            logger.warn("record parseLog is faile ,message:" + WfUtils.getExceptionStacktrace(e));
        }
    }

    public void insertLogEntity(LogContext logContext, String logMsg) {
        if (logMsg != null) {
            RuntimeParseLogEntityImpl runtimeParseLogEntity = RuntimeParseLogEntityImpl.create();
            runtimeParseLogEntity.setActivityId(logContext.getActivityId());
            runtimeParseLogEntity.setActivityName(logContext.getActivityName());
            runtimeParseLogEntity.setBillNo(logContext.getBillNo());
            runtimeParseLogEntity.setProcessType(logContext.getProcessType());
            runtimeParseLogEntity.setBusinessKey(logContext.getBusinessKey());
            runtimeParseLogEntity.setEntityNumber(logContext.getEntityNum());
            runtimeParseLogEntity.setLogMsg(logMsg);
            runtimeParseLogEntity.setLogMsgDetail(logMsg);
            runtimeParseLogEntity.setName(logContext.getName());
            runtimeParseLogEntity.setParseScene(logContext.getSceneType() != null ? logContext.getSceneType().getType() : "");
            runtimeParseLogEntity.setParseTime(logContext.getStartParseTime());
            runtimeParseLogEntity.setProcessDefintionId(logContext.getProcessDefinitionId());
            runtimeParseLogEntity.setProcessInstanceId(logContext.getProcessInstanceId());
            runtimeParseLogEntity.setTaskId(logContext.getTaskId());
            runtimeParseLogEntity.setParseType(logContext.getLogClassType() != null ? logContext.getLogClassType().getType() : "");
            runtimeParseLogEntity.setDesc(logContext.getSceneType() != null ? logContext.getSceneType().getName() : "");
            runtimeParseLogEntity.setSubProcess(logContext.isSubProcess());
            ILocaleString userNamer = WfUtils.findUserName(RequestContext.get().getCurrUserId());
            runtimeParseLogEntity.setUserName(userNamer != null ? userNamer.getLocaleValue() : "");
            Context.getCommandContext().getParseLogManager().insert(runtimeParseLogEntity, false);
        }
    }
}

