/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.log.manager;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.logorm.LogORM;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.history.HistoryLevel;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.interceptor.DefaultCommandContextCloseListener;
import kd.bos.workflow.engine.impl.log.entity.ConditionParseLogEntity;
import kd.bos.workflow.engine.impl.log.entity.ConditionParseLogEntityImpl;
import kd.bos.workflow.engine.impl.log.manager.AbstractLogItemManager;
import kd.bos.workflow.engine.impl.log.manager.ConditionParseLogManager;
import kd.bos.workflow.engine.impl.log.pojo.InsertConditionParseLogParam;
import kd.bos.workflow.engine.impl.persistence.entity.Entity;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntityImpl;
import kd.bos.workflow.engine.impl.util.condition.ConditionType;
import kd.bos.workflow.engine.pojo.StartUpConditionText;
import kd.bos.workflow.service.WfTraceType;

public class ConditionParseLogManagerImpl
extends AbstractLogItemManager<ConditionParseLogEntity>
implements ConditionParseLogManager {
    private static Log log = LogFactory.getLog(ConditionParseLogManagerImpl.class);

    public ConditionParseLogManagerImpl(ProcessEngineConfigurationImpl processEngineConfiguration) {
        super(processEngineConfiguration);
    }

    @Override
    public Class<? extends ConditionParseLogEntity> getManagedEntityClass() {
        return ConditionParseLogEntityImpl.class;
    }

    @Override
    public String getSelectFields() {
        return "id,processdefinitionid,processinstanceid,executionid,activityid,activityinstid,opdate,expression,logmsg,logmsg_tag,businesskey,key,username,opname,opdesc,processname,itemname,entitynumber,billno,superprocessname";
    }

    @Override
    public List<ConditionParseLogEntity> findByQueryFilters(QFilter[] filters) {
        List<ConditionParseLogEntity> byQueryFilters = this.findByQueryFilters(0, 2000, filters);
        byQueryFilters.sort(Comparator.comparingLong(Entity::getId));
        return byQueryFilters;
    }

    @Override
    public int count(QFilter[] qFilters) {
        LogORM logORM = LogORM.create();
        return logORM.count("wf_conditionparselog", qFilters);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<ConditionParseLogEntity> findByQueryFilters(int start, int limit, QFilter[] qFilters) {
        LogORM logORM = LogORM.create();
        try (DataSet rows = logORM.queryDataSet("wf_conditionparselog", this.getSelectFields(), qFilters, limit, start);){
            if (rows == null || rows.isEmpty()) {
                ArrayList<ConditionParseLogEntity> arrayList = new ArrayList<ConditionParseLogEntity>(0);
                return arrayList;
            }
            DynamicObjectCollection collection = ORM.create().toPlainDynamicObjectCollection(rows, start, limit);
            List<ConditionParseLogEntity> list = collection.stream().map(item -> {
                ConditionParseLogEntity entity = (ConditionParseLogEntity)this.create();
                entity.setId(item.getLong("id"));
                entity.setActivityId(item.getString("activityid"));
                entity.setExecutionId(item.getLong("executionid"));
                entity.setActivityInstId(item.getLong("activityinstid"));
                entity.setCreateDate(item.getDate("opdate"));
                entity.setProcessName(item.getString("processname"));
                entity.setLogMsg(item.getString("logmsg"));
                entity.setKey(item.getString("key"));
                entity.setExpression(item.getString("expression"));
                entity.setBusinessKey(item.getString("businesskey"));
                entity.setUserName(item.getString("username"));
                entity.setOpName(item.getString("opname"));
                entity.setOpDesc(item.getString("opdesc"));
                entity.setItemName(item.getString("itemname"));
                entity.setProcessDefinitionId(item.getLong("processdefinitionid"));
                entity.setEntityNumber(item.getString("entitynumber"));
                entity.setBillNo(item.getString("billno"));
                entity.setProcessInstanceId(item.getLong("processinstanceid"));
                entity.setSuperProcessName(item.getString("superprocessname"));
                return entity;
            }).collect(Collectors.toList());
            return list;
        }
        catch (Throwable ex) {
            log.error("logORM.queryDataSet is error, errorinfo is :" + WfUtils.getExceptionStacktrace(ex));
            return new ArrayList<ConditionParseLogEntity>(0);
        }
    }

    @Override
    public ConditionParseLogEntity insert(InsertConditionParseLogParam param) {
        HistoryLevel historyLevel = this.processEngineConfiguration.getHistoryLevel();
        if (WfTraceType.getOrCreate().getJobInfo() == null || !historyLevel.isAtLeast(HistoryLevel.AUDIT) || param == null || StringUtils.isEmpty((CharSequence)param.getBusinessKey())) {
            return (ConditionParseLogEntity)this.create();
        }
        this.logAddressOpDesc(param);
        ExecutionEntity executionEntity = param.getExecutionEntity();
        if (executionEntity.getId() != null && executionEntity.getId() != 0L) {
            executionEntity.getSuperExecution();
        }
        ConditionParseLogEntity entity = this.from(param);
        Long id = ORM.create().genLongId(entity.getDynObjTypeName());
        entity.setId(id);
        this.insert(entity);
        return entity;
    }

    @Override
    public long delete(String businessKey, String entityNumber) {
        QFilter eqBusinessKey = new QFilter("businesskey", "=", (Object)businessKey);
        QFilter eqEntityNumber = new QFilter("entitynumber", "=", (Object)entityNumber);
        QFilter[] qFilters = new QFilter[]{eqBusinessKey, eqEntityNumber};
        try {
            return LogORM.create().delete("wf_conditionparselog", qFilters);
        }
        catch (Throwable ex) {
            log.warn("logORM.queryDataSet is error, errorinfo is :" + WfUtils.getExceptionStacktrace(ex));
            return 0L;
        }
    }

    @Override
    public void delete(final JobEntity timerEntity) {
        if (timerEntity == null || WfUtils.isEmpty(timerEntity.getBusinessKey()) || WfUtils.isEmpty(timerEntity.getEntityNumber())) {
            return;
        }
        if (Context.getCommandContext() != null) {
            return;
        }
        Context.getCommandContext().addCloseListener(new DefaultCommandContextCloseListener("deleteConditionParseLogJob"){

            @Override
            public void closed(CommandContext commandContext) {
                ConditionParseLogManagerImpl.this.delete(timerEntity.getBusinessKey(), timerEntity.getEntityNumber());
            }
        });
    }

    @Override
    public void deleteByFilters(QFilter[] qFilters) {
        try {
            LogORM.create().delete("wf_conditionparselog", qFilters);
        }
        catch (Exception e) {
            this.logger.info("wf_conditionparselog deleteByFilters is error");
        }
    }

    public String logAddressOpDesc(InsertConditionParseLogParam param) {
        if (param == null || param.getMarkKey() == null || param.getExecutionEntity() == null || param.getExecutionEntity().getProcessDefinitionId() == null) {
            return "";
        }
        String markKey = param.getMarkKey();
        ConditionType conditionType = Optional.ofNullable(ConditionType.valueOf(markKey, true)).orElse(ConditionType.OTHERS);
        if (ConditionType.ADDRESS == conditionType) {
            Long definitionId = param.getExecutionEntity().getProcessDefinitionId();
            ArrayList<Long> definitionIds = new ArrayList<Long>();
            definitionIds.add(definitionId);
            List<StartUpConditionText> startUpConditionTexts = this.getCommandContext().getConditionRuleEntityManager().batchFindStartUpCondition(definitionIds);
            if (startUpConditionTexts == null || startUpConditionTexts.isEmpty()) {
                return "";
            }
            return ConditionType.logOpDesc(startUpConditionTexts.get(0).getShowText());
        }
        if (ConditionType.ENV_ADDRESS_PROCESS == conditionType) {
            Long definitionId = param.getExecutionEntity().getProcessDefinitionId();
            ArrayList<Long> definitionIds = new ArrayList<Long>();
            definitionIds.add(definitionId);
            List<StartUpConditionText> startUpConditionTexts = this.getCommandContext().getConditionRuleEntityManager().batchFindStartUpCondition(definitionIds);
            if (startUpConditionTexts == null || startUpConditionTexts.isEmpty()) {
                return "";
            }
            return ConditionType.logOpDesc(startUpConditionTexts.get(0).getShowText());
        }
        return "";
    }

    public ConditionParseLogEntity from(InsertConditionParseLogParam param) {
        ConditionParseLogEntity entity = (ConditionParseLogEntity)this.create();
        ExecutionEntity executionEntity = Optional.ofNullable(param.getExecutionEntity()).orElseGet(ExecutionEntityImpl::new);
        entity.setProcessDefinitionId(executionEntity.getProcessDefinitionId());
        entity.setProcessInstanceId(executionEntity.getProcessInstanceId());
        entity.setActivityId(executionEntity.getActivityId());
        entity.setActivityInstId(executionEntity.getCurrentActInstId());
        entity.setBillNo(executionEntity.getBillNo());
        entity.setEntityNumber(executionEntity.getEntityNumber());
        ILocaleString name = Optional.ofNullable(executionEntity.getName()).orElseGet(LocaleString::new);
        entity.setProcessName(name.getLocaleValue());
        entity.setExpression(param.getConditionalRule());
        entity.setLogMsg(param.getExpressResult());
        entity.setLogMsgDetail(param.getExpressResult());
        entity.setKey(param.getMarkKey());
        entity.setBusinessKey(param.getBusinessKey());
        ExecutionEntity superExecution = Optional.ofNullable(executionEntity.getSuperExecution()).orElseGet(ExecutionEntityImpl::new);
        String superName = Optional.ofNullable(superExecution.getName()).orElseGet(() -> new LocaleString("")).toString();
        entity.setSuperProcessName(superName);
        String opDesc = ConditionType.getOpDesc();
        entity.setOpDesc(opDesc);
        String key = param.getMarkKey();
        if (StringUtils.isNotEmpty((CharSequence)key)) {
            ConditionType conditionType = Optional.ofNullable(ConditionType.valueOf(key, true)).orElse(ConditionType.OTHERS);
            String itemName = this.calItemName(key, executionEntity);
            entity.setOpName(conditionType.name());
            entity.setItemName(itemName);
        }
        return entity;
    }

    public String calItemName(String key, ExecutionEntity executionEntity) {
        if (StringUtils.isEmpty((CharSequence)key)) {
            return "";
        }
        String logName = ConditionType.getItemName();
        if (StringUtils.isNotEmpty((CharSequence)logName)) {
            return logName;
        }
        ILocaleString itemName = Optional.ofNullable(executionEntity.getActivityName()).orElseGet(LocaleString::new);
        String number = "";
        if (StringUtils.isNotEmpty((CharSequence)executionEntity.getActivityId())) {
            number = "(" + executionEntity.getActivityId() + ")";
        }
        return itemName + number;
    }
}

