/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.log.manager;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logorm.LogORM;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.event.EventLogEntry;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.interceptor.DefaultCommandContextCloseListener;
import kd.bos.workflow.engine.impl.log.entity.EventLogEntryEsEntityImpl;
import kd.bos.workflow.engine.impl.log.manager.AbstractLogItemManager;
import kd.bos.workflow.engine.impl.log.manager.EventLogEntryEsEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.EventLogEntryEntity;

public class EventLogEntryEsEntityManagerImpl
extends AbstractLogItemManager<EventLogEntryEntity>
implements EventLogEntryEsEntityManager {
    public EventLogEntryEsEntityManagerImpl(ProcessEngineConfigurationImpl processEngineConfiguration) {
        super(processEngineConfiguration);
    }

    @Override
    public Class<? extends EventLogEntryEntity> getManagedEntityClass() {
        return EventLogEntryEsEntityImpl.class;
    }

    @Override
    public String getEntityName() {
        return "wf_eventlogentryes";
    }

    @Override
    public String getSelectFields() {
        return "id,username,opname,opdesc,opdate,type,processDefinitionId,jobId,billNo,processInstanceId,executionId,taskId,timeStamp,userId,data,businessKey,srcjobid,traceno,jobtype,elementId";
    }

    @Override
    public void deleteLogsByBusinessKey(String busKey) {
        QFilter[] qFilters = new QFilter[]{new QFilter("businesskey", "=", (Object)busKey)};
        this.deleteByFilters(qFilters);
    }

    @Override
    public void deleteLogsByJob(final JobEntity timerEntity) {
        if (timerEntity == null || WfUtils.isEmpty(timerEntity.getBusinessKey())) {
            return;
        }
        if (Context.getCommandContext() != null) {
            Context.getCommandContext().addCloseListener(new DefaultCommandContextCloseListener("deleteEvtLogs"){

                @Override
                public void closed(CommandContext commandContext) {
                    LogORM logORM = LogORM.create();
                    QFilter[] qFilters = new QFilter[]{new QFilter("businesskey", "=", (Object)timerEntity.getBusinessKey()), new QFilter("jobtype", "=", (Object)"async-timing")};
                    DynamicObjectCollection logs = logORM.query("wf_eventlogentryes", String.format("%s,%s,%s", "jobid", "srcjobid", "id"), qFilters, 0, 20000);
                    if (logs != null && !logs.isEmpty()) {
                        Long srcJobId = timerEntity.getSrcJobId();
                        Long jobId = timerEntity.getId();
                        ArrayList<Long> ids = new ArrayList<Long>(logs.size());
                        for (DynamicObject entry : logs) {
                            if ((!WfUtils.isNotEmpty(srcJobId) || !srcJobId.equals(entry.getLong("srcjobid"))) && (!WfUtils.isNotEmpty(jobId) || !jobId.equals(entry.getLong("jobid")))) continue;
                            ids.add(entry.getLong("id"));
                        }
                        qFilters = new QFilter[]{new QFilter("id", "in", ids)};
                        try {
                            logORM.delete("wf_eventlogentryes", qFilters);
                        }
                        catch (Throwable e) {
                            EventLogEntryEsEntityManagerImpl.this.logger.info("wf_eventlogentryes deleteByFilters is error");
                        }
                    }
                }
            });
        }
    }

    @Override
    public List<EventLogEntry> findAllEventLogEntries() {
        return null;
    }

    @Override
    public List<EventLogEntry> findEventLogEntries(long startLogNr, long pageSize) {
        return null;
    }

    @Override
    public List<EventLogEntry> findEventLogEntriesByProcessInstanceId(Long processInstanceId) {
        return null;
    }

    @Override
    public void deleteEventLogEntry(long logNr) {
    }

    @Override
    public void deleteByFilters(QFilter[] qFilters) {
        try {
            LogORM.create().delete("wf_eventlogentryes", qFilters);
        }
        catch (Throwable e) {
            this.logger.info("wf_eventlogentryes deleteByFilters is error");
        }
    }
}

