/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.log.manager;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.logorm.LogORM;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.log.entity.RuntimeParseLogEntity;
import kd.bos.workflow.engine.impl.log.entity.RuntimeParseLogEntityImpl;
import kd.bos.workflow.engine.impl.log.manager.AbstractLogItemManager;
import kd.bos.workflow.engine.impl.log.manager.RuntimeParseLogManager;

public class RuntimeParseLogManagerImpl
extends AbstractLogItemManager<RuntimeParseLogEntity>
implements RuntimeParseLogManager {
    private static Log log = LogFactory.getLog(RuntimeParseLogManagerImpl.class);
    private static final String ENTITYNUMBER = "entitynumber";
    private static final String BILLNO = "billno";
    private static final String NAME = "name";
    private static final String ACTIVITYNAME = "activityname";
    private static final String OPDATE = "opdate";
    private static final String PROCESSDEFINTIONID = "processdefintionid";
    private static final String PROCESSINSTANCEID = "processinstanceid";
    private static final String TASKID = "taskid";
    private static final String BUSINESSKEY = "businesskey";
    private static final String LOGMSG = "logmsg";
    private static final String LOGMSG_TAG = "logmsg_tag";
    private static final String OPNAME = "opname";
    private static final String PROCESSTYPE = "processtype";
    private static final String ACTIVITYID = "activityid";
    private static final String PARSETYPE = "parsetype";
    private static final String OPDESC = "opdesc";
    private static final String SUBPROCESS = "subprocess";
    private static final String ID = "id";

    public RuntimeParseLogManagerImpl(ProcessEngineConfigurationImpl processEngineConfiguration) {
        super(processEngineConfiguration);
    }

    @Override
    public Class<? extends RuntimeParseLogEntity> getManagedEntityClass() {
        return RuntimeParseLogEntityImpl.class;
    }

    @Override
    public String getSelectFields() {
        return "entitynumber,billno,id,processdefintionid,processinstanceid,taskid,name,businesskey,opname,processtype,parsetype,opdesc,username,activityname,activityid,opdate,subprocess,logmsg,logmsg_tag";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<RuntimeParseLogEntity> getParseLogListDataByEntityNumANdBillNo(int start, int limit, QFilter[] filters, String orderBy) {
        ArrayList<RuntimeParseLogEntity> runtimeParseLogEntities = new ArrayList();
        LogORM logORM = LogORM.create();
        try (DataSet ds = logORM.queryDataSet("wf_runtimeparselog", this.getSelectFields(), filters, limit, start);){
            if (ds == null || ds.isEmpty()) {
                ArrayList<RuntimeParseLogEntity> arrayList = new ArrayList<RuntimeParseLogEntity>(0);
                return arrayList;
            }
            DynamicObjectCollection results = ORM.create().toPlainDynamicObjectCollection(ds, start, limit);
            if (results.size() > 0) {
                for (DynamicObject dyn : results) {
                    RuntimeParseLogEntityImpl runtimeParseLogEntity = RuntimeParseLogEntityImpl.create();
                    runtimeParseLogEntity.setEntityNumber(dyn.getString(ENTITYNUMBER));
                    runtimeParseLogEntity.setBillNo(dyn.getString(BILLNO));
                    runtimeParseLogEntity.setId(dyn.getLong(ID));
                    runtimeParseLogEntity.setProcessDefintionId(dyn.getLong(PROCESSDEFINTIONID));
                    runtimeParseLogEntity.setProcessInstanceId(dyn.getLong(PROCESSINSTANCEID));
                    runtimeParseLogEntity.setTaskId(dyn.getLong(TASKID));
                    runtimeParseLogEntity.setName(dyn.getString(NAME));
                    runtimeParseLogEntity.setBusinessKey(dyn.getString(BUSINESSKEY));
                    runtimeParseLogEntity.setProcessType(dyn.getString(PROCESSTYPE));
                    runtimeParseLogEntity.setParseType(dyn.getString(PARSETYPE));
                    runtimeParseLogEntity.setDesc(dyn.getString(OPDESC));
                    runtimeParseLogEntity.setParseScene(dyn.getString(OPNAME));
                    runtimeParseLogEntity.setActivityName(dyn.getString(ACTIVITYNAME));
                    runtimeParseLogEntity.setActivityId(dyn.getString(ACTIVITYID));
                    runtimeParseLogEntity.setParseTime(dyn.getDate(OPDATE));
                    runtimeParseLogEntity.setLogMsg(dyn.getString(LOGMSG));
                    runtimeParseLogEntity.setLogMsgDetail(dyn.getString(LOGMSG_TAG));
                    runtimeParseLogEntity.setSubProcess(String.valueOf(dyn.getString(SUBPROCESS)));
                    runtimeParseLogEntities.add(runtimeParseLogEntity);
                }
            }
        }
        catch (Throwable ex) {
            log.error("logORM.queryDataSet is error, errorinfo is :" + WfUtils.getExceptionStacktrace(ex));
        }
        runtimeParseLogEntities = runtimeParseLogEntities.stream().sorted(Comparator.comparing(RuntimeParseLogEntity::getParseTime).reversed()).collect(Collectors.toList());
        if (!"asc".equalsIgnoreCase(orderBy.trim())) return runtimeParseLogEntities;
        return Lists.reverse(runtimeParseLogEntities);
    }

    @Override
    public int getParseLogCountByEntityNumANdBillNo(QFilter[] filters) {
        LogORM logORM = LogORM.create();
        try {
            return logORM.count("wf_runtimeparselog", filters);
        }
        catch (Throwable ex) {
            log.error("logORM.count is error, errorinfo is :" + WfUtils.getExceptionStacktrace(ex));
            return 0;
        }
    }

    @Override
    public void deleteByFilters(QFilter[] qFilters) {
        try {
            LogORM.create().delete("wf_runtimeparselog", qFilters);
        }
        catch (Throwable e) {
            this.logger.info("wf_runtimeparselog deleteByFilters is error");
        }
    }
}

