/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.nocodeflow;

import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.api.IMsgEventListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.workflow.engine.WfUtils;

public class NoCodeFlowMsgEvent
implements IMsgEventListener {
    private static Log log = LogFactory.getLog(NoCodeFlowMsgEvent.class);
    private static final String NOTIFYTYPE = "notifyType";
    private static final String STATE = "state";
    private static final String ERRORINFO = "errorinfo";

    public void subSuccessMsgInfo(Long msgId, Map<String, Object> data) {
        super.subSuccessMsgInfo(msgId, data);
        NoCodeFlowMsgEvent.updateDetailLog(msgId, data);
    }

    public void subFailMsgInfo(Long msgId, Map<String, Object> data) {
        super.subFailMsgInfo(msgId, data);
        NoCodeFlowMsgEvent.updateDetailLog(msgId, data);
    }

    private static void updateDetailLog(Long msgId, Map<String, Object> data) {
        if (data.get(NOTIFYTYPE) == null) {
            return;
        }
        log.debug("NoCodeFlowMsgEvent enter");
        QFilter q1 = new QFilter("messageid", "=", (Object)msgId);
        QFilter q2 = new QFilter("channel", "=", data.get(NOTIFYTYPE));
        QFilter[] filters = new QFilter[]{q1, q2};
        try {
            DynamicObject[] objs = BusinessDataServiceHelper.load((String)"wf_detaillog", (String)"id,errormessage,opinion,modifydate", (QFilter[])filters);
            if (objs == null || objs.length == 0) {
                return;
            }
            objs[0].set("opinion", data.get(STATE));
            if (data.get(ERRORINFO) != null) {
                objs[0].set("errormessage", (Object)WfUtils.subStringForMax(data.get(ERRORINFO).toString(), 900));
            }
            SaveServiceHelper.save((DynamicObject[])objs);
        }
        catch (Exception e) {
            log.error("NoCodeFlowMsgEvent updateDetailLog is error : " + WfUtils.getExceptionStacktrace(e));
        }
    }
}

