/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.persistence.cache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.cache.CachedEntity;
import kd.bos.workflow.engine.impl.persistence.cache.EntityCache;
import kd.bos.workflow.engine.impl.persistence.entity.Entity;

public class EntityCacheImpl
implements EntityCache {
    protected Map<Class<?>, Map<Long, CachedEntity>> cachedObjects = new HashMap();

    @Override
    public CachedEntity put(Entity entity, boolean storeState) {
        Map<Long, CachedEntity> classCache = this.cachedObjects.get(entity.getClass());
        if (classCache == null) {
            classCache = new HashMap<Long, CachedEntity>();
            this.cachedObjects.put(entity.getClass(), classCache);
        }
        CachedEntity cachedObject = new CachedEntity(entity, storeState);
        classCache.put(entity.getId(), cachedObject);
        return cachedObject;
    }

    @Override
    public <T> T findInCache(Class<T> entityClass, Long id) {
        CachedEntity cachedObject = null;
        Map<Long, CachedEntity> classCache = this.cachedObjects.get(entityClass);
        if (classCache == null) {
            classCache = this.findClassCacheByCheckingSubclasses(entityClass);
        }
        if (classCache != null) {
            cachedObject = classCache.get(id);
        }
        if (cachedObject != null) {
            return (T)cachedObject.getEntity();
        }
        return null;
    }

    protected Map<Long, CachedEntity> findClassCacheByCheckingSubclasses(Class<?> entityClass) {
        for (Map.Entry<Class<?>, Map<Long, CachedEntity>> entry : this.cachedObjects.entrySet()) {
            Class<?> clazz = entry.getKey();
            if (!entityClass.isAssignableFrom(clazz)) continue;
            return entry.getValue();
        }
        return null;
    }

    @Override
    public void cacheRemove(Class<?> entityClass, String entityId) {
        if (WfUtils.isNotEmpty(entityId)) {
            Map<Long, CachedEntity> classCache = this.cachedObjects.get(entityClass);
            if (classCache == null) {
                return;
            }
            classCache.remove(Long.valueOf(entityId));
        }
    }

    @Override
    public <T> Collection<CachedEntity> findInCacheAsCachedObjects(Class<T> entityClass) {
        Collection<CachedEntity> col = new ArrayList<CachedEntity>();
        Map<Long, CachedEntity> classCache = this.cachedObjects.get(entityClass);
        if (classCache != null) {
            col = classCache.values();
        }
        return col;
    }

    @Override
    public <T> List<T> findInCache(Class<T> entityClass) {
        Map<Long, CachedEntity> classCache = this.cachedObjects.get(entityClass);
        if (classCache == null) {
            classCache = this.findClassCacheByCheckingSubclasses(entityClass);
        }
        if (classCache != null) {
            ArrayList<Entity> entities = new ArrayList<Entity>(classCache.size());
            for (CachedEntity cachedObject : classCache.values()) {
                entities.add(cachedObject.getEntity());
            }
            return entities;
        }
        return Collections.emptyList();
    }

    @Override
    public Map<Class<?>, Map<Long, CachedEntity>> getAllCachedEntities() {
        return this.cachedObjects;
    }

    @Override
    public void close() {
    }

    @Override
    public void flushLog() {
    }

    @Override
    public void flush() {
    }
}

