/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.persistence.deploy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cache.WfCacheHelper;
import kd.bos.workflow.engine.impl.persistence.deploy.DeploymentCache;

public class DefaultDeploymentCache<T>
implements DeploymentCache<T> {
    protected static Log logger = LogFactory.getLog(DefaultDeploymentCache.class);
    protected Map<String, T> cache;
    protected DistributeSessionlessCache disCache;
    protected Map<String, String> lastUpdateTimeCache;
    private static final String TRACERTYPE = "ProcessModelCache";

    public DefaultDeploymentCache() {
        this.cache = Collections.synchronizedMap(new HashMap());
        this.lastUpdateTimeCache = Collections.synchronizedMap(new HashMap());
        this.disCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("workflow", new DistributeCacheHAPolicy());
    }

    public DefaultDeploymentCache(final int limit) {
        this.cache = Collections.synchronizedMap(new LinkedHashMap<String, T>(limit + 1, 0.75f, true){
            private static final long serialVersionUID = 1L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, T> eldest) {
                boolean removeEldest;
                boolean bl = removeEldest = this.size() > limit;
                if (removeEldest) {
                    logger.debug(String.format("Cache limit is reached, %s will be evicted", eldest.getKey()));
                }
                return removeEldest;
            }
        });
        this.lastUpdateTimeCache = Collections.synchronizedMap(new HashMap());
        this.disCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("workflow", new DistributeCacheHAPolicy());
    }

    @Override
    public T get(Long id) {
        try (TraceSpan ts = Tracer.create((String)TRACERTYPE, (String)"GetCache");){
            ts.addTag("id", String.valueOf(id));
        }
        String cacheKey = this.getMultiLangCacheKey(id);
        this.checkDisCache(cacheKey);
        return this.cache.get(cacheKey);
    }

    private void checkDisCache(String cacheKey) {
        String lastUpdateTime = (String)this.disCache.get(cacheKey);
        String cacheLastUpdateTime = this.lastUpdateTimeCache.get(cacheKey);
        logger.debug(String.format("cacheKey: %s, lastUpdateTime: %s, cacheLastUpdateTime: %s", cacheKey, lastUpdateTime, cacheLastUpdateTime));
        if (lastUpdateTime == null || !lastUpdateTime.equals(cacheLastUpdateTime)) {
            this.cache.remove(cacheKey);
            this.lastUpdateTimeCache.put(cacheKey, lastUpdateTime);
        }
    }

    private String getMultiLangCacheKey(Long id) {
        String lang = RequestContext.get().getLang().toString();
        return this.getMultiLangCacheKey(id, lang);
    }

    private String getMultiLangCacheKey(Long id, String lang) {
        return String.format("%s_wfdef_%s_%s", WfCacheHelper.getAccountId(), id, lang);
    }

    private void updateDisCache(String cacheKey, String lastUpdateTime) {
        this.lastUpdateTimeCache.put(cacheKey, lastUpdateTime);
        this.disCache.put(cacheKey, (Object)lastUpdateTime);
        logger.debug(String.format("updateCache[%s-%s]", cacheKey, lastUpdateTime));
    }

    @Override
    public void add(Long id, T obj, String lastUpdateTime) {
        try (TraceSpan ts = Tracer.create((String)TRACERTYPE, (String)"updateCache");){
            ts.addTag("id", String.valueOf(id));
        }
        String cacheKey = this.getMultiLangCacheKey(id);
        this.cache.put(cacheKey, obj);
        this.updateDisCache(cacheKey, lastUpdateTime);
    }

    private void removeCache(String cacheKey) {
        this.cache.remove(cacheKey);
        this.disCache.remove(cacheKey);
        this.lastUpdateTimeCache.remove(cacheKey);
    }

    @Override
    public void remove(Long id) {
        Lang[] values;
        Lang[] langArray = null;
        try (TraceSpan ts = Tracer.create((String)TRACERTYPE, (String)"removeCache");){
            ts.addTag("id", String.valueOf(id));
        }
        catch (Throwable object) {
            langArray = object;
            throw object;
        }
        for (Lang lang : values = WfMultiLangUtils.getSupportLangs()) {
            String cacheKey = this.getMultiLangCacheKey(id, lang.toString());
            this.removeCache(cacheKey);
        }
    }

    @Override
    public void remove(Set<Long> ids) {
        if (WfUtils.isEmptyForCollection(ids)) {
            return;
        }
        Lang[] values = WfMultiLangUtils.getSupportLangs();
        ArrayList<String> cacheKeys = new ArrayList<String>(ids.size());
        try (TraceSpan ts = Tracer.create((String)TRACERTYPE, (String)"removeCache");){
            ts.addTag("id", String.valueOf(ids));
        }
        for (Long id : ids) {
            for (Lang lang : values) {
                String cacheKey = this.getMultiLangCacheKey(id, lang.toString());
                cacheKeys.add(cacheKey);
                this.cache.remove(cacheKey);
                this.lastUpdateTimeCache.remove(cacheKey);
            }
        }
        if (WfUtils.isNotEmptyForCollection(cacheKeys)) {
            this.disCache.remove(cacheKeys.toArray(new String[cacheKeys.size()]));
        }
    }

    @Override
    public boolean contains(Long id) {
        return this.cache.containsKey(String.valueOf(id));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        this.cache.clear();
        if (this.lastUpdateTimeCache != null) {
            if (this.lastUpdateTimeCache.size() > 0) {
                DefaultDeploymentCache defaultDeploymentCache = this;
                synchronized (defaultDeploymentCache) {
                    String[] keys = this.lastUpdateTimeCache.keySet().toArray(new String[this.lastUpdateTimeCache.size()]);
                    this.disCache.remove(keys);
                }
            }
            this.lastUpdateTimeCache.clear();
        }
    }

    @Override
    public int size() {
        return this.cache.size();
    }
}

