/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.persistence.deploy;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.event.ActivitiEventDispatcher;
import kd.bos.workflow.engine.delegate.event.ActivitiEventType;
import kd.bos.workflow.engine.delegate.event.impl.ActivitiEventBuilder;
import kd.bos.workflow.engine.impl.cache.WfCacheHelper;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.db.EntityQueryBuilder;
import kd.bos.workflow.engine.impl.persistence.deploy.Deployer;
import kd.bos.workflow.engine.impl.persistence.deploy.DeploymentCache;
import kd.bos.workflow.engine.impl.persistence.deploy.ProcessDefinitionCacheEntry;
import kd.bos.workflow.engine.impl.persistence.deploy.ProcessDefinitionInfoCache;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricDynamicResourceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcessInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.DeploymentEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.DeploymentEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.DynamicResourceEntity;
import kd.bos.workflow.engine.repository.ProcessDefinition;
import kd.bos.workflow.exception.WFEngineException;
import kd.bos.workflow.exception.WFIllegalArgumentException;
import kd.bos.workflow.exception.WFObjectNotFoundException;

public class DeploymentManager {
    public static final String TYPE_PROCDEF = "processdefinition";
    public static final String TYPE_PROCINST = "procinstance";
    public static final String TYPE_SCHEME = "scheme";
    protected DeploymentCache<ProcessDefinitionCacheEntry> processDefinitionCache;
    protected ProcessDefinitionInfoCache processDefinitionInfoCache;
    protected DeploymentCache<Object> knowledgeBaseCache;
    protected List<Deployer> deployers;
    protected ProcessEngineConfigurationImpl processEngineConfiguration;
    protected ProcessDefinitionEntityManager processDefinitionEntityManager;
    protected DeploymentEntityManager deploymentEntityManager;
    protected Log log = LogFactory.getLog(this.getClass());

    public void deploy(DeploymentEntity deployment) {
        this.deploy(deployment, null);
    }

    public List<ProcessDefinitionCacheEntry> deploy(DeploymentEntity deployment, Map<String, Object> deploymentSettings) {
        ArrayList<ProcessDefinitionCacheEntry> ret = new ArrayList<ProcessDefinitionCacheEntry>();
        for (Deployer deployer : this.deployers) {
            ret.addAll(deployer.deploy(deployment, deploymentSettings));
        }
        return ret;
    }

    public ProcessDefinition findDeployedProcessDefinitionById(Long processDefinitionId) {
        ProcessDefinition processDefinition;
        if (processDefinitionId == null) {
            throw new WFIllegalArgumentException("Invalid process definition id : null");
        }
        ProcessDefinitionCacheEntry cacheEntry = this.processDefinitionCache.get(processDefinitionId);
        ProcessDefinition processDefinition2 = processDefinition = cacheEntry != null ? cacheEntry.getProcessDefinition() : null;
        if (processDefinition == null) {
            processDefinition = (ProcessDefinition)this.processDefinitionEntityManager.findById(processDefinitionId);
            if (processDefinition == null) {
                throw new WFObjectNotFoundException("no deployed process definition found with id '" + processDefinitionId + "'", ProcessDefinition.class);
            }
            processDefinition = this.resolveProcessDefinition(processDefinition).getProcessDefinition();
        }
        return processDefinition;
    }

    public ProcessDefinition findDeployedProcessDefinition(Long processDefinitionId, Long processInstanceId) {
        ProcessDefinition processDefinition;
        if (WfUtils.isEmpty(processInstanceId)) {
            return this.findDeployedProcessDefinitionById(processDefinitionId);
        }
        if (processDefinitionId == null) {
            throw new WFIllegalArgumentException("Invalid process definition id : null");
        }
        ProcessDefinitionCacheEntry cacheEntry = this.processDefinitionCache.get(processInstanceId);
        ProcessDefinition processDefinition2 = processDefinition = cacheEntry != null ? cacheEntry.getProcessDefinition() : null;
        if (processDefinition == null) {
            processDefinition = (ProcessDefinition)this.processDefinitionEntityManager.findById(processDefinitionId);
            if (processDefinition == null) {
                throw new WFObjectNotFoundException("no deployed process definition found with id '" + processDefinitionId + "'", ProcessDefinition.class);
            }
            processDefinition = this.resolveProcessDefinition(processDefinition, processInstanceId).getProcessDefinition();
        }
        return processDefinition;
    }

    public ProcessDefinition findDeployedLatestProcessDefinitionByKey(String processDefinitionKey) {
        ProcessDefinition processDefinition = this.processDefinitionEntityManager.findLatestProcessDefinitionByKey(processDefinitionKey);
        if (processDefinition == null) {
            throw new WFObjectNotFoundException("no processes deployed with key '" + processDefinitionKey + "'", ProcessDefinition.class);
        }
        processDefinition = this.resolveProcessDefinition(processDefinition).getProcessDefinition();
        return processDefinition;
    }

    public ProcessDefinition findDeployedProcessDefinitionByKeyAndVersion(String processDefinitionKey, String processDefinitionVersion) {
        ProcessDefinition processDefinition = (ProcessDefinitionEntity)this.processDefinitionEntityManager.findProcessDefinitionByKeyAndVersion(processDefinitionKey, processDefinitionVersion);
        if (processDefinition == null) {
            throw new WFObjectNotFoundException("no processes deployed with key = '" + processDefinitionKey + "' and version = '" + processDefinitionVersion + "'", ProcessDefinition.class);
        }
        processDefinition = this.resolveProcessDefinition(processDefinition).getProcessDefinition();
        return processDefinition;
    }

    public ProcessDefinitionCacheEntry resolveProcessDefinition(ProcessDefinition processDefinition) {
        Long processInstanceId = null;
        return this.resolveProcessDefinition(processDefinition, processInstanceId);
    }

    public ProcessDefinitionCacheEntry resolveProcessDefinition(ProcessDefinition processDefinition, Long processInstanceId) {
        HashMap<String, Object> settings = new HashMap<String, Object>();
        settings.put("processInstanceId", processInstanceId);
        return this.resolveProcessDefinition(processDefinition, settings);
    }

    public ProcessDefinitionCacheEntry resolveProcessDefinition(ProcessDefinition processDefinition, Map<String, Object> settings) {
        ProcessDefinitionCacheEntry cachedProcessDefinition = null;
        Long procInstId = null;
        Long cacheKeyId = null;
        String type = "";
        if (settings != null && !settings.isEmpty() && WfUtils.isNotEmpty(procInstId = (Long)settings.get("processInstanceId"))) {
            cacheKeyId = procInstId;
            cachedProcessDefinition = this.processDefinitionCache.get(cacheKeyId);
            type = "proinstance";
        } else {
            cacheKeyId = processDefinition.getId();
            cachedProcessDefinition = this.processDefinitionCache.get(cacheKeyId);
            type = TYPE_PROCDEF;
        }
        if (cachedProcessDefinition == null) {
            Long deploymentId = processDefinition.getDeploymentId();
            DeploymentEntity deployment = (DeploymentEntity)this.deploymentEntityManager.findById(deploymentId);
            deployment.setNew(false);
            List<ProcessDefinitionCacheEntry> ret = this.deploy(deployment, settings);
            if (ret != null && ret.size() > 0) {
                cachedProcessDefinition = ret.get(0);
            }
            if (cachedProcessDefinition == null) {
                cachedProcessDefinition = this.processDefinitionCache.get(cacheKeyId);
            }
            if (cachedProcessDefinition == null) {
                throw new WFEngineException(String.format("cannot get bpmnModel cache [%s-%s]", type, cacheKeyId));
            }
        }
        return cachedProcessDefinition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessDefinitionCacheEntry resolveProcessDefinition(Long processDefinitionId, Long schemeId, Long processInstanceId) {
        HashMap<String, Object> settings = new HashMap<String, Object>();
        settings.put("processInstanceId", processInstanceId);
        settings.put("schemeId", schemeId);
        settings.put("processDefinitionId", processDefinitionId);
        try {
            ProcessDefinitionCacheEntry processDefinitionCacheEntry = this.resolveProcessDefinition(processDefinitionId, settings);
            return processDefinitionCacheEntry;
        }
        finally {
            Context.getCommandContext().removeAttribute("DYNRESOURCE");
        }
    }

    private ProcessDefinitionCacheEntry resolveProcessDefinition(Long processDefinitionId, Map<String, Object> settings) {
        ProcessEngineConfigurationImpl configuration;
        Map<String, String> cacheVal;
        ProcessDefinitionCacheEntry cachedProcessDefinition = null;
        Long procInstId = (Long)settings.get("processInstanceId");
        Long schemeId = (Long)settings.get("schemeId");
        String type = TYPE_PROCDEF;
        Long cacheKeyId = processDefinitionId;
        if (WfUtils.isNotEmpty(procInstId)) {
            cacheKeyId = procInstId;
            type = TYPE_PROCINST;
        } else if (WfUtils.isNotEmpty(schemeId)) {
            cacheKeyId = schemeId;
            type = TYPE_SCHEME;
        }
        cachedProcessDefinition = this.processDefinitionCache.get(cacheKeyId);
        this.log.debug(String.format("procDefId: %s  schemeId: %s  procInstId: %s  cacheType: %s  cacheKeyId: %s  cached: %s", processDefinitionId, schemeId, procInstId, type, cacheKeyId, cachedProcessDefinition != null));
        if (cachedProcessDefinition == null && TYPE_PROCINST.equals(type) && (cacheVal = this.isProcessHasDynResources(configuration = Context.getProcessEngineConfiguration(), procInstId)) != null && cacheVal.get(TYPE_SCHEME) != null) {
            if (WfUtils.isEmpty(schemeId)) {
                schemeId = Long.valueOf(cacheVal.get(TYPE_SCHEME));
            }
            this.log.debug(String.format("the process %s is non-dynamic!", procInstId));
            if (WfUtils.isEmpty(schemeId)) {
                this.log.debug(String.format("schemeId is null! procInstId: %s", procInstId));
                HistoricProcessInstanceEntity procInst = (HistoricProcessInstanceEntity)configuration.getHistoricProcessInstanceEntityManager().findById(procInstId);
                if (procInst != null) {
                    type = TYPE_SCHEME;
                    cacheKeyId = procInst.getSchemeId();
                    settings.remove("processInstanceId");
                    settings.put("schemeId", procInst.getSchemeId());
                    cachedProcessDefinition = this.processDefinitionCache.get(cacheKeyId);
                    this.log.debug(String.format("procInst is not null! procInstId: %s  cached: %s", procInstId, cachedProcessDefinition != null));
                } else {
                    type = TYPE_PROCDEF;
                    cacheKeyId = processDefinitionId;
                    settings.remove("processInstanceId");
                    cachedProcessDefinition = this.processDefinitionCache.get(cacheKeyId);
                    this.log.debug(String.format("procInst is null! use processDefinitionId! procInstId: %s  procDefId: %s cached: %s", procInstId, processDefinitionId, cachedProcessDefinition != null));
                }
            } else {
                type = TYPE_SCHEME;
                cacheKeyId = schemeId;
                settings.remove("processInstanceId");
                settings.put("schemeId", schemeId);
                cachedProcessDefinition = this.processDefinitionCache.get(cacheKeyId);
                this.log.debug(String.format("schemeId is not null! schemeId: %s  cached: %s", schemeId, cachedProcessDefinition != null));
            }
        }
        if (cachedProcessDefinition == null) {
            ProcessDefinition def = (ProcessDefinition)this.processDefinitionEntityManager.findById(processDefinitionId);
            Long deploymentId = def.getDeploymentId();
            DeploymentEntity deployment = (DeploymentEntity)this.deploymentEntityManager.findById(deploymentId);
            deployment.setNew(false);
            List<ProcessDefinitionCacheEntry> ret = this.deploy(deployment, settings);
            if (ret != null && ret.size() > 0) {
                cachedProcessDefinition = ret.get(0);
            }
            if (cachedProcessDefinition == null) {
                cachedProcessDefinition = this.processDefinitionCache.get(cacheKeyId);
            }
            if (cachedProcessDefinition == null) {
                throw new WFEngineException(String.format("cannot get bpmnModel cache [%s-%s]", type, cacheKeyId));
            }
        }
        return cachedProcessDefinition;
    }

    private Map<String, String> isProcessHasDynResources(ProcessEngineConfigurationImpl configuration, Long procInstanceId) {
        Map<String, String> dynamicState = WfCacheHelper.getCachedDynamicProcessInstance(procInstanceId);
        this.log.debug(String.format("processInstanceId: %s dynamic state in cache: %s", procInstanceId, dynamicState));
        if (dynamicState == null || dynamicState.isEmpty()) {
            boolean isDynamic = false;
            HistoricProcessInstanceEntity exec = (HistoricProcessInstanceEntity)configuration.getHistoricProcessInstanceEntityManager().findById(procInstanceId, String.format("%s,%s", "schemeId", "endTime"));
            Long schemeId = 0L;
            if (exec != null) {
                schemeId = exec.getSchemeId();
            }
            if (exec != null && exec.getEndTime() == null) {
                List<DynamicResourceEntity> resources = configuration.getDynamicResourceEntityManager().findByProcessInstanceId(procInstanceId);
                if (resources != null && !resources.isEmpty()) {
                    isDynamic = true;
                    Context.getCommandContext().addAttribute("DYNRESOURCE", resources);
                }
            } else {
                List<HistoricDynamicResourceEntity> hisResources = configuration.getHistoricDynamicResourceEntityManager().findByProcessInstanceId(procInstanceId);
                if (hisResources != null && !hisResources.isEmpty()) {
                    isDynamic = true;
                }
            }
            HashMap<String, String> cacheVal = new HashMap<String, String>();
            if (schemeId == null) {
                schemeId = 0L;
            }
            if (isDynamic) {
                cacheVal.put(TYPE_PROCINST, String.format("%s#%s", procInstanceId, schemeId));
            } else {
                cacheVal.put(TYPE_SCHEME, String.valueOf(schemeId));
            }
            WfCacheHelper.markProcessInstanceIsDynamic(procInstanceId, cacheVal);
            this.log.debug(String.format("processInstanceId: %s dynamic state: %s, put state in cache.", procInstanceId, isDynamic));
            return cacheVal;
        }
        return dynamicState;
    }

    public void removeDeployment(Long deploymentId, boolean cascade) {
        DeploymentEntity deployment = (DeploymentEntity)this.deploymentEntityManager.findById(deploymentId);
        if (deployment == null) {
            throw new WFObjectNotFoundException("Could not find a deployment with id '" + deploymentId + "'.", DeploymentEntity.class);
        }
        EntityQueryBuilder qb = this.processDefinitionEntityManager.createQueryBuilder();
        qb.addFilter("deploymentId", deploymentId);
        List processDefinitions = this.processDefinitionEntityManager.findByQueryBuilder(qb);
        ActivitiEventDispatcher eventDispatcher = Context.getProcessEngineConfiguration().getEventDispatcher();
        for (ProcessDefinition processDefinition : processDefinitions) {
            if (!eventDispatcher.isEnabled()) continue;
            eventDispatcher.dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.ENTITY_DELETED, processDefinition));
        }
        this.deploymentEntityManager.deleteDeployment(deploymentId, cascade);
        if (eventDispatcher.isEnabled()) {
            eventDispatcher.dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.ENTITY_DELETED, deployment));
        }
        for (ProcessDefinition processDefinition : processDefinitions) {
            this.processDefinitionCache.remove(processDefinition.getId());
        }
    }

    public List<Deployer> getDeployers() {
        return this.deployers;
    }

    public void setDeployers(List<Deployer> deployers) {
        this.deployers = deployers;
    }

    public DeploymentCache<ProcessDefinitionCacheEntry> getProcessDefinitionCache() {
        return this.processDefinitionCache;
    }

    public void setProcessDefinitionCache(DeploymentCache<ProcessDefinitionCacheEntry> processDefinitionCache) {
        this.processDefinitionCache = processDefinitionCache;
    }

    public ProcessDefinitionInfoCache getProcessDefinitionInfoCache() {
        return this.processDefinitionInfoCache;
    }

    public void setProcessDefinitionInfoCache(ProcessDefinitionInfoCache processDefinitionInfoCache) {
        this.processDefinitionInfoCache = processDefinitionInfoCache;
    }

    public DeploymentCache<Object> getKnowledgeBaseCache() {
        return this.knowledgeBaseCache;
    }

    public void setKnowledgeBaseCache(DeploymentCache<Object> knowledgeBaseCache) {
        this.knowledgeBaseCache = knowledgeBaseCache;
    }

    public ProcessEngineConfigurationImpl getProcessEngineConfiguration() {
        return this.processEngineConfiguration;
    }

    public void setProcessEngineConfiguration(ProcessEngineConfigurationImpl processEngineConfiguration) {
        this.processEngineConfiguration = processEngineConfiguration;
    }

    public ProcessDefinitionEntityManager getProcessDefinitionEntityManager() {
        return this.processDefinitionEntityManager;
    }

    public void setProcessDefinitionEntityManager(ProcessDefinitionEntityManager processDefinitionEntityManager) {
        this.processDefinitionEntityManager = processDefinitionEntityManager;
    }

    public DeploymentEntityManager getDeploymentEntityManager() {
        return this.deploymentEntityManager;
    }

    public void setDeploymentEntityManager(DeploymentEntityManager deploymentEntityManager) {
        this.deploymentEntityManager = deploymentEntityManager;
    }
}

