/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.persistence.deploy;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.interceptor.CommandExecutor;
import kd.bos.workflow.engine.impl.persistence.deploy.ProcessDefinitionInfoCacheObject;

public class ProcessDefinitionInfoCache {
    protected static Log logger = LogFactory.getLog(ProcessDefinitionInfoCache.class);
    protected Map<Long, ProcessDefinitionInfoCacheObject> cache;
    protected CommandExecutor commandExecutor;

    public ProcessDefinitionInfoCache(CommandExecutor commandExecutor) {
        this.commandExecutor = commandExecutor;
        this.cache = Collections.synchronizedMap(new HashMap());
    }

    public ProcessDefinitionInfoCache(CommandExecutor commandExecutor, final int limit) {
        this.commandExecutor = commandExecutor;
        this.cache = Collections.synchronizedMap(new LinkedHashMap<Long, ProcessDefinitionInfoCacheObject>(limit + 1, 0.75f, true){
            private static final long serialVersionUID = 1L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<Long, ProcessDefinitionInfoCacheObject> eldest) {
                boolean removeEldest;
                boolean bl = removeEldest = this.size() > limit;
                if (removeEldest) {
                    logger.debug(String.format("Cache limit is reached, %s will be evicted", eldest.getKey()));
                }
                return removeEldest;
            }
        });
    }

    public ProcessDefinitionInfoCacheObject get(final Long processDefinitionId) {
        ProcessDefinitionInfoCacheObject infoCacheObject = null;
        Command<ProcessDefinitionInfoCacheObject> cacheCommand = new Command<ProcessDefinitionInfoCacheObject>(){

            @Override
            public ProcessDefinitionInfoCacheObject execute(CommandContext commandContext) {
                return ProcessDefinitionInfoCache.this.retrieveProcessDefinitionInfoCacheObject(processDefinitionId, commandContext);
            }
        };
        infoCacheObject = Context.getCommandContext() != null ? this.retrieveProcessDefinitionInfoCacheObject(processDefinitionId, Context.getCommandContext()) : this.commandExecutor.execute(cacheCommand);
        return infoCacheObject;
    }

    public void add(Long id, ProcessDefinitionInfoCacheObject obj) {
        this.cache.put(id, obj);
    }

    public void remove(Long id) {
        this.cache.remove(id);
    }

    public void clear() {
        this.cache.clear();
    }

    public int size() {
        return this.cache.size();
    }

    protected ProcessDefinitionInfoCacheObject retrieveProcessDefinitionInfoCacheObject(Long processDefinitionId, CommandContext commandContext) {
        ObjectMapper objectMapper = commandContext.getProcessEngineConfiguration().getObjectMapper();
        ProcessDefinitionInfoCacheObject cacheObject = null;
        ProcessDefinitionInfoCacheObject cacheObjectTemp = this.cache.get(processDefinitionId);
        if (cacheObjectTemp != null) {
            cacheObject = this.cache.get(processDefinitionId);
        } else {
            cacheObject = new ProcessDefinitionInfoCacheObject();
            cacheObject.setRevision(0);
            cacheObject.setInfoNode(objectMapper.createObjectNode());
        }
        return cacheObject;
    }
}

