/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.persistence.entity;

import com.alibaba.fastjson.annotation.JSONField;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.script.annotations.KSMethod;
import kd.bos.workflow.bpmn.converter.field.TransIgnore;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.Entity;

public abstract class AbstractEntity
implements Entity,
Serializable {
    private static final long serialVersionUID = 703107190907242346L;
    private static Log logger = LogFactory.getLog(AbstractEntity.class);
    @JSONField(serialize=false)
    protected boolean inserted;
    @JSONField(serialize=false)
    protected boolean updated;
    @JSONField(serialize=false)
    protected boolean deleted;
    @JSONField(serialize=false)
    protected DynamicObject dynamicObject;

    public AbstractEntity(DynamicObject dynamicObject) {
        this.dynamicObject = dynamicObject;
    }

    public AbstractEntity() {
        this.init();
    }

    protected final void init() {
        try {
            String et = this.getDynObjTypeName();
            if (WfUtils.isNotEmpty(et)) {
                MainEntityType type = EntityMetadataCache.getDataEntityType((String)et);
                this.dynamicObject = new DynamicObject((DynamicObjectType)type);
            }
        }
        catch (Exception e) {
            logger.info(e.getMessage());
        }
    }

    @KSMethod
    @SimplePropertyAttribute(name="id")
    public Long getId() {
        return this.normalizeId(this.dynamicObject.getLong("id"));
    }

    public void setId(Long id) {
        this.dynamicObject.set("id", (Object)id);
    }

    @TransIgnore
    public boolean isInserted() {
        return this.inserted;
    }

    public void setInserted(boolean isInserted) {
        this.inserted = isInserted;
    }

    @TransIgnore
    public boolean isUpdated() {
        return this.updated;
    }

    public void setUpdated(boolean isUpdated) {
        this.updated = isUpdated;
    }

    @TransIgnore
    public boolean isDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean isDeleted) {
        this.deleted = isDeleted;
    }

    public DynamicObject getDynamicObject() {
        return this.dynamicObject;
    }

    public void setDynamicObject(DynamicObject dynamicObject) {
        this.dynamicObject = dynamicObject;
    }

    public Object getPersistentState() {
        return null;
    }

    @JSONField(serialize=false)
    public String getDynObjTypeName() {
        String className = this.getClass().getSimpleName();
        return WfUtils.getDynObjectTypeName(className);
    }

    @KSMethod
    @SimplePropertyAttribute(name="createDate")
    public Date getCreateDate() {
        return this.dynamicObject.getDate("createDate");
    }

    public void setCreateDate(Date createDate) {
        this.dynamicObject.set("createDate", (Object)createDate);
    }

    @KSMethod
    @SimplePropertyAttribute(name="modifyDate")
    public Date getModifyDate() {
        return this.dynamicObject.getDate("modifyDate");
    }

    public void setModifyDate(Date modifyDate) {
        this.dynamicObject.set("modifyDate", (Object)modifyDate);
    }

    public void addToCreateAndModifyDate(Map<String, Object> persistentState) {
        Date modifyDate;
        Date createDate = this.getCreateDate();
        if (createDate != null) {
            persistentState.put("createDate", createDate);
        }
        if ((modifyDate = this.getModifyDate()) != null) {
            persistentState.put("modifyDate", modifyDate);
        }
    }

    public Long normalizeId(String id) {
        return WfUtils.normalizeId(id);
    }

    public Long normalizeId(long id) {
        return WfUtils.normalizeId(id);
    }

    public Long normalizeId(Long id) {
        return WfUtils.normalizeId(id);
    }
}

