/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.persistence.entity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.engine.EntityUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.event.ActivitiEventDispatcher;
import kd.bos.workflow.engine.delegate.event.ActivitiEventType;
import kd.bos.workflow.engine.delegate.event.impl.ActivitiEventBuilder;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.db.BatchSQLInfo;
import kd.bos.workflow.engine.impl.db.DbSqlSession;
import kd.bos.workflow.engine.impl.db.EntityQueryBuilder;
import kd.bos.workflow.engine.impl.persistence.AbstractManager;
import kd.bos.workflow.engine.impl.persistence.CachedEntityMatcher;
import kd.bos.workflow.engine.impl.persistence.CountingExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.cache.CachedEntity;
import kd.bos.workflow.engine.impl.persistence.cache.EntityCache;
import kd.bos.workflow.engine.impl.persistence.entity.Entity;
import kd.bos.workflow.engine.impl.persistence.entity.EntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import org.apache.commons.beanutils.PropertyUtils;

public abstract class AbstractEntityManager<T extends Entity>
extends AbstractManager
implements EntityManager<T> {
    public AbstractEntityManager(ProcessEngineConfigurationImpl processEngineConfiguration) {
        super(processEngineConfiguration);
        this.init();
    }

    private void init() {
        this.mapToEntityMgr();
    }

    protected void mapToEntityMgr() {
        this.processEngineConfiguration.mapToEntityMgr(this.getEntityName(), this.getManagedEntityClass(), this);
    }

    @Override
    public void insert(T entity) {
        this.insert(entity, true);
    }

    @Override
    public void insert(T entity, boolean fireCreateEvent) {
        this.getDbSqlSession().insert((Entity)entity);
        ActivitiEventDispatcher eventDispatcher = this.getEventDispatcher();
        if (fireCreateEvent && eventDispatcher.isEnabled()) {
            eventDispatcher.dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.ENTITY_CREATED, entity));
        }
    }

    @Override
    public T update(T entity) {
        return this.update(entity, true);
    }

    @Override
    public T update(T entity, boolean fireUpdateEvent) {
        this.getDbSqlSession().update((Entity)entity);
        if (fireUpdateEvent && this.getEventDispatcher().isEnabled()) {
            this.getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.ENTITY_UPDATED, entity));
        }
        return entity;
    }

    @Override
    public void delete(Long id) {
        T entity = this.findById(id);
        if (entity != null) {
            this.delete(entity);
        }
    }

    @Override
    public void delete(T entity) {
        this.delete(entity, true);
    }

    @Override
    public void delete(T entity, boolean fireDeleteEvent) {
        if (entity == null) {
            return;
        }
        this.getDbSqlSession().delete((Entity)entity);
        if (fireDeleteEvent && this.getEventDispatcher().isEnabled()) {
            this.getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.ENTITY_DELETED, entity));
        }
    }

    public void deleteByCacheFilter(String entityNumber, QFilter filter) {
        if (WfUtils.isNotEmpty(entityNumber) || filter != null) {
            this.getDbSqlSession().deleteByCacheFilter(entityNumber, filter);
        }
    }

    @Override
    public long countByFilter(String field, QFilter[] qFilters, boolean distinct) {
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)this.createAlgoKey(), (String)this.getEntityName(), (String)field, (QFilter[])qFilters, null);){
            long l = ds.count(field, distinct);
            return l;
        }
    }

    @Override
    public T findById(Long entityId, String fields) {
        this.logger.debug("starting findById,params is [" + this.getClass().getName() + "],entityId:[" + entityId + "]");
        if (WfUtils.isEmpty(entityId)) {
            return null;
        }
        Entity cachedEntity = (Entity)this.getEntityCache().findInCache(this.getManagedEntityClass(), entityId);
        if (cachedEntity != null) {
            return (T)cachedEntity;
        }
        this.logger.debug("cannot find entity[" + entityId + "] in the cache,will be find it by function findByORM");
        return this.getDbSqlSession().selectById(this.getManagedEntityClass(), entityId, fields, false);
    }

    @Override
    public T findById(Long entityId) {
        return this.findById(entityId, null);
    }

    @Override
    public List<T> findByQueryBuilder(EntityQueryBuilder<T> queryBuilder, boolean useCache) {
        return this.getDbSqlSession().selectCollection(queryBuilder, null, useCache);
    }

    @Override
    public List<T> findByQueryBuilder(EntityQueryBuilder<T> queryBuilder) {
        return this.getDbSqlSession().selectCollection(queryBuilder, null, this.useCache(queryBuilder.getSelectFields()));
    }

    public List<T> findByQueryBuilder(EntityQueryBuilder<T> queryBuilder, CachedEntityMatcher<T> cachedEntityMatcher, Object parameter, boolean checkCache) {
        return this.getList(queryBuilder, cachedEntityMatcher, parameter, checkCache);
    }

    @Override
    public List<T> findByQueryFilters(QFilter[] filters) {
        EntityQueryBuilder<T> builder = this.createEntityQueryBuilder(filters);
        return this.findByQueryBuilder(builder);
    }

    @Override
    public List<T> findByQueryFilters(QFilter[] filters, boolean useCache) {
        EntityQueryBuilder<T> builder = this.createEntityQueryBuilder(filters);
        return this.findByQueryBuilder(builder, useCache);
    }

    @Override
    public List<T> findByQueryFilters(QFilter[] qFilters, String fields, String sort) {
        return this.findByQueryFilters(qFilters, fields, sort, this.useCache(fields));
    }

    @Override
    public List<T> findByQueryFilters(QFilter[] qFilters, String fields, String sort, boolean useCache) {
        EntityQueryBuilder<T> builder = this.createEntityQueryBuilder(qFilters, fields, sort);
        return this.getDbSqlSession().selectCollection(builder, null, useCache);
    }

    private boolean useCache(String fields) {
        String selectFields = this.getSelectFields();
        return selectFields != null && selectFields.equals(fields);
    }

    protected List<T> findEntityBySQLFilter(String sql, Object[] params) {
        return this.getDbSqlSession().selectCollection(sql, params, this.getEntityName(), this.getSelectFields());
    }

    protected List<T> findEntityBySQLFilter(String sql, Object[] params, String selectedfields) {
        return this.getDbSqlSession().selectCollection(sql, params, this.getEntityName(), selectedfields);
    }

    @Override
    public EntityQueryBuilder<T> createQueryBuilder() {
        return new EntityQueryBuilder(this.getEntityName(), this.getSelectFields());
    }

    @Override
    public EntityQueryBuilder<T> createQueryBuilder(ProcessEngineConfigurationImpl configurationImpl) {
        EntityQueryBuilder t = new EntityQueryBuilder(this.getEntityName(), this.getSelectFields());
        t.setConfigurationImpl(configurationImpl);
        return t;
    }

    public T findOneByCondition(QFilter[] qFilters, String fields, String sort) {
        EntityQueryBuilder<T> t = this.createEntityQueryBuilder(qFilters, fields, sort);
        return this.findOneByCondition(t);
    }

    public T findOneByCondition(EntityQueryBuilder<T> eb) {
        eb.setLimit(1);
        List<T> list = this.findByQueryBuilder(eb);
        if (list != null && list.size() > 0) {
            return (T)((Entity)list.get(0));
        }
        return null;
    }

    public Entity findDBOneByCondition(String sql, Object[] params) {
        List<T> ret = this.findEntityBySQLFilter(sql, params);
        if (ret != null && !ret.isEmpty()) {
            return (Entity)ret.get(0);
        }
        return null;
    }

    @Override
    public void deleteByFilters(QFilter[] qFilters) {
        this.getDbSqlSession().deleteByFilters(this.getEntityName(), qFilters);
    }

    public abstract Class<? extends T> getManagedEntityClass();

    @Override
    public abstract String getSelectFields();

    public List<Class<? extends T>> getManagedEntitySubClasses() {
        return new ArrayList<Class<? extends T>>();
    }

    protected DbSqlSession getDbSqlSession() {
        return this.getSession(DbSqlSession.class);
    }

    protected EntityCache getEntityCache() {
        return this.getSession(EntityCache.class);
    }

    @Override
    public T create() {
        return EntityUtil.createEntity(this.getManagedEntityClass());
    }

    @Override
    public T create(DynamicObject dynamicObject) {
        Object t = EntityUtil.createEntity(this.getManagedEntityClass(), dynamicObject);
        this.fixSpecialProp(t);
        return t;
    }

    @Override
    public void addBatchSQLInfo(BatchSQLInfo batchSQLInfo) {
        this.getDbSqlSession().addBatchSQLInfo(batchSQLInfo);
    }

    @Override
    public boolean exist(Long id) {
        return this.getDbSqlSession().exist(this.getEntityName(), id);
    }

    @Override
    public boolean exist(QFilter[] qFilters) {
        return this.getDbSqlSession().exist(this.getEntityName(), qFilters);
    }

    protected void fixSpecialProp(T t) {
    }

    public String getEntityName() {
        return WfUtils.getDynObjectTypeName(this.getManagedEntityClass().getSimpleName());
    }

    public String getTableName() {
        return "";
    }

    public String getMultiLangTableName() {
        return "";
    }

    public String getSeparateStorageKey() {
        return "";
    }

    protected String createAlgoKey() {
        String methodName = Thread.currentThread().getStackTrace()[2].getMethodName();
        return new StringBuffer().append("bos.wf.").append(this.getClass().getName()).append(".").append(methodName).toString();
    }

    protected EntityQueryBuilder<T> createEntityQueryBuilder(QFilter[] filters) {
        return this.createEntityQueryBuilder(filters, "");
    }

    protected EntityQueryBuilder<T> createEntityQueryBuilder(QFilter[] filters, String orderBy) {
        return this.createEntityQueryBuilder(filters, this.getSelectFields(), orderBy);
    }

    protected EntityQueryBuilder<T> createEntityQueryBuilder(QFilter[] filters, String fields, String orderBy) {
        return this.createQueryBuilder().addFilters(filters).setSelectFields(fields).orderBy(orderBy);
    }

    protected Map<String, Object> exportRowToMap(Row row, RowMeta rowMeta) {
        Field[] fields;
        if (WfUtils.isNullObject(rowMeta)) {
            return null;
        }
        HashMap<String, Object> ret = new HashMap<String, Object>();
        for (Field field : fields = rowMeta.getFields()) {
            if ("id".equals(field.getName().toLowerCase())) {
                ret.put(field.getName().toLowerCase(), row.getLong(field.getName()));
                continue;
            }
            ret.put(field.getName().toLowerCase(), row.get(field.getName()));
        }
        return ret;
    }

    protected List<T> getListFromCache(CachedEntityMatcher<T> entityMatcher, Object parameter) {
        Collection<CachedEntity> cachedObjects = this.getEntityCache().findInCacheAsCachedObjects(this.getManagedEntityClass());
        DbSqlSession dbSqlSession = this.getDbSqlSession();
        ArrayList<Entity> result = new ArrayList<Entity>(cachedObjects.size());
        if (cachedObjects != null && entityMatcher != null) {
            for (CachedEntity cachedEntity : cachedObjects) {
                Entity cachedEntity2 = cachedEntity.getEntity();
                if (!entityMatcher.isRetained(null, cachedObjects, cachedEntity2, parameter) || dbSqlSession.isEntityToBeDeleted(cachedEntity2)) continue;
                result.add(cachedEntity2);
            }
        }
        if (this.getManagedEntitySubClasses() != null && entityMatcher != null) {
            for (Class clazz : this.getManagedEntitySubClasses()) {
                Collection<CachedEntity> subclassCachedObjects = this.getEntityCache().findInCacheAsCachedObjects(clazz);
                if (subclassCachedObjects == null) continue;
                for (CachedEntity subclassCachedObject : subclassCachedObjects) {
                    Entity cachedSubclassEntity = subclassCachedObject.getEntity();
                    if (!entityMatcher.isRetained(null, cachedObjects, cachedSubclassEntity, parameter) || dbSqlSession.isEntityToBeDeleted(cachedSubclassEntity)) continue;
                    result.add(cachedSubclassEntity);
                }
            }
        }
        return result;
    }

    protected boolean isExecutionRelatedEntityCountEnabledGlobally() {
        return this.processEngineConfiguration.getPerformanceSettings().isEnableExecutionRelationshipCounts();
    }

    protected boolean isExecutionRelatedEntityCountEnabled(ExecutionEntity executionEntity) {
        if (executionEntity instanceof CountingExecutionEntity) {
            return this.isExecutionRelatedEntityCountEnabled((CountingExecutionEntity)((Object)executionEntity));
        }
        return false;
    }

    protected boolean isExecutionRelatedEntityCountEnabled(CountingExecutionEntity executionEntity) {
        return this.isExecutionRelatedEntityCountEnabledGlobally() && executionEntity.isCountEnabled();
    }

    protected List<T> getList(EntityQueryBuilder<T> qb, CachedEntityMatcher<T> cachedEntityMatcher, Object parameter, boolean checkCache) {
        Collection<CachedEntity> cachedObjects;
        Collection<Object> result = this.findByQueryBuilder(qb);
        if (checkCache && ((cachedObjects = this.getEntityCache().findInCacheAsCachedObjects(this.getManagedEntityClass())) != null && cachedObjects.size() > 0 || this.getManagedEntitySubClasses() != null)) {
            LinkedHashMap<Long, Entity> entityMap = new LinkedHashMap<Long, Entity>(result.size());
            for (Entity entity : result) {
                entityMap.put(entity.getId(), entity);
            }
            if (cachedObjects != null && cachedEntityMatcher != null) {
                for (CachedEntity cachedEntity : cachedObjects) {
                    Entity cachedEntity2 = cachedEntity.getEntity();
                    if (!cachedEntityMatcher.isRetained(result, cachedObjects, cachedEntity2, parameter)) continue;
                    entityMap.put(cachedEntity2.getId(), cachedEntity2);
                }
            }
            if (this.getManagedEntitySubClasses() != null && cachedEntityMatcher != null) {
                for (Class clazz : this.getManagedEntitySubClasses()) {
                    Collection<CachedEntity> subclassCachedObjects = this.getEntityCache().findInCacheAsCachedObjects(clazz);
                    if (subclassCachedObjects == null) continue;
                    for (CachedEntity subclassCachedObject : subclassCachedObjects) {
                        Entity cachedSubclassEntity = subclassCachedObject.getEntity();
                        if (!cachedEntityMatcher.isRetained(result, cachedObjects, cachedSubclassEntity, parameter)) continue;
                        entityMap.put(cachedSubclassEntity.getId(), cachedSubclassEntity);
                    }
                }
            }
            result = entityMap.values();
        }
        ArrayList<Object> ret = null;
        if (result != null && result.size() > 0) {
            Iterator resultIterator = result.iterator();
            while (resultIterator.hasNext()) {
                if (!this.getDbSqlSession().isEntityToBeDeleted((Entity)resultIterator.next())) continue;
                resultIterator.remove();
            }
            ret = new ArrayList<T>(result);
        } else {
            ret = new ArrayList();
        }
        if (WfUtils.isNotEmpty(qb.getOrderBys())) {
            this.sortList(ret, qb.getOrderBys());
        }
        return ret;
    }

    private void sortList(ArrayList<T> ret, String orderBy) {
        String regex = "^\\s*(\\w+)(\\s+((desc)|(asc)))?\\s*$";
        if (orderBy.matches(regex)) {
            String ASC = "asc";
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(orderBy);
            if (matcher.find()) {
                final String field = matcher.group(1);
                String dir = matcher.group(3);
                final String direction = dir == null ? "asc" : dir;
                Collections.sort(ret, new Comparator<T>(){

                    @Override
                    public int compare(T entity, T other) {
                        try {
                            Object val = PropertyUtils.getProperty(entity, (String)field);
                            Object otherVal = PropertyUtils.getProperty(other, (String)field);
                            if (val instanceof String) {
                                return "asc".equals(direction) ? val.toString().compareTo(otherVal.toString()) : otherVal.toString().compareTo(val.toString());
                            }
                            if (val instanceof Integer) {
                                return "asc".equals(direction) ? (Integer)val - (Integer)otherVal : (Integer)otherVal - (Integer)val;
                            }
                            if (val instanceof Long) {
                                return (int)("asc".equals(direction) ? (Long)val - (Long)otherVal : (Long)otherVal - (Long)val);
                            }
                            if (val instanceof Double) {
                                return (int)("asc".equals(direction) ? (Double)val - (Double)otherVal : (Double)otherVal - (Double)val);
                            }
                        }
                        catch (Exception e) {
                            AbstractEntityManager.this.logger.error(e.getMessage(), (Throwable)e);
                        }
                        return 0;
                    }
                });
            }
        }
    }
}

