/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.persistence.entity.basedata;

import java.util.List;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.persistence.entity.AbstractEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.basedata.BaseDataRefRecordEntity;
import kd.bos.workflow.engine.impl.persistence.entity.basedata.BaseDataRefRecordEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.basedata.BaseDataRefRecordManager;

public class BaseDataRefRecordManagerImpl
extends AbstractEntityManager<BaseDataRefRecordEntity>
implements BaseDataRefRecordManager {
    public BaseDataRefRecordManagerImpl(ProcessEngineConfigurationImpl processEngineConfiguration) {
        super(processEngineConfiguration);
    }

    @Override
    public Class<? extends BaseDataRefRecordEntity> getManagedEntityClass() {
        return BaseDataRefRecordEntityImpl.class;
    }

    @Override
    public String getSelectFields() {
        return "id,procdefid,procnum,schemeid,value,type,activityid,property";
    }

    @Override
    public void clearBaseDataRefRecord(Long procDefId, Long schemeId) {
        QFilter q1 = new QFilter("procdefid", "=", (Object)procDefId);
        QFilter q2 = new QFilter("schemeid", "=", (Object)schemeId);
        QFilter q3 = new QFilter("activityid", "!=", (Object)" ");
        QFilter q4 = new QFilter("property", "is not null", null).or(new QFilter("property", "=", (Object)"startUpCondition")).or(new QFilter("property", "=", (Object)"schemaCondition"));
        QFilter[] qFilters = new QFilter[]{q1, q2, q3, q4};
        this.deleteByFilters(qFilters);
    }

    @Override
    @Deprecated
    public void insertBaseDataRefRecord(Long procdefId, Long schemeId, String type, Long value, String activityId, String property, String procnum) {
        BaseDataRefRecordEntity bdrrentity = (BaseDataRefRecordEntity)this.create();
        bdrrentity.setProcdefId(procdefId);
        bdrrentity.setSchemeId(schemeId);
        bdrrentity.setType(type);
        bdrrentity.setValue(value);
        bdrrentity.setActivityId(activityId);
        bdrrentity.setProperty(property);
        bdrrentity.setProcnum(procnum);
        this.insert(bdrrentity);
    }

    @Override
    public void insertBaseDataRefRecord(Long procdefId, Long schemeId, String type, Long value, String activityId, ILocaleString activityName, String property, String procnum) {
        BaseDataRefRecordEntity bdrrentity = (BaseDataRefRecordEntity)this.create();
        bdrrentity.setProcdefId(procdefId);
        bdrrentity.setSchemeId(schemeId);
        bdrrentity.setType(type);
        bdrrentity.setValue(value);
        bdrrentity.setActivityId(activityId);
        if (WfUtils.isNotEmpty(activityName)) {
            bdrrentity.setActivityName(WfUtils.subILocaleString(activityName, 255));
        }
        bdrrentity.setProperty(property);
        bdrrentity.setProcnum(procnum);
        this.insert(bdrrentity);
    }

    @Override
    public List<BaseDataRefRecordEntity> getExistBaseDataRefs(String type, Long baseDataId) {
        QFilter[] qFilters = new QFilter[]{new QFilter("value", "=", (Object)baseDataId)};
        return this.findByQueryFilters(qFilters, "procnum", null);
    }

    @Override
    public void clearSchemeCondRuleBaseDataRefRecord(Long procDefId, Long schemeId, String type) {
        schemeId = schemeId == null ? Long.valueOf(0L) : schemeId;
        QFilter q1 = new QFilter("procdefid", "=", (Object)procDefId);
        QFilter q2 = new QFilter("schemeid", "=", (Object)schemeId);
        QFilter q3 = new QFilter("type", "=", (Object)type);
        QFilter q4 = new QFilter("activityid", "=", (Object)" ");
        QFilter q5 = new QFilter("property", "=", (Object)" ").or(new QFilter("property", "=", (Object)"startUpCondition")).or(new QFilter("property", "=", (Object)"schemaCondition"));
        QFilter[] qFilters = new QFilter[]{q1, q2, q3, q4, q5};
        this.deleteByFilters(qFilters);
    }

    @Override
    public void deleteBaseDataRefRecordBySchemeId(Long schemeId) {
        if (schemeId == null) {
            return;
        }
        QFilter[] filters = new QFilter[]{new QFilter("schemeid", "=", (Object)schemeId)};
        this.deleteByFilters(filters);
    }
}

