/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.persistence.entity.design;

import java.util.List;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.db.EntityQueryBuilder;
import kd.bos.workflow.engine.impl.persistence.entity.AbstractEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.design.AuditPointInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.design.AuditPointInstanceEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.design.AuditPointInstanceEntityManager;

public class AuditPointInstanceEntityManagerImpl
extends AbstractEntityManager<AuditPointInstanceEntity>
implements AuditPointInstanceEntityManager {
    public AuditPointInstanceEntityManagerImpl(ProcessEngineConfigurationImpl processEngineConfiguration) {
        super(processEngineConfiguration);
    }

    @Override
    public Class<? extends AuditPointInstanceEntity> getManagedEntityClass() {
        return AuditPointInstanceEntityImpl.class;
    }

    @Override
    public String getSelectFields() {
        return "id,auditpointseq,processinstanceid,executionid,activityinstanceid,taskid,actid,businesskey,entitynumber,type,condition,isdisplay,displayname,descriptionexpression,description,businessrule,checkresult,isneedreason,failedreasonexpression,failedreason,isneedmark,isimmediately,assigneeid,assigneename,createrid,createdate,modifierid,modifydate";
    }

    @Override
    public String getEntityName() {
        return "wf_auditpointinstance";
    }

    @Override
    public void updateAuditPointInstance(AuditPointInstanceEntity entity) {
        entity.setModifyDate(this.getClock().getCurrentTime());
        this.update(entity);
    }

    @Override
    public AuditPointInstanceEntity findAuditPointInstanceById(Long id) {
        return (AuditPointInstanceEntity)this.findById(id);
    }

    @Override
    public List<AuditPointInstanceEntity> findAuditPointInstancesByTaskId(Long taskId) {
        EntityQueryBuilder qb = this.createQueryBuilder().addFilter("taskId", taskId).orderBy("auditpointseq");
        return this.findByQueryBuilder(qb);
    }

    @Override
    public List<AuditPointInstanceEntity> getDisplayAuditPointInstsByTaskId(Long taskId) {
        EntityQueryBuilder queryBuilder = this.createQueryBuilder();
        queryBuilder.addFilter("taskId", taskId).addFilter("isdisplay", Boolean.TRUE).orderBy("auditpointseq");
        return this.findByQueryBuilder(queryBuilder);
    }
}

