/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.persistence.entity.design;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.workflow.bpmn.converter.BpmnJsonConverter;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.db.EntityQueryBuilder;
import kd.bos.workflow.engine.impl.persistence.CachedEntityMatcher;
import kd.bos.workflow.engine.impl.persistence.entity.AbstractEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.cachematcher.ModelEntityByIdMatcher;
import kd.bos.workflow.engine.impl.persistence.entity.design.AppModelRelationEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelEntity;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.design.ProcessCategoryEntity;
import kd.bos.workflow.engine.impl.persistence.entity.design.ProcessCategoryEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.design.ProcessCategoryEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.design.ResourceEntity;

public class ModelEntityManagerImpl
extends AbstractEntityManager<ModelEntity>
implements ModelEntityManager {
    private CachedEntityMatcher<ModelEntity> byIdMatcher = new ModelEntityByIdMatcher();

    public ModelEntityManagerImpl(ProcessEngineConfigurationImpl processEngineConfiguration) {
        super(processEngineConfiguration);
    }

    @Override
    public Class<? extends ModelEntity> getManagedEntityClass() {
        return ModelEntityImpl.class;
    }

    @Override
    public String getSelectFields() {
        return "id, key, name, description, orgunitid, entrabill, entrabillid, categoryid, version, deploymentid, bpmnxmlid, pngid, graphid, operation, parentprocid, type, publish, creatorid, createdate, modifierid, modifydate, discard, applicationid,businessid,orgviewid,template,templatenumber,templateversion,primarysubprocess";
    }

    @Override
    public void insert(ModelEntity entity) {
        super.insert(entity);
        this.insertRelation(entity);
    }

    @Override
    public void updateModel(ModelEntity updatedModel) {
        updatedModel.setModifyDate(this.getClock().getCurrentTime());
        this.update(updatedModel);
        this.updateRelation(updatedModel);
    }

    @Override
    public void delete(Long modelId) {
        ModelEntity modelEntity = (ModelEntity)this.findById(modelId);
        super.delete(modelEntity);
        if (modelEntity == null) {
            return;
        }
        this.deleteEditorSource(modelEntity);
        this.deleteEditorSourceExtra(modelEntity);
        this.deleteEditorSourceGraph(modelEntity);
        this.deleteRelation(modelEntity);
    }

    @Override
    public void deleteEditorSource(ModelEntity model) {
        if (WfUtils.isNotEmpty(model.getBPMNXMLID())) {
            this.processEngineConfiguration.getResourceEntityManager().delete(model.getBPMNXMLID());
        }
    }

    @Override
    public void deleteEditorSourceExtra(ModelEntity model) {
        if (WfUtils.isNotEmpty(model.getPNGID())) {
            this.processEngineConfiguration.getResourceEntityManager().delete(model.getPNGID());
        }
    }

    @Override
    public void deleteEditorSourceGraph(ModelEntity model) {
        if (WfUtils.isNotEmpty(model.getGraphId())) {
            this.processEngineConfiguration.getResourceEntityManager().delete(model.getGraphId());
        }
    }

    @Override
    public byte[] findEditorSourceByModelId(Long modelId) {
        byte[] source = new byte[]{};
        ModelEntity model = (ModelEntity)this.findById(modelId);
        if (model == null || model.getBPMNXMLID() == null) {
            return source;
        }
        return source;
    }

    @Override
    public byte[] findEditorSourceExtraByModelId(Long modelId) {
        byte[] source = new byte[]{};
        ModelEntity model = (ModelEntity)this.findById(modelId);
        if (model == null || model.getPNGID() == null) {
            return source;
        }
        return source;
    }

    @Override
    public List<ModelEntity> findModelEntitiesByIds(Collection<Long> modelIds, String fields) {
        EntityQueryBuilder queryBuilder = this.createQueryBuilder().addFilter("id", "in", modelIds);
        if (fields != null) {
            queryBuilder.setSelectFields(fields);
        }
        return this.findByQueryBuilder(queryBuilder, this.byIdMatcher, modelIds, true);
    }

    @Override
    public List<ModelEntity> findModelsByKey(String key) {
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter("key", key);
        return this.findByQueryBuilder(eb);
    }

    @Override
    public List<ModelEntity> findModelEntitysByQFilters(QFilter[] filters) {
        return this.findByQueryFilters(filters);
    }

    private void insertRelation(ModelEntity entity) {
        this.updateRelation(entity);
    }

    private void updateRelation(ModelEntity entity) {
        this.processEngineConfiguration.getAppModelRelationEntityManager().deleteByModelId(entity.getId());
        Set<String> appIds = this.getModelRelationAppIds(entity);
        for (String appId : appIds) {
            AppModelRelationEntityImpl relation = this.getAppModelRelationEntity(entity, appId);
            this.processEngineConfiguration.getAppModelRelationEntityManager().insert(relation);
        }
    }

    private void deleteRelation(ModelEntity model) {
        if (WfUtils.isNotEmpty(model.getId())) {
            this.processEngineConfiguration.getAppModelRelationEntityManager().deleteByModelId(model.getId());
        }
    }

    private String getAppIdByBillId(String billId) {
        DynamicObject dynamicObject = BizAppServiceHelp.getBizAppByFormID((String)billId);
        if (dynamicObject == null) {
            this.logger.warn("\u83b7\u53d6\u6d41\u7a0b\u6a21\u578b\u5355\u636e\u6240\u5c5e\u7684\u5e94\u7528\u5206\u7c7b\u9519\u8bef\u3002");
            return null;
        }
        String appId = (String)dynamicObject.get("id");
        return appId;
    }

    private AppModelRelationEntityImpl getAppModelRelationEntity(ModelEntity model, String appId) {
        AppModelRelationEntityImpl relation = new AppModelRelationEntityImpl();
        relation.setModelId(model.getId());
        relation.setAppId(appId);
        relation.setType("model");
        return relation;
    }

    private Set<String> getModelRelationAppIds(ModelEntity model) {
        HashSet<String> appIds = new HashSet<String>();
        try {
            List<UserTask> userTasks;
            Long resourceId = model.getBPMNXMLID();
            if (WfUtils.isEmpty(resourceId)) {
                return appIds;
            }
            ResourceEntity resourceEntity = (ResourceEntity)this.processEngineConfiguration.getResourceEntityManager().findById(resourceId);
            if (resourceEntity == null) {
                return appIds;
            }
            String modelJson = resourceEntity.getData();
            JsonNode jsonNode = new ObjectMapper().readTree(modelJson);
            BpmnModel bpmnModel = new BpmnJsonConverter().convertToBpmnModel(jsonNode);
            Process process = bpmnModel.getMainProcess();
            String appId = this.getAppIdByBillId(process.getEntraBillId());
            if (appId != null) {
                appIds.add(appId);
            }
            if ((userTasks = process.findFlowElementsOfType(UserTask.class)) == null || userTasks.size() == 0) {
                return appIds;
            }
            for (UserTask userTask : userTasks) {
                appId = this.getAppIdByBillId(userTask.getEntityId());
                if (appId == null) continue;
                appIds.add(appId);
            }
        }
        catch (Exception e) {
            this.logger.error("\u66f4\u65b0\u9636\u6bb5\u89e3\u6790\u5355\u636e\u5bf9\u5e94\u7684\u5e94\u7528Id\u51fa\u9519", (Throwable)e);
        }
        return appIds;
    }

    @Deprecated
    private void procateOperation(ModelEntity model) {
        String billId = model.getEntraBillId();
        if (!StringUtils.isBlank((CharSequence)billId)) {
            Long tempId;
            Long pAppId = null;
            Long pCloudId = null;
            DynamicObject dynamicObject = BizAppServiceHelp.getBizAppByFormID((String)billId);
            if (dynamicObject == null) {
                return;
            }
            String appId = (String)dynamicObject.get("id");
            Long appProcateId = this.processEngineConfiguration.getProcessCategoryEntityManager().getProcateIdByApplicationId(appId);
            Long l = tempId = appProcateId == null ? null : appProcateId;
            if (StringUtils.isNotBlank((Object)tempId)) {
                pAppId = tempId;
            } else {
                String cloudId = (String)dynamicObject.get("bizcloud.id");
                Long cloudProcateId = this.processEngineConfiguration.getProcessCategoryEntityManager().getProcateIdByApplicationId(cloudId);
                Long l2 = tempId = cloudProcateId == null ? null : cloudProcateId;
                if (StringUtils.isNotBlank((Object)tempId)) {
                    pCloudId = tempId;
                } else {
                    DynamicObject cloudInfo = (DynamicObject)dynamicObject.get("bizcloud");
                    pCloudId = this.insertProcessCategory(cloudInfo, false, null);
                }
                pAppId = this.insertProcessCategory(dynamicObject, true, pCloudId);
            }
            model.setCategory(pAppId);
        }
    }

    @Deprecated
    private Long insertProcessCategory(DynamicObject dynamicObject, boolean isLeaf, Long parentId) {
        ProcessCategoryEntityImpl procateEntity = new ProcessCategoryEntityImpl();
        procateEntity.setILocaleStringName(dynamicObject.getLocaleString("name"));
        if (isLeaf) {
            procateEntity.setDescription(dynamicObject.get("description").toString());
        } else {
            procateEntity.setDescription("");
        }
        procateEntity.setNumber((String)dynamicObject.get("number"));
        procateEntity.setApplicationId((String)dynamicObject.get("id"));
        procateEntity.setLeaf(isLeaf);
        procateEntity.setParentId(parentId);
        procateEntity.setCreatorId(Long.parseLong(RequestContext.get().getUserId()));
        procateEntity.setModifierId(Long.parseLong(RequestContext.get().getUserId()));
        this.processEngineConfiguration.getProcessCategoryEntityManager().insert(procateEntity);
        return procateEntity.getId();
    }

    @Override
    public DynamicObject[] getModelByIds(Long[] modelIds) {
        if (modelIds == null || modelIds.length == 0) {
            return new DynamicObject[0];
        }
        return BusinessDataServiceHelper.load((Object[])modelIds, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)this.getEntityName()));
    }

    @Override
    public DynamicObject[] getModelByProcessCategoryId(Long processCategoryId) {
        if (processCategoryId == null || processCategoryId == 0L) {
            return new DynamicObject[0];
        }
        QFilter filter = null;
        ProcessCategoryEntityManager processCategoryEntityManager = this.processEngineConfiguration.getProcessCategoryEntityManager();
        Long rootId = processCategoryEntityManager.getRootEntity().getId();
        if (processCategoryId.equals(rootId)) {
            filter = new QFilter("categoryid", "not in", (Object)new Long[]{processCategoryId});
        } else {
            List<ProcessCategoryEntity> processCategoryEntities = this.processEngineConfiguration.getRepositoryService().getProcateByParentId(processCategoryId);
            if (processCategoryEntities != null && processCategoryEntities.size() > 0) {
                Long[] ids = new Long[processCategoryEntities.size() + 1];
                int i = 0;
                for (ProcessCategoryEntity processCategoryEntity : processCategoryEntities) {
                    ids[i] = processCategoryEntity.getId();
                    ++i;
                }
                ids[i] = processCategoryId;
                filter = new QFilter("categoryid", "in", (Object)ids);
            } else {
                filter = new QFilter("categoryid", "=", (Object)processCategoryId);
            }
        }
        return BusinessDataServiceHelper.load((String)this.getEntityName(), (String)this.getSelectFields(), (QFilter[])new QFilter[]{filter});
    }
}

