/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.persistence.entity.design;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.devportal.BizCloudServiceHelp;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.db.EntityQueryBuilder;
import kd.bos.workflow.engine.impl.persistence.CachedEntityMatcher;
import kd.bos.workflow.engine.impl.persistence.entity.AbstractEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.cachematcher.ProcessCategoryByAppIdMatcher;
import kd.bos.workflow.engine.impl.persistence.entity.design.ProcessCategoryEntity;
import kd.bos.workflow.engine.impl.persistence.entity.design.ProcessCategoryEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.design.ProcessCategoryEntityManager;

public class ProcessCategoryEntityManagerImpl
extends AbstractEntityManager<ProcessCategoryEntity>
implements ProcessCategoryEntityManager {
    private Log logger = LogFactory.getLog(ProcessCategoryEntityManagerImpl.class);
    private CachedEntityMatcher<ProcessCategoryEntity> byAppIdMatcher = new ProcessCategoryByAppIdMatcher();

    public ProcessCategoryEntityManagerImpl(ProcessEngineConfigurationImpl processEngineConfiguration) {
        super(processEngineConfiguration);
    }

    @Override
    public Class<? extends ProcessCategoryEntity> getManagedEntityClass() {
        return ProcessCategoryEntityImpl.class;
    }

    @Override
    public void insert(ProcessCategoryEntity entity) {
        if (entity.isLeaf().booleanValue()) {
            String appId = entity.getApplicationId();
            if (WfUtils.isNotEmpty(appId)) {
                try {
                    DynamicObject dynamicObject = BizCloudServiceHelp.getBizCloudByAppID((String)appId);
                    String cloudId = (String)dynamicObject.getPkValue();
                    Long cloudProcateId = this.getProcateIdByApplicationId(cloudId);
                    if (StringUtils.isNotBlank((Object)cloudProcateId)) {
                        entity.setParentId(cloudProcateId);
                    } else {
                        ProcessCategoryEntity parentProcessCategory = this.getCloudProcessCategory(dynamicObject);
                        parentProcessCategory.setProcessType(entity.getProcessType());
                        super.insert(parentProcessCategory);
                        entity.setParentId(parentProcessCategory.getId());
                    }
                }
                catch (Exception e) {
                    this.logger.error(String.format("appId[%s] is not exist, %s", appId, WfUtils.getExceptionStacktrace(e)));
                    entity.setParentId(this.getRootId());
                }
            }
            super.insert(entity);
        } else {
            entity.setParentId(this.getRootId());
            super.insert(entity);
        }
    }

    @Override
    public String getSelectFields() {
        return "id,number,isLeaf,parentId, applicationid, creatorid,createDate,modifierid,modifyDate,name,description,processtype";
    }

    @Override
    public Long getProcateIdByApplicationId(String applicationId) {
        ProcessCategoryEntity category = this.getProcessCategoryByApplicationId(applicationId);
        if (category != null) {
            return category.getId();
        }
        return null;
    }

    @Override
    public ProcessCategoryEntity getProcessCategoryByApplicationId(String applicationId) {
        EntityQueryBuilder queryBuilder = new EntityQueryBuilder(this.getEntityName(), this.getSelectFields());
        queryBuilder.addFilter("applicationid", applicationId);
        List<ProcessCategoryEntity> categories = this.getList(queryBuilder, this.byAppIdMatcher, applicationId, true);
        if (categories != null && !categories.isEmpty()) {
            return categories.get(0);
        }
        return null;
    }

    @Override
    public String getEntityName() {
        return "wf_processcagetory";
    }

    @Override
    public ProcessCategoryEntity getRootEntity() {
        EntityQueryBuilder qb = this.createQueryBuilder().addFilter("applicationid", "0").addFilter("isleaf", Boolean.FALSE).addFilter("parentid", 0);
        List processCategoryEntities = this.findByQueryBuilder(qb);
        if (processCategoryEntities == null || processCategoryEntities.size() <= 0) {
            this.logger.warn("\u6839\u8bb0\u5f55\u4e3a\u7a7a");
            return null;
        }
        return (ProcessCategoryEntity)processCategoryEntities.get(0);
    }

    @Override
    public DynamicObject[] getAllProcessCategory() {
        String properties = "id,number,isLeaf,parentId,name,description";
        QFilter filter = new QFilter("id", "not in", (Object)new Long[]{0L});
        return BusinessDataServiceHelper.load((String)this.getEntityName(), (String)properties, (QFilter[])new QFilter[]{filter});
    }

    private ProcessCategoryEntity getCloudProcessCategory(DynamicObject dynamicObject) {
        ProcessCategoryEntityImpl procateEntity = new ProcessCategoryEntityImpl();
        procateEntity.setILocaleStringName(dynamicObject.getLocaleString("name"));
        procateEntity.setDescription("");
        procateEntity.setNumber((String)dynamicObject.get("number"));
        procateEntity.setApplicationId((String)dynamicObject.get("id"));
        procateEntity.setLeaf(Boolean.FALSE);
        procateEntity.setParentId(this.getRootId());
        return procateEntity;
    }

    private Long getRootId() {
        return this.getRootEntity().getId();
    }

    @Override
    public List<ProcessCategoryEntity> getAllProcessCategoryEntity() {
        EntityQueryBuilder qb = this.createQueryBuilder().addFilter("number", "is not null", null);
        return this.findByQueryBuilder(qb);
    }

    @Override
    public Long getOrCreateCategory(String cloudId, String appId, String processType) {
        if (WfUtils.isEmpty(cloudId) && WfUtils.isEmpty(appId)) {
            this.logger.warn("cloudId is null. appId is null.");
            return null;
        }
        String key = cloudId;
        DynamicObject appOrCloud = null;
        if (WfUtils.isNotEmpty(appId)) {
            if (WfUtils.isEmpty(cloudId)) {
                appOrCloud = BizAppServiceHelp.getBizAppByID((String)appId);
                DynamicObject cloud = appOrCloud.getDynamicObject("bizcloud");
                cloudId = String.valueOf(cloud.getPkValue());
            }
            key = String.format("%s_%s", cloudId, appId);
        }
        try (DLock lock = DLock.create((String)String.format("wf/createProcessCategory/%s", key), (String)String.format("getOrCreateCategory:%s", key)).fastMode();){
            boolean canLock = lock.tryLock(60000L);
            if (canLock) {
                ArrayList<String> applicationIds = new ArrayList<String>();
                if (WfUtils.isNotEmpty(cloudId)) {
                    applicationIds.add(cloudId);
                }
                if (WfUtils.isNotEmpty(appId)) {
                    applicationIds.add(appId);
                }
                QFilter[] filters = new QFilter[]{new QFilter("applicationid", "in", (Object)applicationIds.toArray())};
                String fields = String.format("%s,%s", "id", "applicationid");
                List<ProcessCategoryEntity> categories = this.findByQueryFilters(filters, fields, null);
                if (WfUtils.isNotEmpty(appId)) {
                    Long l = this.getOrCreateProcessCategoryId(categories, appId, processType, appOrCloud, true);
                    return l;
                }
                if (WfUtils.isNotEmpty(cloudId)) {
                    Long l = this.getOrCreateProcessCategoryId(categories, cloudId, processType, appOrCloud, false);
                    return l;
                }
                Long l = 10000L;
                return l;
            }
        }
        return 10000L;
    }

    private Long getOrCreateProcessCategoryId(List<ProcessCategoryEntity> categories, String applicationId, String processType, DynamicObject appOrCloud, boolean isApp) {
        Long categoryId = null;
        for (ProcessCategoryEntity category : categories) {
            if (!applicationId.equals(category.getApplicationId())) continue;
            categoryId = category.getId();
            break;
        }
        if (categoryId == null) {
            if (appOrCloud == null) {
                appOrCloud = isApp ? BizAppServiceHelp.getBizAppByID((String)applicationId) : BizCloudServiceHelp.getBizCloudByID((String)applicationId);
            }
            String number = appOrCloud.getString("number");
            ILocaleString name = appOrCloud.getLocaleString("name");
            String description = appOrCloud.getString("description");
            ProcessCategoryEntity category = this.createProcessCategory(number, name, description, applicationId, processType, isApp);
            categoryId = category.getId();
            this.logger.info(String.format("createCategory: applicationId:%s processType:%s isApp:%s", applicationId, processType, isApp));
        }
        return categoryId;
    }

    private ProcessCategoryEntity createProcessCategory(String number, ILocaleString name, String description, String applicationId, String processType, boolean isApp) {
        ProcessCategoryEntity procateEntity = (ProcessCategoryEntity)this.create();
        procateEntity.setNumber(number);
        procateEntity.setILocaleStringName(name);
        procateEntity.setDescription(description);
        procateEntity.setApplicationId(applicationId);
        procateEntity.setLeaf(isApp);
        procateEntity.setProcessType(processType);
        if (!isApp) {
            procateEntity.setParentId(10000L);
        }
        this.insert(procateEntity);
        return procateEntity;
    }
}

