/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.persistence.entity.design;

import java.util.Collection;
import java.util.List;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.db.EntityQueryBuilder;
import kd.bos.workflow.engine.impl.persistence.CachedEntityMatcher;
import kd.bos.workflow.engine.impl.persistence.entity.AbstractEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.cachematcher.ResourceByDeploymentIdMatcher;
import kd.bos.workflow.engine.impl.persistence.entity.cachematcher.ResourceEntityByIdMatcher;
import kd.bos.workflow.engine.impl.persistence.entity.design.ResourceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.design.ResourceEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.design.ResourceEntityManager;

public class ResourceEntityManagerImpl
extends AbstractEntityManager<ResourceEntity>
implements ResourceEntityManager {
    private CachedEntityMatcher<ResourceEntity> resourceByIdMatcher = new ResourceEntityByIdMatcher();
    protected CachedEntityMatcher<ResourceEntity> resourceByDeployIdMatcher = new ResourceByDeploymentIdMatcher();

    public ResourceEntityManagerImpl(ProcessEngineConfigurationImpl processEngineConfiguration) {
        super(processEngineConfiguration);
    }

    @Override
    public void deleteResourcesByDeploymentId(Long deploymentId) {
        String sql = "delete from T_WF_GEBYTEARRAY where FDEPLOYMENTID = ?";
        DB.execute((DBRoute)DBRoute.workflow, (String)sql, (Object[])new Object[]{deploymentId});
    }

    @Override
    public ResourceEntity findResourceByDeploymentIdAndResourceName(Long deploymentId, Long resourceName) {
        QFilter deployIdFilter = new QFilter("deploymentId", "=", (Object)deploymentId);
        QFilter rsNameFilter = new QFilter("name", "=", (Object)resourceName);
        List ret = this.findByQueryFilters(new QFilter[]{deployIdFilter, rsNameFilter}, this.getSelectFields(), null);
        if (ret != null && ret.size() > 0) {
            return (ResourceEntity)ret.get(0);
        }
        return null;
    }

    @Override
    public List<ResourceEntity> findResourcesByDeploymentId(Long deploymentId) {
        EntityQueryBuilder queryBuilder = this.createQueryBuilder();
        queryBuilder.addFilter("deploymentId", deploymentId).orderBy("name asc");
        return this.findByQueryBuilder(queryBuilder, this.resourceByDeployIdMatcher, deploymentId, true);
    }

    @Override
    public List<ResourceEntity> findResourcesByIds(Collection<Long> resourceIds) {
        EntityQueryBuilder queryBuilder = this.createQueryBuilder().addFilter("id", "in", resourceIds);
        return this.findByQueryBuilder(queryBuilder, this.resourceByIdMatcher, resourceIds, true);
    }

    @Override
    public ResourceEntity findByModelIdAndType(Long modelId, String type) {
        String field = "FBPMNXMLID";
        switch (type) {
            case "graph_json": {
                field = "FBPMNXMLID";
                break;
            }
            case "graph_xml": {
                field = "FGRAPHID";
                break;
            }
            case "svg_xml": {
                field = "FPNGID";
                break;
            }
        }
        String sql = String.format("SELECT R.FID,R.FNAME,R.FDEPLOYMENTID,R.FGENERATED,R.FCURRENTLANGUAGE,R.FCONTENT,RL.FCONTENT FROM T_WF_MODEL M LEFT JOIN T_WF_GEBYTEARRAY R ON M.%s = R.FID LEFT JOIN T_WF_GEBYTEARRAY_L RL ON R.FID = RL.FID WHERE M.FID = ? ", field);
        List entity = this.findEntityBySQLFilter(sql, new Object[]{modelId});
        if (entity != null && entity.size() > 0) {
            return (ResourceEntity)entity.get(0);
        }
        return null;
    }

    @Override
    public Class<? extends ResourceEntity> getManagedEntityClass() {
        return ResourceEntityImpl.class;
    }

    @Override
    public String getSelectFields() {
        return "id,name,content,deploymentId,generated,currentlanguage,data";
    }
}

