/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.persistence.entity.detaillog;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.engine.EntityNumberConstant;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.identity.UserInfo;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.cmd.task.processassistant.ProcessAssistantUtil;
import kd.bos.workflow.engine.impl.db.EntityQueryBuilder;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.CachedEntityMatcher;
import kd.bos.workflow.engine.impl.persistence.entity.AbstractEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.cachematcher.DetailLogsByTaskIdMatcher;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelType;
import kd.bos.workflow.engine.impl.persistence.entity.detaillog.DetailLogEntity;
import kd.bos.workflow.engine.impl.persistence.entity.detaillog.DetailLogEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.detaillog.DetailLogEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcessInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricTaskInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.CommentEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskHandleLogEntity;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;

public class DetailLogEntityManagerImpl
extends AbstractEntityManager<DetailLogEntity>
implements DetailLogEntityManager {
    private static Log log = LogFactory.getLog(DetailLogEntityManagerImpl.class);
    protected CachedEntityMatcher<DetailLogEntity> detailLogsByTaskIdMatcher = new DetailLogsByTaskIdMatcher();

    public DetailLogEntityManagerImpl(ProcessEngineConfigurationImpl processEngineConfiguration) {
        super(processEngineConfiguration);
    }

    @Override
    public String getEntityName() {
        return "wf_detaillog";
    }

    @Override
    public Class<? extends DetailLogEntity> getManagedEntityClass() {
        return DetailLogEntityImpl.class;
    }

    @Override
    public String getSelectFields() {
        return String.format("%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s", "taskid", "businesskey", "entitynumber", "nodebusinesskey", "nodeentitynumber", "entityname", "procdefid", "procinstid", "subprocessinstanceid", "billno", "activityid", "activityname", "subactivityname", "rejectactivityid", "rejectactivityname", "category", "currentsubject", "startid", "startname", "startavatar", "ownerid", "owner", "owneravatar", "assigneeid", "assignee", "assigneeavatar", "decisiontype", "executiontype", "resultnumber", "resultname", "handlestate", "opinion", "groupid", "terminalway", "type", "createDate", "modifyDate", "errormessage");
    }

    @Override
    public List<DetailLogEntity> findDetailLogsByTaskId(Long taskId) {
        QFilter q1 = new QFilter("taskid", "=", (Object)taskId);
        QFilter q2 = new QFilter("type", "=", (Object)"comment");
        EntityQueryBuilder eb = this.createQueryBuilder().addFilters(new QFilter[]{q1, q2});
        HashMap<String, Object> parameters = new HashMap<String, Object>(2);
        parameters.put("taskid", taskId);
        parameters.put("type", "comment");
        return this.getList(eb, this.detailLogsByTaskIdMatcher, parameters, true);
    }

    @Override
    public DynamicObjectCollection getDetailLogList(String filterSql, List<Object> paramsList, String orderBy) {
        String lang = RequestContext.get().getLang().toString();
        String masterTableAlias = "a";
        String multiLangTableAlias = "b";
        String entityNameSQL = WfMultiLangUtils.getGeneralLangSQL("wf_detaillog", masterTableAlias, multiLangTableAlias, "fentityname", "entityName", "entityname");
        String activityNameSQL = WfMultiLangUtils.getGeneralLangSQL("wf_detaillog", masterTableAlias, multiLangTableAlias, "factivityname", "activityName", "activityname");
        String subActivityNameSQL = WfMultiLangUtils.getGeneralLangSQL("wf_detaillog", masterTableAlias, multiLangTableAlias, "fsubactivityname", "subActivityName", "subactivityname");
        String currentSubjectSQL = WfMultiLangUtils.getGeneralLangSQL("wf_detaillog", masterTableAlias, multiLangTableAlias, "fcurrentsubject", "currentSubject", "currentsubject");
        String startNameSQL = WfMultiLangUtils.getGeneralLangSQL("wf_detaillog", masterTableAlias, multiLangTableAlias, "fstartname", "startName", "startname");
        String ownerSQL = WfMultiLangUtils.getGeneralLangSQL("wf_detaillog", masterTableAlias, multiLangTableAlias, "fowner", "owner", "owner");
        String assigneeSQL = WfMultiLangUtils.getGeneralLangSQL("wf_detaillog", masterTableAlias, multiLangTableAlias, "fassignee", "assignee", "assignee");
        String resultNameSQL = WfMultiLangUtils.getGeneralLangSQL("wf_detaillog", masterTableAlias, multiLangTableAlias, "fresultname", "resultName", "resultname");
        String opinionSQL = WfMultiLangUtils.getGeneralLangSQL("wf_detaillog", masterTableAlias, multiLangTableAlias, "fopinion", "opinion", "opinion");
        StringBuilder sql = new StringBuilder();
        sql.append("select a.fid id").append(", ");
        sql.append("a.ftaskid taskId").append(", ");
        sql.append("a.fbusinesskey businessKey").append(", ");
        sql.append("a.fentitynumber entityNumber").append(", ");
        sql.append("a.fnodebusinesskey nodeBusinessKey").append(", ");
        sql.append("a.fnodeentitynumber nodeEntityNumber").append(", ");
        sql.append("a.fprocdefid procdefId").append(", ");
        sql.append("a.fprocinstid procinstId").append(", ");
        sql.append("a.fbillno billNo").append(", ");
        sql.append("a.factivityid activityId").append(", ");
        sql.append("a.frejectactivityid rejectActivityId").append(", ");
        sql.append("a.frejectactivityname rejectActivityName").append(", ");
        sql.append("a.fcategory category").append(", ");
        sql.append("a.fstartid startId").append(", ");
        sql.append("a.fstartavatar startAvatar").append(", ");
        sql.append("a.fownerid ownerId").append(", ");
        sql.append("a.fowneravatar ownerAvatar").append(", ");
        sql.append("a.fassigneeid assigneeId").append(", ");
        sql.append("a.fassigneeavatar assigneeAvatar").append(", ");
        sql.append("a.fdecisiontype decisionType").append(", ");
        sql.append("a.fexecutiontype executionType").append(", ");
        sql.append("a.fresultnumber resultNumber").append(", ");
        sql.append("a.fhandlestate handleState").append(", ");
        sql.append("a.fgroupid groupId").append(", ");
        sql.append("a.fterminalway terminalWay").append(", ");
        sql.append("a.ftype type").append(", ");
        sql.append("a.fcreatedate createDate").append(", ");
        sql.append("a.fmodifydate modifyDate").append(", ");
        sql.append("a.ferrormessage errorMessage").append(", ");
        sql.append("a.fmessageid messageId").append(", ");
        sql.append("a.fchannel channel").append(", ");
        sql.append(entityNameSQL).append(", ");
        sql.append(activityNameSQL).append(", ");
        sql.append(subActivityNameSQL).append(", ");
        sql.append(currentSubjectSQL).append(", ");
        sql.append(startNameSQL).append(", ");
        sql.append(ownerSQL).append(", ");
        sql.append(assigneeSQL).append(", ");
        sql.append(resultNameSQL).append(", ");
        sql.append(opinionSQL).append(", ");
        sql.append("' ' processName").append(" ");
        sql.append("from t_wf_detaillog a left join t_wf_detaillog_l b on a.fid = b.fid ");
        sql.append("where b.flocaleid = ? ");
        if (!WfUtils.isEmpty(filterSql)) {
            sql.append(filterSql).append(" ");
        }
        if (WfUtils.isNotEmpty(orderBy)) {
            sql.append("order by ").append(orderBy).append(";");
        }
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(lang);
        params.addAll(paramsList);
        try (DataSet ds = DB.queryDataSet((String)"DetailLogEntityManagerImpl.getDetailLogList", (DBRoute)WfUtils.WFS, (String)sql.toString(), (Object[])params.toArray());){
            DynamicObjectCollection results = ORM.create().toPlainDynamicObjectCollection(ds);
            if (null == results || results.getDynamicObjectType() == null || 0 == results.size()) {
                DynamicObjectType dt = new DynamicObjectType();
                DynamicObjectCollection dynamicObjectCollection = new DynamicObjectCollection(dt, new Object());
                return dynamicObjectCollection;
            }
            HashSet<Long> procdefIds = new HashSet<Long>(results.size());
            for (DynamicObject obj : results) {
                procdefIds.add(obj.getLong("procdefId"));
            }
            Map<Long, String> procdefMap = ProcessAssistantUtil.getProcdefNameByProcdefId(procdefIds);
            if (WfUtils.isNotEmptyForMap(procdefMap)) {
                for (DynamicObject obj : results) {
                    obj.set("processName", (Object)procdefMap.get(obj.getLong("procdefId")));
                }
            }
            DynamicObjectCollection dynamicObjectCollection = results;
            return dynamicObjectCollection;
        }
    }

    @Override
    public void recordDetailLogFromComment(CommandContext commandContext, CommentEntity comment) {
        UserInfo userInfo;
        if (null == comment) {
            return;
        }
        Long taskId = comment.getTaskId();
        if (WfUtils.isEmpty(taskId)) {
            return;
        }
        TaskEntity task = (TaskEntity)commandContext.getTaskEntityManager().findById(comment.getTaskId());
        if (task == null) {
            return;
        }
        String processType = task.getProcessType();
        if (!ModelType.NoCodeFlow.name().equalsIgnoreCase(processType)) {
            return;
        }
        DetailLogEntityImpl detailLog = new DetailLogEntityImpl();
        detailLog.setTaskId(comment.getTaskId());
        detailLog.setBusinessKey(comment.getBusinessKey());
        detailLog.setEntityNumber(comment.getEntityNumber());
        detailLog.setEntityName(comment.getEntityName());
        this.recordNodeBusinessKey(commandContext, comment, detailLog);
        detailLog.setProcDefId(task.getProcessDefinitionId());
        detailLog.setProcInstId(comment.getProcessInstanceId());
        detailLog.setBillNo(comment.getBillNo());
        detailLog.setActivityId(comment.getActivityId());
        detailLog.setActivityName((ILocaleString)new LocaleString(comment.getActivityName()));
        detailLog.setSubActivityName((ILocaleString)new LocaleString(comment.getSubactivityname()));
        detailLog.setCategory(comment.getCategory());
        detailLog.setCurrentSubject(comment.getCurrentSubject());
        HashSet<Long> userIds = new HashSet<Long>(2);
        userIds.add(comment.getStarterId());
        userIds.add(comment.getUserId());
        Map<Object, Object> userInfoMap = new HashMap(userIds.size());
        if (!userIds.isEmpty()) {
            userInfoMap = ProcessAssistantUtil.queryUserInfos(userIds);
        }
        detailLog.setStartId(comment.getStarterId());
        if (WfUtils.isNotEmpty(comment.getStarterId())) {
            userInfo = (UserInfo)userInfoMap.get(comment.getStarterId().toString());
            detailLog.setStartName((ILocaleString)(userInfo != null ? userInfo.getName() : new LocaleString()));
            detailLog.setStartAvatar(userInfo != null ? userInfo.getImgUrl() : "");
        }
        detailLog.setAssigneeId(comment.getUserId());
        if (WfUtils.isNotEmpty(comment.getUserId())) {
            userInfo = (UserInfo)userInfoMap.get(comment.getUserId().toString());
            detailLog.setAssignee((ILocaleString)(userInfo != null ? userInfo.getName() : new LocaleString()));
            detailLog.setAssigneeAvatar(userInfo != null ? userInfo.getImgUrl() : "");
        }
        detailLog.setDecisionType(comment.getDecisionType());
        detailLog.setExecutionType(comment.getExecutionType());
        detailLog.setResultNumber(comment.getResultNumber());
        detailLog.setResultName(comment.getCommentResult());
        detailLog.setHandleState(comment.getHandleState());
        detailLog.setOpinion(comment.getCommentMessage());
        detailLog.setGroupId(comment.getGroupId());
        String terminalWay = comment.getTerminalWay();
        if (WfUtils.isEmpty(terminalWay)) {
            terminalWay = RequestContext.get().getClient();
        }
        detailLog.setTerminalWay(terminalWay);
        DetailLogEntityManagerImpl.buildCommentType(comment, detailLog);
        detailLog.setCreateDate(comment.getTime());
        DetailLogEntityManagerImpl.recordRejectActivityId(task, detailLog);
        task.removeTransientVariable("rejectActivityId");
        task.removeTransientVariable("rejectActivityName");
        this.recordOperationType(detailLog);
        commandContext.getDetailLogEntityManager().insert(detailLog);
    }

    private void recordNodeBusinessKey(CommandContext commandContext, CommentEntity comment, DetailLogEntity detailLog) {
        if (!"UserTask".equalsIgnoreCase(comment.getCategory())) {
            return;
        }
        detailLog.setNodeBusinessKey(comment.getBusinessKey());
        detailLog.setNodeEntityNumber(comment.getEntityNumber());
        if (WfUtils.isEmpty(comment.getProcessInstanceId())) {
            return;
        }
        HistoricProcessInstanceEntity obj = (HistoricProcessInstanceEntity)commandContext.getHistoricProcessInstanceEntityManager().findById(comment.getProcessInstanceId());
        if (obj == null) {
            return;
        }
        detailLog.setBusinessKey(obj.getBusinessKey());
        detailLog.setEntityNumber(obj.getEntitynumber());
    }

    private void recordOperationType(DetailLogEntity detailLog) {
        if (WfUtils.isEmpty(detailLog.getProcInstId())) {
            return;
        }
        QFilter q1 = new QFilter("processInstanceId", "=", (Object)detailLog.getProcInstId());
        QFilter q2 = new QFilter("name", "=", (Object)"_operation_");
        try {
            DynamicObject obj = BusinessDataServiceHelper.loadSingle((String)EntityNumberConstant.getHiVariableInstEntityNumber(), (String)"textValue", (QFilter[])new QFilter[]{q1, q2});
            if (WfUtils.isEmptyString(obj)) {
                return;
            }
            detailLog.setChannel(obj.getString("textValue"));
        }
        catch (Exception e) {
            this.logger.warn("recordOperationType is error:" + WfUtils.getExceptionStacktrace(e));
        }
    }

    @Override
    public void recordDetailLogFromTaskHandleLog(CommandContext commandContext, TaskHandleLogEntity taskHandleLog) {
        UserInfo userInfo;
        if (null == taskHandleLog) {
            return;
        }
        Long taskId = taskHandleLog.getTaskId();
        Long procInstId = taskHandleLog.getProcessInstanceId();
        if (WfUtils.isEmpty(procInstId) && WfUtils.isEmpty(taskId)) {
            return;
        }
        DetailLogEntityImpl detailLog = new DetailLogEntityImpl();
        detailLog.setTaskId(taskId);
        detailLog.setProcInstId(procInstId);
        String processType = DetailLogEntityManagerImpl.buildTaskInfoAndReturnProcessType(commandContext, detailLog);
        if (!ModelType.NoCodeFlow.name().equalsIgnoreCase(processType)) {
            return;
        }
        detailLog.setBusinessKey(taskHandleLog.getBusinessKey());
        detailLog.setBillNo(taskHandleLog.getBillNo());
        detailLog.setActivityId(taskHandleLog.getActivityId());
        detailLog.setActivityName(taskHandleLog.getActivityName());
        detailLog.setCurrentSubject(taskHandleLog.getCurrentSubject());
        HashSet<Long> userIds = new HashSet<Long>(2);
        userIds.add(taskHandleLog.getOwnerId());
        userIds.add(taskHandleLog.getAssigneeid());
        Map<Object, Object> userInfoMap = new HashMap(userIds.size());
        if (!userIds.isEmpty()) {
            userInfoMap = ProcessAssistantUtil.queryUserInfos(userIds);
        }
        detailLog.setOwnerId(taskHandleLog.getOwnerId());
        if (WfUtils.isNotEmpty(taskHandleLog.getOwnerId())) {
            userInfo = (UserInfo)userInfoMap.get(taskHandleLog.getOwnerId().toString());
            detailLog.setOwner((ILocaleString)(userInfo != null ? userInfo.getName() : new LocaleString()));
            detailLog.setOwnerAvatar(userInfo != null ? userInfo.getImgUrl() : "");
        }
        detailLog.setAssigneeId(taskHandleLog.getAssigneeid());
        if (WfUtils.isNotEmpty(taskHandleLog.getAssigneeid())) {
            userInfo = (UserInfo)userInfoMap.get(taskHandleLog.getAssigneeid().toString());
            detailLog.setAssignee((ILocaleString)(userInfo != null ? userInfo.getName() : new LocaleString()));
            detailLog.setAssigneeAvatar(userInfo != null ? userInfo.getImgUrl() : "");
        }
        detailLog.setType(taskHandleLog.getType());
        detailLog.setOpinion(taskHandleLog.getOpinion());
        String terminalWay = taskHandleLog.getTerminalWay();
        if (WfUtils.isEmpty(terminalWay)) {
            terminalWay = RequestContext.get().getClient();
        }
        detailLog.setTerminalWay(terminalWay);
        detailLog.setCreateDate(taskHandleLog.getCreateDate());
        commandContext.getDetailLogEntityManager().insert(detailLog);
    }

    @Override
    public void recordDetailLog(CommandContext commandContext, DetailLogEntity detailLog) {
        String fields;
        QFilter[] filters;
        List entities;
        if (null == detailLog) {
            return;
        }
        String processType = DetailLogEntityManagerImpl.buildTaskInfoAndReturnProcessType(commandContext, detailLog);
        if (!ModelType.NoCodeFlow.name().equalsIgnoreCase(processType)) {
            return;
        }
        if (WfUtils.isEmpty(detailLog.getTerminalWay())) {
            detailLog.setTerminalWay(RequestContext.get().getClient());
        }
        if (detailLog.getProcInstId() != null && detailLog.getActivityId() != null && !(entities = this.findByQueryFilters(filters = new QFilter[]{new QFilter("procinstid", "=", (Object)detailLog.getProcInstId()), new QFilter("activityid", "=", (Object)detailLog.getActivityId())}, fields = String.format("%s,%s,%s,%s", "id", "startid", "startname", "startavatar"), null)).isEmpty()) {
            this.logger.debug(String.format("already exists. ProcInstId: %s, ActivityId: %s, BusinessKey: %s ", detailLog.getProcInstId(), detailLog.getActivityId(), detailLog.getBusinessKey()));
            this.updateDetailLogEntity(detailLog, (DetailLogEntity)entities.get(0));
            return;
        }
        commandContext.getDetailLogEntityManager().insert(detailLog);
    }

    private void updateDetailLogEntity(DetailLogEntity detailLog, DetailLogEntity entity) {
        if (WfUtils.isNotEmpty(detailLog.getStartName())) {
            entity.setStartName(detailLog.getStartName());
        }
        if (WfUtils.isNotEmpty(detailLog.geStartId())) {
            entity.setStartId(detailLog.geStartId());
        }
        if (WfUtils.isNotEmpty(detailLog.getStartAvatar())) {
            entity.setStartAvatar(detailLog.getStartAvatar());
        }
        this.update(entity);
    }

    @Override
    public void updateErrorMessage(CommandContext commandContext, Long processInstanceId, String activityId, String errorMessage) {
        if (WfUtils.isEmpty(errorMessage)) {
            return;
        }
        QFilter q1 = new QFilter("procinstid", "=", (Object)processInstanceId);
        QFilter q2 = new QFilter("activityid", "=", (Object)activityId);
        QFilter[] filters = new QFilter[]{q1, q2};
        try {
            DynamicObject[] objs = BusinessDataServiceHelper.load((String)"wf_detaillog", (String)"id,errormessage", (QFilter[])filters);
            if (objs == null || objs.length == 0) {
                DetailLogEntityImpl detailLog = new DetailLogEntityImpl();
                detailLog.setProcInstId(processInstanceId);
                detailLog.setActivityId(activityId);
                detailLog.setErrorMessage(WfUtils.subStringForMax(errorMessage, 490));
                this.recordDetailLog(commandContext, detailLog);
            } else {
                objs[0].set("errormessage", (Object)WfUtils.subStringForMax(errorMessage, 490));
                SaveServiceHelper.save((DynamicObject[])objs);
            }
        }
        catch (Exception e) {
            log.error("updateErrorMessage is error : " + WfUtils.getExceptionStacktrace(e));
        }
    }

    private static void buildCommentType(CommentEntity comment, DetailLogEntity detailLog) {
        String type = comment.getType();
        if ("comment".equals(type)) {
            detailLog.setType("comment");
            detailLog.setAssignee(comment.getTaskAssignee());
        } else if ("coordinate".equals(type)) {
            detailLog.setType("coordinateReply");
            detailLog.setAssigneeId(comment.getOwnerId());
            detailLog.setAssignee(WfUtils.findUserName(comment.getOwnerId()));
        } else if ("suggestion".equals(type)) {
            detailLog.setType("addComment");
        } else if ("converted".equals(type)) {
            detailLog.setType("converted");
        }
    }

    private static String buildTaskInfoAndReturnProcessType(CommandContext commandContext, DetailLogEntity detailLog) {
        String processType = "";
        if (WfUtils.isNotEmpty(detailLog.getTaskId())) {
            Long taskId = detailLog.getTaskId();
            TaskEntity task = (TaskEntity)commandContext.getTaskEntityManager().findById(taskId);
            if (null != task) {
                processType = task.getProcessType();
                if (ModelType.NoCodeFlow.name().equalsIgnoreCase(processType)) {
                    detailLog.setEntityNumber(task.getEntityNumber());
                    detailLog.setEntityName(task.getEntityName());
                    detailLog.setProcDefId(task.getProcessDefinitionId());
                    detailLog.setProcInstId(task.getProcessInstanceId());
                    detailLog.setCategory(task.getCategory());
                    detailLog.setActivityId(task.getTaskDefinitionKey());
                    detailLog.setActivityName(task.getName());
                    detailLog.setBusinessKey(task.getBusinessKey());
                    detailLog.setBillNo(task.getBillNo());
                }
            } else {
                HistoricTaskInstanceEntity hiTask = (HistoricTaskInstanceEntity)commandContext.getHistoricTaskInstanceEntityManager().findById(taskId);
                if (null == hiTask) {
                    return processType;
                }
                processType = hiTask.getProcessType();
                if (ModelType.NoCodeFlow.name().equalsIgnoreCase(processType)) {
                    detailLog.setEntityNumber(hiTask.getEntityNumber());
                    detailLog.setEntityName(hiTask.getEntityName());
                    detailLog.setProcDefId(hiTask.getProcessDefinitionId());
                    detailLog.setProcInstId(hiTask.getProcessInstanceId());
                    detailLog.setCategory(hiTask.getCategory());
                    detailLog.setActivityId(hiTask.getTaskDefinitionKey());
                    detailLog.setActivityName(hiTask.getName());
                    detailLog.setBusinessKey(hiTask.getBusinessKey());
                    detailLog.setBillNo(hiTask.getBillNo());
                }
            }
        } else {
            HistoricProcessInstanceEntity obj = (HistoricProcessInstanceEntity)commandContext.getHistoricProcessInstanceEntityManager().findById(detailLog.getProcInstId());
            if (null == obj) {
                return processType;
            }
            processType = obj.getProcessType();
            if (ModelType.NoCodeFlow.name().equalsIgnoreCase(processType)) {
                detailLog.setEntityNumber(obj.getEntitynumber());
                detailLog.setEntityName(obj.getEntraBillName());
                detailLog.setProcDefId(obj.getProcessDefinitionId());
                detailLog.setBusinessKey(obj.getBusinessKey());
                detailLog.setBillNo(obj.getBillNo());
                if (WfUtils.isNotEmpty(detailLog.getActivityId())) {
                    FlowElement flowElement = ProcessDefinitionUtil.getBpmnModel(obj.getProcessDefinitionId(), detailLog.getProcInstId()).getFlowElement(detailLog.getActivityId());
                    detailLog.setActivityName((ILocaleString)new LocaleString(flowElement.getName()));
                    detailLog.setCategory(flowElement.getType());
                }
            }
        }
        return processType;
    }

    private static void recordRejectActivityId(TaskEntity task, DetailLogEntity detailLog) {
        Object rejectActivityName;
        if (!"reject".equalsIgnoreCase(detailLog.getDecisionType())) {
            return;
        }
        Object rejectActivityId = task.getTransientVariable("rejectActivityId");
        if (rejectActivityId != null) {
            detailLog.setRejectActivityId(rejectActivityId.toString());
        }
        if ((rejectActivityName = task.getTransientVariable("rejectActivityName")) != null) {
            detailLog.setRejectActivityName(rejectActivityName.toString());
        }
    }
}

