/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.persistence.entity.history;

import java.util.Date;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricScopeInstanceEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.DurationDetailEntityManager;

public class HistoricActivityInstanceEntityImpl
extends HistoricScopeInstanceEntityImpl
implements HistoricActivityInstanceEntity {
    private static final long serialVersionUID = 1L;

    public HistoricActivityInstanceEntityImpl() {
    }

    public HistoricActivityInstanceEntityImpl(DynamicObject dynamicObject) {
        super(dynamicObject);
    }

    @Override
    public void calRealDuration() {
        ProcessEngineConfigurationImpl processEngineConfigurationImpl = Context.getProcessEngineConfiguration();
        DurationDetailEntityManager durationDetailEntityManager = processEngineConfigurationImpl.getDurationDetailEntityManager();
        Long suspendTime = durationDetailEntityManager.getSuspendDurationForUndoSuspendedByActivityInstId(this.getId());
        Long durationInMillis = this.getDurationInMillis();
        long realDurationInMillis = 0L;
        if (durationInMillis > suspendTime) {
            realDurationInMillis = durationInMillis - suspendTime;
        }
        this.setRealDurationInMillis(realDurationInMillis);
    }

    @Override
    public Object getPersistentState() {
        HashMap<String, Object> persistentState = new HashMap<String, Object>(19);
        persistentState.put("endTime", this.getEndTime());
        persistentState.put("durationInMillis", this.getDurationInMillis());
        persistentState.put("realdurationinmillis", this.getRealDurationInMillis());
        persistentState.put("deleteReason", this.getDeleteReason());
        persistentState.put("executionId", this.getExecutionId());
        persistentState.put("assignee", this.getAssignee());
        persistentState.put("sourceElementId", this.getSourceElementId());
        persistentState.put("targetElementId", this.getTargetElementId());
        persistentState.put("parentTaskId", this.getParentTaskId());
        persistentState.put("executionType", this.getExecutionType());
        persistentState.put("skipReason", this.getSkipReason());
        persistentState.put("assigneeId", this.getAssigneeId());
        persistentState.put("taskId", this.getTaskId());
        persistentState.put("activityId", this.getActivityId());
        persistentState.put("activityName", this.getActivityName());
        persistentState.put("activityType", this.getActivityType());
        persistentState.put("calledProcessInstanceId", this.getCalledProcessInstanceId());
        persistentState.put("joinFlag", this.getJoinFlag());
        persistentState.put("forkPath", this.getForkPath());
        persistentState.put("biztraceno", this.getBizTraceNo());
        persistentState.put("businessKey", this.getBusinessKey());
        persistentState.put("entitynumber", this.getEntityNumber());
        persistentState.put("billno", this.getBillNo());
        return persistentState;
    }

    @Override
    @SimplePropertyAttribute(name="activityId")
    public String getActivityId() {
        return this.dynamicObject.getString("activityId");
    }

    @Override
    public void setActivityId(String activityId) {
        this.dynamicObject.set("activityId", (Object)activityId);
    }

    @Override
    @SimplePropertyAttribute(name="activityName")
    public ILocaleString getActivityName() {
        return this.dynamicObject.getLocaleString("activityName");
    }

    @Override
    public void setActivityName(ILocaleString activityName) {
        this.dynamicObject.set("activityName", (Object)activityName);
    }

    @Override
    @SimplePropertyAttribute(name="activityType")
    public String getActivityType() {
        return this.dynamicObject.getString("activityType");
    }

    @Override
    public void setActivityType(String activityType) {
        this.dynamicObject.set("activityType", (Object)activityType);
    }

    @Override
    @SimplePropertyAttribute(name="executionId")
    public Long getExecutionId() {
        return this.normalizeId(this.dynamicObject.getLong("executionId"));
    }

    @Override
    public void setExecutionId(Long executionId) {
        this.dynamicObject.set("executionId", (Object)executionId);
    }

    @Override
    @SimplePropertyAttribute(name="assigneeId")
    public Long getAssigneeId() {
        return this.normalizeId(this.dynamicObject.getLong("assigneeId"));
    }

    @Override
    public void setAssigneeId(Long assigneeId) {
        this.dynamicObject.set("assigneeId", (Object)assigneeId);
    }

    @Override
    @SimplePropertyAttribute(name="taskId")
    public Long getTaskId() {
        return this.normalizeId(this.dynamicObject.getLong("taskId"));
    }

    @Override
    public void setTaskId(Long taskId) {
        this.dynamicObject.set("taskId", (Object)taskId);
    }

    @Override
    @SimplePropertyAttribute(name="calledProcessInstanceId")
    public Long getCalledProcessInstanceId() {
        return this.dynamicObject.getLong("calledProcessInstanceId");
    }

    @Override
    public void setCalledProcessInstanceId(Long calledProcessInstanceId) {
        this.dynamicObject.set("calledProcessInstanceId", (Object)calledProcessInstanceId);
    }

    public Date getTime() {
        return this.getCreateDate();
    }

    public String toString() {
        return "HistoricActivityInstanceEntity[id=" + this.getId() + ", activityId=" + this.getActivityId() + ", activityName=" + this.getActivityName() + "]";
    }

    @Override
    @SimplePropertyAttribute(name="sourceElementId")
    public Long getSourceElementId() {
        return this.normalizeId(this.dynamicObject.getLong("sourceElementId"));
    }

    @Override
    public void setSourceElementId(Long sourceElementId) {
        this.dynamicObject.set("sourceElementId", (Object)sourceElementId);
    }

    @Override
    @SimplePropertyAttribute(name="targetElementId")
    public Long getTargetElementId() {
        return this.normalizeId(this.dynamicObject.getLong("targetElementId"));
    }

    @Override
    public void setTargetElementId(Long targetElementId) {
        this.dynamicObject.set("targetElementId", (Object)targetElementId);
    }

    @Override
    @SimplePropertyAttribute(name="parentTaskId")
    public Long getParentTaskId() {
        return this.normalizeId(this.dynamicObject.getLong("parentTaskId"));
    }

    @Override
    public void setParentTaskId(Long parentTaskId) {
        this.dynamicObject.set("parentTaskId", (Object)parentTaskId);
    }

    @Override
    @SimplePropertyAttribute(name="assignee")
    public ILocaleString getAssignee() {
        return this.dynamicObject.getLocaleString("assignee");
    }

    @Override
    public void setAssignee(ILocaleString assignee) {
        this.dynamicObject.set("assignee", (Object)WfUtils.subILocaleString(assignee, 100));
    }

    @Override
    @SimplePropertyAttribute(name="executionType")
    public String getExecutionType() {
        return this.dynamicObject.getString("executionType");
    }

    @Override
    public void setExecutionType(String executionType) {
        this.dynamicObject.set("executionType", (Object)executionType);
    }

    @Override
    @SimplePropertyAttribute(name="skipReason")
    public ILocaleString getSkipReason() {
        return this.dynamicObject.getLocaleString("skipReason");
    }

    @Override
    public void setSkipReason(ILocaleString skipReason) {
        this.dynamicObject.set("skipReason", (Object)skipReason);
    }

    @Override
    @SimplePropertyAttribute(name="step")
    public int getStep() {
        return this.dynamicObject.getInt("step");
    }

    @Override
    public void setStep(int step) {
        this.dynamicObject.set("step", (Object)step);
    }

    @Override
    @SimplePropertyAttribute(name="cycle")
    public String getCycle() {
        return this.dynamicObject.getString("cycle");
    }

    @Override
    public void setCycle(String cycle) {
        this.dynamicObject.set("cycle", (Object)cycle);
    }

    @Override
    @SimplePropertyAttribute(name="level")
    public int getLevel() {
        return this.dynamicObject.getInt("level");
    }

    @Override
    @SimplePropertyAttribute(name="joinFlag")
    public String getJoinFlag() {
        return this.dynamicObject.getString("joinFlag");
    }

    @Override
    public void setJoinFlag(String joinFlag) {
        this.dynamicObject.set("joinFlag", (Object)joinFlag);
    }

    @Override
    @SimplePropertyAttribute(name="forkPath")
    public String getForkPath() {
        return this.dynamicObject.getString("forkPath");
    }

    @Override
    public void setForkPath(String forkPath) {
        this.dynamicObject.set("forkPath", (Object)forkPath);
    }

    @Override
    public void setLevel(int level) {
        this.dynamicObject.set("level", (Object)level);
    }

    @Override
    public String getDynObjTypeName() {
        return "wf_hiactinst";
    }

    @Override
    @SimplePropertyAttribute(name="biztraceno")
    public String getBizTraceNo() {
        return this.dynamicObject.getString("biztraceno");
    }

    @Override
    public void setBizTraceNo(String bizTraceNo) {
        this.dynamicObject.set("biztraceno", (Object)bizTraceNo);
    }

    @Override
    @SimplePropertyAttribute(name="businessKey")
    public String getBusinessKey() {
        return this.dynamicObject.getString("businessKey");
    }

    @Override
    public void setBusinessKey(String businessKey) {
        this.dynamicObject.set("businessKey", (Object)businessKey);
    }

    @Override
    @SimplePropertyAttribute(name="entitynumber")
    public String getEntityNumber() {
        return this.dynamicObject.getString("entitynumber");
    }

    @Override
    public void setEntityNumber(String entityNumber) {
        this.dynamicObject.set("entitynumber", (Object)entityNumber);
    }

    @Override
    @SimplePropertyAttribute(name="billno")
    public String getBillNo() {
        return this.dynamicObject.getString("billno");
    }

    @Override
    public void setBillNo(String billNo) {
        this.dynamicObject.set("billno", (Object)billNo);
    }
}

