/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.persistence.entity.history;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.StringJoiner;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.workflow.api.AgentExecution;
import kd.bos.workflow.api.AgentTask;
import kd.bos.workflow.api.WorkflowElement;
import kd.bos.workflow.bpmn.model.CallActivity;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.FlowNode;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.YunzhijiaTask;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cfg.PerformanceSettings;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.db.EntityQueryBuilder;
import kd.bos.workflow.engine.impl.persistence.CachedEntityMatcher;
import kd.bos.workflow.engine.impl.persistence.entity.AbstractEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.cachematcher.HistoricActivityInstByExecutionIdAndActivityIdMatcher;
import kd.bos.workflow.engine.impl.persistence.entity.cachematcher.HistoricActivityInstanceByJoinFlagMatcher;
import kd.bos.workflow.engine.impl.persistence.entity.cachematcher.HistoricActivityInstanceByTaskIdMatcher;
import kd.bos.workflow.engine.impl.persistence.entity.cachematcher.HistoricActivityInstancesByActivityIdMatcher;
import kd.bos.workflow.engine.impl.persistence.entity.cachematcher.HistoricActivityInstancesBySourceIdMatcher;
import kd.bos.workflow.engine.impl.persistence.entity.cachematcher.HistoricActivityInstancesByTargetIdMatcher;
import kd.bos.workflow.engine.impl.persistence.entity.cachematcher.UnfinishedHistoricActivityInstanceMatcher;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelType;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.exception.WFCycleNumbersExceedException;
import kd.bos.workflow.exception.WFErrorCode;

public class HistoricActivityInstanceEntityManagerImpl
extends AbstractEntityManager<HistoricActivityInstanceEntity>
implements HistoricActivityInstanceEntityManager {
    private static final String PROCESSINSTANCEID = "processInstanceId";
    private static final String LEVELSTEPORDER = "level,step";
    private static final int CYCLENUMBERSMAXIMUM = 30;
    protected PerformanceSettings performanceSettings;
    protected CachedEntityMatcher<HistoricActivityInstanceEntity> unfinishedHistoricActivityInstanceMatcher = new UnfinishedHistoricActivityInstanceMatcher();
    protected CachedEntityMatcher<HistoricActivityInstanceEntity> actiInstsByProcessInstanceIdAndSourceIdMatcher = new HistoricActivityInstancesBySourceIdMatcher();
    protected CachedEntityMatcher<HistoricActivityInstanceEntity> actiInstsByProcessInstanceIdAndTargetIdMatcher = new HistoricActivityInstancesByTargetIdMatcher();
    protected CachedEntityMatcher<HistoricActivityInstanceEntity> actiInstsByProcessInstanceIdAndActivityIdMatcher = new HistoricActivityInstancesByActivityIdMatcher();
    protected CachedEntityMatcher<HistoricActivityInstanceEntity> actiInstsByTaskIdMatcher = new HistoricActivityInstanceByTaskIdMatcher();
    protected CachedEntityMatcher<HistoricActivityInstanceEntity> actiInstsByExecutionIdAndActivityIdMatcher = new HistoricActivityInstByExecutionIdAndActivityIdMatcher();
    protected CachedEntityMatcher<HistoricActivityInstanceEntity> actiInstsByJoinFlagMatcher = new HistoricActivityInstanceByJoinFlagMatcher();

    public HistoricActivityInstanceEntityManagerImpl(ProcessEngineConfigurationImpl processEngineConfiguration) {
        super(processEngineConfiguration);
    }

    @Override
    public List<HistoricActivityInstanceEntity> findUnfinishedHistoricActivityInstancesByProcessInstanceId(Long processInstanceId) {
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter(PROCESSINSTANCEID, processInstanceId).addFilter("endTime", "is null", null);
        HashMap<String, Long> parameters = new HashMap<String, Long>();
        parameters.put(PROCESSINSTANCEID, processInstanceId);
        return this.getList(eb, this.unfinishedHistoricActivityInstanceMatcher, parameters, true);
    }

    @Override
    public void deleteHistoricActivityInstancesByProcessInstanceId(Long historicProcessInstanceId) {
        List<HistoricActivityInstanceEntity> list = this.findByProcessInstanceId(historicProcessInstanceId);
        for (HistoricActivityInstanceEntity entity : list) {
            this.delete(entity);
        }
    }

    @Override
    public void insert(HistoricActivityInstanceEntity entity, boolean fireCreateEvent) {
        this.calcActivityInstanceLevelAndStep(entity);
        super.insert(entity, fireCreateEvent);
    }

    private void calcActivityInstanceLevelAndStep(HistoricActivityInstanceEntity entity) {
        HistoricActivityInstanceEntity pre;
        ExecutionEntity execution = (ExecutionEntity)this.getExecutionEntityManager().findById(entity.getExecutionId());
        if (execution != null && (execution.isEventScope() || execution.getParent().isEventScope())) {
            pre = (HistoricActivityInstanceEntity)this.findById(entity.getSourceElementId());
            if (pre == null) {
                int level = 0;
                List<? extends ExecutionEntity> children = execution.getParent().getExecutions();
                if (children != null && children.size() > 0) {
                    for (ExecutionEntity executionEntity : children) {
                        if (!executionEntity.isEventScope() || executionEntity.getId().equals(execution.getId())) continue;
                        EntityQueryBuilder queryBuilder = this.createEntityQueryBuilder(new QFilter[]{new QFilter("executionId", "=", (Object)executionEntity.getId())});
                        queryBuilder.orderBy("level desc");
                        List instanceEntity = this.findByQueryBuilder(queryBuilder);
                        if (instanceEntity == null || instanceEntity.size() <= 0) continue;
                        level = ((HistoricActivityInstanceEntity)instanceEntity.get(0)).getLevel();
                        break;
                    }
                }
                if (level == 0) {
                    entity.setLevel(100);
                } else {
                    entity.setLevel(level + 1);
                }
            } else {
                entity.setLevel(pre.getLevel());
            }
        } else {
            entity.setLevel(1);
        }
        if (WfUtils.isEmpty(entity.getSourceElementId())) {
            entity.setStep(1);
            entity.setCycle("1");
        } else {
            EntityQueryBuilder eb;
            List list;
            pre = (HistoricActivityInstanceEntity)this.findById(entity.getSourceElementId());
            FlowElement elem = ProcessDefinitionUtil.getFlowElement(pre.getProcessDefinitionId(), pre.getProcessInstanceId(), pre.getActivityId());
            if (elem instanceof FlowNode && ((FlowNode)elem).getJoin() != null && ((FlowNode)elem).getJoin().booleanValue() && (list = this.findByQueryBuilder(eb = this.createQueryBuilder().addFilter(PROCESSINSTANCEID, pre.getProcessInstanceId()).addFilter("activityId", pre.getActivityId()).orderBy("step desc"), false)) != null && !list.isEmpty()) {
                pre = (HistoricActivityInstanceEntity)list.get(0);
            }
            int maxStep = this.findMaxStep(entity.getProcessInstanceId(), pre);
            entity.setStep(maxStep + 1);
            Process process = ProcessDefinitionUtil.getProcess(pre.getProcessDefinitionId(), pre.getProcessInstanceId());
            if (process == null) {
                return;
            }
            if (ModelType.AuditFlow.name().equals(process.getProcessType())) {
                int maximumCyclesNumber;
                boolean newCalc;
                HistoricActivityInstanceEntity historicActivityInstanceEntity = this.findLatestCycleOfPreSameHistoricActivityInstance(entity);
                boolean bl = newCalc = historicActivityInstanceEntity == null || pre.getCycle().split("_").length > historicActivityInstanceEntity.getCycle().split("_").length;
                if (newCalc) {
                    String[] o = pre.getCycle().split("_");
                    int index = historicActivityInstanceEntity == null ? 0 : historicActivityInstanceEntity.getCycle().split("_").length;
                    StringBuilder sb = new StringBuilder(historicActivityInstanceEntity == null ? "" : historicActivityInstanceEntity.getCycle());
                    for (int i = index; i < o.length - 1; ++i) {
                        if (sb.toString().length() > 0 && !sb.toString().endsWith("_")) {
                            sb.append('_');
                        }
                        sb.append('0').append('_');
                    }
                    if (sb.toString().length() > 0 && !sb.toString().endsWith("_")) {
                        sb.append('_');
                    }
                    sb.append(String.valueOf(entity.getStep()));
                    entity.setCycle(sb.toString());
                } else if (historicActivityInstanceEntity != null && historicActivityInstanceEntity.getCycle().split("_").length == pre.getCycle().split("_").length) {
                    if (historicActivityInstanceEntity.getEndTime() != null) {
                        entity.setCycle(historicActivityInstanceEntity.getCycle() + "_" + String.valueOf(entity.getStep()));
                    }
                } else if (historicActivityInstanceEntity != null) {
                    entity.setCycle(historicActivityInstanceEntity.getCycle() + "_" + String.valueOf(entity.getStep()));
                }
                int configValue = WfConfigurationUtil.getMaximumOfCyclesNumber();
                int n = maximumCyclesNumber = configValue > 0 ? configValue : 30;
                if (entity.getCycle().split("_").length > maximumCyclesNumber + 1 && execution != null) {
                    throw new WFCycleNumbersExceedException(WFErrorCode.createCycleNumbersExceedError(), execution.getProcessInstanceId(), entity.getCycle().split("_").length - 1, execution.getActivityId());
                }
            } else {
                entity.setCycle(String.valueOf(entity.getStep()));
            }
        }
    }

    private int findMaxStep(Long processInstanceId, HistoricActivityInstanceEntity pre) {
        int step = 0;
        StringBuilder sb = new StringBuilder();
        sb.append("select max(fstep) as step from t_wf_hiactinst  ");
        sb.append("where FPROCINSTID= ? ");
        step = (Integer)DB.query((DBRoute)DBRoute.workflow, (String)sb.toString(), (Object[])new Object[]{processInstanceId}, (ResultSetHandler)new ResultSetHandler<Integer>(){

            public Integer handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    return rs.getInt("step");
                }
                return 0;
            }
        });
        return Math.max(step, pre.getStep());
    }

    private HistoricActivityInstanceEntity findLatestCycleOfPreSameHistoricActivityInstance(HistoricActivityInstanceEntity entity) {
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter(PROCESSINSTANCEID, entity.getProcessInstanceId()).addFilter("activityId", entity.getActivityId()).orderBy("level ,step desc");
        List list = this.findByQueryBuilder(eb, false);
        if (list == null || list.size() == 0) {
            return null;
        }
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            HistoricActivityInstanceEntity tmp = (HistoricActivityInstanceEntity)iter.next();
            if ((tmp.getSourceElementId() == null || !tmp.getSourceElementId().equals(entity.getSourceElementId())) && tmp.getEndTime() != null) continue;
            iter.remove();
        }
        Collections.sort(list, new Comparator<HistoricActivityInstanceEntity>(){

            @Override
            public int compare(HistoricActivityInstanceEntity o1, HistoricActivityInstanceEntity o2) {
                return o2.getCycle().length() - o1.getCycle().length();
            }
        });
        if (list != null && !list.isEmpty()) {
            return (HistoricActivityInstanceEntity)list.get(0);
        }
        return null;
    }

    @Override
    public List<HistoricActivityInstanceEntity> findByProcessInstanceId(Long processInstanceId) {
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter(PROCESSINSTANCEID, processInstanceId).orderBy(LEVELSTEPORDER);
        List<HistoricActivityInstanceEntity> list = this.findByQueryBuilder(eb);
        if (WfUtils.isEmptyForCollection(list)) {
            return this.getHistoricProcCompactEntityManager().getEntitysFromWide(processInstanceId, LEVELSTEPORDER);
        }
        return list;
    }

    @Override
    public HistoricActivityInstanceEntity create(DynamicObject dynamicObject) {
        return new HistoricActivityInstanceEntityImpl(dynamicObject);
    }

    @Override
    public String getEntityName() {
        return "wf_hiactinst";
    }

    @Override
    public String getTableName() {
        return "t_wf_hiactinst";
    }

    @Override
    public String getMultiLangTableName() {
        return "t_wf_hiactinst_l";
    }

    @Override
    public String getSelectFields() {
        return "id,processDefinitionId,processInstanceId,executionId,activityId,taskId,calledProcessInstanceId,activityName,activityType,assigneeId,assignee,endTime,durationInMillis,realDurationInMillis,deleteReason,sourceElementId,targetElementId,parentTaskId,executionType,skipReason,createDate,modifyDate,step,level,cycle,joinFlag,forkPath,biztraceno,businessKey,entitynumber,billno";
    }

    @Override
    public Class<? extends HistoricActivityInstanceEntity> getManagedEntityClass() {
        return HistoricActivityInstanceEntityImpl.class;
    }

    @Override
    public HistoricActivityInstanceEntity create() {
        return new HistoricActivityInstanceEntityImpl();
    }

    @Override
    public List<HistoricActivityInstanceEntity> findUnfinishedHistoricActivityInstancesByExecutionAndActivityId(Long executionId, String activityId) {
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter("executionId", executionId).addFilter("activityId", activityId);
        return this.findByQueryBuilder(eb);
    }

    @Override
    public List<HistoricActivityInstanceEntity> findByTargetId(Long processInstanceId, Long targetId) {
        QFilter q1 = new QFilter(PROCESSINSTANCEID, "=", (Object)processInstanceId);
        QFilter q2 = new QFilter("targetElementId", "=", (Object)targetId);
        QFilter[] qFilters = new QFilter[]{q1, q2};
        EntityQueryBuilder qb = new EntityQueryBuilder(this.getEntityName(), qFilters, this.getSelectFields(), this.getManagedEntityClass());
        HashMap<String, Long> parameters = new HashMap<String, Long>(2);
        parameters.put(PROCESSINSTANCEID, processInstanceId);
        parameters.put("targetElementId", targetId);
        return this.getList(qb, this.actiInstsByProcessInstanceIdAndTargetIdMatcher, parameters, true);
    }

    @Override
    public List<HistoricActivityInstanceEntity> findByActivityId(Long processInstanceId, String activityId) {
        List<HistoricActivityInstanceEntity> result = null;
        QFilter q1 = new QFilter(PROCESSINSTANCEID, "=", (Object)processInstanceId);
        QFilter q2 = new QFilter("activityId", "=", (Object)activityId);
        QFilter[] qFilters = new QFilter[]{q1, q2};
        String orderBys = "step desc";
        EntityQueryBuilder qb = new EntityQueryBuilder(this.getEntityName(), qFilters, orderBys, this.getSelectFields(), this.getManagedEntityClass());
        HashMap<String, Object> parameters = new HashMap<String, Object>(2);
        parameters.put(PROCESSINSTANCEID, processInstanceId);
        parameters.put("activityId", activityId);
        result = this.getList(qb, this.actiInstsByProcessInstanceIdAndActivityIdMatcher, parameters, true);
        if (WfUtils.isEmptyForCollection(result)) {
            return this.getHistoricProcCompactEntityManager().getEntitysFromWideByActivityId(processInstanceId, activityId, orderBys);
        }
        return result;
    }

    @Override
    public List<HistoricActivityInstanceEntity> findByActivityId(Long processInstanceId, String activityId, String selectFields, String orderBy) {
        QFilter[] filters = new QFilter[]{new QFilter(PROCESSINSTANCEID, "=", (Object)processInstanceId), new QFilter("activityId", "=", (Object)activityId)};
        List<HistoricActivityInstanceEntity> result = this.findByQueryFilters(filters, selectFields, orderBy);
        if (WfUtils.isEmptyForCollection(result)) {
            return this.getHistoricProcCompactEntityManager().getEntitysFromWideByActivityId(processInstanceId, activityId, orderBy);
        }
        return result;
    }

    @Override
    public HistoricActivityInstanceEntity findActivityByTaskId(Long taskId) {
        HistoricActivityInstanceEntity result = null;
        QFilter q = new QFilter("taskId", "=", (Object)taskId);
        QFilter[] qFilters = new QFilter[]{q};
        EntityQueryBuilder qb = new EntityQueryBuilder(this.getEntityName(), qFilters, this.getSelectFields(), this.getManagedEntityClass());
        List<HistoricActivityInstanceEntity> list = this.getList(qb, this.actiInstsByTaskIdMatcher, taskId, true);
        if (list == null || list.size() <= 0) {
            return this.getHistoricProcCompactEntityManager().getEntitysFromWideByTaskId(taskId);
        }
        result = list.get(0);
        return result;
    }

    @Override
    public HistoricActivityInstanceEntity findActivityByYzjAuditParentTaskId(Long processInstanceId, Long parentTaskId) {
        List<HistoricActivityInstanceEntity> hisActivitys = this.findByProcessInstanceId(processInstanceId);
        for (int i = 0; i < hisActivitys.size(); ++i) {
            if (parentTaskId == null || hisActivitys.get(i) == null || !parentTaskId.equals(hisActivitys.get(i).getParentTaskId())) continue;
            return hisActivitys.get(i);
        }
        return null;
    }

    @Override
    public HistoricActivityInstanceEntity findLatestActivityByExecution(AgentExecution execution) {
        Long executionId = execution.getId();
        WorkflowElement element = execution.getCurrentFlowElement();
        if (element == null) {
            return null;
        }
        String activityId = element.getId();
        if (element instanceof YunzhijiaTask) {
            HistoricActivityInstanceEntity entity = this.create();
            AgentTask task = execution.getCurrentTask();
            if (task instanceof TaskEntity) {
                TaskEntity taskEntity = (TaskEntity)task;
                if (WfUtils.isEmpty(taskEntity.getParentTaskId())) {
                    entity.setId(taskEntity.getId());
                } else {
                    entity.setId(taskEntity.getParentTaskId());
                }
            }
            if (execution instanceof ExecutionEntity) {
                entity.setSourceElementId(((ExecutionEntity)execution).getCurrentActInstId());
            }
            entity.setActivityId(activityId);
            return entity;
        }
        String filterKey = "executionId";
        Long filterValue = executionId;
        if (element instanceof CallActivity) {
            filterKey = PROCESSINSTANCEID;
            filterValue = execution.getProcessInstanceId();
        }
        QFilter[] filters = new QFilter[]{new QFilter(filterKey, "=", (Object)filterValue), new QFilter("activityId", "=", (Object)activityId)};
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put(filterKey, filterValue);
        param.put("activityId", activityId);
        String orderBy = String.format("%s desc", "step");
        EntityQueryBuilder queryBuilder = this.createEntityQueryBuilder(filters, orderBy);
        List<HistoricActivityInstanceEntity> entities = this.getList(queryBuilder, this.actiInstsByExecutionIdAndActivityIdMatcher, param, true);
        if (entities != null && !entities.isEmpty()) {
            return entities.get(0);
        }
        return null;
    }

    @Override
    public Long findActivityIdByTask(Long taskId) {
        HistoricActivityInstanceEntity historicActivityInstanceEntity = this.findActivityByTaskId(taskId);
        if (historicActivityInstanceEntity == null) {
            QFilter q = new QFilter("parenttaskid", "=", (Object)taskId);
            DynamicObject[] tasks = BusinessDataServiceHelper.load((String)"wf_task", (String)"id", (QFilter[])new QFilter[]{q});
            if (tasks != null && tasks.length > 0) {
                long childTaskId = tasks[0].getLong("id");
                HistoricActivityInstanceEntity childHistoricActivityInstanceEntity = this.findActivityByTaskId(childTaskId);
                return childHistoricActivityInstanceEntity.getId();
            }
            return 0L;
        }
        return historicActivityInstanceEntity.getId();
    }

    @Override
    public List<HistoricActivityInstanceEntity> findBySourceId(Long processInstanceId, Long sourceId) {
        QFilter q1 = new QFilter(PROCESSINSTANCEID, "=", (Object)processInstanceId);
        QFilter q2 = new QFilter("sourceElementId", "=", (Object)(sourceId != null ? sourceId : 0L));
        QFilter[] qFilters = new QFilter[]{q1, q2};
        EntityQueryBuilder qb = new EntityQueryBuilder(this.getEntityName(), qFilters, this.getSelectFields(), this.getManagedEntityClass());
        HashMap<String, Long> parameters = new HashMap<String, Long>(2);
        parameters.put(PROCESSINSTANCEID, processInstanceId);
        parameters.put("sourceElementId", sourceId);
        return this.getList(qb, this.actiInstsByProcessInstanceIdAndSourceIdMatcher, parameters, true);
    }

    @Override
    public List<HistoricActivityInstanceEntity> findByProInstIdAndJoinFlag(Long proInstId, String joinFlag, Long executionId) {
        QFilter q1 = new QFilter(PROCESSINSTANCEID, "=", (Object)proInstId);
        QFilter q2 = new QFilter("joinFlag", "=", (Object)joinFlag);
        QFilter[] qFilters = new QFilter[]{q1, q2};
        EntityQueryBuilder qb = new EntityQueryBuilder(this.getEntityName(), qFilters, this.getSelectFields(), this.getManagedEntityClass());
        List<HistoricActivityInstanceEntity> formCache = this.getList(qb, this.actiInstsByJoinFlagMatcher, joinFlag, true);
        List formDB = this.findByQueryBuilder(qb);
        HashSet<Long> formCacheIds = new HashSet<Long>(formCache.size());
        for (HistoricActivityInstanceEntity u : formCache) {
            formCacheIds.add(u.getId());
        }
        for (HistoricActivityInstanceEntity u : formDB) {
            if (formCacheIds.contains(u.getId())) continue;
            formCache.add(u);
        }
        return formCache;
    }

    @Override
    public List<HistoricActivityInstanceEntity> findByBusinessKeyAndEntityNumber(String businessKey, String entityNumber) {
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter("businessKey", businessKey).addFilter("entitynumber", entityNumber).addFilter("endTime", null).orderBy(LEVELSTEPORDER);
        return this.findByQueryBuilder(eb);
    }

    @Override
    public List<HistoricActivityInstanceEntity> findByActivityIdByProcInstIdAndActivityIdAndBusinessKey(Long processInstanceId, String activityId, String businessKey) {
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter(PROCESSINSTANCEID, processInstanceId).addFilter("activityId", activityId).addFilter("businessKey", businessKey).orderBy(LEVELSTEPORDER);
        return this.findByQueryBuilder(eb);
    }

    @Override
    public List<HistoricActivityInstanceEntity> findUnTargetBillTaskActInstance(Long processInstanceId, Set<String> acts, List<String> bks) {
        QFilter[] qFilters = new QFilter[]{new QFilter(PROCESSINSTANCEID, "=", (Object)processInstanceId), new QFilter("activityId", "in", acts), new QFilter("businessKey", "in", bks), new QFilter("targetElementId", "=", (Object)0L)};
        return this.findByQueryFilters(qFilters);
    }

    @Override
    public HistoricActivityInstanceEntity findNodeLastActiveByProcInstIdAndActivityId(Long processInstanceId, String activityId) {
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter(PROCESSINSTANCEID, processInstanceId).addFilter("activityId", activityId).orderBy("endtime desc").setLimit(1);
        List historicActs = this.findByQueryBuilder(eb);
        if (historicActs != null && historicActs.size() > 0) {
            return (HistoricActivityInstanceEntity)historicActs.get(0);
        }
        return null;
    }

    @Override
    public HistoricActivityInstanceEntity findByActivityInstId(Long processInstanceId, Long activityInstId) {
        HistoricActivityInstanceEntity result = (HistoricActivityInstanceEntity)this.findById(activityInstId);
        if (result == null) {
            return this.getHistoricProcCompactEntityManager().getEntitysFromWideActivityInstId(processInstanceId, activityInstId);
        }
        return result;
    }

    @Override
    public List<HistoricActivityInstanceEntity> findByActivityType(Set<Long> processInstanceIds, String activityType, String fields, String orderBy) {
        List<HistoricActivityInstanceEntity> result = null;
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter(PROCESSINSTANCEID, "in", processInstanceIds).addFilter("activityType", "=", activityType);
        Set<String> queryFeilds = null;
        if (WfUtils.isNotEmpty(fields)) {
            queryFeilds = this.getSelectField(fields, orderBy);
            StringJoiner queryFeildStr = new StringJoiner(",");
            for (String queryFeild : queryFeilds) {
                queryFeildStr.add(queryFeild);
            }
            eb.setSelectFields(queryFeildStr.toString());
        }
        if (WfUtils.isNotEmpty(orderBy)) {
            eb.orderBy(orderBy);
        }
        result = this.findByQueryBuilder(eb);
        result.addAll(this.getHistoricProcCompactEntityManager().getEntitysFromWideByProcInstIdsAndActType(processInstanceIds, activityType, queryFeilds));
        if (WfUtils.isNotEmpty(orderBy)) {
            this.sortHiActInsts(result, orderBy);
        }
        return result;
    }

    @Override
    public List<HistoricActivityInstanceEntity> findByBusinessKeysAndActType(Set<String> businessKeys, String actType, String fields, String orderBy) {
        List<HistoricActivityInstanceEntity> result = null;
        if (WfUtils.isEmptyForCollection(businessKeys)) {
            return result;
        }
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter("businessKey", "in", businessKeys).addFilter("activityType", "=", actType);
        Set<String> queryFeilds = null;
        if (WfUtils.isNotEmpty(fields)) {
            queryFeilds = this.getSelectField(fields, orderBy);
            StringJoiner queryFeildStr = new StringJoiner(",");
            for (String queryFeild : queryFeilds) {
                queryFeildStr.add(queryFeild);
            }
            eb.setSelectFields(queryFeildStr.toString());
        }
        if (WfUtils.isNotEmpty(orderBy)) {
            eb.orderBy(orderBy);
        }
        result = this.findByQueryBuilder(eb);
        result.addAll(this.getHistoricProcCompactEntityManager().getEntitysFromWideByBusinessKeysAndActType(businessKeys, actType, queryFeilds));
        if (WfUtils.isNotEmpty(orderBy)) {
            this.sortHiActInsts(result, orderBy);
        }
        return result;
    }

    @Override
    public Long getProcInstIdFromHistoricActivityByBusinessKey(String entityNumber, String businessKey) {
        HistoricActivityInstanceEntity entity;
        if (WfUtils.isEmpty(businessKey)) {
            return null;
        }
        QFilter[] qFilters = new QFilter[2];
        qFilters[0] = new QFilter("businessKey", "=", (Object)businessKey);
        if (WfUtils.isNotEmpty(entityNumber)) {
            qFilters[1] = new QFilter("entitynumber", "=", (Object)entityNumber);
        }
        if ((entity = (HistoricActivityInstanceEntity)this.findOneByCondition(qFilters, PROCESSINSTANCEID, String.format("%s desc", PROCESSINSTANCEID))) != null) {
            return entity.getProcessInstanceId();
        }
        return this.getHistoricCompactRelaEntityManager().getProcInstIdByBusinessKey(entityNumber, businessKey);
    }

    @Override
    public HistoricActivityInstanceEntity findByBusinessKeyAndActivityInstId(String businessKey, Long activityInstId) {
        HistoricActivityInstanceEntity entity = (HistoricActivityInstanceEntity)this.findById(activityInstId);
        if (entity != null) {
            return entity;
        }
        return this.getHistoricProcCompactEntityManager().getActFromWideByBusinessKeyAndId(businessKey, activityInstId);
    }

    private void sortHiActInsts(List<HistoricActivityInstanceEntity> hiActInsts, String orderByStr) {
        if (WfUtils.isEmpty(orderByStr) || WfUtils.isEmptyForCollection(hiActInsts)) {
            return;
        }
        if (WfUtils.isNotEmpty(orderByStr = orderByStr.trim().toLowerCase(Locale.ENGLISH))) {
            String[] orderBys = orderByStr.split(",");
            hiActInsts.sort((act1, act2) -> this.getOrderResult((HistoricActivityInstanceEntity)act1, (HistoricActivityInstanceEntity)act2, orderBys));
        }
    }

    private int getOrderResult(HistoricActivityInstanceEntity act1, HistoricActivityInstanceEntity act2, String[] orderBys) {
        int result = 0;
        for (String orderBy : orderBys) {
            orderBy = orderBy.trim();
            String field = "";
            boolean reverseOrder = false;
            if (orderBy.endsWith("desc")) {
                reverseOrder = true;
                field = orderBy.substring(0, orderBy.indexOf("desc")).trim();
            } else {
                field = orderBy.endsWith("asc") ? orderBy.substring(0, orderBy.indexOf("asc")).trim() : orderBy;
            }
            switch (field) {
                case "id": {
                    result = act1.getId() < act2.getId() ? -1 : 1;
                    break;
                }
                case "level": {
                    result = act1.getLevel() - act2.getLevel();
                    break;
                }
                case "step": {
                    result = act1.getStep() - act2.getStep();
                    break;
                }
                case "createdate": {
                    result = act1.getCreateDate().equals(act2.getCreateDate()) ? 0 : (act1.getCreateDate().after(act2.getCreateDate()) ? 1 : -1);
                    break;
                }
            }
            if (result == 0) continue;
            if (!reverseOrder) break;
            result = -result;
            break;
        }
        return result;
    }

    private Set<String> getSelectField(String fields, String orderBy) {
        String[] orderByFeilds;
        HashSet<String> result = new HashSet<String>(16);
        result.addAll(Arrays.asList(fields.split(",")));
        if (WfUtils.isEmpty(orderBy)) {
            return result;
        }
        orderBy = orderBy.trim().toLowerCase(Locale.ENGLISH);
        for (String orderByFeild : orderByFeilds = orderBy.split(",")) {
            String feild = orderByFeild.trim();
            if (feild.endsWith("desc")) {
                result.add(feild.substring(0, feild.indexOf("desc")).trim());
                continue;
            }
            if (feild.endsWith("asc")) {
                result.add(feild.substring(0, feild.indexOf("asc")).trim());
                continue;
            }
            result.add(feild);
        }
        return result;
    }
}

