/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.persistence.entity.history;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.component.approvalrecord.ApprovalAttachmentInfo;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.event.ActivitiEventType;
import kd.bos.workflow.engine.delegate.event.impl.ActivitiEventBuilder;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.cmd.task.RecordItemAttachmentInfo;
import kd.bos.workflow.engine.impl.persistence.entity.AbstractEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricAttachmentEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricAttachmentEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricAttachmentEntityManager;
import kd.bos.workflow.engine.impl.util.CollectionUtil;
import kd.bos.workflow.engine.impl.util.CoordinateRecordUtil;
import kd.bos.workflow.engine.task.Attachment;
import kd.bos.workflow.engine.task.Task;

public class HistoricAttachmentEntityManagerImpl
extends AbstractEntityManager<HistoricAttachmentEntity>
implements HistoricAttachmentEntityManager {
    public HistoricAttachmentEntityManagerImpl(ProcessEngineConfigurationImpl processEngineConfiguration) {
        super(processEngineConfiguration);
    }

    @Override
    public Class<? extends HistoricAttachmentEntity> getManagedEntityClass() {
        return HistoricAttachmentEntityImpl.class;
    }

    @Override
    public String getEntityName() {
        return "wf_hiattachment";
    }

    @Override
    public String getSelectFields() {
        return "id,userId,name,description,type,taskId,urlId,processInstanceId,contentId,createDate,modifyDate";
    }

    @Override
    public List<HistoricAttachmentEntity> findAttachmentsByTaskId(Long taskId) {
        QFilter q = new QFilter("taskId", "=", (Object)taskId);
        QFilter[] qFilters = new QFilter[]{q};
        String orderby = " createDate desc";
        return this.findByQueryFilters(qFilters, this.getSelectFields(), orderby);
    }

    @Override
    public void deleteAttachmentsByTaskId(Long taskId) {
        Task task;
        List<HistoricAttachmentEntity> attachments = this.findAttachmentsByTaskId(taskId);
        boolean dispatchEvents = this.getEventDispatcher().isEnabled();
        Long processInstanceId = null;
        Long processDefinitionId = null;
        Long executionId = null;
        if (dispatchEvents && (task = (Task)this.getTaskEntityManager().findById(taskId)) != null) {
            processDefinitionId = task.getProcessDefinitionId();
            processInstanceId = task.getProcessInstanceId();
            executionId = task.getExecutionId();
        }
        if (attachments != null && !attachments.isEmpty()) {
            for (Attachment attachment : attachments) {
                this.delete((HistoricAttachmentEntity)attachment);
                if (!dispatchEvents) continue;
                this.getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.ENTITY_DELETED, attachment, executionId, processInstanceId, processDefinitionId));
            }
        }
    }

    @Override
    public Map<String, RecordItemAttachmentInfo> getAttachmentInfo(String contentIds, Long processInstanceId) {
        HashMap<String, RecordItemAttachmentInfo> recordAttachmentMap = new HashMap<String, RecordItemAttachmentInfo>();
        StringBuilder sql = new StringBuilder();
        sql.append("select a.furlid attachmentId, a.fcontentid commentId from t_wf_hiattachment a ");
        sql.append("left join t_wf_hiattachment_l b on b.fid = a.fid and b.flocaleid = ? ");
        sql.append("where a.fuserid != 1 and a.fcontentid in ").append(contentIds).append(' ');
        if (WfUtils.isNotEmpty(processInstanceId)) {
            sql.append("and  a.fprocinstid = ? ");
        }
        sql.append("order by a.fcreatedate desc");
        String lang = RequestContext.get().getLang().toString();
        Object[] params = new Object[]{lang, processInstanceId};
        if (WfUtils.isEmpty(processInstanceId)) {
            params = new Object[]{lang};
        }
        HashMap<String, RecordItemAttachmentInfo> attIdRefCommentId = new HashMap<String, RecordItemAttachmentInfo>();
        ArrayList<Long> allAttachmentIds = new ArrayList<Long>();
        RecordItemAttachmentInfo recordAttachmentInfo = null;
        DataSet ds = DB.queryDataSet((String)"getProcessAttachments", (DBRoute)DBRoute.workflow, (String)sql.toString(), (Object[])params);
        Object object = null;
        try {
            for (Row r : ds) {
                String commentId = String.valueOf(r.get("commentId"));
                Long attachmentId = r.getLong("attachmentId");
                recordAttachmentInfo = (RecordItemAttachmentInfo)recordAttachmentMap.get(commentId);
                if (recordAttachmentInfo == null) {
                    recordAttachmentInfo = new RecordItemAttachmentInfo();
                    recordAttachmentMap.put(commentId, recordAttachmentInfo);
                }
                allAttachmentIds.add(attachmentId);
                attIdRefCommentId.put(String.valueOf(attachmentId), recordAttachmentInfo);
                recordAttachmentInfo.getAttachmentIds().add(attachmentId);
            }
        }
        catch (Throwable iter) {
            object = iter;
            throw iter;
        }
        finally {
            if (ds != null) {
                if (object != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable iter) {
                        ((Throwable)object).addSuppressed(iter);
                    }
                } else {
                    ds.close();
                }
            }
        }
        if (CollectionUtil.isNotEmpty(allAttachmentIds)) {
            List<ApprovalAttachmentInfo> approvalAttachments = CoordinateRecordUtil.getApprovalAttachments(allAttachmentIds);
            for (ApprovalAttachmentInfo attachment : approvalAttachments) {
                recordAttachmentInfo = (RecordItemAttachmentInfo)attIdRefCommentId.get(attachment.getId());
                if (recordAttachmentInfo == null) continue;
                recordAttachmentInfo.getAttachments().add(attachment);
            }
        }
        return recordAttachmentMap;
    }
}

