/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.persistence.entity.history;

import java.util.List;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.db.EntityQueryBuilder;
import kd.bos.workflow.engine.impl.persistence.entity.AbstractEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricCompactRelaEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricCompactRelaEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricCompactRelaEntityManager;

public class HistoricCompactRelaEntityManagerImpl
extends AbstractEntityManager<HistoricCompactRelaEntity>
implements HistoricCompactRelaEntityManager {
    public HistoricCompactRelaEntityManagerImpl(ProcessEngineConfigurationImpl processEngineConfiguration) {
        super(processEngineConfiguration);
    }

    @Override
    public Class<? extends HistoricCompactRelaEntity> getManagedEntityClass() {
        return HistoricCompactRelaEntityImpl.class;
    }

    @Override
    public String getSelectFields() {
        return "id,processinstanceid,businesskey,entitynumber";
    }

    @Override
    public String getEntityName() {
        return "wf_historiccompactrela";
    }

    @Override
    public List<HistoricCompactRelaEntity> findByProcInstId(Long procInstId) {
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter("processInstanceId", procInstId);
        return this.findByQueryBuilder(eb);
    }

    @Override
    public void deleteByProcInstId(Long procInstId) {
        List<HistoricCompactRelaEntity> entityList = this.findByProcInstId(procInstId);
        if (WfUtils.isNotEmptyForCollection(entityList)) {
            for (HistoricCompactRelaEntity entity : entityList) {
                this.delete(entity);
            }
        }
    }

    @Override
    public Long getProcInstIdByBusinessKey(String entityNumber, String businessKey) {
        HistoricCompactRelaEntity entity;
        if (WfUtils.isEmpty(businessKey)) {
            return null;
        }
        QFilter[] qFilters = new QFilter[2];
        qFilters[0] = new QFilter("businessKey", "=", (Object)businessKey);
        if (WfUtils.isNotEmpty(entityNumber)) {
            qFilters[1] = new QFilter("entitynumber", "=", (Object)entityNumber);
        }
        if ((entity = (HistoricCompactRelaEntity)this.findOneByCondition(qFilters, "processInstanceId", String.format("%s desc", "processInstanceId"))) != null) {
            return entity.getProcessInstanceId();
        }
        return null;
    }
}

