/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.persistence.entity.history;

import java.util.Date;
import java.util.List;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.db.EntityQueryBuilder;
import kd.bos.workflow.engine.impl.persistence.entity.AbstractEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricConditionalRuleEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricConditionalRuleEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricConditionalRuleEntityManager;

public class HistoricConditionalRuleEntityManagerImpl
extends AbstractEntityManager<HistoricConditionalRuleEntity>
implements HistoricConditionalRuleEntityManager {
    public HistoricConditionalRuleEntityManagerImpl(ProcessEngineConfigurationImpl configuration) {
        super(configuration);
    }

    @Override
    public String getEntityName() {
        return "wf_hiconditionalrulemodel";
    }

    @Override
    public String getSelectFields() {
        return "id,procdefid,conditionalruleid,showtext,description,validtime,invalidtime,expression,plugin,version,modifierid,modifydate,createdate";
    }

    @Override
    public void setInvalidTime(Long condRuleId, String version, Date invalidTime) {
        QFilter[] filters = new QFilter[]{new QFilter("conditionalruleid", "=", (Object)condRuleId), new QFilter("version", "=", (Object)version)};
        HistoricConditionalRuleEntityImpl hisCondRule = (HistoricConditionalRuleEntityImpl)this.findOneByCondition(filters, this.getSelectFields(), null);
        hisCondRule.setInvalidTime(invalidTime);
        this.update(hisCondRule);
    }

    @Override
    public List<HistoricConditionalRuleEntity> getHistoricCondRulesByCondRuleId(Long condRuleId) {
        EntityQueryBuilder queryBuilder = this.createQueryBuilder().addFilter("conditionalruleid", condRuleId).orderBy(String.format("%s %s", "validtime", "desc"));
        return this.findByQueryBuilder(queryBuilder);
    }

    @Override
    public void deleteHistoricCondRulesByCondRuleId(Long condRuleId) {
        this.logger.debug("begin delete historic conditionalrule by id: " + condRuleId);
        this.deleteByFilters(new QFilter[]{new QFilter("conditionalruleid", "=", (Object)condRuleId)});
    }

    @Override
    public Class<? extends HistoricConditionalRuleEntity> getManagedEntityClass() {
        return HistoricConditionalRuleEntityImpl.class;
    }
}

