/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.persistence.entity.history;

import java.util.List;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.db.EntityQueryBuilder;
import kd.bos.workflow.engine.impl.persistence.CachedEntityMatcher;
import kd.bos.workflow.engine.impl.persistence.entity.AbstractEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.cachematcher.HistoricDynResourceByProcessInstanceIdEntityMatcher;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricDynamicResourceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricDynamicResourceEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricDynamicResourceEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.DynamicResourceEntity;

public class HistoricDynamicResourceEntityManagerImpl
extends AbstractEntityManager<HistoricDynamicResourceEntity>
implements HistoricDynamicResourceEntityManager {
    protected CachedEntityMatcher<HistoricDynamicResourceEntity> hisDynResourceByProcessInstanceIdMatcher = new HistoricDynResourceByProcessInstanceIdEntityMatcher();

    public HistoricDynamicResourceEntityManagerImpl(ProcessEngineConfigurationImpl processEngineConfiguration) {
        super(processEngineConfiguration);
    }

    @Override
    public Class<? extends HistoricDynamicResourceEntity> getManagedEntityClass() {
        return HistoricDynamicResourceEntityImpl.class;
    }

    @Override
    public String getSelectFields() {
        return "id,name,content,processInstanceId,processDefinitionId,activityId,activityInstanceId,endTime,durationInMillis,deletereason,createDate,modifyDate,type,ownerId,taskId";
    }

    @Override
    public HistoricDynamicResourceEntity create(DynamicResourceEntity dynamicResource) {
        return new HistoricDynamicResourceEntityImpl(dynamicResource);
    }

    @Override
    public List<HistoricDynamicResourceEntity> findByProcessInstanceId(Long processInstanceId) {
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter("processInstanceId", processInstanceId).orderBy(String.format("%s,%s asc", "createDate", "id"));
        return this.getList(eb, this.hisDynResourceByProcessInstanceIdMatcher, processInstanceId, true);
    }

    @Override
    public HistoricDynamicResourceEntity findByActivityInstId(Long processInstanceId, Long activityInstId) {
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter("processInstanceId", processInstanceId).addFilter("activityInstanceId", activityInstId);
        List entities = this.findByQueryBuilder(eb);
        return entities != null && !entities.isEmpty() ? (HistoricDynamicResourceEntity)entities.get(0) : null;
    }

    @Override
    public String getEntityName() {
        return "wf_hidynamicresource";
    }

    @Override
    public String getTableName() {
        return "t_wf_hidynresource";
    }

    @Override
    public String getMultiLangTableName() {
        return "t_wf_hidynresource_l";
    }
}

