/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.persistence.entity.history;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.db.EntityQueryBuilder;
import kd.bos.workflow.engine.impl.persistence.CachedEntityMatcher;
import kd.bos.workflow.engine.impl.persistence.entity.AbstractEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.cachematcher.HistoricIdentityLinkByTaskIdMatcher;
import kd.bos.workflow.engine.impl.persistence.entity.cachematcher.HistoricIdentityLinkByTaskIdUserIdMatcher;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricIdentityLinkEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricIdentityLinkEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricIdentityLinkEntityManager;

public class HistoricIdentityLinkEntityManagerImpl
extends AbstractEntityManager<HistoricIdentityLinkEntity>
implements HistoricIdentityLinkEntityManager {
    public static final String SELECT_FIELDS = "id,type,userId,taskId,processInstanceId,processDefId,ownerId,transferOpinion,createDate,modifyDate,subscribesign,parenttaskid,endTime,durationInMillis,priority,username,compositetaskid,usernameformatter,delegateid,display,trustname,trustnameformat,currentsubject,readtime";
    protected CachedEntityMatcher<HistoricIdentityLinkEntity> hisIdentityLinksByTaskIdMatcher = new HistoricIdentityLinkByTaskIdMatcher();
    protected CachedEntityMatcher<HistoricIdentityLinkEntity> hisIdentityLinksByTaskIdUserIdMatcher = new HistoricIdentityLinkByTaskIdUserIdMatcher();

    public HistoricIdentityLinkEntityManagerImpl(ProcessEngineConfigurationImpl processEngineConfiguration) {
        super(processEngineConfiguration);
    }

    @Override
    public List<HistoricIdentityLinkEntity> findHistoricIdentityLinksByTaskId(Long taskId) {
        QFilter q = new QFilter("taskId", "=", (Object)taskId);
        QFilter q2 = new QFilter("type", "=", (Object)"participant");
        QFilter[] qFilters = new QFilter[]{q, q2};
        EntityQueryBuilder qb = new EntityQueryBuilder(this.getEntityName(), qFilters, this.getSelectFields(), this.getManagedEntityClass());
        return this.getList(qb, this.hisIdentityLinksByTaskIdMatcher, taskId, true);
    }

    @Override
    public List<HistoricIdentityLinkEntity> findHistoricIdentityLinksByTaskIdUserId(Long taskId, Long userId) {
        EntityQueryBuilder queryBuilder = this.createQueryBuilder();
        queryBuilder.addFilter("taskId", "=", taskId);
        queryBuilder.addFilter("userId", "=", userId);
        return this.getList(queryBuilder, this.hisIdentityLinksByTaskIdMatcher, taskId, true);
    }

    @Override
    public List<HistoricIdentityLinkEntity> findHistoricIdentityLinksByParentTaskId(Long parentTaskId) {
        QFilter filter = new QFilter("parenttaskid", "=", (Object)parentTaskId);
        List<HistoricIdentityLinkEntity> entitys = this.findByQueryFilters(new QFilter[]{filter});
        return entitys;
    }

    @Override
    public void deleteHistoricIdentityLinksByTaskId(Long taskId) {
        List<HistoricIdentityLinkEntity> identityLinks = this.findHistoricIdentityLinksByTaskId(taskId);
        for (HistoricIdentityLinkEntity identityLink : identityLinks) {
            this.delete(identityLink);
        }
    }

    @Override
    public void deleteHistoricIdentityLinksByProcInstance(Long processInstanceId) {
        List<HistoricIdentityLinkEntity> identityLinks = this.findHistoricIdentityLinksByProcessInstanceId(processInstanceId);
        for (HistoricIdentityLinkEntity identityLink : identityLinks) {
            this.delete(identityLink);
        }
    }

    @Override
    public HistoricIdentityLinkEntity create(DynamicObject dynamicObject) {
        return new HistoricIdentityLinkEntityImpl(dynamicObject);
    }

    @Override
    public Class<? extends HistoricIdentityLinkEntity> getManagedEntityClass() {
        return HistoricIdentityLinkEntityImpl.class;
    }

    @Override
    public HistoricIdentityLinkEntity create() {
        return new HistoricIdentityLinkEntityImpl();
    }

    @Override
    public List<HistoricIdentityLinkEntity> findHistoricIdentityLinksByProcessInstanceId(Long processInstanceId) {
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter("processInstanceId", processInstanceId);
        return this.findByQueryBuilder(eb);
    }

    @Override
    public List<HistoricIdentityLinkEntity> findHistoricIdentityLinksByTaskUserGroupAndType(Long taskId, Long userId, String type) {
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter("taskId", taskId);
        if (userId > 0L) {
            eb.addFilter("userId", userId);
        }
        if (null != type) {
            eb.addFilter("type", type);
        }
        return this.findByQueryBuilder(eb);
    }

    @Override
    public String getSelectFields() {
        return SELECT_FIELDS;
    }

    @Override
    public String getEntityName() {
        return "wf_hiparticipant";
    }

    @Override
    public String getTableName() {
        return "t_wf_hiparticipant";
    }

    @Override
    public String getMultiLangTableName() {
        return "t_wf_hiparticipant_l";
    }

    @Override
    public List<Long> findParticipantsByParentTaskIdAndSubscribe(Long parentTaskId, boolean subscribe) {
        QFilter pfilter = new QFilter("parenttaskid", "=", (Object)parentTaskId);
        QFilter sfilter = new QFilter("subscribesign", "=", (Object)subscribe);
        List entitys = this.findByQueryFilters(new QFilter[]{pfilter, sfilter}, "userId", null);
        ArrayList<Long> userIds = new ArrayList<Long>(entitys.size());
        for (HistoricIdentityLinkEntity entity : entitys) {
            userIds.add(entity.getUserId());
        }
        return userIds;
    }

    @Override
    @Deprecated
    public List<HistoricIdentityLinkEntity> findDelegateHistoricIdentityLinksByTaskIdAndType(Long taskId, String type) {
        EntityQueryBuilder entityQueryBuilder = this.createQueryBuilder();
        entityQueryBuilder.addFilter("taskId", "=", taskId);
        entityQueryBuilder.addFilter("type", "=", type);
        entityQueryBuilder.addFilter("delegateid", "!=", 0L);
        return this.findByQueryBuilder(entityQueryBuilder);
    }

    @Override
    public List<HistoricIdentityLinkEntity> findParticipantsByTaskIdAndUserId(Long taskId, Long userId, String type, String selectFeilds) {
        List<HistoricIdentityLinkEntity> result = new ArrayList<HistoricIdentityLinkEntity>(10);
        if (WfUtils.isEmpty(taskId) || WfUtils.isEmpty(userId)) {
            return result;
        }
        EntityQueryBuilder entityQueryBuilder = this.createQueryBuilder();
        entityQueryBuilder.addFilter("taskId", "=", taskId);
        entityQueryBuilder.addFilter("userId", "=", userId);
        if (WfUtils.isNotEmpty(type)) {
            entityQueryBuilder.addFilter("type", "=", type);
        }
        if (WfUtils.isNotEmpty(selectFeilds)) {
            entityQueryBuilder.setSelectFields(selectFeilds);
        }
        if (WfUtils.isEmptyForCollection(result = this.findByQueryBuilder(entityQueryBuilder))) {
            result = this.getHistoricProcCompactEntityManager().findHistoricIdentityLinkByTaskIdAndUserId(taskId, userId, type);
        }
        return result;
    }

    @Override
    public List<HistoricIdentityLinkEntity> findByProcInstIds(List<Long> procInstIds, String selectFeilds) {
        List<HistoricIdentityLinkEntity> result = new ArrayList<HistoricIdentityLinkEntity>(10);
        if (WfUtils.isEmptyForCollection(procInstIds)) {
            return result;
        }
        EntityQueryBuilder entityQueryBuilder = this.createQueryBuilder();
        entityQueryBuilder.addFilter("processInstanceId", "in", procInstIds);
        if (WfUtils.isNotEmpty(selectFeilds)) {
            if (!selectFeilds.toLowerCase().contains("processinstanceid")) {
                selectFeilds = String.format("%s,%s", selectFeilds, "processInstanceId");
            }
            entityQueryBuilder.setSelectFields(selectFeilds);
        }
        result = this.findByQueryBuilder(entityQueryBuilder);
        HashSet<Long> procInstIdSet = new HashSet<Long>(procInstIds);
        if (WfUtils.isNotEmptyForCollection(result)) {
            for (HistoricIdentityLinkEntity entity : result) {
                procInstIdSet.remove(entity.getProcessInstanceId());
            }
        }
        if (procInstIdSet.isEmpty()) {
            return result;
        }
        result.addAll(this.getHistoricProcCompactEntityManager().findHistoricIdentityLinkByProcInstIds(procInstIdSet));
        return result;
    }

    @Override
    public List<HistoricIdentityLinkEntity> findByProcInstIdAndTypeAndTrustNameNotNull(Long processInstanceId, String type, String selectFeilds) {
        List<HistoricIdentityLinkEntity> result = new ArrayList<HistoricIdentityLinkEntity>(10);
        if (WfUtils.isEmpty(processInstanceId) || WfUtils.isEmpty(type)) {
            return result;
        }
        EntityQueryBuilder entityQueryBuilder = this.createQueryBuilder();
        entityQueryBuilder.addFilter("processInstanceId", "=", processInstanceId);
        entityQueryBuilder.addFilter("type", "=", type);
        entityQueryBuilder.addFilter("trustname", "!=", " ");
        if (WfUtils.isNotEmpty(selectFeilds)) {
            entityQueryBuilder.setSelectFields(selectFeilds);
        }
        if (WfUtils.isEmptyForCollection(result = this.findByQueryBuilder(entityQueryBuilder))) {
            result = this.getHistoricProcCompactEntityManager().findByProcInstIdAndTypeAndTrustNameNotNull(processInstanceId, type);
        }
        return result;
    }

    @Override
    public List<HistoricIdentityLinkEntity> findByProcInstIdAndType(Long processInstanceId, String type) {
        List<HistoricIdentityLinkEntity> result = new ArrayList<HistoricIdentityLinkEntity>(10);
        if (WfUtils.isEmpty(processInstanceId) || WfUtils.isEmpty(type)) {
            return result;
        }
        EntityQueryBuilder entityQueryBuilder = this.createQueryBuilder();
        entityQueryBuilder.addFilter("processInstanceId", "=", processInstanceId);
        entityQueryBuilder.addFilter("type", "=", type);
        result = this.findByQueryBuilder(entityQueryBuilder);
        if (WfUtils.isEmptyForCollection(result)) {
            result = this.getHistoricProcCompactEntityManager().findByProcInstIdAndType(processInstanceId, type);
        }
        return result;
    }

    @Override
    public List<HistoricIdentityLinkEntity> findParticipantsByTaskIdAndType(Long taskId, String type) {
        List<HistoricIdentityLinkEntity> result = new ArrayList<HistoricIdentityLinkEntity>(10);
        if (WfUtils.isEmpty(taskId) || WfUtils.isEmpty(type)) {
            return result;
        }
        EntityQueryBuilder entityQueryBuilder = this.createQueryBuilder();
        entityQueryBuilder.addFilter("taskId", "=", taskId);
        entityQueryBuilder.addFilter("type", "=", type);
        result = this.findByQueryBuilder(entityQueryBuilder);
        if (WfUtils.isEmptyForCollection(result)) {
            result = this.getHistoricProcCompactEntityManager().findParticipantsByTaskIdAndType(taskId, type);
        }
        return result;
    }

    @Override
    public List<HistoricIdentityLinkEntity> findParticipantsByTaskId(Long taskId, String selectFeilds, String orderBy) {
        List<HistoricIdentityLinkEntity> result = new ArrayList<HistoricIdentityLinkEntity>(10);
        if (WfUtils.isEmpty(taskId)) {
            return result;
        }
        EntityQueryBuilder entityQueryBuilder = this.createQueryBuilder();
        entityQueryBuilder.addFilter("taskId", "=", taskId);
        if (WfUtils.isNotEmpty(selectFeilds)) {
            entityQueryBuilder.setSelectFields(selectFeilds);
        }
        if (WfUtils.isNotEmpty(orderBy)) {
            entityQueryBuilder.orderBy(orderBy);
        }
        if (WfUtils.isEmptyForCollection(result = this.findByQueryBuilder(entityQueryBuilder))) {
            result = this.getHistoricProcCompactEntityManager().findParticipantsByTaskId(taskId, orderBy);
        }
        return result;
    }

    @Override
    public List<HistoricIdentityLinkEntity> findParticipantsByParentTaskId(Long parentTaskId, Long userId) {
        List<HistoricIdentityLinkEntity> result = new ArrayList<HistoricIdentityLinkEntity>(10);
        if (WfUtils.isEmpty(parentTaskId) || WfUtils.isEmpty(userId)) {
            return result;
        }
        EntityQueryBuilder entityQueryBuilder = this.createQueryBuilder();
        entityQueryBuilder.addFilter("parentTaskId", "=", parentTaskId);
        entityQueryBuilder.addFilter("userId", "=", userId);
        result = this.findByQueryBuilder(entityQueryBuilder);
        if (WfUtils.isEmptyForCollection(result)) {
            result = this.getHistoricProcCompactEntityManager().findParticipantsByParentTaskId(parentTaskId, userId);
        }
        return result;
    }

    @Override
    public List<HistoricIdentityLinkEntity> findParticipantsByTaskIds(Long procInstId, List<Long> taskIds) {
        List<HistoricIdentityLinkEntity> result = new ArrayList<HistoricIdentityLinkEntity>(10);
        if (WfUtils.isEmpty(procInstId) || WfUtils.isEmptyForCollection(taskIds)) {
            return result;
        }
        EntityQueryBuilder entityQueryBuilder = this.createQueryBuilder();
        entityQueryBuilder.addFilter("processInstanceId", "=", procInstId);
        entityQueryBuilder.addFilter("taskId", "in", taskIds);
        result = this.findByQueryBuilder(entityQueryBuilder);
        if (WfUtils.isEmptyForCollection(result)) {
            result = this.getHistoricProcCompactEntityManager().findParticipantsByTaskIds(procInstId, taskIds);
        }
        return result;
    }

    @Override
    public List<HistoricIdentityLinkEntity> findNotDelegateParticipantsByTaskIdsAndType(Long procInstId, Set<Long> taskIds, String type) {
        List<HistoricIdentityLinkEntity> result = new ArrayList<HistoricIdentityLinkEntity>(10);
        if (WfUtils.isEmpty(procInstId) || WfUtils.isEmptyForCollection(taskIds) || WfUtils.isEmpty(type)) {
            return result;
        }
        EntityQueryBuilder entityQueryBuilder = this.createQueryBuilder();
        entityQueryBuilder.addFilter("taskId", "in", taskIds);
        entityQueryBuilder.addFilter("type", "=", type);
        entityQueryBuilder.addFilter("delegateid", "=", 0L);
        result = this.findByQueryBuilder(entityQueryBuilder);
        if (WfUtils.isEmptyForCollection(result)) {
            result = this.getHistoricProcCompactEntityManager().findNotDelegateParticipantsByTaskIdsAndType(procInstId, taskIds, type);
        }
        return result;
    }

    @Override
    public List<HistoricIdentityLinkEntity> findParticipantsByTaskIdAndOwnerId(Long procInstId, Long taskId, Long ownerId, String type, String selectFeilds) {
        List<HistoricIdentityLinkEntity> result = new ArrayList<HistoricIdentityLinkEntity>(10);
        if (WfUtils.isEmpty(taskId) || WfUtils.isEmpty(ownerId)) {
            return result;
        }
        EntityQueryBuilder entityQueryBuilder = this.createQueryBuilder();
        entityQueryBuilder.addFilter("taskId", "=", taskId);
        entityQueryBuilder.addFilter("ownerId", "=", ownerId);
        if (WfUtils.isNotEmpty(type)) {
            entityQueryBuilder.addFilter("type", "=", type);
        }
        if (WfUtils.isNotEmpty(selectFeilds)) {
            entityQueryBuilder.setSelectFields(selectFeilds);
        }
        if (WfUtils.isEmptyForCollection(result = this.findByQueryBuilder(entityQueryBuilder))) {
            result = this.getHistoricProcCompactEntityManager().findParticipantsByTaskIdAndOwnerId(procInstId, taskId, ownerId, type);
        }
        return result;
    }
}

