/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.persistence.entity.history;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.message.utils.MessageSystemParamterUtils;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.bpmn.helper.BPMNUtil;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcessInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricScopeInstanceEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricVariableInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.DurationDetailEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.util.workCalendar.WorkCalendarUtil;

public class HistoricProcessInstanceEntityImpl
extends HistoricScopeInstanceEntityImpl
implements HistoricProcessInstanceEntity {
    private static final long serialVersionUID = 1L;
    protected String processDefinitionKey;
    protected String processDefinitionName;
    protected Integer processDefinitionVersion;
    protected Long deploymentId;
    protected List<HistoricVariableInstanceEntity> queryVariables;

    public HistoricProcessInstanceEntityImpl() {
    }

    public HistoricProcessInstanceEntityImpl(DynamicObject dynamicObject) {
        super(dynamicObject);
    }

    public HistoricProcessInstanceEntityImpl(ExecutionEntity processInstance) {
        this.dynamicObject.set("id", (Object)processInstance.getId());
        this.dynamicObject.set("processInstanceId", (Object)processInstance.getId());
        this.dynamicObject.set("businessKey", (Object)processInstance.getBusinessKey());
        this.dynamicObject.set("processDefinitionId", (Object)processInstance.getProcessDefinitionId());
        this.processDefinitionKey = processInstance.getProcessDefinitionKey();
        this.processDefinitionName = processInstance.getProcessDefinitionName();
        this.processDefinitionVersion = processInstance.getProcessDefinitionVersion();
        this.deploymentId = processInstance.getDeploymentId();
        this.dynamicObject.set("startActivityId", (Object)processInstance.getActivityId());
        this.dynamicObject.set("superProcessInstanceId", processInstance.getSuperExecution() != null ? processInstance.getSuperExecution().getProcessInstanceId() : null);
        this.dynamicObject.set("rootProcessInstanceId", (Object)processInstance.getRootProcessInstanceId());
        this.dynamicObject.set("entraBillName", (Object)processInstance.getEntraBillName());
        this.dynamicObject.set("name", (Object)processInstance.getName());
        this.dynamicObject.set("starUserNameFormat", (Object)processInstance.getStarUserNameFormat());
        this.dynamicObject.set("businessId", (Object)processInstance.getBusinessId());
        this.dynamicObject.set("biztraceno", (Object)processInstance.getBizTraceNo());
        this.dynamicObject.set("processtype", (Object)processInstance.getProcessType());
        this.dynamicObject.set("mainOrgId", (Object)processInstance.getMainOrgId());
        this.dynamicObject.set("orgviewid", (Object)processInstance.getOrgViewId());
        if (this.getStartUserId() == null) {
            this.dynamicObject.set("startName", (Object)WfUtils.subILocaleString(WfUtils.findUserName(processInstance.getStartUserId()), 190));
            this.dynamicObject.set("startUserId", (Object)processInstance.getStartUserId());
        }
        this.dynamicObject.set("billno", (Object)processInstance.getBillNo());
        this.dynamicObject.set("entitynumber", (Object)processInstance.getEntityNumber());
        this.dynamicObject.set("mainOrgId", (Object)processInstance.getMainOrgId());
        this.dynamicObject.set("orgviewid", (Object)processInstance.getOrgViewId());
        this.dynamicObject.set("creatorid", (Object)processInstance.getCreatorId());
        this.dynamicObject.set("modifierid", (Object)processInstance.getModifierId());
        this.dynamicObject.set("schemeId", (Object)processInstance.getSchemeId());
        if (WfUtils.isNotEmpty(processInstance.getTestingPlanId())) {
            this.dynamicObject.set("testingPlanId", (Object)processInstance.getTestingPlanId());
        }
        if ("bybillname".equals(MessageSystemParamterUtils.getTaskType())) {
            this.dynamicObject.set("billType", (Object)processInstance.getEntityNumber());
        } else {
            this.dynamicObject.set("billType", (Object)processInstance.getBillType());
        }
        this.dynamicObject.set("businessId", (Object)processInstance.getBusinessId());
        this.dynamicObject.set("starUserNameFormat", (Object)WfUtils.subILocaleString(processInstance.getStarUserNameFormat(), 490));
    }

    @Override
    public String getDynObjTypeName() {
        return "wf_hiprocinst";
    }

    @Override
    public void calRealDuration() {
        ProcessEngineConfigurationImpl processEngineConfigurationImpl = Context.getProcessEngineConfiguration();
        DurationDetailEntityManager durationDetailEntityManager = processEngineConfigurationImpl.getDurationDetailEntityManager();
        Long suspendTime = durationDetailEntityManager.getSuspendDurationForUndoSuspendedByProcInstId(this.getId());
        long realDurationInMillis = 0L;
        if (WfConfigurationUtil.getIsOpenWorkCalendar() && WfConfigurationUtil.enableWorkCalendar()) {
            Date endDate;
            Date createDate = this.getCreateDate();
            Long workCalendarDuration = WorkCalendarUtil.getRealDuration(createDate, endDate = processEngineConfigurationImpl.getClock().getCurrentTime());
            if (workCalendarDuration > suspendTime) {
                realDurationInMillis = workCalendarDuration - suspendTime;
            }
        } else {
            Long durationInMillis = this.getDurationInMillis();
            if (durationInMillis > suspendTime) {
                realDurationInMillis = durationInMillis - suspendTime;
            }
        }
        this.setRealDurationInMillis(realDurationInMillis);
    }

    @Override
    public Object getPersistentState() {
        Map persistentState = (Map)super.getPersistentState();
        persistentState.put("businessKey", this.getBusinessKey());
        persistentState.put("name", this.getName());
        persistentState.put("endActivityId", this.getEndActivityId());
        persistentState.put("superProcessInstanceId", this.getSuperProcessInstanceId());
        persistentState.put("processDefinitionId", this.getProcessDefinitionId());
        persistentState.put("subject", this.getSubject());
        persistentState.put("activityName", this.getActivityName());
        persistentState.put("entraBillName", this.getEntraBillName());
        persistentState.put("startActivityId", this.getStartActivityId());
        persistentState.put("description", this.getDescription());
        persistentState.put("schemeId", this.getSchemeId());
        persistentState.put("testingPlanId", this.getTestingPlanId());
        persistentState.put("businessId", this.getBusinessId());
        persistentState.put("fstartnameformat", this.getStarUserNameFormat());
        persistentState.put("biztraceno", this.getBizTraceNo());
        persistentState.put("processtype", this.getProcessType());
        persistentState.put("mainOrgId", this.getMainOrgId());
        persistentState.put("orgviewid", this.getOrgViewId());
        persistentState.put("rootProcessInstanceId", this.getRootProcessInstanceId());
        return persistentState;
    }

    @Override
    @SimplePropertyAttribute(name="endActivityId")
    public String getEndActivityId() {
        return this.dynamicObject.getString("endActivityId");
    }

    @Override
    public void setEndActivityId(String endActivityId) {
        this.dynamicObject.set("endActivityId", (Object)endActivityId);
    }

    @Override
    @SimplePropertyAttribute(name="businessKey")
    public String getBusinessKey() {
        return this.dynamicObject.getString("businessKey");
    }

    @Override
    public void setBusinessKey(String businessKey) {
        this.dynamicObject.set("businessKey", (Object)businessKey);
    }

    @Override
    @SimplePropertyAttribute(name="startUserId")
    public final Long getStartUserId() {
        return this.normalizeId(this.dynamicObject.getLong("startUserId"));
    }

    @Override
    public void setStartUserId(Long startUserId) {
        this.dynamicObject.set("startUserId", (Object)startUserId);
    }

    @Override
    @SimplePropertyAttribute(name="startActivityId")
    public String getStartActivityId() {
        return this.dynamicObject.getString("startActivityId");
    }

    @Override
    public void setStartActivityId(String startActivityId) {
        this.dynamicObject.set("startActivityId", (Object)startActivityId);
    }

    @Override
    @SimplePropertyAttribute(name="superProcessInstanceId")
    public Long getSuperProcessInstanceId() {
        return this.normalizeId(this.dynamicObject.getLong("superProcessInstanceId"));
    }

    @Override
    public void setSuperProcessInstanceId(Long superProcessInstanceId) {
        this.dynamicObject.set("superProcessInstanceId", (Object)superProcessInstanceId);
    }

    @Override
    public void setRootProcessInstanceId(Long rootProcessInstanceId) {
        this.dynamicObject.set("rootProcessInstanceId", (Object)rootProcessInstanceId);
    }

    @Override
    public Long getRootProcessInstanceId() {
        return this.dynamicObject.getLong("rootProcessInstanceId");
    }

    @Override
    @SimplePropertyAttribute(name="billno")
    public String getBillNo() {
        return this.dynamicObject.getString("billno");
    }

    @Override
    public void setBillNo(String billNo) {
        this.dynamicObject.set("billno", (Object)billNo);
    }

    @Override
    @SimplePropertyAttribute(name="entitynumber")
    public String getEntitynumber() {
        return this.dynamicObject.getString("entitynumber");
    }

    @Override
    public void setEntitynumber(String entitynumber) {
        this.dynamicObject.set("entitynumber", (Object)entitynumber);
    }

    @Override
    @SimplePropertyAttribute(name="name")
    public ILocaleString getName() {
        return this.dynamicObject.getLocaleString("name");
    }

    @Override
    public void setName(ILocaleString name) {
        this.dynamicObject.set("name", (Object)WfUtils.subILocaleString(name, 490));
    }

    @Override
    @SimplePropertyAttribute(name="description")
    public ILocaleString getDescription() {
        return this.dynamicObject.getLocaleString("description");
    }

    @Override
    public void setActivityName(ILocaleString activityName) {
        this.dynamicObject.set("activityName", (Object)activityName);
    }

    @Override
    @SimplePropertyAttribute(name="activityName")
    public ILocaleString getActivityName() {
        return this.dynamicObject.getLocaleString("activityName");
    }

    @Override
    public void setSubject(ILocaleString subject) {
        this.dynamicObject.set("subject", (Object)BPMNUtil.subStringSubject(subject));
    }

    @Override
    @SimplePropertyAttribute(name="subject")
    public ILocaleString getSubject() {
        return this.dynamicObject.getLocaleString("subject");
    }

    @Override
    public void setEntraBillName(ILocaleString entraBillName) {
        this.dynamicObject.set("entraBillName", (Object)entraBillName);
    }

    @Override
    @SimplePropertyAttribute(name="entraBillName")
    public ILocaleString getEntraBillName() {
        return this.dynamicObject.getLocaleString("entraBillName");
    }

    @Override
    public void setDescription(ILocaleString description) {
        this.dynamicObject.set("description", (Object)description);
    }

    @Override
    public String getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    @Override
    public void setProcessDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
    }

    @Override
    public String getProcessDefinitionName() {
        return this.processDefinitionName;
    }

    @Override
    public void setProcessDefinitionName(String processDefinitionName) {
        this.processDefinitionName = processDefinitionName;
    }

    @Override
    public Integer getProcessDefinitionVersion() {
        return this.processDefinitionVersion;
    }

    @Override
    public void setProcessDefinitionVersion(Integer processDefinitionVersion) {
        this.processDefinitionVersion = processDefinitionVersion;
    }

    @Override
    public Long getDeploymentId() {
        return this.deploymentId;
    }

    @Override
    public void setDeploymentId(Long deploymentId) {
        this.deploymentId = deploymentId;
    }

    @Override
    public Map<String, Object> getProcessVariables() {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        if (this.queryVariables != null) {
            for (HistoricVariableInstanceEntity variableInstance : this.queryVariables) {
                if (variableInstance.getId() == null || variableInstance.getTaskId() != null) continue;
                variables.put(variableInstance.getName(), variableInstance.getValue());
            }
        }
        return variables;
    }

    public String toString() {
        return "HistoricProcessInstanceEntity[superProcessInstanceId=" + this.getSuperProcessInstanceId() + "]";
    }

    @Override
    public void setSchemeId(Long schemeId) {
        this.dynamicObject.set("schemeId", (Object)schemeId);
    }

    @Override
    @SimplePropertyAttribute(name="schemeId")
    public Long getSchemeId() {
        return this.normalizeId(this.dynamicObject.getLong("schemeId"));
    }

    @Override
    public void setMainOrgId(Long mainOrgId) {
        this.dynamicObject.set("mainOrgId", (Object)mainOrgId);
    }

    @Override
    @SimplePropertyAttribute(name="mainOrgId")
    public Long getMainOrgId() {
        return this.normalizeId(this.dynamicObject.getLong("mainOrgId"));
    }

    @Override
    @SimplePropertyAttribute(name="orgviewid")
    public String getOrgViewId() {
        return this.dynamicObject.getString("orgviewid");
    }

    @Override
    public void setOrgViewId(String orgViewId) {
        this.dynamicObject.set("orgviewid", (Object)orgViewId);
    }

    @Override
    @SimplePropertyAttribute(name="startName")
    public ILocaleString getStartName() {
        return this.dynamicObject.getLocaleString("startName");
    }

    @Override
    public void setStartName(ILocaleString startName) {
        this.dynamicObject.set("startName", (Object)WfUtils.subILocaleString(startName, 190));
    }

    @Override
    public void setTestingPlanId(Long testingPlanId) {
        this.dynamicObject.set("testingPlanId", (Object)testingPlanId);
    }

    @Override
    @SimplePropertyAttribute(name="testingPlanId")
    public Long getTestingPlanId() {
        return this.normalizeId(this.dynamicObject.getLong("testingPlanId"));
    }

    @Override
    @SimplePropertyAttribute(name="creatorid")
    public Long getCreatorId() {
        Object creator = this.dynamicObject.get("creatorid");
        if (creator instanceof DynamicObject) {
            return this.normalizeId(((DynamicObject)creator).getLong("id"));
        }
        return this.normalizeId(this.dynamicObject.getLong("creatorid"));
    }

    @Override
    public void setCreatorId(Long creatorId) {
        this.dynamicObject.set("creatorid", (Object)creatorId);
    }

    @Override
    @SimplePropertyAttribute(name="modifierid")
    public Long getModifierId() {
        Object modifier = this.dynamicObject.get("modifierid");
        if (modifier instanceof DynamicObject) {
            return this.normalizeId(((DynamicObject)modifier).getLong("id"));
        }
        return this.normalizeId(this.dynamicObject.getLong("modifierid"));
    }

    @Override
    public void setModifierId(Long modifierId) {
        this.dynamicObject.set("modifierid", (Object)modifierId);
    }

    @Override
    @SimplePropertyAttribute(name="endtype")
    public String getEndType() {
        return this.dynamicObject.getString("endtype");
    }

    @Override
    public void setEndType(String endType) {
        this.dynamicObject.set("endtype", (Object)endType);
    }

    @Override
    @SimplePropertyAttribute(name="biztraceno")
    public String getBizTraceNo() {
        return this.dynamicObject.getString("biztraceno");
    }

    @Override
    public void setBizTraceNo(String bizTraceNo) {
        this.dynamicObject.set("biztraceno", (Object)bizTraceNo);
    }

    @Override
    @SimplePropertyAttribute(name="processtype")
    public String getProcessType() {
        return this.dynamicObject.getString("processtype");
    }

    @Override
    public void setProcessType(String processType) {
        this.dynamicObject.set("processtype", (Object)processType);
    }

    @Override
    @SimplePropertyAttribute(name="billType")
    public String getBillType() {
        return this.dynamicObject.getString("billType");
    }

    @Override
    public void setBillType(String billType) {
        this.dynamicObject.set("billType", (Object)billType);
    }

    @Override
    public String getBusinessId() {
        return this.dynamicObject.getString("businessId");
    }

    @Override
    public void setBusinessId(String businessId) {
        this.dynamicObject.set("businessId", (Object)businessId);
    }

    @Override
    @SimplePropertyAttribute(name="starUserNameFormat")
    public ILocaleString getStarUserNameFormat() {
        return this.dynamicObject.getLocaleString("starUserNameFormat");
    }

    @Override
    public void setStarUserNameFormat(ILocaleString starUserNameFormat) {
        this.dynamicObject.set("starUserNameFormat", (Object)WfUtils.subILocaleString(starUserNameFormat, 490));
    }

    @Override
    @SimplePropertyAttribute(name="priorityshow")
    public String getPriorityShow() {
        return this.dynamicObject.getString("priorityshow");
    }

    @Override
    public void setPriorityShow(String priorityShow) {
        this.dynamicObject.set("priorityshow", (Object)priorityShow);
    }
}

