/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.persistence.entity.history;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.engine.WFMultiLangConstants;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.history.HistoricProcessInstance;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.cmd.task.dataquery.params.EntityQueryParams;
import kd.bos.workflow.engine.impl.db.EntityQueryBuilder;
import kd.bos.workflow.engine.impl.persistence.entity.AbstractEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelType;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcessInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcessInstanceEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcessInstanceEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.history.separatestorage.collector.HistoricProcessInstanceCollector;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.service.impl.ThreadLocalVariables;

public class HistoricProcessInstanceEntityManagerImpl
extends AbstractEntityManager<HistoricProcessInstanceEntity>
implements HistoricProcessInstanceEntityManager {
    private HistoricProcessInstanceCollector historicProcessInstanceCollector = new HistoricProcessInstanceCollector();
    private static final String ENTRABILLNAME = "entrabillname";

    public HistoricProcessInstanceEntityManagerImpl(ProcessEngineConfigurationImpl processEngineConfiguration) {
        super(processEngineConfiguration);
    }

    @Override
    public Class<? extends HistoricProcessInstanceEntity> getManagedEntityClass() {
        return HistoricProcessInstanceEntityImpl.class;
    }

    @Override
    public String getSelectFields() {
        return "id,processDefinitionId,processInstanceId,businessKey,endTime,durationInMillis,startUserId,deleteReason,billno,entitynumber,startActivityId,endActivityId,superProcessInstanceId,name,description,createDate,modifyDate,subject,activityname,entrabillname,mainOrgId,schemeId,testingPlanId,realDurationInMillis,endType,creatorid,modifierid,startName,biztraceno,billtype,businessId,processtype,biztraceno,orgviewid,starusernameformat,priorityshow,rootprocessinstanceid";
    }

    @Override
    public HistoricProcessInstanceEntity create(ExecutionEntity processInstanceExecutionEntity) {
        return new HistoricProcessInstanceEntityImpl(processInstanceExecutionEntity);
    }

    @Override
    public void deleteHistoricProcessInstanceByProcessDefinitionId(Long processDefinitionId) {
        if (this.getHistoryManager().isHistoryEnabled()) {
            ArrayList<Long> historicProcessInstanceIds = new ArrayList<Long>();
            QFilter filter = new QFilter("processDefinitionId", "=", (Object)processDefinitionId);
            QFilter[] filters = new QFilter[]{filter};
            try (DataSet cc = QueryServiceHelper.queryDataSet((String)this.createAlgoKey(), (String)this.getEntityName(), (String)"id", (QFilter[])filters, null);){
                if (cc != null) {
                    Iterator iter = cc.iterator();
                    while (iter.hasNext()) {
                        historicProcessInstanceIds.add((Long)((Row)iter.next()).get("id"));
                    }
                }
            }
            for (Long historicProcessInstanceId : historicProcessInstanceIds) {
                this.delete(historicProcessInstanceId);
            }
        }
    }

    @Override
    public void delete(Long historicProcessInstanceId) {
        if (this.getHistoryManager().isHistoryEnabled()) {
            HistoricProcessInstanceEntity historicProcessInstance = (HistoricProcessInstanceEntity)this.findById(historicProcessInstanceId);
            this.getHistoricVariableInstanceEntityManager().deleteHistoricVariableInstanceByProcessInstanceId(historicProcessInstanceId);
            this.getHistoricActivityInstanceEntityManager().deleteHistoricActivityInstancesByProcessInstanceId(historicProcessInstanceId);
            this.getHistoricTaskInstanceEntityManager().deleteHistoricTaskInstancesByProcessInstanceId(historicProcessInstanceId);
            this.getHistoricIdentityLinkEntityManager().deleteHistoricIdentityLinksByProcInstance(historicProcessInstanceId);
            this.getCommentEntityManager().deleteCommentsByProcessInstanceId(historicProcessInstanceId);
            this.getHistoricProcCompactEntityManager().deleteHistoricActInstWideEntityByProcInstId(historicProcessInstanceId);
            this.getHistoricTrdDataSourceRecordEntityManager().deleteHistoricTrdDataSourceRecordByProcessInstanceId(historicProcessInstanceId);
            this.delete(historicProcessInstance, false);
            EntityQueryBuilder eb = this.createQueryBuilder().addFilter("superProcessInstanceId", historicProcessInstanceId);
            List selectList = this.findByQueryBuilder(eb);
            for (HistoricProcessInstanceEntity child : selectList) {
                this.delete(child.getId());
            }
        }
    }

    @Override
    public HistoricProcessInstance findLatestHistoricProcessInstanceByBusinessKey(String businessKey) {
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter("businessKey", businessKey).addFilter("endType", "!=", "20").addFilter("superProcessInstanceId", "=", 0).orderBy("createDate desc ");
        List list = this.findByQueryBuilder(eb);
        return list != null && !list.isEmpty() ? (HistoricProcessInstance)list.get(0) : null;
    }

    @Override
    public HistoricProcessInstance findLatestHiprocinstByBusinessKeyAndEntityNumber(String businessKey, String entityNumber) {
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter("businessKey", businessKey).addFilter("entitynumber", entityNumber).addFilter("endType", "!=", "20").addFilter("superProcessInstanceId", "=", 0).orderBy("createDate desc ");
        List list = this.findByQueryBuilder(eb);
        return list != null && !list.isEmpty() ? (HistoricProcessInstance)list.get(0) : null;
    }

    @Override
    public HistoricProcessInstance findLatestHiprocinstByEntityNumberAndPkAndProcDefId(String entityNumber, String businessKey, Long processDefinitionId) {
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter("businessKey", businessKey).addFilter("processDefinitionId", processDefinitionId).addFilter("superProcessInstanceId", "=", 0).addFilter("endType", "!=", "20").addFilter("entitynumber", entityNumber).orderBy("createDate desc ");
        List list = this.findByQueryBuilder(eb);
        return list != null && !list.isEmpty() ? (HistoricProcessInstance)list.get(0) : null;
    }

    @Override
    public HistoricProcessInstance findLatestAuditHiprocinstByBusinessKeyAndEntityNumber(String businessKey, String entityNumber) {
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter("businessKey", businessKey).addFilter("entitynumber", entityNumber).addFilter("processType", ModelType.AuditFlow.name()).addFilter("endType", "!=", "20").addFilter("superProcessInstanceId", "=", 0).orderBy("createDate desc ");
        List list = this.findByQueryBuilder(eb);
        return list != null && !list.isEmpty() ? (HistoricProcessInstance)list.get(0) : null;
    }

    @Override
    public List<HistoricProcessInstanceEntity> findLatestHistoricProcessInstanceByBusinessKeyWithSubPro(String businessKey, Boolean includeSubPro) {
        ArrayList<HistoricProcessInstanceEntity> list = new ArrayList<HistoricProcessInstanceEntity>();
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter("businessKey", businessKey).addFilter("endType", "!=", "20").orderBy("createDate desc ");
        List res = this.findByQueryBuilder(eb);
        if (res.size() == 0) {
            return null;
        }
        LinkedHashMap<Long, HistoricProcessInstanceEntity> hiProIns = new LinkedHashMap<Long, HistoricProcessInstanceEntity>(res.size());
        for (HistoricProcessInstanceEntity historicProcessInstance : res) {
            hiProIns.put(historicProcessInstance.getProcessInstanceId(), historicProcessInstance);
        }
        for (HistoricProcessInstanceEntity historicProcessInstanceEntity : res) {
            String processType = historicProcessInstanceEntity.getProcessType();
            if ("BizFlow".equals(processType)) continue;
            Long superProcessInsId = historicProcessInstanceEntity.getSuperProcessInstanceId();
            if (includeSubPro.booleanValue()) {
                list.add(historicProcessInstanceEntity);
                continue;
            }
            if (superProcessInsId == 0L) {
                list.add(historicProcessInstanceEntity);
                break;
            }
            if (hiProIns.get(superProcessInsId) == null || !"BizFlow".equals(((HistoricProcessInstanceEntity)hiProIns.get(superProcessInsId)).getProcessType())) continue;
            list.add(historicProcessInstanceEntity);
        }
        return list;
    }

    @Override
    public String getEntityName() {
        return "wf_hiprocinst";
    }

    @Override
    public String getTableName() {
        return "t_wf_hiprocinst";
    }

    @Override
    public String getMultiLangTableName() {
        return "t_wf_hiprocinst_l";
    }

    @Override
    public DynamicObjectCollection getHiProinstanceByStartuserid(String uid, String billType, String entityNumber, int start, int limit, String filterSql, List<Object> paramsList, String orderBy) {
        try (DataSet ds = this.historicProcessInstanceCollector.getHiProinstanceByStartuserid(uid, billType, entityNumber, start, limit, filterSql, paramsList, orderBy);){
            if (ds == null) {
                DynamicObjectCollection dynamicObjectCollection = new DynamicObjectCollection(new DynamicObjectType("PlainObject"), null);
                return dynamicObjectCollection;
            }
            DynamicObjectCollection dynamicObjectCollection = ORM.create().toPlainDynamicObjectCollection(ds);
            return dynamicObjectCollection;
        }
    }

    @Override
    public long getHiProinstanceCountByStartuserid(String uid, String billType, String entityNumber, String filterSql, List<Object> paramsList) {
        return this.innerGetCount(billType, entityNumber, filterSql, paramsList, uid);
    }

    @Override
    public long getHiProinstanceUnionCountByStartuserid(String uid, String billType, String entityNumber, String filterSql, List<Object> paramsList) {
        return this.innerGetUnionCount(billType, entityNumber, filterSql, paramsList, uid, false);
    }

    @Override
    public DynamicObjectCollection getHiProinstances(String billType, String entityNumber, int start, int limit, String filterSql, List<Object> paramsList, String orderBy, boolean isAuditFlow) {
        String lang = RequestContext.get().getLang().toString();
        String masterTableAlias = "a";
        String multiLangTableAlias = "b";
        String entraBillNameSQL = WfMultiLangUtils.getGeneralLangSQL(this.getEntityName(), masterTableAlias, multiLangTableAlias, "fentrabillname", "entrabillnameshow", ENTRABILLNAME);
        String startNameSQL = WfMultiLangUtils.getGeneralLangSQL(this.getEntityName(), masterTableAlias, multiLangTableAlias, "fstartname", "startname", "startname");
        String startNameFormatSQL = WfMultiLangUtils.getGeneralLangSQL(this.getEntityName(), masterTableAlias, multiLangTableAlias, "fstarusernameformat", "starusernameformat", "starusernameformat");
        String subjectSQL = WfMultiLangUtils.getGeneralLangSQL(this.getEntityName(), masterTableAlias, multiLangTableAlias, "fsubject", "subjectshow", "subject");
        String nameSQL = WfMultiLangUtils.getGeneralLangSQL(this.getEntityName(), masterTableAlias, multiLangTableAlias, "fname", "proandversion", "name");
        StringBuilder sql = new StringBuilder("select top ").append(start + limit);
        sql.append(" a.FID id, a.fprocesstype processtype,");
        sql.append(entraBillNameSQL);
        sql.append(',');
        boolean isDisplaySetting = WfConfigurationUtil.isDisplaySetting();
        if (isDisplaySetting) {
            startNameSQL = "(case when b.fstarusernameformat is not null and b.fstarusernameformat != ' ' then b.fstarusernameformat when a.fstarusernameformat is not null and a.fstarusernameformat != ' ' then a.fstarusernameformat when b.fstartname is not null and b.fstartname != ' ' then b.fstartname else a.fstartname end) as startname";
        }
        sql.append(startNameSQL);
        sql.append(',');
        sql.append(startNameFormatSQL);
        sql.append(',');
        sql.append(subjectSQL);
        sql.append(",a.fcreatedate createdate,a.FEndTime endtime, a.fbusinessid businessid,");
        sql.append(" a.frealduration realduration,a.fduration duration,");
        boolean isOpenWorkCalendar = WfConfigurationUtil.getIsOpenWorkCalendar();
        String hour = ResManager.loadKDString((String)"\u5c0f\u65f6", (String)"HistoricProcessInstanceEntityManagerImpl_1", (String)"bos-wf-engine", (Object[])new Object[0]);
        if (isOpenWorkCalendar && WfConfigurationUtil.enableWorkCalendar()) {
            sql.append(String.format(" concat(round(a.frealduration/3600/1000.0,2), '%s') handletime,", hour));
        } else {
            sql.append(String.format(" concat(round(a.fduration/3600/1000.0,2), '%s') handletime,", hour));
        }
        sql.append(nameSQL);
        sql.append(" from ").append(this.getTableName()).append(" a ");
        sql.append(" left join ").append(this.getMultiLangTableName()).append(" b on a.fid = b.fid and b.flocaleid = ? ");
        sql.append(" where a.fendtype<>'20' ");
        sql.append(" AND a.fendtime is not null ");
        if (isAuditFlow) {
            sql.append(" and a.fprocesstype = '").append(ModelType.AuditFlow.name()).append("'");
        } else {
            sql.append(" and a.fprocesstype != '").append(ModelType.NoCodeFlow.name()).append("'");
        }
        sql.append(WfUtils.isEmpty(billType) ? "" : " and a.fbilltype = ? ");
        sql.append(WfUtils.isEmpty(entityNumber) ? "" : " and a.fentitynumber = ? ");
        sql.append(WfUtils.isNotEmpty(filterSql) ? filterSql : " ");
        if (orderBy == null || orderBy.equals("")) {
            sql.append(" order by a.fendtime desc ");
        } else {
            sql.append(" order by ").append(orderBy);
        }
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(lang);
        if (WfUtils.isNotEmpty(billType)) {
            params.add(billType);
        }
        if (WfUtils.isNotEmpty(entityNumber)) {
            params.add(entityNumber);
        }
        params.addAll(paramsList);
        try (DataSet ds = DB.queryDataSet((String)"WfTaskCenter.t_wf_hiprocinst.queryGridData", (DBRoute)WfUtils.WFS, (String)sql.toString(), (Object[])params.toArray());){
            DynamicObjectCollection dynamicObjectCollection = ORM.create().toPlainDynamicObjectCollection(ds, start, limit);
            return dynamicObjectCollection;
        }
    }

    @Override
    public DynamicObjectCollection getViewBillsData(String billType, String processInstanceId, int start, int limit, String filterSql, List<Object> paramsList, String orderBy) {
        Long procInstId = Long.valueOf(processInstanceId);
        long count = this.getCirculateRelationEntityManager().countByFilter("id", new QFilter[]{new QFilter("procinstid", "=", (Object)procInstId)}, false);
        StringBuilder sql = new StringBuilder("select top ").append(start + limit);
        sql.append("a.fid id,a.fbusinesskey businesskey, a.fentitynumber entitynumber,a.factid entrabillnameshow,a.fbillno startname,a.fstatus subjectshow,");
        sql.append("a.fcreatedate createdate,a.fmodifydate modifydate");
        sql.append(" FROM t_wf_circulaterelation a");
        if (count < 1L) {
            HistoricProcessInstanceEntity procInst = (HistoricProcessInstanceEntity)this.findById(procInstId, String.format("%s,%s", "biztraceno", "businessKey"));
            sql.append(String.format(" WHERE FBIZTRACENO = '%s' AND FBUSINESSKEY = '%s' ", procInst.getBizTraceNo(), procInst.getBusinessKey()));
        } else {
            sql.append(" WHERE FPROCINSTID = ").append(procInstId);
        }
        sql.append(WfUtils.isNotEmpty(filterSql) ? filterSql : " ");
        if (orderBy == null || orderBy.equals("")) {
            sql.append(" order by a.fmodifydate ");
        } else {
            sql.append(" order by ").append(orderBy);
        }
        ArrayList<Object> params = new ArrayList<Object>();
        params.addAll(paramsList);
        try (DataSet ds = DB.queryDataSet((String)"WfTaskCenter.t_wf_circulaterelation.queryGridData", (DBRoute)DBRoute.workflow, (String)sql.toString(), (Object[])params.toArray());){
            DynamicObjectCollection ret = ORM.create().toPlainDynamicObjectCollection(ds, start, limit);
            DynamicObjectCollection result = (DynamicObjectCollection)ret.clone();
            result.clear();
            StringBuilder businessKeysStr = new StringBuilder();
            businessKeysStr.append('(');
            for (int i = 0; i < ret.size(); ++i) {
                DynamicObject dynamicObject = (DynamicObject)ret.get(i);
                String businessKey = dynamicObject.getString("businesskey");
                businessKeysStr.append('\'').append(businessKey).append('\'');
                if (i >= ret.size() - 1) continue;
                businessKeysStr.append(',');
            }
            businessKeysStr.append(')');
            if (businessKeysStr.length() > 2) {
                Map<String, Object> billStateInfo;
                HashMap billStateInfos = new HashMap();
                String messageSQL = WfMultiLangUtils.getGeneralLangSQL("wf_execution", "a", "b", "fentrabillname", "fentrabillname", ENTRABILLNAME);
                String execSql = String.format("select a.fid id,a.fbusinesskey businesskey, fisactive isactive, %s from t_wf_execution a left join t_wf_execution_l b on a.fid=b.fid WHERE fisscope='0' and fbusinesskey in %s and b.FLOCALEID = '%s';", messageSQL, businessKeysStr.toString(), RequestContext.get().getLang().toString());
                try {
                    DataSet markDs = DB.queryDataSet((String)"WfTaskCenter.wf_taskmark.queryGridData", (DBRoute)DBRoute.workflow, (String)execSql, null);
                    Object object = null;
                    try {
                        for (Row row : markDs) {
                            String businessKey = row.getString("businesskey");
                            billStateInfo = (HashMap<String, Boolean>)billStateInfos.get(businessKey);
                            if (billStateInfo == null) {
                                billStateInfo = new HashMap<String, Boolean>();
                                billStateInfo.put("isactive", row.getBoolean("isactive"));
                                billStateInfo.put(ENTRABILLNAME, row.get("fentrabillname"));
                                billStateInfos.put(businessKey, billStateInfo);
                                continue;
                            }
                            if (!row.getBoolean("isactive").booleanValue()) continue;
                            billStateInfo.put("isactive", row.getBoolean("isactive"));
                            billStateInfos.put(businessKey, billStateInfo);
                        }
                    }
                    catch (Throwable iter) {
                        object = iter;
                        throw iter;
                    }
                    finally {
                        if (markDs != null) {
                            if (object != null) {
                                try {
                                    markDs.close();
                                }
                                catch (Throwable iter) {
                                    ((Throwable)object).addSuppressed(iter);
                                }
                            } else {
                                markDs.close();
                            }
                        }
                    }
                }
                catch (Exception e) {
                    this.logger.error(e.getMessage(), (Throwable)e);
                }
                ArrayList<String> bills = new ArrayList<String>();
                for (DynamicObject dynamicObject : ret) {
                    String businessKey = dynamicObject.getString("businesskey");
                    if (bills.contains(businessKey)) continue;
                    bills.add(businessKey);
                    String entraBillName = null;
                    billStateInfo = (Map)billStateInfos.get(businessKey);
                    if (billStateInfo != null) {
                        entraBillName = (String)billStateInfo.get(ENTRABILLNAME);
                    }
                    if (WfUtils.isEmpty(entraBillName)) {
                        String entityNumber = dynamicObject.getString("entitynumber");
                        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
                        entraBillName = entityType.getDisplayName().getLocaleValue();
                    }
                    dynamicObject.set("entrabillnameshow", (Object)entraBillName);
                    if (billStateInfo != null && ((Boolean)billStateInfo.get("isactive")).booleanValue()) {
                        dynamicObject.set("subjectshow", (Object)WFMultiLangConstants.getRuningName().getLocaleValue());
                    } else {
                        dynamicObject.set("subjectshow", (Object)WFMultiLangConstants.getOveredName().getLocaleValue());
                    }
                    result.add((Object)dynamicObject);
                }
            }
            DynamicObjectCollection dynamicObjectCollection = result;
            return dynamicObjectCollection;
        }
    }

    @Override
    public long getViewBillsCount(String processInstanceId, String filterSql, List<Object> paramsList) {
        String sql = null;
        ArrayList<Object> params = new ArrayList<Object>();
        Long procInstId = Long.valueOf(processInstanceId);
        long cirRelCount = this.getCirculateRelationEntityManager().countByFilter("id", new QFilter[]{new QFilter("procinstid", "=", (Object)procInstId)}, false);
        StringBuilder sqlTpl = new StringBuilder("select fid id,fbusinesskey businesskey, fentitynumber entitynumber from t_wf_circulaterelation WHERE ");
        if (cirRelCount < 1L) {
            HistoricProcessInstanceEntity procInst = (HistoricProcessInstanceEntity)this.findById(procInstId, String.format("%s,%s", "biztraceno", "businessKey"));
            sqlTpl.append(String.format(" FBIZTRACENO = '%s' AND FBUSINESSKEY = '%s' ", procInst.getBizTraceNo(), procInst.getBusinessKey()));
        } else {
            sqlTpl.append(String.format(" FPROCINSTID = %s ", procInstId));
        }
        if (WfUtils.isNotEmpty(filterSql)) {
            sqlTpl.append(filterSql);
            params.add(RequestContext.get().getLang().toString());
        }
        sql = sqlTpl.toString();
        params.addAll(paramsList);
        long count = 0L;
        ArrayList<String> billIdAndNames = new ArrayList<String>();
        try (DataSet ds = DB.queryDataSet((String)"WFTASK.t_wf_circulaterelation", (DBRoute)DBRoute.workflow, (String)sql, (Object[])params.toArray());){
            for (Row row : ds) {
                String businessKey = row.getString("businesskey");
                String entityNumber = row.getString("entitynumber");
                String billIdAndName = String.format("%s_%s", businessKey, entityNumber);
                if (billIdAndNames.contains(billIdAndName)) continue;
                billIdAndNames.add(billIdAndName);
                ++count;
            }
        }
        return count;
    }

    @Override
    public long getHiProinstanceCount(String billType, String entityNumber, String filterSql, List<Object> paramsList) {
        return this.getHiProinstanceCount(billType, entityNumber, filterSql, paramsList, false);
    }

    @Override
    public long getHiProinstanceCount(String billType, String entityNumber, String filterSql, List<Object> paramsList, boolean isAuditFlow) {
        return this.innerGetCount(billType, entityNumber, filterSql, paramsList, null, isAuditFlow);
    }

    private long innerGetCount(String billType, String entityNumber, String filterSql, List<Object> paramsList, String uid) {
        return this.innerGetCount(billType, entityNumber, filterSql, paramsList, uid, false);
    }

    private long innerGetCount(String billType, String entityNumber, String filterSql, List<Object> paramsList, String uid, boolean isAuditFlow) {
        String sql = null;
        String entityFilter = "";
        String billFilter = "";
        ArrayList<Object> params = new ArrayList<Object>();
        String noCodeFlow = ThreadLocalVariables.get();
        if (WfUtils.isNotEmpty(billType)) {
            billFilter = " and a.fbilltype=?";
            params.add(billType);
        }
        if (WfUtils.isNotEmpty(entityNumber)) {
            entityFilter = " and a.fentitynumber=?";
            params.add(entityNumber);
        }
        String userFilter = "";
        if (WfUtils.isNotEmpty(uid)) {
            userFilter = " and a.fcreatorid=" + Long.valueOf(uid);
        }
        if (WfUtils.isEmpty(filterSql)) {
            StringBuilder sqlTpl = new StringBuilder("select count(1) count from ");
            sqlTpl.append(this.getTableName()).append(" a WHERE a.fendtype<>'20' ");
            sqlTpl.append(WfUtils.isEmpty(noCodeFlow) ? "" : " and a.fprocesstype = ? ").append(" %s %s %s");
            if (WfUtils.isEmpty(noCodeFlow)) {
                if (isAuditFlow) {
                    sqlTpl.append(String.format(" AND a.fprocesstype = '%s'", ModelType.AuditFlow.name()));
                } else {
                    sqlTpl.append(String.format(" AND a.fprocesstype != '%s'", ModelType.NoCodeFlow.name()));
                }
            }
            sqlTpl.append(" AND a.fendtime is not null ");
            sql = String.format(sqlTpl.toString(), userFilter, entityFilter, billFilter);
            if (WfUtils.isNotEmpty(noCodeFlow)) {
                params.add(0, ModelType.NoCodeFlow.name());
            }
        } else {
            StringBuilder sb = new StringBuilder();
            sb.append("select count(1) count from ").append(this.getTableName()).append(" a ").append("left join ").append(this.getMultiLangTableName()).append(" b ").append("on a.fid = b.fid and b.flocaleid = ? ").append("WHERE a.fendtype<>'20' ").append(WfUtils.isEmpty(noCodeFlow) ? "" : " and a.fprocesstype = ? ").append(" %s %s %s %s");
            if (WfUtils.isEmpty(noCodeFlow)) {
                if (isAuditFlow) {
                    sb.append(String.format(" AND a.fprocesstype = '%s'", ModelType.AuditFlow.name()));
                } else {
                    sb.append(String.format(" AND a.fprocesstype != '%s'", ModelType.NoCodeFlow.name()));
                }
            }
            sb.append(" AND a.fendtime is not null ");
            sql = String.format(sb.toString(), userFilter, entityFilter, billFilter, filterSql);
            params.add(0, RequestContext.get().getLang().toString());
            if (WfUtils.isNotEmpty(noCodeFlow)) {
                params.add(1, ModelType.NoCodeFlow.name());
            }
        }
        params.addAll(paramsList);
        long count = 0L;
        try (DataSet ds = DB.queryDataSet((String)"WFTASK.hiproinstCount", (DBRoute)WfUtils.WFS, (String)sql, (Object[])params.toArray());){
            Iterator iter = ds.iterator();
            if (iter.hasNext()) {
                count = ((Row)iter.next()).getLong("count");
            }
        }
        return count;
    }

    private long innerGetUnionCount(String billType, String entityNumber, String filterSql, List<Object> paramsList, String uid, boolean isAuditFlow) {
        long count = 0L;
        try (DataSet ds = this.historicProcessInstanceCollector.innerGetUnionCount(billType, entityNumber, filterSql, paramsList, uid, isAuditFlow);){
            Iterator iter = ds.iterator();
            while (iter.hasNext()) {
                count += ((Row)iter.next()).getLong("count").longValue();
            }
        }
        return count;
    }

    @Override
    public List<HistoricProcessInstanceEntity> findChildExecutionsByProcessInstanceId(Long processInstanceId) {
        QFilter q1 = new QFilter("superProcessInstanceId", "=", (Object)processInstanceId);
        QFilter[] qFilters = new QFilter[]{q1};
        EntityQueryBuilder eb = new EntityQueryBuilder(this.getEntityName(), qFilters, this.getSelectFields(), this.getManagedEntityClass()).orderBy("createDate desc ");
        return this.findByQueryBuilder(eb);
    }

    @Override
    public List<Map<String, Object>> getEntityByUser(Long uid) {
        String entityNameSQL = WfMultiLangUtils.getGeneralLangSQL(this.getEntityName(), "a", "b", "FENTRABILLNAME", "entityname", ENTRABILLNAME);
        String sql = "select distinct " + entityNameSQL + ",a.FENTITYNUMBER entitynumber, a.fbilltype billtype, a.fbusinesskey businesskey from " + this.getTableName() + " a LEFT JOIN " + this.getMultiLangTableName() + " b ON a.FID = b.FID AND b.FLOCALEID = ?  WHERE a.fcreatorid =? AND a.FENDTIME is not NULL AND a.FENDTYPE <> ? ";
        Object[] params = new Object[]{RequestContext.get().getLang().toString(), uid, "20"};
        List<Map<String, Object>> entityMap = WfUtils.getEntityProperties(sql, params);
        return entityMap;
    }

    @Override
    public List<HistoricProcessInstanceEntity> findNotEndProcessesByBusinesskey(String businesskey) {
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter("businessKey", businesskey).addFilter("endTime", "is null", null).orderBy("createDate desc ");
        return this.findByQueryBuilder(eb);
    }

    @Override
    public HistoricProcessInstanceEntity findLatestAuditflowInstanceByBusinessKey(String businessKey) {
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter("businessKey", businessKey).addFilter("processtype", ModelType.AuditFlow.name()).addFilter("endType", "!=", "20").orderBy("createDate desc ");
        List list = this.findByQueryBuilder(eb);
        if (list != null && !list.isEmpty()) {
            HashSet<Long> allIds = new HashSet<Long>(list.size());
            for (HistoricProcessInstanceEntity entity : list) {
                if (WfUtils.isEmpty(entity.getSuperProcessInstanceId())) {
                    return entity;
                }
                allIds.add(entity.getId());
            }
            if (!allIds.isEmpty()) {
                for (HistoricProcessInstanceEntity e : list) {
                    if (allIds.contains(e.getSuperProcessInstanceId())) continue;
                    return e;
                }
            }
        }
        return null;
    }

    @Override
    public HistoricProcessInstanceEntity findLatestAuditflowInstanceByProcessInstanceId(Long processInstanceId) {
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter("id", processInstanceId).addFilter("processtype", ModelType.AuditFlow.name()).orderBy("createDate desc ");
        List list = this.findByQueryBuilder(eb);
        return list != null && !list.isEmpty() ? (HistoricProcessInstanceEntity)list.get(0) : null;
    }

    @Override
    public DynamicObjectCollection getApplyedProcess(EntityQueryParams entityQueryParams) {
        try (DataSet ds = this.historicProcessInstanceCollector.getHistoricProcessList(entityQueryParams);){
            DynamicObjectCollection resultDynamicObjectCollection;
            if (ds == null) {
                DynamicObjectCollection dynamicObjectCollection = new DynamicObjectCollection(new DynamicObjectType("PlainObject"), null);
                return dynamicObjectCollection;
            }
            DynamicObjectCollection dynamicObjectCollection = resultDynamicObjectCollection = ORM.create().toPlainDynamicObjectCollection(ds);
            return dynamicObjectCollection;
        }
    }

    @Override
    public Long getApplyedProcessCount(EntityQueryParams entityQueryParams) {
        return this.historicProcessInstanceCollector.getHistoricProcessCount(entityQueryParams);
    }
}

