/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.persistence.entity.history;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.bpmn.helper.BPMNUtil;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricScopeInstanceEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricTaskInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricVariableInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ManagementConstants;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.DurationDetailEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.util.workCalendar.WorkCalendarUtil;
import kd.bos.workflow.engine.task.AttributeModifyRecord;
import kd.bos.workflow.engine.task.TaskUtils;
import kd.bos.workflow.feature.taskfield.util.TaskExtendFieldUtil;

public class HistoricTaskInstanceEntityImpl
extends HistoricScopeInstanceEntityImpl
implements HistoricTaskInstanceEntity {
    private static final long serialVersionUID = 1L;
    protected List<HistoricVariableInstanceEntity> queryVariables;
    protected Long currentActInst;
    Map<String, AttributeModifyRecord> attributeModifyRecords = new HashMap<String, AttributeModifyRecord>();

    public HistoricTaskInstanceEntityImpl() {
    }

    public HistoricTaskInstanceEntityImpl(DynamicObject dynamicObject) {
        super(dynamicObject);
    }

    public HistoricTaskInstanceEntityImpl(TaskEntity task, ExecutionEntity execution) {
        this.dynamicObject.set("id", (Object)task.getId());
        if (execution != null) {
            this.dynamicObject.set("processDefinitionId", (Object)execution.getProcessDefinitionId());
            this.dynamicObject.set("processInstanceId", (Object)execution.getProcessInstanceId());
            this.dynamicObject.set("executionId", (Object)execution.getId());
        }
        this.dynamicObject.set("name", (Object)WfUtils.subILocaleString(task.getName(), 500));
        this.dynamicObject.set("parentTaskId", (Object)task.getParentTaskId());
        this.dynamicObject.set("description", (Object)task.getDescription());
        this.dynamicObject.set("owner", (Object)task.getOwner());
        this.dynamicObject.set("assignee", (Object)task.getTaskAssignee());
        this.dynamicObject.set("taskDefinitionKey", (Object)task.getTaskDefinitionKey());
        this.dynamicObject.set("display", (Object)task.isDisplay());
        this.dynamicObject.set("starterId", (Object)task.getStarterId());
        this.dynamicObject.set("senderId", (Object)task.getSenderId());
        this.dynamicObject.set("subject", (Object)task.getSubject());
        this.dynamicObject.set("assigneeId", (Object)task.getAssigneeId());
        this.dynamicObject.set("ownerId", (Object)task.getOwnerId());
        this.dynamicObject.set("executionType", (Object)task.getExecutionType());
        this.dynamicObject.set("entityNumber", (Object)task.getEntityNumber());
        this.dynamicObject.set("entityName", (Object)task.getEntityName());
        this.dynamicObject.set("startName", (Object)task.getStartName());
        this.dynamicObject.set("senderName", (Object)task.getSenderName());
        this.dynamicObject.set("startnameformat", (Object)task.getStartNameFormat());
        this.dynamicObject.set("sendernameformat", (Object)task.getSenderNameFormat());
        this.dynamicObject.set("businessKey", (Object)task.getBusinessKey());
        this.dynamicObject.set("billno", (Object)task.getBillNo());
        this.dynamicObject.set("delegationState", (Object)task.getDelegationState());
        this.dynamicObject.set("createDate", (Object)task.getCreateDate());
        this.dynamicObject.set("formKey", (Object)task.getFormKey());
        this.dynamicObject.set("mobileFormKey", (Object)task.getMobileFormKey());
        this.dynamicObject.set("yzjGroupId", (Object)task.getYzjGroupId());
        this.dynamicObject.set("processingPage", (Object)task.getProcessingPage());
        this.dynamicObject.set("processingMobilePage", (Object)task.getProcessingMobilePage());
        this.dynamicObject.set("handleState", (Object)task.getHandleState());
        this.dynamicObject.set("priority", (Object)task.getPriority());
        this.dynamicObject.set("dueDate", (Object)task.getDueDate());
        this.dynamicObject.set("category", (Object)task.getCategory());
        this.dynamicObject.set("participantName", (Object)task.getParticipantName());
        this.dynamicObject.set("source", (Object)task.getSource());
        this.dynamicObject.set("validateoperation", (Object)task.getValidateOperation());
        this.dynamicObject.set("groupnumber", (Object)task.getGroupNumber());
        this.dynamicObject.set("batchOp", (Object)task.getBatchOp());
        this.dynamicObject.set("billType", (Object)task.getBillType());
        this.dynamicObject.set("orgunitid", (Object)task.getOrgUnitId());
        this.dynamicObject.set("orgviewid", (Object)task.getOrgViewId());
        this.dynamicObject.set("biztraceno", (Object)task.getBizTraceNo());
        this.dynamicObject.set("processtype", (Object)task.getProcessType());
        this.dynamicObject.set("control", (Object)task.getControl());
        this.dynamicObject.set("biz_date", (Object)task.getBusinessDate());
        this.dynamicObject.set("biz_number", (Object)task.getBusinessNumber());
        this.dynamicObject.set("bizformat", (Object)task.getBusinessFormat());
        this.dynamicObject.set("biz_str1", (Object)task.getBusinessStr1());
        this.dynamicObject.set("biz_str2", (Object)task.getBusinessStr2());
        this.dynamicObject.set("biz_number2", (Object)task.getBusinessNumber2());
        this.dynamicObject.set("biz_date2", (Object)task.getBusinessDate2());
        this.dynamicObject.set("biz_strmul1", (Object)task.getBusinessMulStr1());
        this.dynamicObject.set("biz_strmul2", (Object)task.getBusinessMulStr2());
        this.dynamicObject.set("captionpc", (Object)task.getCaptionPC());
        this.dynamicObject.set("captionmob", (Object)task.getCaptionMob());
        this.dynamicObject.set("resourceid", (Object)task.getResourceId());
        this.dynamicObject.set("sourcename", (Object)task.getSourceName());
        this.dynamicObject.set("url", (Object)task.getUrl());
        this.dynamicObject.set("mobileurl", (Object)task.getMobileUrl());
        TaskExtendFieldUtil.setExtendTaskBusinessField(this.dynamicObject, task.getDynamicObject());
    }

    @Override
    public void calRealDuration() {
        ProcessEngineConfigurationImpl processEngineConfigurationImpl = Context.getProcessEngineConfiguration();
        DurationDetailEntityManager durationDetailEntityManager = processEngineConfigurationImpl.getDurationDetailEntityManager();
        Long suspendTime = durationDetailEntityManager.getSuspendDurationForUndoSuspendedByTaskId(this.getId());
        long realDurationInMillis = 0L;
        if (WfConfigurationUtil.getIsOpenWorkCalendar() && WfConfigurationUtil.enableWorkCalendar()) {
            Date endDate;
            Date createDate = this.getCreateDate();
            Long workCalendarDuration = WorkCalendarUtil.getRealDuration(createDate, endDate = processEngineConfigurationImpl.getClock().getCurrentTime());
            if (workCalendarDuration > suspendTime) {
                realDurationInMillis = workCalendarDuration - suspendTime;
            }
        } else {
            Long durationInMillis = this.getDurationInMillis();
            if (durationInMillis > suspendTime) {
                realDurationInMillis = durationInMillis - suspendTime;
            }
        }
        this.setRealDurationInMillis(realDurationInMillis);
    }

    @Override
    public Object getPersistentState() {
        Map persistentState = (Map)super.getPersistentState();
        persistentState.put("name", this.getName());
        persistentState.put("owner", this.getOwner());
        persistentState.put("ownerId", this.getOwnerId());
        persistentState.put("assignee", this.getAssignee());
        persistentState.put("assigneeId", this.getAssigneeId());
        persistentState.put("handleState", this.getHandleState());
        persistentState.put("description", this.getDescription());
        persistentState.put("taskDefinitionKey", this.getTaskDefinitionKey());
        persistentState.put("formKey", this.getFormKey());
        persistentState.put("priority", this.getPriority());
        persistentState.put("category", this.getCategory());
        persistentState.put("processDefinitionId", this.getProcessDefinitionId());
        persistentState.put("parentTaskId", this.getParentTaskId());
        persistentState.put("dueDate", this.getDueDate());
        persistentState.put("claimTime", this.getClaimTime());
        persistentState.put("subactivityname", this.getSubactivityname());
        persistentState.put("endtype", this.getEndType());
        persistentState.put("subject", this.getSubject());
        persistentState.put("participantName", this.getParticipantName());
        persistentState.put("source", this.getSource());
        persistentState.put("orgunitid", this.getOrgUnitId());
        persistentState.put("orgviewid", this.getOrgViewId());
        persistentState.put("captionpc", this.getCaptionPC());
        persistentState.put("captionmob", this.getCaptionMob());
        persistentState.put("resourceid", this.getResourceId());
        persistentState.put("sourcename", this.getSourceName());
        persistentState.put("url", this.getUrl());
        persistentState.put("mobileurl", this.getMobileUrl());
        return persistentState;
    }

    @Override
    public String getDynObjTypeName() {
        return "wf_hitaskinst";
    }

    @SimplePropertyAttribute(name="executionId")
    public Long getExecutionId() {
        return this.normalizeId(this.dynamicObject.getLong("executionId"));
    }

    @Override
    public void setExecutionId(Long executionId) {
        this.dynamicObject.set("executionId", (Object)executionId);
    }

    @SimplePropertyAttribute(name="name")
    public ILocaleString getName() {
        return this.dynamicObject.getLocaleString("name");
    }

    @Override
    public void setName(String name) {
        this.dynamicObject.set("name", (Object)WfUtils.subStringForMax(name, 500));
    }

    public void setName(ILocaleString name) {
        this.dynamicObject.set("name", (Object)WfUtils.subILocaleString(name, 500));
    }

    @SimplePropertyAttribute(name="description")
    public ILocaleString getDescription() {
        return this.dynamicObject.getLocaleString("description");
    }

    @Override
    public void setDescription(String description) {
        this.dynamicObject.set("description", (Object)description);
    }

    @Deprecated
    public String getAssignee() {
        return this.dynamicObject.getString("assignee");
    }

    @SimplePropertyAttribute(name="assignee")
    public ILocaleString getTaskAssignee() {
        return this.dynamicObject.getLocaleString("assignee");
    }

    @Override
    public void setAssignee(ILocaleString assignee) {
        this.dynamicObject.set("assignee", (Object)assignee);
    }

    @SimplePropertyAttribute(name="taskDefinitionKey")
    public String getTaskDefinitionKey() {
        return this.dynamicObject.getString("taskDefinitionKey");
    }

    @Override
    public void setTaskDefinitionKey(String taskDefinitionKey) {
        this.dynamicObject.set("taskDefinitionKey", (Object)taskDefinitionKey);
    }

    @SimplePropertyAttribute(name="formKey")
    public String getFormKey() {
        return this.dynamicObject.getString("formKey");
    }

    @Override
    public void setFormKey(String formKey) {
        this.dynamicObject.set("formKey", (Object)formKey);
    }

    @SimplePropertyAttribute(name="priority")
    public int getPriority() {
        return this.dynamicObject.getInt("priority");
    }

    @Override
    public void setPriority(int priority) {
        this.dynamicObject.set("priority", (Object)priority);
    }

    @SimplePropertyAttribute(name="dueDate")
    public Date getDueDate() {
        return this.dynamicObject.getDate("dueDate");
    }

    @Override
    public void setDueDate(Date dueDate) {
        this.dynamicObject.set("dueDate", (Object)dueDate);
    }

    @SimplePropertyAttribute(name="category")
    public String getCategory() {
        return this.dynamicObject.getString("category");
    }

    @Override
    public void setCategory(String category) {
        this.dynamicObject.set("category", (Object)category);
    }

    @SimplePropertyAttribute(name="parentTaskId")
    public Long getParentTaskId() {
        return this.normalizeId(this.dynamicObject.getLong("parentTaskId"));
    }

    @Override
    public void setParentTaskId(Long parentTaskId) {
        this.dynamicObject.set("parentTaskId", (Object)parentTaskId);
    }

    @Override
    @SimplePropertyAttribute(name="claimTime")
    public Date getClaimTime() {
        return this.dynamicObject.getDate("claimTime");
    }

    @Override
    public void setClaimTime(Date claimTime) {
        this.dynamicObject.set("claimTime", (Object)claimTime);
    }

    @Override
    @SimplePropertyAttribute(name="display")
    public boolean isDisplay() {
        return this.dynamicObject.getBoolean("display");
    }

    @Override
    public void setDisplay(boolean isDisplay) {
        this.dynamicObject.set("display", (Object)isDisplay);
    }

    @Override
    @SimplePropertyAttribute(name="starterId")
    public Long getStarterId() {
        return this.normalizeId(this.dynamicObject.getLong("starterId"));
    }

    @Override
    public void setStarterId(Long starterId) {
        this.dynamicObject.set("starterId", (Object)starterId);
    }

    @Override
    @SimplePropertyAttribute(name="senderId")
    public String getSenderId() {
        return this.dynamicObject.getString("senderId");
    }

    @Override
    public void setSenderId(String senderId) {
        this.dynamicObject.set("senderId", (Object)senderId);
    }

    @Override
    @SimplePropertyAttribute(name="subject")
    public ILocaleString getSubject() {
        return this.dynamicObject.getLocaleString("subject");
    }

    public void setSubject(String subject) {
        this.dynamicObject.set("subject", (Object)BPMNUtil.getInterceptedString(subject, 1000));
    }

    @Override
    public void setSubject(ILocaleString subject) {
        this.dynamicObject.set("subject", (Object)BPMNUtil.subStringSubject(subject));
    }

    @Override
    @SimplePropertyAttribute(name="assigneeId")
    public Long getAssigneeId() {
        return this.normalizeId(this.dynamicObject.getLong("assigneeId"));
    }

    @Override
    public void setAssigneeId(Long assigneeId) {
        this.dynamicObject.set("assigneeId", (Object)assigneeId);
    }

    @Override
    @SimplePropertyAttribute(name="ownerId")
    public Long getOwnerId() {
        return this.normalizeId(this.dynamicObject.getLong("ownerId"));
    }

    @Override
    public void setOwnerId(Long ownerId) {
        this.dynamicObject.set("ownerId", (Object)ownerId);
    }

    @Override
    @SimplePropertyAttribute(name="executionType")
    public String getExecutionType() {
        return this.dynamicObject.getString("executionType");
    }

    @Override
    public void setExecutionType(String executionType) {
        this.gatherAttributeModifyRecord("executionType", executionType);
        this.dynamicObject.set("executionType", (Object)executionType);
    }

    @Override
    public void setEndTime(Date endTime) {
        this.gatherAttributeModifyRecord("endTime", endTime);
        super.setEndTime(endTime);
    }

    @Override
    @SimplePropertyAttribute(name="entityNumber")
    public String getEntityNumber() {
        return this.dynamicObject.getString("entityNumber");
    }

    @Override
    public void setEntityNumber(String entityNumber) {
        this.dynamicObject.set("entityNumber", (Object)entityNumber);
    }

    @SimplePropertyAttribute(name="owner")
    public String getOwner() {
        return this.dynamicObject.getString("owner");
    }

    @Override
    public void setOwner(String owner) {
        this.dynamicObject.set("owner", (Object)owner);
    }

    @Override
    @SimplePropertyAttribute(name="entityName")
    public ILocaleString getEntityName() {
        return this.dynamicObject.getLocaleString("entityName");
    }

    public void setEntityName(ILocaleString entityName) {
        this.dynamicObject.set("entityName", (Object)entityName);
    }

    @Override
    @SimplePropertyAttribute(name="startName")
    public ILocaleString getStartName() {
        return this.dynamicObject.getLocaleString("startName");
    }

    public void setStartName(String startName) {
        this.dynamicObject.set("startName", (Object)startName);
    }

    @Override
    public void setStartNameFormat(ILocaleString startNameFormat) {
        this.dynamicObject.set("startnameformat", (Object)WfUtils.subILocaleString(startNameFormat, 490));
    }

    @Override
    public ILocaleString getStartNameFormat() {
        return this.dynamicObject.getLocaleString("startnameformat");
    }

    @Override
    public void setSenderNameFormat(ILocaleString senderNameFormat) {
        this.dynamicObject.set("sendernameformat", (Object)WfUtils.subILocaleString(senderNameFormat, 490));
    }

    @Override
    public ILocaleString getSenderNameFormat() {
        return this.dynamicObject.getLocaleString("sendernameformat");
    }

    @Override
    @SimplePropertyAttribute(name="senderName")
    public ILocaleString getSenderName() {
        return this.dynamicObject.getLocaleString("senderName");
    }

    public void setSenderName(String senderName) {
        this.dynamicObject.set("senderName", (Object)senderName);
    }

    @Override
    @SimplePropertyAttribute(name="businessKey")
    public String getBusinessKey() {
        return this.dynamicObject.getString("businessKey");
    }

    @Override
    public void setBusinessKey(String businessKey) {
        this.dynamicObject.set("businessKey", (Object)businessKey);
    }

    @Override
    @SimplePropertyAttribute(name="delegationState")
    public String getDelegationState() {
        return this.dynamicObject.getString("delegationState");
    }

    @Override
    public void setDelegationState(String delegationState) {
        this.dynamicObject.set("delegationState", (Object)delegationState);
    }

    @Override
    @SimplePropertyAttribute(name="mobileFormKey")
    public String getMobileFormKey() {
        return this.dynamicObject.getString("mobileFormKey");
    }

    @Override
    public void setMobileFormKey(String mobileFormKey) {
        this.dynamicObject.set("mobileFormKey", (Object)mobileFormKey);
    }

    @Override
    @SimplePropertyAttribute(name="yzjGroupId")
    public String getYzjGroupId() {
        return this.dynamicObject.getString("yzjGroupId");
    }

    @Override
    public void setYzjGroupId(String yzjGroupId) {
        this.dynamicObject.set("yzjGroupId", (Object)yzjGroupId);
    }

    @Override
    @SimplePropertyAttribute(name="processingPage")
    public String getProcessingPage() {
        return this.dynamicObject.getString("processingPage");
    }

    @Override
    public void setProcessingPage(String processingPage) {
        this.dynamicObject.set("processingPage", (Object)processingPage);
    }

    @Override
    @SimplePropertyAttribute(name="processingMobilePage")
    public String getProcessingMobilePage() {
        return this.dynamicObject.getString("processingMobilePage");
    }

    @Override
    public void setProcessingMobilePage(String processingMobilePage) {
        this.dynamicObject.set("processingMobilePage", (Object)processingMobilePage);
    }

    @Override
    @SimplePropertyAttribute(name="handleState")
    public String getHandleState() {
        return this.dynamicObject.getString("handleState");
    }

    @Override
    public void setHandleState(String handleState) {
        this.gatherAttributeModifyRecord("handleState", handleState);
        this.dynamicObject.set("handleState", (Object)handleState);
    }

    @Override
    @SimplePropertyAttribute(name="billNo")
    public String getBillNo() {
        return this.dynamicObject.getString("billNo");
    }

    @Override
    public void setBillNo(String billNo) {
        this.dynamicObject.set("billNo", (Object)billNo);
    }

    public void setSubactivityname(String subactivityname) {
        this.dynamicObject.set("subactivityname", (Object)subactivityname);
    }

    @SimplePropertyAttribute(name="subactivityname")
    public ILocaleString getSubactivityname() {
        return this.dynamicObject.getLocaleString("subactivityname");
    }

    @Override
    public void setEndType(String endType) {
        this.dynamicObject.set("endType", (Object)endType);
    }

    @Override
    @SimplePropertyAttribute(name="endType")
    public String getEndType() {
        return this.dynamicObject.getString("endType");
    }

    public Date getTime() {
        return this.getCreateDate();
    }

    @Override
    public Long getWorkTimeInMillis() {
        if (this.getEndTime() == null || this.getClaimTime() == null) {
            return null;
        }
        return this.getEndTime().getTime() - this.getClaimTime().getTime();
    }

    public Map<String, Object> getTaskLocalVariables() {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        if (this.queryVariables != null) {
            for (HistoricVariableInstanceEntity variableInstance : this.queryVariables) {
                if (variableInstance.getId() == null || variableInstance.getTaskId() == null) continue;
                variables.put(variableInstance.getName(), variableInstance.getValue());
            }
        }
        return variables;
    }

    public Map<String, Object> getProcessVariables() {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        if (this.queryVariables != null) {
            for (HistoricVariableInstanceEntity variableInstance : this.queryVariables) {
                if (variableInstance.getId() == null || variableInstance.getTaskId() != null) continue;
                variables.put(variableInstance.getName(), variableInstance.getValue());
            }
        }
        return variables;
    }

    public boolean isActive() {
        return true;
    }

    public boolean isFromHistory() {
        return true;
    }

    @Override
    @SimplePropertyAttribute(name="participantName")
    public ILocaleString getParticipantName() {
        return this.dynamicObject.getLocaleString("participantName");
    }

    @Override
    public void setParticipantName(ILocaleString participantName) {
        this.dynamicObject.set("participantName", (Object)WfUtils.subILocaleString(participantName, 490));
    }

    @Override
    public void setSource(String source) {
        this.dynamicObject.set("source", (Object)source);
    }

    @Override
    @SimplePropertyAttribute(name="source")
    public String getSource() {
        return this.dynamicObject.getString("source");
    }

    public Long getCurrentActInst() {
        return this.currentActInst;
    }

    public void setCurrentActInst(Long currentActInst) {
        this.currentActInst = currentActInst;
    }

    @Override
    @SimplePropertyAttribute(name="validateoperation")
    public String getValidateOperation() {
        return this.dynamicObject.getString("validateoperation");
    }

    @Override
    public void setValidateOperation(String validate) {
        this.dynamicObject.set("validateoperation", (Object)validate);
    }

    public String getSuspensionState() {
        return ManagementConstants.ACTIVE.getStateCode();
    }

    @Override
    public Long getGroupNumber() {
        Object groupNumber = this.dynamicObject.get("groupnumber");
        if (groupNumber instanceof DynamicObject) {
            return this.normalizeId(((DynamicObject)groupNumber).getLong("id"));
        }
        return this.normalizeId(this.dynamicObject.getLong("groupnumber"));
    }

    @Override
    public void setGroupNumber(Long number) {
        this.dynamicObject.set("groupnumber", (Object)number);
    }

    @Override
    @SimplePropertyAttribute(name="batchOp")
    public String getBatchOp() {
        return this.dynamicObject.getString("batchOp");
    }

    @Override
    public void setBatchOp(String batchOp) {
        this.dynamicObject.set("batchOp", (Object)batchOp);
    }

    @Override
    @SimplePropertyAttribute(name="billType")
    public String getBillType() {
        return this.dynamicObject.getString("billType");
    }

    @Override
    public void setBillType(String billType) {
        this.dynamicObject.set("billType", (Object)billType);
    }

    @Override
    @SimplePropertyAttribute(name="biztraceno")
    public String getBizTraceNo() {
        return this.dynamicObject.getString("biztraceno");
    }

    @Override
    public void setBizTraceNo(String bizTraceNo) {
        this.dynamicObject.set("biztraceno", (Object)bizTraceNo);
    }

    @Override
    @SimplePropertyAttribute(name="orgunitid")
    public Long getOrgUnitId() {
        return this.dynamicObject.getLong("orgunitid");
    }

    @Override
    public void setOrgUnitId(Long id) {
        this.dynamicObject.set("orgunitid", (Object)id);
    }

    @Override
    @SimplePropertyAttribute(name="orgviewid")
    public String getOrgViewId() {
        return this.dynamicObject.getString("orgviewid");
    }

    @Override
    public void setOrgViewId(String orgViewId) {
        this.dynamicObject.set("orgviewid", (Object)orgViewId);
    }

    @Override
    @SimplePropertyAttribute(name="presentassignee")
    public ILocaleString getPresentAssignee() {
        return this.dynamicObject.getLocaleString("presentassignee");
    }

    @Override
    public void setPresentAssignee(ILocaleString presentAssignee) {
        presentAssignee = WfUtils.subILocaleString(presentAssignee, 1990);
        this.gatherAttributeModifyRecord("presentassignee", presentAssignee);
        this.dynamicObject.set("presentassignee", (Object)presentAssignee);
    }

    @Override
    @SimplePropertyAttribute(name="processtype")
    public String getProcessType() {
        return this.dynamicObject.getString("processtype");
    }

    @Override
    public void setProcessType(String processType) {
        this.dynamicObject.set("processtype", (Object)processType);
    }

    @Override
    @SimplePropertyAttribute(name="control")
    public String getControl() {
        return this.dynamicObject.getString("control");
    }

    @Override
    public void setControl(String control) {
        this.dynamicObject.set("control", (Object)control);
    }

    @Override
    @SimplePropertyAttribute(name="biz_date")
    public Date getBusinessDate() {
        return this.dynamicObject.getDate("biz_date");
    }

    @Override
    public void setBusinessDate(Date businessDate) {
        this.dynamicObject.set("biz_date", (Object)businessDate);
    }

    @Override
    @SimplePropertyAttribute(name="biz_number")
    public double getBusinessNumber() {
        return this.dynamicObject.getBigDecimal("biz_number").doubleValue();
    }

    @Override
    public void setBusinessNumber(double businessNumber) {
        this.dynamicObject.set("biz_number", (Object)businessNumber);
    }

    @Override
    @SimplePropertyAttribute(name="bizformat")
    public String getBusinessFormat() {
        return this.dynamicObject.getString("bizformat");
    }

    @Override
    public void setBusinessFormat(String businessFormat) {
        this.dynamicObject.set("bizformat", (Object)businessFormat);
    }

    @Override
    @SimplePropertyAttribute(name="biz_str1")
    public String getBusinessStr1() {
        return this.dynamicObject.getString("biz_str1");
    }

    @Override
    public void setBusinessStr1(String businessStr1) {
        this.dynamicObject.set("biz_str1", (Object)businessStr1);
    }

    @Override
    @SimplePropertyAttribute(name="biz_str2")
    public String getBusinessStr2() {
        return this.dynamicObject.getString("biz_str2");
    }

    @Override
    public void setBusinessStr2(String businessStr2) {
        this.dynamicObject.set("biz_str2", (Object)businessStr2);
    }

    @Override
    @SimplePropertyAttribute(name="biz_date2")
    public Date getBusinessDate2() {
        return this.dynamicObject.getDate("biz_date2");
    }

    @Override
    public void setBusinessDate2(Date businessDate) {
        this.dynamicObject.set("biz_date2", (Object)businessDate);
    }

    @Override
    @SimplePropertyAttribute(name="biz_number2")
    public double getBusinessNumber2() {
        return this.dynamicObject.getBigDecimal("biz_number2").doubleValue();
    }

    @Override
    public void setBusinessNumber2(double businessNumber) {
        this.dynamicObject.set("biz_number2", (Object)businessNumber);
    }

    @Override
    @SimplePropertyAttribute(name="biz_strmul1")
    public ILocaleString getBusinessMulStr1() {
        return this.dynamicObject.getLocaleString("biz_strmul1");
    }

    @Override
    public void setBusinessMulStr1(ILocaleString businessStr) {
        this.dynamicObject.set("biz_strmul1", (Object)businessStr);
    }

    @Override
    @SimplePropertyAttribute(name="biz_strmul2")
    public ILocaleString getBusinessMulStr2() {
        return this.dynamicObject.getLocaleString("biz_strmul2");
    }

    @Override
    public void setBusinessMulStr2(ILocaleString businessStr) {
        this.dynamicObject.set("biz_strmul2", (Object)businessStr);
    }

    @Override
    public void setCaptionPC(ILocaleString captionPC) {
        this.dynamicObject.set("captionpc", (Object)captionPC);
    }

    @SimplePropertyAttribute(name="captionpc")
    public ILocaleString getCaptionPC() {
        return this.dynamicObject.getLocaleString("captionpc");
    }

    @Override
    public void setCaptionMob(ILocaleString captionMob) {
        this.dynamicObject.set("captionmob", (Object)captionMob);
    }

    @SimplePropertyAttribute(name="captionmob")
    public ILocaleString getCaptionMob() {
        return this.dynamicObject.getLocaleString("captionmob");
    }

    @Override
    public Map<String, AttributeModifyRecord> getAttributesModifyRecords() {
        return this.attributeModifyRecords;
    }

    @Override
    public void clearAttributesModifyRecords() {
        this.attributeModifyRecords = new HashMap<String, AttributeModifyRecord>();
    }

    private void gatherAttributeModifyRecord(String attribute, Object newValue) {
        this.gatherAttributeModifyRecord(this.dynamicObject, attribute, newValue);
    }

    @Override
    public void setResourceId(String resourceId) {
        this.dynamicObject.set("resourceid", (Object)resourceId);
    }

    @Override
    @SimplePropertyAttribute(name="resourceid")
    public String getResourceId() {
        return this.dynamicObject.getString("resourceid");
    }

    @Override
    public void setSourceName(ILocaleString sourceName) {
        this.dynamicObject.set("sourcename", (Object)sourceName);
    }

    @Override
    @SimplePropertyAttribute(name="sourcename")
    public ILocaleString getSourceName() {
        return this.dynamicObject.getLocaleString("sourcename");
    }

    @Override
    public void setUrl(String url) {
        this.dynamicObject.set("url", (Object)url);
    }

    @Override
    @SimplePropertyAttribute(name="url")
    public String getUrl() {
        return this.dynamicObject.getString("url");
    }

    @Override
    public void setMobileUrl(String mobileUrl) {
        this.dynamicObject.set("mobileurl", (Object)mobileUrl);
    }

    @Override
    @SimplePropertyAttribute(name="mobileurl")
    public String getMobileUrl() {
        return this.dynamicObject.getString("mobileurl");
    }

    public boolean isBizTask() {
        return TaskUtils.isBizTask(this.getSource());
    }
}

