/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.persistence.entity.history;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.format.FormatObject;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.bos.workflow.bpmn.converter.util.CollectionUtils;
import kd.bos.workflow.engine.EntityNumberConstant;
import kd.bos.workflow.engine.TableNameConstant;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.history.HistoricTaskInstance;
import kd.bos.workflow.engine.identity.UserInfo;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.cmd.task.dataquery.params.EntityQueryParams;
import kd.bos.workflow.engine.impl.cmd.task.processassistant.ProcessAssistantUtil;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.db.EntityQueryBuilder;
import kd.bos.workflow.engine.impl.history.HistoryLevel;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.AbstractEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelType;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcessInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricTaskInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricTaskInstanceEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricTaskInstanceEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.history.separatestorage.collector.HistoricTaskInstanceCollector;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.IdentityLinkEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.persistence.separatestorage.SeparateStorageType;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.msg.MessageServiceUtil;
import kd.bos.workflow.feature.taskfield.util.TaskExtendFieldUtil;
import kd.bos.workflow.service.impl.ThreadLocalVariables;

public class HistoricTaskInstanceEntityManagerImpl
extends AbstractEntityManager<HistoricTaskInstanceEntity>
implements HistoricTaskInstanceEntityManager {
    private HistoricTaskInstanceCollector historicTaskInstanceCollector = new HistoricTaskInstanceCollector();

    public HistoricTaskInstanceEntityManagerImpl(ProcessEngineConfigurationImpl processEngineConfiguration) {
        super(processEngineConfiguration);
    }

    @Override
    public Class<? extends HistoricTaskInstanceEntity> getManagedEntityClass() {
        return HistoricTaskInstanceEntityImpl.class;
    }

    @Override
    public String getSelectFields() {
        String extBusinessFieldBy = TaskExtendFieldUtil.getExtBusinessFieldByEntityNumber(this.getEntityName());
        return "id,processInstanceId,processDefinitionId,endTime,billNo,durationInMillis,deleteReason,executionId,name,parentTaskId,description,owner,assignee,taskDefinitionKey,formKey,priority,dueDate,claimTime,category,display,starterId,startName,senderId,senderName,entityName,subject,assigneeId,ownerId,executionType,entityNumber,businessKey,yzjgroupid,processingPage,processingMobilePage,handleState,delegationState,mobileFormKey,createDate,modifyDate,subactivityname,endtype,source,sourcename,participantName,validateoperation,resourceid,url,mobileurl,groupnumber,realDurationInMillis,batchOp,billtype,biztraceno,orgunitid,orgviewid,sendernameformat,startnameformat,presentassignee,processtype,control,biz_date,biz_number,bizformat,biz_str1,biz_str2,captionpc,captionmob,biz_date2,biz_number2,biz_strmul1,biz_strmul2" + extBusinessFieldBy;
    }

    @Override
    public HistoricTaskInstanceEntity create(TaskEntity task, ExecutionEntity execution) {
        return new HistoricTaskInstanceEntityImpl(task, execution);
    }

    @Override
    public void deleteHistoricTaskInstancesByProcessInstanceId(Long processInstanceId) {
        if (this.getHistoryManager().isHistoryLevelAtLeast(HistoryLevel.AUDIT)) {
            EntityQueryBuilder eb = this.createQueryBuilder().addFilter("processInstanceId", processInstanceId);
            List taskInstances = this.findByQueryBuilder(eb);
            for (HistoricTaskInstanceEntity historicTaskInstanceEntity : taskInstances) {
                this.delete(historicTaskInstanceEntity.getId());
            }
        }
    }

    @Override
    public void delete(Long id) {
        HistoricTaskInstanceEntity historicTaskInstance;
        if (this.getHistoryManager().isHistoryEnabled() && (historicTaskInstance = (HistoricTaskInstanceEntity)this.findById(id)) != null) {
            EntityQueryBuilder eb = this.createQueryBuilder().addFilter("parentTaskId", historicTaskInstance.getId());
            List subTasks = this.findByQueryBuilder(eb);
            for (HistoricTaskInstance subTask : subTasks) {
                this.delete(subTask.getId());
            }
            this.getHistoricVariableInstanceEntityManager().deleteHistoricVariableInstancesByTaskId(id);
            this.getCommentEntityManager().deleteByFilters(new QFilter[]{new QFilter("taskId", "=", (Object)id)});
            this.getHistoricAttachmentEntityManager().deleteAttachmentsByTaskId(id);
            this.getHistoricIdentityLinkEntityManager().deleteHistoricIdentityLinksByTaskId(id);
            this.getTaskHandleLogEntityManager().deleteTaskHandleLogByTaskId(id);
            this.delete(historicTaskInstance);
        }
    }

    @Override
    public HistoricTaskInstanceEntity update(HistoricTaskInstanceEntity hiTask) {
        super.update(hiTask);
        hiTask.clearAttributesModifyRecords();
        return hiTask;
    }

    @Override
    public HistoricTaskInstanceEntity findHistoricTaskByTaskDefKey(String taskDefKey, Long processInstanceId) {
        QFilter q1 = new QFilter("taskDefinitionKey", "=", (Object)taskDefKey);
        QFilter q2 = new QFilter("processInstanceId", "=", (Object)processInstanceId);
        QFilter[] qFilters = new QFilter[]{q2, q1};
        return (HistoricTaskInstanceEntity)this.findOneByCondition(qFilters, this.getSelectFields(), null);
    }

    @Override
    public List<HistoricTaskInstanceEntity> findHistoricTasksByTaskDefKey(String taskDefKey, Long processInstanceId, String businesskey) {
        QFilter q1 = new QFilter("taskDefinitionKey", "=", (Object)taskDefKey);
        QFilter q2 = new QFilter("processInstanceId", "=", (Object)processInstanceId);
        QFilter q3 = new QFilter("businessKey", "=", (Object)businesskey);
        QFilter[] qFilters = new QFilter[]{q2, q3, q1};
        return this.findByQueryFilters(qFilters, this.getSelectFields(), "createdate desc");
    }

    @Override
    public String getEntityName() {
        return "wf_hitaskinst";
    }

    @Override
    public String getTableName() {
        return "t_wf_hitaskinst";
    }

    @Override
    public String getMultiLangTableName() {
        return "t_wf_hitaskinst_l";
    }

    @Override
    public DynamicObjectCollection getHandledTasksByAssigneeid(String uid, String billType, String entityNumber, int start, int limit, String filterSql, List<Object> paramsList, String orderBy) {
        return this.getHandledTasksByAssigneeid(uid, billType, entityNumber, start, limit, filterSql, "pc", paramsList, orderBy);
    }

    @Override
    public DynamicObjectCollection getHandledTasksByAssigneeid(String uid, String billType, String entityNumber, int start, int limit, String filterSql, String showType, List<Object> paramsList, String orderBy) {
        if (WfConfigurationUtil.isHiTaskSingleTableQuery().booleanValue() && WfConfigurationUtil.isUpdateHiTaskToHiCommentComplete().booleanValue()) {
            return this.getHandledTasksByAssigneeidAndSingleRelationQuery(uid, billType, entityNumber, start, limit, filterSql, showType, paramsList, orderBy);
        }
        String billEntityNumber = StringUtils.isNotBlank((CharSequence)entityNumber) ? entityNumber : billType;
        try (DataSet ds = this.historicTaskInstanceCollector.getHandledTasksByAssigneeid(uid, billType, entityNumber, start, limit, filterSql, showType, paramsList, orderBy);){
            if (ds == null) {
                DynamicObjectCollection dynamicObjectCollection = new DynamicObjectCollection(new DynamicObjectType("PlainObject"), null);
                return dynamicObjectCollection;
            }
            DynamicObjectCollection ret = ORM.create().toPlainDynamicObjectCollection(ds);
            HashMap<String, List<Long>> coordinateTaskIdsMap = new HashMap<String, List<Long>>();
            HashMap<String, JSONObject> extendFieldJsonMap = new HashMap<String, JSONObject>();
            boolean isDisplaySetting = WfConfigurationUtil.isDisplaySetting();
            FormatObject formatObject = null;
            boolean isNeedQueryBusinessField = TaskExtendFieldUtil.isNeedQueryBusinessField(billEntityNumber);
            for (DynamicObject d : ret) {
                String d_type;
                String separateStorageKey = d.getString("separateStorageKey");
                ArrayList<Long> coordinateTaskIds = (ArrayList<Long>)coordinateTaskIdsMap.get(separateStorageKey);
                if (coordinateTaskIds == null) {
                    coordinateTaskIds = new ArrayList<Long>();
                    coordinateTaskIdsMap.put(separateStorageKey, coordinateTaskIds);
                }
                if (isDisplaySetting && WfUtils.isNotEmpty(d.getString("startnameformat"))) {
                    d.set("startname", d.get("startnameformat"));
                }
                if (isDisplaySetting && WfUtils.isNotEmpty(d.getString("sendernameformat"))) {
                    d.set("sendername", d.get("sendernameformat"));
                }
                String category = d.getString("category");
                String pCaption = MessageServiceUtil.getPCCaption(d.getString("startname"), d.getString("entityname"));
                String mCaption = MessageServiceUtil.getMBCaption(d.getString("entityname"));
                if (SeparateStorageType.ORIGINAL.getKey().equals(separateStorageKey)) {
                    String url = MessageServiceUtil.buildWebPageForTaskUrl(d.getString("processingpage"), d.getString("processingmobilepage"), d.getLong("id"), "handled", d.getString("businesskey"), WfUtils.isNotEmpty(category) && BpmnModelUtil.instanceofUserTaskOnly(category), pCaption, mCaption);
                    d.set("url", (Object)url);
                } else {
                    d.set("url", null);
                }
                if (WfUtils.isNotEmpty(d.getString("currentsubject"))) {
                    d.set("subject", (Object)d.getString("currentsubject"));
                }
                if ("coordinate".equals(d_type = d.getString("d_type"))) {
                    d.set("HANDLESTATE", (Object)"handled");
                    coordinateTaskIds.add(d.getLong("id"));
                } else if ("forceReject".equals(d_type)) {
                    d.set("HANDLESTATE", (Object)d_type);
                }
                if (!isNeedQueryBusinessField || !WfUtils.isNotEmpty(entityNumber) && !WfUtils.isNotEmpty(billType)) continue;
                JSONObject json = (JSONObject)extendFieldJsonMap.get(separateStorageKey);
                if (json == null) {
                    json = TaskExtendFieldUtil.getTaskBusinessSelectFields(EntityNumberConstant.getHiTaskInstEntityNumber(separateStorageKey), billEntityNumber, "a", "b", "f");
                    extendFieldJsonMap.put(separateStorageKey, json);
                }
                if (!json.getJSONObject("fieldRelateFormatField").isEmpty()) {
                    for (Map.Entry property : json.getJSONObject("fieldRelateFormatField").entrySet()) {
                        if (!d.containsProperty((String)property.getKey())) continue;
                        d.set((String)property.getValue(), d.get((String)property.getKey()));
                    }
                }
                if (!d.containsProperty("bizformat") || !StringUtils.isNotBlank((CharSequence)d.getString("bizformat"))) continue;
                if (formatObject == null) {
                    formatObject = InteServiceHelper.getUserFormat((Long)RequestContext.get().getCurrUserId());
                }
                TaskExtendFieldUtil.formatTaskBusinessFieldVlue(d, json.getJSONObject("fieldRelateFormatField"), formatObject);
            }
            this.setCreateDateByCoordinateTaskInfo(ret, coordinateTaskIdsMap, uid);
            Iterator iterator = ret;
            return iterator;
        }
    }

    private void setCreateDateByCoordinateTaskInfo(DynamicObjectCollection ret, Map<String, List<Long>> coordinateTaskIdsMap, String uid) {
        if (ret.size() > 0 && !coordinateTaskIdsMap.isEmpty()) {
            for (Map.Entry<String, List<Long>> entry : coordinateTaskIdsMap.entrySet()) {
                String separateStorageKey = entry.getKey();
                List<Long> coordinateTaskIds = entry.getValue();
                if (!CollectionUtils.isNotEmpty(coordinateTaskIds)) continue;
                QFilter q1 = new QFilter("type", "=", (Object)"coordinate");
                QFilter q2 = new QFilter("taskid", "in", coordinateTaskIds);
                QFilter q3 = new QFilter("userid", "=", (Object)Long.valueOf(uid));
                DynamicObject[] hiparticipants = BusinessDataServiceHelper.load((String)EntityNumberConstant.getHiIdentityLinkEntityNumber(separateStorageKey), (String)"id,taskid,createdate", (QFilter[])new QFilter[]{q1, q2, q3});
                if (hiparticipants == null || hiparticipants.length <= 0) continue;
                HashMap<String, DynamicObject> coordinateTaskInfos = new HashMap<String, DynamicObject>(hiparticipants.length);
                for (DynamicObject hiparticipant : hiparticipants) {
                    coordinateTaskInfos.put(hiparticipant.getString("taskid"), hiparticipant);
                }
                for (DynamicObject d : ret) {
                    if (coordinateTaskInfos.get(d.getString("id")) == null) continue;
                    d.set("createdate", ((DynamicObject)coordinateTaskInfos.get(d.getString("id"))).get("createdate"));
                }
            }
        }
    }

    @Override
    public DynamicObjectCollection getHandledTasksByAssigneeidForApi(String uid, String billType, String entityNumber, int start, int limit, String filterSql, String showType, List<Object> paramsList, String orderBy) {
        String lang = RequestContext.get().getLang().toString();
        String endType = "";
        if ("mobile".equals(showType)) {
            endType = "pc";
        } else if ("pc".equals(showType)) {
            endType = "mobile";
        }
        String noCodeFlow = ThreadLocalVariables.get();
        boolean flag = WfUtils.isEmpty(entityNumber);
        String masterTableAlias = "a";
        String multiLangTableAlias = "b";
        String entityNameSQL = WfMultiLangUtils.getGeneralLangSQL("wf_hitaskinst", masterTableAlias, multiLangTableAlias, "fentityname", "entityname", "entityname");
        String startNameSQL = WfMultiLangUtils.getGeneralLangSQL("wf_hitaskinst", masterTableAlias, multiLangTableAlias, "FSTARTNAME", "startname", "startname");
        String subjectSQL = WfMultiLangUtils.getGeneralLangSQL("wf_hitaskinst", masterTableAlias, multiLangTableAlias, "FSUBJECT", "subject", "subject");
        String nameSQL = WfMultiLangUtils.getGeneralLangSQL("wf_hitaskinst", masterTableAlias, multiLangTableAlias, "FNAME", "name", "name");
        String senderNameSQL = WfMultiLangUtils.getGeneralLangSQL("wf_hitaskinst", masterTableAlias, multiLangTableAlias, "fsendername", "sendername", "sendername");
        String senderNameFormatSQL = WfMultiLangUtils.getGeneralLangSQL("wf_task", masterTableAlias, multiLangTableAlias, "fsendernameformat", "sendernameformat", "sendernameformat");
        String startNameFormatSQL = WfMultiLangUtils.getGeneralLangSQL("wf_task", masterTableAlias, multiLangTableAlias, "fstartnameformat", "startnameformat", "startnameformat");
        String presentAssigneeSQL = WfMultiLangUtils.getGeneralLangSQL("wf_hitaskinst", masterTableAlias, multiLangTableAlias, "fpresentassignee", "presentassignee", "presentassignee");
        String currentSubjectSQL = WfMultiLangUtils.getGeneralLangSQL("wf_hicomment", "d", "e", "fcurrentsubject", "currentsubject", "currentsubject");
        String billEntityNumber = StringUtils.isNotBlank((CharSequence)entityNumber) ? entityNumber : billType;
        String sql = "SELECT top " + (start + limit) + " a.FID id,a.fbillno billno," + entityNameSQL + "," + senderNameFormatSQL + "," + startNameFormatSQL + "," + startNameSQL + ",a.FSTARTERID initiatorId," + subjectSQL + ",a.fprocessingmobilepage processingmobilepage,a.FPROCESSINGPAGE processingpage,a.FBUSINESSKEY businesskey,a.FBUSINESSKEY url,a.FHANDLESTATE handlestate,a.FCATEGORY category," + nameSQL + "," + senderNameSQL + ",a.FCREATEDATE createdate,a.FBUSINESSKEY userImgUrl,a.FBUSINESSKEY openId,d.ftype d_type,d.FTIME ENDTIME, " + presentAssigneeSQL + "," + currentSubjectSQL + ",a.fendtime  FROM t_wf_hicomment d LEFT JOIN t_wf_hicomment_l e on d.fid = e.fid and e.flocaleid = ? and d.FUSERID = ? and d.ftype != 'suggestion' INNER JOIN t_wf_hitaskinst a ON a.fid = d.FTASKID LEFT JOIN t_wf_hitaskinst_A f ON a.fid = f.fid INNER JOIN t_wf_hitaskinst_l b ON a.FID = b.FID AND b.FLOCALEID = ? where d.FUSERID = ? and d.ftype != 'suggestion' and a.FEXECUTIONTYPE != ? and a.FISDISPLAY = '1'" + (WfUtils.isEmpty(endType) ? "" : " AND a.fendtype != ? ") + (WfUtils.isEmpty(billType) ? "" : " AND a.fbilltype = ? ") + (flag ? "" : "and a.fentitynumber=? ") + (WfUtils.isEmpty(noCodeFlow) ? "" : " and a.fprocesstype = ? ") + (WfUtils.isNotEmpty(filterSql) ? " " + filterSql : " ") + " order by " + (WfUtils.isEmpty(orderBy) ? "" : orderBy + ",") + " d.FTIME desc";
        ArrayList<Object> params = new ArrayList<Object>();
        params.addAll(Arrays.asList(lang, Long.valueOf(uid), lang, Long.valueOf(uid), "byAuto"));
        if (WfUtils.isNotEmpty(endType)) {
            params.add(endType);
        }
        if (WfUtils.isNotEmpty(billType)) {
            params.add(billType);
        }
        if (!flag) {
            params.add(entityNumber);
        }
        if (WfUtils.isNotEmpty(noCodeFlow)) {
            params.add(noCodeFlow);
        }
        params.addAll(paramsList);
        try (DataSet ds = DB.queryDataSet((String)"WfTaskCenter.wf_task.queryGridData", (DBRoute)WfUtils.WFS, (String)sql, (Object[])params.toArray());){
            QFilter q3;
            QFilter q2;
            QFilter q1;
            DynamicObject[] hiparticipants;
            DynamicObjectCollection ret = ORM.create().toPlainDynamicObjectCollection(ds, start, limit);
            ArrayList<Long> coordinateTaskIds = new ArrayList<Long>();
            boolean isDisplaySetting = WfConfigurationUtil.isDisplaySetting();
            for (DynamicObject d : ret) {
                String d_type;
                if (isDisplaySetting && WfUtils.isNotEmpty(d.getString("startnameformat"))) {
                    d.set("startname", d.get("startnameformat"));
                }
                if (isDisplaySetting && WfUtils.isNotEmpty(d.getString("sendernameformat"))) {
                    d.set("sendername", d.get("sendernameformat"));
                }
                String category = d.getString("category");
                String pCaption = MessageServiceUtil.getPCCaption(d.getString("startname"), d.getString("entityname"));
                String mCaption = MessageServiceUtil.getMBCaption(d.getString("entityname"));
                String url = MessageServiceUtil.buildWebPageForTaskUrl(d.getString("processingpage"), d.getString("processingmobilepage"), d.getLong("id"), "handled", d.getString("businesskey"), WfUtils.isNotEmpty(category) && BpmnModelUtil.instanceofUserTaskOnly(category), pCaption, mCaption);
                d.set("url", (Object)url);
                if (WfUtils.isNotEmpty(d.getString("currentsubject"))) {
                    d.set("subject", (Object)d.getString("currentsubject"));
                }
                if ("coordinate".equals(d_type = d.getString("d_type"))) {
                    d.set("HANDLESTATE", (Object)"handled");
                    coordinateTaskIds.add(d.getLong("id"));
                    continue;
                }
                if (!"forceReject".equals(d_type)) continue;
                d.set("HANDLESTATE", (Object)d_type);
            }
            if (CollectionUtils.isNotEmpty(coordinateTaskIds) && (hiparticipants = BusinessDataServiceHelper.load((String)"wf_hiparticipant", (String)"id,taskid,createdate", (QFilter[])new QFilter[]{q1 = new QFilter("type", "=", (Object)"coordinate"), q2 = new QFilter("taskid", "in", coordinateTaskIds), q3 = new QFilter("userid", "=", (Object)Long.valueOf(uid))})) != null && hiparticipants.length > 0) {
                HashMap<String, DynamicObject> coordinateTaskInfos = new HashMap<String, DynamicObject>(hiparticipants.length);
                for (DynamicObject hiparticipant : hiparticipants) {
                    coordinateTaskInfos.put(hiparticipant.getString("taskid"), hiparticipant);
                }
                for (DynamicObject d : ret) {
                    if (coordinateTaskInfos.get(d.getString("id")) == null) continue;
                    d.set("createdate", ((DynamicObject)coordinateTaskInfos.get(d.getString("id"))).get("createdate"));
                }
            }
            Iterator iterator = ret;
            return iterator;
        }
    }

    @Override
    public long getHandledTasksCountByAssigneeid(String uid, String billType, String entityNumber, String filterSql, List<Object> paramsList) {
        if (WfConfigurationUtil.isHiTaskSingleTableQuery().booleanValue() && WfConfigurationUtil.isUpdateHiTaskToHiCommentComplete().booleanValue()) {
            return this.getHandledTasksCountByAssigneeidAndSingleRelationQuery(uid, billType, entityNumber, filterSql, paramsList);
        }
        String hiCommentTableName = TableNameConstant.getHiCommentTableName();
        String hiTaskInstTableName = this.getTableName();
        String hiTaskInstSplitTableName = String.format("%s_A", hiTaskInstTableName);
        String hiTaskInstMultiLTableName = this.getMultiLangTableName();
        String lang = RequestContext.get().getLang().toString();
        String noCodeFlow = ThreadLocalVariables.get();
        StringBuilder sql = new StringBuilder();
        sql.append("select count(1) count from ").append(hiCommentTableName).append(" d ");
        sql.append("INNER JOIN ").append(hiTaskInstTableName).append(" a ON a.fid = d.FTASKID and d.fuserid=? and d.ftype != 'suggestion' ");
        sql.append("LEFT JOIN ").append(hiTaskInstSplitTableName).append(" f on a.fid = f.fid ");
        sql.append("LEFT JOIN ").append(hiTaskInstMultiLTableName).append(" b ON a.FID = b.FID and b.flocaleid = ? ");
        sql.append("where d.fuserid=? and d.ftype != 'suggestion' ");
        sql.append("and a.fexecutiontype != ? and a.fisdisplay = '1' and a.fendtype != 'mobile' ");
        sql.append(WfUtils.isEmpty(entityNumber) ? " " : "and a.fentitynumber=? ");
        sql.append(WfUtils.isEmpty(noCodeFlow) ? " " : "and a.fprocesstype=? ");
        sql.append(WfUtils.isEmpty(billType) ? " " : "and a.fbilltype=? ");
        sql.append(WfUtils.isEmpty(filterSql) ? "" : filterSql);
        ArrayList<Object> params = new ArrayList<Object>();
        if (WfUtils.isEmpty(entityNumber)) {
            params.addAll(Arrays.asList(Long.valueOf(uid), lang, Long.valueOf(uid), "byAuto"));
        } else {
            params.addAll(Arrays.asList(Long.valueOf(uid), lang, Long.valueOf(uid), "byAuto", entityNumber));
        }
        if (WfUtils.isNotEmpty(noCodeFlow)) {
            params.add(ModelType.NoCodeFlow.name());
        }
        if (WfUtils.isNotEmpty(billType)) {
            params.add(billType);
        }
        params.addAll(paramsList);
        long count = 0L;
        try (DataSet ds = DB.queryDataSet((String)"WFTASK.hitasksCount", (DBRoute)WfUtils.WFS, (String)sql.toString(), (Object[])params.toArray());){
            Iterator iter = ds.iterator();
            if (iter.hasNext()) {
                count = ((Row)iter.next()).getLong("count");
            }
        }
        return count;
    }

    @Override
    public long getHandledTasksUnionCountByAssigneeid(String uid, String billType, String entityNumber, String filterSql, List<Object> paramsList) {
        if (WfConfigurationUtil.isHiTaskSingleTableQuery().booleanValue() && WfConfigurationUtil.isUpdateHiTaskToHiCommentComplete().booleanValue()) {
            return this.getHandledTasksUnionCountByAssigneeidAndSingleRelationQuery(uid, billType, entityNumber, filterSql, paramsList);
        }
        long count = 0L;
        try (DataSet ds = this.historicTaskInstanceCollector.getHandledTasksUnionCountByAssigneeid(uid, billType, entityNumber, filterSql, paramsList);){
            Iterator iter = ds.iterator();
            while (iter.hasNext()) {
                count += ((Row)iter.next()).getLong("count").longValue();
            }
        }
        return count;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public DynamicObjectCollection getHandledTaskByFolderId(long folderId, int start, int limit, String filterSql, List<Object> paramsList, String orderBy) {
        if (WfConfigurationUtil.isHiTaskSingleTableQuery().booleanValue() && WfConfigurationUtil.isUpdateHiTaskToHiCommentComplete().booleanValue()) {
            return this.getHandledTaskByFolderIdAndSingleRelationQuery(folderId, start, limit, filterSql, paramsList, orderBy);
        }
        try (DataSet ds = this.historicTaskInstanceCollector.getHandledTaskByFolderId(folderId, start, limit, filterSql, paramsList, orderBy);){
            DynamicObjectCollection ret = ORM.create().toPlainDynamicObjectCollection(ds);
            boolean isDisplaySetting = WfConfigurationUtil.isDisplaySetting();
            for (DynamicObject dynamicObject : ret) {
                if (dynamicObject != null && isDisplaySetting && WfUtils.isNotEmpty(dynamicObject.getString("startnameformat"))) {
                    dynamicObject.set("startname", (Object)dynamicObject.getString("startnameformat"));
                }
                if (dynamicObject != null && isDisplaySetting && WfUtils.isNotEmpty(dynamicObject.getString("sendernameformat"))) {
                    dynamicObject.set("sendername", (Object)dynamicObject.getString("sendernameformat"));
                }
                if (dynamicObject == null || !WfUtils.isNotEmpty(dynamicObject.getString("currentsubject"))) continue;
                dynamicObject.set("subject", (Object)dynamicObject.getString("currentsubject"));
            }
            Iterator iterator = ret;
            return iterator;
        }
        catch (Exception e) {
            this.logger.info(String.format("getHandledTaskByFolderId has error: %s", WfUtils.getExceptionStacktrace(e)));
            return null;
        }
    }

    @Override
    public long getHandledTaskCountByFolderId(long folderId, String filterSql, List<Object> paramsList) {
        if (WfConfigurationUtil.isHiTaskSingleTableQuery().booleanValue() && WfConfigurationUtil.isUpdateHiTaskToHiCommentComplete().booleanValue()) {
            return this.getHandledTaskCountByFolderIdAndSingleRelationQuery(folderId, filterSql, paramsList);
        }
        long count = 0L;
        try (DataSet ds = this.historicTaskInstanceCollector.getHandledTaskCountByFolderId(folderId, filterSql, paramsList);){
            Iterator iter = ds.iterator();
            while (iter.hasNext()) {
                count += ((Row)iter.next()).getLong("count").longValue();
            }
        }
        catch (Exception e) {
            this.logger.info(String.format("getHandledTaskCountByFolderId has error: %s", WfUtils.getExceptionStacktrace(e)));
        }
        return count;
    }

    @Override
    public DynamicObjectCollection getTransferHandledTask(String uid, int start, int limit, String filterSql, List<Object> paramsList, String orderBy) {
        if (WfConfigurationUtil.isHiTaskSingleTableQuery().booleanValue() && WfConfigurationUtil.isUpdateHiTaskToHiCommentComplete().booleanValue()) {
            return this.getTransferHandledTasksBySingleRelationQuery(uid, start, limit, filterSql, paramsList, orderBy);
        }
        String lang = RequestContext.get().getLang().toString();
        String masterTableAlias = "a";
        String multiLangTableAlias = "b";
        String sourceNameSQL = WfMultiLangUtils.getGeneralLangSQL("wf_hitaskinst", masterTableAlias, multiLangTableAlias, "fsourcename", "sourcename", "sourcename");
        String entityNameSQL = WfMultiLangUtils.getGeneralLangSQL("wf_hitaskinst", masterTableAlias, multiLangTableAlias, "fentityname", "entityname", "entityname");
        String startNameSQL = WfMultiLangUtils.getGeneralLangSQL("wf_hitaskinst", masterTableAlias, multiLangTableAlias, "FSTARTNAME", "startname", "startname");
        String subjectSQL = WfMultiLangUtils.getGeneralLangSQL("wf_hitaskinst", masterTableAlias, multiLangTableAlias, "FSUBJECT", "SUBJECT", "subject");
        String nameSQL = WfMultiLangUtils.getGeneralLangSQL("wf_hitaskinst", masterTableAlias, multiLangTableAlias, "FNAME", "NAME", "name");
        String senderNameSQL = WfMultiLangUtils.getGeneralLangSQL("wf_hitaskinst", masterTableAlias, multiLangTableAlias, "fassignee", "sendername", "assignee");
        String startNameFormatSQL = WfMultiLangUtils.getGeneralLangSQL("wf_task", masterTableAlias, multiLangTableAlias, "fstartnameformat", "startnameformat", "startnameformat");
        String presentAssigneeSQL = WfMultiLangUtils.getGeneralLangSQL("wf_hitaskinst", masterTableAlias, multiLangTableAlias, "fpresentassignee", "presentassignee", "presentassignee");
        String currentSubjectSQL = WfMultiLangUtils.getGeneralLangSQL("wf_taskhandlelog", "c", "e", "fcurrentsubject", "currentsubject", "currentsubject");
        ArrayList<Object> params = new ArrayList<Object>();
        Long userId = Long.parseLong(uid);
        StringBuilder sql = new StringBuilder();
        sql.append("select top ").append(start + limit).append(" ");
        sql.append("a.fid id, a.fbillno billno, a.fhandlestate handlestate, a.fendtime endtime, c.ftype type, a.fcreatedate createdate, ");
        sql.append(sourceNameSQL).append(", ").append(entityNameSQL).append(", ").append(startNameSQL).append(", ");
        sql.append(startNameFormatSQL).append(", ").append(subjectSQL).append(", ").append(nameSQL).append(", ");
        sql.append(senderNameSQL).append(", ").append(presentAssigneeSQL).append(", ").append(currentSubjectSQL).append(" ");
        sql.append("from t_wf_taskhandlelog c ");
        sql.append("inner join t_wf_taskhandlelog_l e on c.fownerid = ? and c.fisadminforward = '0' and c.ftype = 'transfer' and c.fid = e.fid and e.flocaleid = ? ");
        sql.append("inner join t_wf_hitaskinst a on c.ftaskid = a.fid ");
        sql.append("inner join t_wf_hitaskinst_l b on a.fid = b.fid and b.flocaleid = ? ");
        sql.append("where c.fownerid = ? and c.fisadminforward = '0' and c.ftype = 'transfer' ");
        sql.append("and a.fendtime is not null and a.fexecutiontype = 'byHand' and a.fendtype != 'mobile' and a.fprocesstype != ? ");
        params.addAll(Arrays.asList(userId, lang, lang, userId, ModelType.NoCodeFlow.name()));
        if (WfUtils.isNotEmpty(filterSql)) {
            sql.append(filterSql);
            params.addAll(paramsList);
        }
        sql.append(" order by ");
        if (WfUtils.isNotEmpty(orderBy)) {
            sql.append(orderBy).append(", ");
        }
        sql.append("a.fid desc;");
        try (DataSet ds = DB.queryDataSet((String)"WfTaskCenterCustom.queryGridData", (DBRoute)WfUtils.WFS, (String)sql.toString(), (Object[])params.toArray());){
            DynamicObjectCollection ret = ORM.create().toPlainDynamicObjectCollection(ds, start, limit);
            if (ret == null || ret.size() == 0) {
                DynamicObjectCollection dynamicObjectCollection = ret;
                return dynamicObjectCollection;
            }
            DynamicObjectCollection col = new DynamicObjectCollection();
            HashMap<Long, Integer> p = new HashMap<Long, Integer>();
            boolean isDisplaySetting = WfConfigurationUtil.isDisplaySetting();
            for (int i = 0; i < ret.size(); ++i) {
                DynamicObject dyObject = (DynamicObject)ret.get(i);
                Long taskId = dyObject.getLong("id");
                Object indexTemp = p.get(taskId);
                String startNameFormat = dyObject.getString("startnameformat");
                if (isDisplaySetting && WfUtils.isNotEmpty(startNameFormat)) {
                    dyObject.set("startname", (Object)startNameFormat);
                }
                if (indexTemp != null) {
                    Integer index;
                    Date dateInMap;
                    Date dateOfCurrent = dyObject.getDate("createdate");
                    if (dateOfCurrent.after(dateInMap = ((DynamicObject)col.get((index = Integer.valueOf(String.valueOf(p.get(taskId)))).intValue())).getDate("createdate"))) {
                        col.remove(index.intValue());
                        col.add((Object)dyObject);
                    }
                } else {
                    col.add((Object)dyObject);
                    p.put(taskId, col.size() - 1);
                }
                if (!WfUtils.isNotEmpty(dyObject.getString("currentsubject"))) continue;
                dyObject.set("subject", (Object)dyObject.getString("currentsubject"));
            }
            DynamicObjectCollection dynamicObjectCollection = col;
            return dynamicObjectCollection;
        }
    }

    @Override
    public int getTransferHandledTaskCount(String uid, String filterSql, List<Object> paramsList) {
        if (WfConfigurationUtil.isHiTaskSingleTableQuery().booleanValue() && WfConfigurationUtil.isUpdateHiTaskToHiCommentComplete().booleanValue()) {
            return this.getTransferHandledTasksCountBySingleRelationQuery(uid, filterSql, paramsList);
        }
        StringBuilder sql = new StringBuilder();
        sql.append("select count(1) count ");
        sql.append("from t_wf_taskhandlelog c ");
        sql.append("inner join t_wf_hitaskinst a on c.ftaskid = a.fid ");
        sql.append("left join t_wf_hitaskinst_l b on a.fid = b.fid and b.flocaleid = ? ");
        sql.append("where c.fownerid = ? and c.fisadminforward = '0' and c.ftype = 'transfer' ");
        sql.append("and a.fendtime is not null and a.fexecutiontype = 'byHand' and a.fendtype != 'mobile' and a.fprocesstype != ? ");
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(RequestContext.get().getLang().toString());
        params.add(Long.valueOf(uid));
        params.add(ModelType.NoCodeFlow.name());
        if (WfUtils.isNotEmpty(filterSql)) {
            sql.append(filterSql);
            params.addAll(paramsList);
        }
        int count = 0;
        try (DataSet ds = DB.queryDataSet((String)"wf_toHandle_transfer_count", (DBRoute)WfUtils.WFS, (String)sql.toString(), (Object[])params.toArray());){
            Iterator iter = ds.iterator();
            if (iter.hasNext()) {
                Row row = (Row)iter.next();
                count = row.getInteger("count");
            }
        }
        return count;
    }

    @Override
    public DynamicObjectCollection getDelegateHandledTask(String uid, int start, int limit, String filterSql, List<Object> paramsList, String orderBy) {
        if (WfConfigurationUtil.isHiTaskSingleTableQuery().booleanValue() && WfConfigurationUtil.isUpdateHiTaskToHiCommentComplete().booleanValue()) {
            return this.getDelegateHandledTasksBySingleRelationQuery(uid, start, limit, filterSql, paramsList, orderBy);
        }
        if (filterSql.contains("a.fcreatedate")) {
            filterSql = filterSql.replace("a.fcreatedate", "c.fcreatedate");
        }
        ArrayList<Object> params = new ArrayList<Object>();
        String lang = RequestContext.get().getLang().toString();
        String masterTableAlias = "a";
        String multiLangTableAlias = "b";
        String sourceNameSQL = WfMultiLangUtils.getGeneralLangSQL("wf_hitaskinst", masterTableAlias, multiLangTableAlias, "fsourcename", "sourcename", "sourcename");
        String entityNameSQL = WfMultiLangUtils.getGeneralLangSQL("wf_hitaskinst", masterTableAlias, multiLangTableAlias, "fentityname", "entityname", "entityname");
        String startNameSQL = WfMultiLangUtils.getGeneralLangSQL("wf_hitaskinst", masterTableAlias, multiLangTableAlias, "fstartname", "startname", "startname");
        String subjectSQL = WfMultiLangUtils.getGeneralLangSQL("wf_hitaskinst", masterTableAlias, multiLangTableAlias, "fsubject", "subject", "subject");
        String nameSQL = WfMultiLangUtils.getGeneralLangSQL("wf_hitaskinst", masterTableAlias, multiLangTableAlias, "fname", "name", "name");
        String senderNameSQL = WfMultiLangUtils.getGeneralLangSQL("wf_hitaskinst", masterTableAlias, multiLangTableAlias, "fsendername", "sendername", "sendername");
        String userNameFormatSql = WfMultiLangUtils.getGeneralLangSQL("wf_participant", "c", "d", "fusernameformatter", "usernameformatter", "usernameformatter");
        String startNameFormatSQL = WfMultiLangUtils.getGeneralLangSQL("wf_task", masterTableAlias, multiLangTableAlias, "fstartnameformat", "startnameformat", "startnameformat");
        String senderNameFormatSQL = WfMultiLangUtils.getGeneralLangSQL("wf_task", masterTableAlias, multiLangTableAlias, "fsendernameformat", "sendernameformat", "sendernameformat");
        String presentAssigneeSQL = WfMultiLangUtils.getGeneralLangSQL("wf_hitaskinst", masterTableAlias, multiLangTableAlias, "fpresentassignee", "presentassignee", "presentassignee");
        StringBuilder sql = new StringBuilder();
        sql.append("select top ").append(start + limit).append(" a.fid id,a.fbillno billno,a.fhandlestate handlestate,a.fassigneeid assigneeid ,c.fuserid userid,");
        sql.append(sourceNameSQL).append(", ").append(entityNameSQL).append(",").append(startNameSQL).append(",").append(subjectSQL).append(",").append(nameSQL).append(",");
        sql.append(senderNameSQL).append(",").append(userNameFormatSql).append(",").append(startNameFormatSQL).append(",").append(senderNameFormatSQL).append(",").append(presentAssigneeSQL).append(",").append("a.fendtime endtime,d.fusername trustee,c.fcreatedate createdate ");
        sql.append("from t_wf_hiparticipant c ");
        sql.append("inner join t_wf_hiparticipant_l d on d.fid = c.fid and d.flocaleid = ? and c.fownerid = ? ");
        params.add(lang);
        params.add(Long.parseLong(uid));
        sql.append("inner join t_wf_hitaskinst a on a.fid = c.ftaskid ");
        sql.append("inner join t_wf_hitaskinst_l b on a.fid = b.fid and b.flocaleid = ? ");
        params.add(lang);
        sql.append("where c.fownerid = ? and c.ftype = 'participant' and c.fendtime is not null and c.fdelegateid > 0 ");
        params.add(Long.parseLong(uid));
        sql.append("and a.fendtype != 'mobile' and a.fendtime is not null and a.fexecutiontype = 'byHand' and a.fprocesstype != ? ");
        params.add(ModelType.NoCodeFlow.name());
        if (!WfUtils.isEmpty(filterSql)) {
            sql.append(filterSql);
            params.addAll(paramsList);
        }
        if (!WfUtils.isEmpty(orderBy)) {
            sql.append("order by ").append(orderBy);
        } else {
            sql.append("order by a.fendtime desc");
        }
        try (DataSet ds = DB.queryDataSet((String)this.createAlgoKey(), (DBRoute)WfUtils.WFS, (String)sql.toString(), (Object[])params.toArray());){
            DynamicObjectCollection resultDynamicObjectCollection = ORM.create().toPlainDynamicObjectCollection(ds, start, limit);
            boolean isDisplaySetting = WfConfigurationUtil.isDisplaySetting();
            DynamicObjectCollection refinedResults = new DynamicObjectCollection();
            for (DynamicObject resultDynamicObject : resultDynamicObjectCollection) {
                Long assigneeId = resultDynamicObject.getLong("assigneeid");
                Long userId = resultDynamicObject.getLong("userid");
                if (WfUtils.isNotEmpty(assigneeId) && !assigneeId.equals(userId)) continue;
                if (resultDynamicObject != null && isDisplaySetting && WfUtils.isNotEmpty(resultDynamicObject.getString("startnameformat"))) {
                    resultDynamicObject.set("startname", (Object)resultDynamicObject.getString("startnameformat"));
                }
                if (resultDynamicObject != null && isDisplaySetting && WfUtils.isNotEmpty(resultDynamicObject.getString("usernameformatter")) && !"false".equals(resultDynamicObject.getString("usernameformatter"))) {
                    resultDynamicObject.set("trustee", (Object)resultDynamicObject.getString("usernameformatter"));
                }
                if (resultDynamicObject != null && isDisplaySetting && WfUtils.isNotEmpty(resultDynamicObject.getString("sendernameformat")) && !"false".equals(resultDynamicObject.getString("sendernameformat"))) {
                    resultDynamicObject.set("sendername", (Object)resultDynamicObject.getString("sendernameformat"));
                }
                refinedResults.add((Object)resultDynamicObject);
            }
            if (refinedResults == null || refinedResults.isEmpty()) {
                DynamicObjectType dt = new DynamicObjectType();
                refinedResults = new DynamicObjectCollection(dt, new Object());
            }
            Iterator iterator = refinedResults;
            return iterator;
        }
    }

    @Override
    public int getDelegateHandledTaskCount(String userId, String filterSql, List<Object> paramsList) {
        if (WfConfigurationUtil.isHiTaskSingleTableQuery().booleanValue() && WfConfigurationUtil.isUpdateHiTaskToHiCommentComplete().booleanValue()) {
            return this.getDelegateHandledTasksDataCountBySingleRelationQuery(userId, filterSql, paramsList);
        }
        if (filterSql.contains("a.fcreatedate")) {
            filterSql = filterSql.replace("a.fcreatedate", "c.fcreatedate");
        }
        String lang = RequestContext.get().getLang().toString();
        ArrayList<Object> params = new ArrayList<Object>();
        StringBuilder sql = new StringBuilder();
        sql.append(" select count(1) count from t_wf_hiparticipant c");
        sql.append(" inner join t_wf_hitaskinst a on c.ftaskid = a.fid and c.fownerid = ").append(Long.parseLong(userId));
        if (filterSql.contains("b.")) {
            sql.append(" inner join t_wf_hitaskinst_l b on a.fid = b.fid and b.flocaleid = ? ");
            params.add(lang);
        }
        sql.append(" where a.fassigneeid > 0 and a.fendtime is not null and a.fexecutiontype = 'byHand' and a.fendtype != 'mobile' and a.fprocesstype != ? ");
        sql.append(" and c.fownerid = ? and c.ftype = 'participant' and c.fendtime is not null and c.fdelegateid > 0 ");
        params.add(ModelType.NoCodeFlow.name());
        params.add(Long.parseLong(userId));
        if (!WfUtils.isEmpty(filterSql)) {
            sql.append(filterSql);
            params.addAll(paramsList);
        }
        int count = 0;
        try (DataSet ds = DB.queryDataSet((String)this.createAlgoKey(), (DBRoute)WfUtils.WFS, (String)sql.toString(), (Object[])params.toArray());){
            Iterator iter = ds.iterator();
            if (iter.hasNext()) {
                Row row = (Row)iter.next();
                count = row.getInteger("count");
            }
        }
        return count;
    }

    @Override
    public List<Map<String, Object>> getEntityByUser(Long userId) {
        String entityNameSQL = WfMultiLangUtils.getGeneralLangSQL(this.getEntityName(), "a", "b", "fentityName", "entityname", "entityname");
        String sql = "SELECT distinct " + entityNameSQL + ",a.FENTITYNUMBER entitynumber, a.fbusinesskey businesskey, a.fbilltype billtype from " + this.getTableName() + " a INNER JOIN " + this.getMultiLangTableName() + " b on a.FID = b.FID where a.FASSIGNEEID=? AND a.FENDTIME is not null and a.FISDISPLAY = ? AND a.fendtype != 'pc' AND b.FLOCALEID =? ";
        Object[] params = new Object[]{userId, "1", RequestContext.get().getLang().toString()};
        List<Map<String, Object>> entityMap = WfUtils.getEntityProperties(sql, params);
        return entityMap;
    }

    @Override
    public HistoricTaskInstanceEntity findEntityForMyInitiation(Long processInstanceId) {
        EntityQueryBuilder queryBuilder = this.createQueryBuilder().addFilter("processInstanceId", processInstanceId).orderBy("createDate desc");
        List entities = this.findByQueryBuilder(queryBuilder);
        if (null != entities && 0 != entities.size()) {
            return (HistoricTaskInstanceEntity)entities.get(0);
        }
        return null;
    }

    @Override
    public List<HistoricTaskInstanceEntity> findCompositeTasksByTaskId(Long taskId, Long processInstanceId) {
        CommandContext commandContext = Context.getCommandContext();
        QFilter procinstFilter = new QFilter("processinstanceid", "=", (Object)processInstanceId);
        QFilter taskFilter = new QFilter("taskid", ">", (Object)0);
        QFilter comFilter = new QFilter("compositetaskid", "=", (Object)taskId);
        List identityLinkEntities = commandContext.getIdentityLinkEntityManager().findByQueryFilters(new QFilter[]{procinstFilter, taskFilter, comFilter});
        if (CollectionUtils.isNotEmpty(identityLinkEntities)) {
            ArrayList<Long> taskIds = new ArrayList<Long>(identityLinkEntities.size());
            for (IdentityLinkEntity dentityLinkEntity : identityLinkEntities) {
                taskIds.add(dentityLinkEntity.getTaskId());
            }
            return this.findByQueryFilters(new QFilter[]{new QFilter("id", "in", taskIds)});
        }
        return new ArrayList<HistoricTaskInstanceEntity>();
    }

    @Override
    public List<HistoricTaskInstanceEntity> findApprovedTaskByParentTaskId(Long procInstanceId, Long parentTaskId) {
        QFilter proInst = new QFilter("processInstanceId", "=", (Object)procInstanceId);
        QFilter parent = new QFilter("parentTaskId", "=", (Object)parentTaskId);
        QFilter endtime = new QFilter("endTime", "is not null", null);
        QFilter[] fs = new QFilter[]{proInst, parent, endtime};
        return this.findByQueryFilters(fs);
    }

    @Override
    public DynamicObjectCollection getDelegateTasks(int start, int limit, String filterSql, List<Object> paramsList, String orderBy, boolean includeAllDelegateData) {
        if (WfConfigurationUtil.isHiTaskSingleTableQuery().booleanValue() && WfConfigurationUtil.isUpdateHiTaskToHiCommentComplete().booleanValue() && !includeAllDelegateData) {
            return this.getDelegateTasksBySingleRelationQuery(start, limit, filterSql, paramsList, orderBy);
        }
        String lang = RequestContext.get().getLang().toString();
        String masterTableAlias = "a";
        String multiLangTableAlias = "b";
        String sourceNameSQL = WfMultiLangUtils.getGeneralLangSQL("wf_hitaskinst", masterTableAlias, multiLangTableAlias, "fsourcename", "sourcename", "sourcename");
        String entityNameSQL = WfMultiLangUtils.getGeneralLangSQL("wf_hitaskinst", masterTableAlias, multiLangTableAlias, "fentityname", "entityname", "entityname");
        String startNameSQL = WfMultiLangUtils.getGeneralLangSQL("wf_hitaskinst", masterTableAlias, multiLangTableAlias, "fstartname", "startname", "startname");
        String subjectSQL = WfMultiLangUtils.getGeneralLangSQL("wf_hitaskinst", masterTableAlias, multiLangTableAlias, "fsubject", "subject", "subject");
        String nameSQL = WfMultiLangUtils.getGeneralLangSQL("wf_hitaskinst", masterTableAlias, multiLangTableAlias, "fname", "name", "name");
        String senderNameSQL = WfMultiLangUtils.getGeneralLangSQL("wf_hitaskinst", masterTableAlias, multiLangTableAlias, "fsendername", "sendername", "sendername");
        StringBuilder sql = new StringBuilder();
        sql.append("select top ").append(start + limit).append(" ");
        sql.append("a.fid id,a.fdeletereason deletereason,a.fbillno billno,").append(sourceNameSQL).append(", ").append(entityNameSQL).append(",");
        sql.append(startNameSQL).append(",").append(subjectSQL).append(",").append("a.fhandlestate handlestate,");
        sql.append(nameSQL).append(",").append(senderNameSQL).append(",").append("a.fcreatedate createdate ").append(", ").append("c.fdelegateid delegateid ,a.fassigneeid assigneeid ,c.fuserid userid,c.fownerid ownerid ");
        sql.append("from t_wf_hiparticipant c ");
        sql.append("inner join t_wf_hitaskinst a on c.ftaskid = a.fid and c.fdelegateid > 0 ");
        sql.append("inner join t_wf_hitaskinst_l b on a.fid = b.fid and b.flocaleid = ? ");
        sql.append("where a.fisdisplay = '1' and a.fendtype != 'mobile' and a.fexecutiontype not in ('skip', 'byAuto') ");
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(lang);
        if (!WfUtils.isEmpty(filterSql)) {
            sql.append(filterSql).append(" ");
            params.addAll(paramsList);
        }
        if (WfUtils.isEmpty(orderBy)) {
            sql.append(" order by a.fcreatedate desc");
        } else {
            sql.append(" order by ").append(orderBy);
        }
        try (DataSet ds = DB.queryDataSet((String)this.createAlgoKey(), (DBRoute)WfUtils.WFS, (String)sql.toString(), (Object[])params.toArray());){
            DynamicObjectCollection preliminaryResults = ORM.create().toPlainDynamicObjectCollection(ds, start, limit);
            DynamicObjectCollection refinedResults = new DynamicObjectCollection();
            for (DynamicObject preliminaryResult : preliminaryResults) {
                String deletereason;
                Long assigneeId = preliminaryResult.getLong("assigneeid");
                Long userId = preliminaryResult.getLong("userid");
                String handlestate = preliminaryResult.getString("handlestate");
                if (("approve".equals(handlestate) || "handled".equals(handlestate)) && WfUtils.isNotEmpty(assigneeId) && !assigneeId.equals(userId) || "fork_jumpOrReject".equals(deletereason = preliminaryResult.getString("deletereason")) || "task skip".equals(deletereason)) continue;
                refinedResults.add((Object)preliminaryResult);
            }
            if (refinedResults == null || refinedResults.isEmpty()) {
                DynamicObjectType dt = new DynamicObjectType();
                refinedResults = new DynamicObjectCollection(dt, new Object());
            }
            Iterator iterator = refinedResults;
            return iterator;
        }
    }

    @Override
    public DynamicObjectCollection getDelegateTasks(int start, int limit, String filterSql, List<Object> paramsList, String orderBy) {
        return this.getDelegateTasks(start, limit, filterSql, paramsList, orderBy, false);
    }

    @Override
    public long getDelegateTasksDataCount(String filterSql, List<Object> paramsList) {
        return this.getDelegateTasksDataCount(filterSql, paramsList, false);
    }

    @Override
    public long getDelegateTasksDataCount(String filterSql, List<Object> paramsList, boolean includeAllDelegateData) {
        if (WfConfigurationUtil.isHiTaskSingleTableQuery().booleanValue() && WfConfigurationUtil.isUpdateHiTaskToHiCommentComplete().booleanValue() && !includeAllDelegateData) {
            return this.getDelegateTasksDataCountBySingleRelationQuery(filterSql, paramsList);
        }
        StringBuilder sql = new StringBuilder();
        sql.append("select count(distinct a.fid) count ");
        sql.append("from t_wf_hiparticipant c ");
        sql.append("inner join t_wf_hitaskinst a on c.ftaskid = a.fid and c.fdelegateid > 0 ");
        sql.append("left join t_wf_hitaskinst_l b on b.fid = a.fid and b.flocaleid = ? ");
        sql.append("where a.fisdisplay = '1' and a.fexecutiontype != ? and a.fendtype != 'mobile' ");
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(RequestContext.get().getLang().toString());
        params.add("byAuto");
        if (!WfUtils.isEmpty(filterSql)) {
            sql.append(filterSql).append(" ");
            params.addAll(paramsList);
        }
        long count = 0L;
        try (DataSet ds = DB.queryDataSet((String)this.createAlgoKey(), (DBRoute)WfUtils.WFS, (String)sql.toString(), (Object[])params.toArray());){
            Iterator iter = ds.iterator();
            if (iter.hasNext()) {
                count = ((Row)iter.next()).getLong("count");
            }
        }
        return count;
    }

    @Override
    public List<HistoricTaskInstanceEntity> getHiTasksByEntitynumber(String entityNumber, Date createDate, String orderby, int limit) {
        EntityQueryBuilder queryBuilder = this.createQueryBuilder();
        queryBuilder.addFilter("entitynumber", "=", entityNumber);
        queryBuilder.addFilter("createdate", "<=", createDate);
        queryBuilder.setLimit(limit).orderBy(orderby);
        return this.findByQueryBuilder(queryBuilder);
    }

    private DynamicObjectCollection getHandledTasksByAssigneeidAndSingleRelationQuery(String uid, String billType, String entityNumber, int start, int limit, String filterSql, String showType, List<Object> paramsList, String orderBy) {
        String masterTableAlias = "a";
        String multiLangTableAlias = "b";
        String billEntityNumber = StringUtils.isNotBlank((CharSequence)entityNumber) ? entityNumber : billType;
        try (DataSet ds = this.historicTaskInstanceCollector.getHandledTasksByAssigneeidAndSingleRelationQuery(uid, billType, entityNumber, start, limit, filterSql, showType, paramsList, orderBy);){
            if (ds == null) {
                DynamicObjectCollection dynamicObjectCollection = new DynamicObjectCollection(new DynamicObjectType("PlainObject"), null);
                return dynamicObjectCollection;
            }
            DynamicObjectCollection ret = ORM.create().toPlainDynamicObjectCollection(ds);
            boolean isDisplaySetting = WfConfigurationUtil.isDisplaySetting();
            FormatObject formatObject = null;
            HashMap<String, JSONObject> extendFieldJsonMap = new HashMap<String, JSONObject>();
            boolean isNeedQueryBusinessField = TaskExtendFieldUtil.isNeedQueryBusinessField(billEntityNumber);
            for (DynamicObject d : ret) {
                String separateStorageKey = d.getString("separateStorageKey");
                if (isDisplaySetting && WfUtils.isNotEmpty(d.getString("startnameformat"))) {
                    d.set("startname", d.get("startnameformat"));
                }
                if (isDisplaySetting && WfUtils.isNotEmpty(d.getString("sendernameformat"))) {
                    d.set("sendername", d.get("sendernameformat"));
                }
                String category = d.getString("category");
                String pCaption = MessageServiceUtil.getPCCaption(d.getString("startname"), d.getString("entityname"));
                String mCaption = MessageServiceUtil.getMBCaption(d.getString("entityname"));
                if (SeparateStorageType.ORIGINAL.getKey().equals(separateStorageKey)) {
                    String url = MessageServiceUtil.buildWebPageForTaskUrl(d.getString("processingpage"), d.getString("processingmobilepage"), d.getLong("id"), "handled", d.getString("businesskey"), WfUtils.isNotEmpty(category) && BpmnModelUtil.instanceofUserTaskOnly(category), pCaption, mCaption);
                    d.set("url", (Object)url);
                } else {
                    d.set("url", null);
                }
                String type = d.getString("d_type");
                if ("coordinate".equals(type)) {
                    d.set("HANDLESTATE", (Object)"handled");
                } else if ("forceReject".equals(type)) {
                    d.set("HANDLESTATE", (Object)type);
                }
                if (!isNeedQueryBusinessField || !WfUtils.isNotEmpty(entityNumber) && !WfUtils.isNotEmpty(billType)) continue;
                JSONObject json = (JSONObject)extendFieldJsonMap.get(separateStorageKey);
                if (json == null) {
                    json = TaskExtendFieldUtil.getTaskBusinessSelectFields(EntityNumberConstant.getHiCommentEntityNumber(separateStorageKey), billEntityNumber, masterTableAlias, multiLangTableAlias, "f");
                    extendFieldJsonMap.put(separateStorageKey, json);
                }
                if (!json.getJSONObject("fieldRelateFormatField").isEmpty()) {
                    for (Map.Entry property : json.getJSONObject("fieldRelateFormatField").entrySet()) {
                        if (!d.containsProperty((String)property.getKey())) continue;
                        d.set((String)property.getValue(), d.get((String)property.getKey()));
                    }
                }
                if (!d.containsProperty("bizformat") || !StringUtils.isNotBlank((CharSequence)d.getString("bizformat"))) continue;
                if (formatObject == null) {
                    formatObject = InteServiceHelper.getUserFormat((Long)RequestContext.get().getCurrUserId());
                }
                TaskExtendFieldUtil.formatTaskBusinessFieldVlue(d, json.getJSONObject("fieldRelateFormatField"), formatObject);
            }
            Iterator iterator = ret;
            return iterator;
        }
    }

    private long getHandledTasksCountByAssigneeidAndSingleRelationQuery(String uid, String billType, String entityNumber, String filterSql, List<Object> paramsList) {
        String hiCommentTableName = TableNameConstant.getHiCommentTableName();
        String hiCommentSplitTableName = String.format("%s_A", hiCommentTableName);
        String hiCommentMultiLTableName = String.format("%s_l", hiCommentTableName);
        String noCodeFlow = ThreadLocalVariables.get();
        StringBuilder sql = new StringBuilder();
        sql.append("select count(1) count from ").append(hiCommentTableName).append(" a ");
        sql.append("LEFT JOIN ").append(hiCommentSplitTableName).append(" f on a.fid = f.fid ");
        sql.append("INNER JOIN ").append(hiCommentMultiLTableName).append(" b ON a.FID = b.FID and b.flocaleid = ? ");
        sql.append("where a.fuserid=? ");
        sql.append("and a.ftype in ('message','comment','forceReject','coordinate', 'converted', 'event') ");
        sql.append("and a.fexecutiontype in ('byHand','byExpireAuto','skip','forceReject','jump','enterBoundary','frozen','abandon','cancel','addSignBefore','compensation','manualdraw','manualpush', ' ') ");
        sql.append("and a.fisdisplay = '1' and a.fendtype != 'mobile' ");
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(RequestContext.get().getLang().toString());
        params.add(Long.valueOf(uid));
        if (WfUtils.isNotEmpty(entityNumber)) {
            sql.append("and a.fentitynumber=? ");
            params.add(entityNumber);
        }
        if (WfUtils.isNotEmpty(noCodeFlow)) {
            sql.append("and a.fprocesstype=? ");
            params.add(noCodeFlow);
        }
        if (WfUtils.isNotEmpty(billType)) {
            sql.append("and a.fbilltype=? ");
            params.add(billType);
        }
        if (WfUtils.isNotEmpty(filterSql)) {
            sql.append(filterSql);
            params.addAll(paramsList);
        }
        long count = 0L;
        try (DataSet ds = DB.queryDataSet((String)"WFTASK.hitasksCount", (DBRoute)WfUtils.WFS, (String)sql.toString(), (Object[])params.toArray());){
            Iterator iter = ds.iterator();
            if (iter.hasNext()) {
                count = ((Row)iter.next()).getLong("count");
            }
        }
        return count;
    }

    private long getHandledTasksUnionCountByAssigneeidAndSingleRelationQuery(String uid, String billType, String entityNumber, String filterSql, List<Object> paramsList) {
        long count = 0L;
        try (DataSet ds = this.historicTaskInstanceCollector.getHandledTasksUnionCountByAssigneeidAndSingleRelationQuery(uid, billType, entityNumber, filterSql, paramsList);){
            Iterator iter = ds.iterator();
            while (iter.hasNext()) {
                count += ((Row)iter.next()).getLong("count").longValue();
            }
        }
        return count;
    }

    private DynamicObjectCollection getTransferHandledTasksBySingleRelationQuery(String uid, int start, int limit, String filterSql, List<Object> paramsList, String orderBy) {
        String lang = RequestContext.get().getLang().toString();
        String masterTableAlias = "a";
        String multiLangTableAlias = "b";
        String sourceNameSQL = WfMultiLangUtils.getGeneralLangSQL("wf_hicomment", masterTableAlias, multiLangTableAlias, "fsourcename", "sourcename", "sourcename");
        String entityNameSQL = WfMultiLangUtils.getGeneralLangSQL("wf_hicomment", masterTableAlias, multiLangTableAlias, "fentityname", "entityname", "entityname");
        String startNameSQL = WfMultiLangUtils.getGeneralLangSQL("wf_hicomment", masterTableAlias, multiLangTableAlias, "FSTARTNAME", "startname", "startname");
        String subjectSQL = WfMultiLangUtils.getGeneralLangSQL("wf_hicomment", masterTableAlias, multiLangTableAlias, "fcurrentsubject", "SUBJECT", "currentsubject");
        String nameSQL = WfMultiLangUtils.getGeneralLangSQL("wf_hicomment", masterTableAlias, multiLangTableAlias, "FACTIVITYNAME", "NAME", "activityname");
        String senderNameSQL = WfMultiLangUtils.getGeneralLangSQL("wf_hicomment", masterTableAlias, multiLangTableAlias, "fassignee", "sendername", "assignee");
        String startNameFormatSQL = WfMultiLangUtils.getGeneralLangSQL("wf_hicomment", masterTableAlias, multiLangTableAlias, "fstartnameformat", "startnameformat", "startnameformat");
        String presentAssigneeSQL = WfMultiLangUtils.getGeneralLangSQL("wf_hicomment", masterTableAlias, multiLangTableAlias, "fpresentassignee", "presentassignee", "presentassignee");
        String currentSubjectSQL = WfMultiLangUtils.getGeneralLangSQL("wf_taskhandlelog", "c", "e", "fcurrentsubject", "currentsubject", "currentsubject");
        ArrayList<Object> params = new ArrayList<Object>();
        Long userId = Long.parseLong(uid);
        StringBuilder sql = new StringBuilder();
        sql.append("select top ").append(start + limit).append(" ");
        sql.append("a.ftaskid id, a.fbillno billno, a.fhandlestate handlestate, a.ftime endtime, c.ftype type, c.fcreatedate createdate, ");
        sql.append(sourceNameSQL).append(", ").append(entityNameSQL).append(", ").append(startNameSQL).append(", ");
        sql.append(startNameFormatSQL).append(", ").append(subjectSQL).append(", ").append(nameSQL).append(", ");
        sql.append(senderNameSQL).append(", ").append(presentAssigneeSQL).append(", ").append(currentSubjectSQL).append(" ");
        sql.append("from t_wf_taskhandlelog c ");
        sql.append("inner join t_wf_taskhandlelog_l e on c.fownerid = ? and c.fisadminforward = '0' and c.ftype = 'transfer' and c.fid = e.fid and e.flocaleid = ? ");
        sql.append("inner join t_wf_hicomment a on c.ftaskid = a.ftaskid ");
        sql.append("inner join t_wf_hicomment_l b on a.fid = b.fid and b.flocaleid = ? ");
        sql.append("where c.fownerid = ? and c.fisadminforward = '0' and c.ftype = 'transfer' ");
        sql.append("and a.fexecutiontype = 'byHand' and a.fendtype != 'mobile' and a.fprocesstype != ? ");
        params.addAll(Arrays.asList(userId, lang, lang, userId, ModelType.NoCodeFlow.name()));
        if (WfUtils.isNotEmpty(filterSql)) {
            sql.append(filterSql);
            params.addAll(paramsList);
        }
        sql.append(" order by ");
        if (WfUtils.isNotEmpty(orderBy)) {
            sql.append(orderBy).append(", ");
        }
        sql.append("a.fid desc;");
        try (DataSet ds = DB.queryDataSet((String)"WfTaskCenterCustom.queryGridData", (DBRoute)WfUtils.WFS, (String)sql.toString(), (Object[])params.toArray());){
            DynamicObjectCollection ret = ORM.create().toPlainDynamicObjectCollection(ds, start, limit);
            if (ret == null || ret.size() == 0) {
                DynamicObjectCollection dynamicObjectCollection = ret;
                return dynamicObjectCollection;
            }
            DynamicObjectCollection col = new DynamicObjectCollection();
            HashMap<Long, Integer> p = new HashMap<Long, Integer>();
            boolean isDisplaySetting = WfConfigurationUtil.isDisplaySetting();
            for (int i = 0; i < ret.size(); ++i) {
                DynamicObject dyObject = (DynamicObject)ret.get(i);
                Long taskId = dyObject.getLong("id");
                Object indexTemp = p.get(taskId);
                String startNameFormat = dyObject.getString("startnameformat");
                if (isDisplaySetting && WfUtils.isNotEmpty(startNameFormat)) {
                    dyObject.set("startname", (Object)startNameFormat);
                }
                if (indexTemp != null) {
                    Integer index;
                    Date dateInMap;
                    Date dateOfCurrent = dyObject.getDate("createdate");
                    if (!dateOfCurrent.after(dateInMap = ((DynamicObject)col.get((index = Integer.valueOf(String.valueOf(p.get(taskId)))).intValue())).getDate("createdate"))) continue;
                    col.remove(index.intValue());
                    col.add((Object)dyObject);
                    continue;
                }
                col.add((Object)dyObject);
                p.put(taskId, col.size() - 1);
            }
            DynamicObjectCollection dynamicObjectCollection = col;
            return dynamicObjectCollection;
        }
    }

    private int getTransferHandledTasksCountBySingleRelationQuery(String uid, String filterSql, List<Object> paramsList) {
        ArrayList<Object> params = new ArrayList<Object>();
        StringBuilder sql = new StringBuilder();
        sql.append("select count(1) count ");
        sql.append("from t_wf_taskhandlelog c ");
        sql.append("inner join t_wf_hicomment a on c.ftaskid = a.ftaskid and c.fownerid = ? and c.fisadminforward = '0' and c.ftype = 'transfer' ");
        sql.append("left join t_wf_hicomment_l b on a.fid = b.fid and b.flocaleid = ? ");
        sql.append("where a.fexecutiontype = 'byHand' AND a.fendtype != 'mobile' and a.fprocesstype != ? ");
        params.add(Long.valueOf(uid));
        params.add(RequestContext.get().getLang().toString());
        params.add(ModelType.NoCodeFlow.name());
        if (WfUtils.isNotEmpty(filterSql)) {
            sql.append(filterSql);
            params.addAll(paramsList);
        }
        int count = 0;
        try (DataSet ds = DB.queryDataSet((String)"wf_toHandle_transfer_count", (DBRoute)WfUtils.WFS, (String)sql.toString(), (Object[])params.toArray());){
            Iterator iter = ds.iterator();
            if (iter.hasNext()) {
                Row row = (Row)iter.next();
                count = row.getInteger("count");
            }
        }
        return count;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DynamicObjectCollection getHandledTaskByFolderIdAndSingleRelationQuery(Long folderId, int start, int limit, String filterSql, List<Object> paramsList, String orderBy) {
        try (DataSet ds = this.historicTaskInstanceCollector.getHandledTaskByFolderIdAndSingleRelationQuery(folderId, start, limit, filterSql, paramsList, orderBy);){
            DynamicObjectCollection ret = ORM.create().toPlainDynamicObjectCollection(ds);
            boolean isDisplaySetting = WfConfigurationUtil.isDisplaySetting();
            for (DynamicObject dynamicObject : ret) {
                if (dynamicObject != null && isDisplaySetting && WfUtils.isNotEmpty(dynamicObject.getString("startnameformat"))) {
                    dynamicObject.set("startname", (Object)dynamicObject.getString("startnameformat"));
                }
                if (dynamicObject == null || !isDisplaySetting || !WfUtils.isNotEmpty(dynamicObject.getString("sendernameformat"))) continue;
                dynamicObject.set("sendername", (Object)dynamicObject.getString("sendernameformat"));
            }
            Iterator iterator = ret;
            return iterator;
        }
        catch (Exception e) {
            this.logger.info(String.format("getHandledTaskByFolderId has error: %s", WfUtils.getExceptionStacktrace(e)));
            return null;
        }
    }

    private long getHandledTaskCountByFolderIdAndSingleRelationQuery(long folderId, String filterSql, List<Object> paramsList) {
        long count = 0L;
        try (DataSet ds = this.historicTaskInstanceCollector.getHandledTaskCountByFolderIdAndSingleRelationQuery(folderId, filterSql, paramsList);){
            Iterator iter = ds.iterator();
            while (iter.hasNext()) {
                count += ((Row)iter.next()).getLong("count").longValue();
            }
        }
        catch (Exception e) {
            this.logger.info(String.format("getHandledTaskCountByFolderId has error: %s", WfUtils.getExceptionStacktrace(e)));
        }
        return count;
    }

    private DynamicObjectCollection getDelegateHandledTasksBySingleRelationQuery(String uid, int start, int limit, String filterSql, List<Object> paramsList, String orderBy) {
        ArrayList<Object> params = new ArrayList<Object>();
        String lang = RequestContext.get().getLang().toString();
        String masterTableAlias = "a";
        String multiLangTableAlias = "b";
        String sourceNameSQL = WfMultiLangUtils.getGeneralLangSQL("wf_hicomment", masterTableAlias, multiLangTableAlias, "fsourcename", "sourcename", "sourcename");
        String entityNameSQL = WfMultiLangUtils.getGeneralLangSQL("wf_hicomment", masterTableAlias, multiLangTableAlias, "fentityname", "entityname", "entityname");
        String startNameSQL = WfMultiLangUtils.getGeneralLangSQL("wf_hicomment", masterTableAlias, multiLangTableAlias, "fstartname", "startname", "startname");
        String subjectSQL = WfMultiLangUtils.getGeneralLangSQL("wf_hicomment", masterTableAlias, multiLangTableAlias, "fcurrentsubject", "subject", "currentsubject");
        String nameSQL = WfMultiLangUtils.getGeneralLangSQL("wf_hicomment", masterTableAlias, multiLangTableAlias, "factivityname", "name", "activityname");
        String senderNameSQL = WfMultiLangUtils.getGeneralLangSQL("wf_hicomment", masterTableAlias, multiLangTableAlias, "fsendername", "sendername", "sendername");
        String userNameFormatSql = WfMultiLangUtils.getGeneralLangSQL("wf_hicomment", masterTableAlias, multiLangTableAlias, "fusernameformatter", "usernameformatter", "usernameformatter");
        String startNameFormatSQL = WfMultiLangUtils.getGeneralLangSQL("wf_hicomment", masterTableAlias, multiLangTableAlias, "fstartnameformat", "startnameformat", "startnameformat");
        String senderNameFormatSQL = WfMultiLangUtils.getGeneralLangSQL("wf_hicomment", masterTableAlias, multiLangTableAlias, "fsendernameformat", "sendernameformat", "sendernameformat");
        String presentAssigneeSQL = WfMultiLangUtils.getGeneralLangSQL("wf_hicomment", masterTableAlias, multiLangTableAlias, "fpresentassignee", "presentassignee", "presentassignee");
        StringBuilder sql = new StringBuilder();
        sql.append("select top ").append(start + limit).append(" a.ftaskid id,a.fbillno billno,a.fhandlestate handlestate,");
        sql.append(sourceNameSQL).append(", ").append(entityNameSQL).append(",").append(startNameSQL).append(",").append(subjectSQL).append(",").append(nameSQL).append(",");
        sql.append(senderNameSQL).append(",").append(userNameFormatSql).append(",").append(startNameFormatSQL).append(",").append(senderNameFormatSQL).append(",").append(presentAssigneeSQL).append(",").append("a.ftime endtime,a.fassignee trustee,a.fcreatedate createdate ");
        sql.append("from t_wf_hicomment a ");
        sql.append("inner join t_wf_hicomment_l b on a.fid = b.fid and b.flocaleid = ? ");
        sql.append("where a.fownerid = ? ");
        sql.append("and a.ftype in ('message','comment','coordinate','converted','event','sugesstion') ");
        sql.append("and a.fexecutiontype = 'byHand' ");
        sql.append("and a.fdelegateid > 0 AND a.fendtype != 'mobile' and a.fprocesstype != ? ");
        params.add(lang);
        params.add(Long.parseLong(uid));
        params.add(ModelType.NoCodeFlow.name());
        if (!WfUtils.isEmpty(filterSql)) {
            sql.append(filterSql);
            params.addAll(paramsList);
        }
        if (!WfUtils.isEmpty(orderBy)) {
            sql.append("order by ").append(orderBy);
        } else {
            sql.append("order by a.ftime desc");
        }
        try (DataSet ds = DB.queryDataSet((String)this.createAlgoKey(), (DBRoute)WfUtils.WFS, (String)sql.toString(), (Object[])params.toArray());){
            DynamicObjectCollection resultDynamicObjectCollection = ORM.create().toPlainDynamicObjectCollection(ds, start, limit);
            boolean isDisplaySetting = WfConfigurationUtil.isDisplaySetting();
            for (DynamicObject resultDynamicObject : resultDynamicObjectCollection) {
                if (resultDynamicObject != null && isDisplaySetting && WfUtils.isNotEmpty(resultDynamicObject.getString("startnameformat"))) {
                    resultDynamicObject.set("startname", (Object)resultDynamicObject.getString("startnameformat"));
                }
                if (resultDynamicObject != null && isDisplaySetting && WfUtils.isNotEmpty(resultDynamicObject.getString("usernameformatter")) && !"false".equals(resultDynamicObject.getString("usernameformatter"))) {
                    resultDynamicObject.set("trustee", (Object)resultDynamicObject.getString("usernameformatter"));
                }
                if (resultDynamicObject == null || !isDisplaySetting || !WfUtils.isNotEmpty(resultDynamicObject.getString("sendernameformat")) || "false".equals(resultDynamicObject.getString("sendernameformat"))) continue;
                resultDynamicObject.set("sendername", (Object)resultDynamicObject.getString("sendernameformat"));
            }
            Iterator iterator = resultDynamicObjectCollection;
            return iterator;
        }
    }

    private int getDelegateHandledTasksDataCountBySingleRelationQuery(String userId, String filterSql, List<Object> paramsList) {
        ArrayList<Object> params = new ArrayList<Object>();
        StringBuilder sql = new StringBuilder();
        sql.append(" select count(1) count from t_wf_hicomment a");
        if (filterSql.contains("b.")) {
            sql.append(" inner join t_wf_hicomment_l b on a.fid = b.fid and b.flocaleid = ? ");
            params.add(RequestContext.get().getLang().toString());
        }
        sql.append(" where a.fownerid = ? and a.ftype in ('message','comment','coordinate','converted','event','sugesstion') ");
        sql.append("and a.fexecutiontype = 'byHand' and a.fuserid > 0 and a.fdelegateid > 0 AND a.fendtype != 'mobile'  and a.fprocesstype != ? ");
        params.add(Long.parseLong(userId));
        params.add(ModelType.NoCodeFlow.name());
        if (!WfUtils.isEmpty(filterSql)) {
            sql.append(filterSql);
            params.addAll(paramsList);
        }
        int count = 0;
        try (DataSet ds = DB.queryDataSet((String)this.createAlgoKey(), (DBRoute)WfUtils.WFS, (String)sql.toString(), (Object[])params.toArray());){
            Iterator iter = ds.iterator();
            if (iter.hasNext()) {
                Row row = (Row)iter.next();
                count = row.getInteger("count");
            }
        }
        return count;
    }

    private DynamicObjectCollection getDelegateTasksBySingleRelationQuery(int start, int limit, String filterSql, List<Object> paramsList, String orderBy) {
        String lang = RequestContext.get().getLang().toString();
        String masterTableAlias = "a";
        String multiLangTableAlias = "b";
        String sourceNameSQL = WfMultiLangUtils.getGeneralLangSQL("wf_hicomment", masterTableAlias, multiLangTableAlias, "fsourcename", "sourcename", "sourcename");
        String entityNameSQL = WfMultiLangUtils.getGeneralLangSQL("wf_hicomment", masterTableAlias, multiLangTableAlias, "fentityname", "entityname", "entityname");
        String startNameSQL = WfMultiLangUtils.getGeneralLangSQL("wf_hicomment", masterTableAlias, multiLangTableAlias, "fstartname", "startname", "startname");
        String subjectSQL = WfMultiLangUtils.getGeneralLangSQL("wf_hicomment", masterTableAlias, multiLangTableAlias, "fcurrentsubject", "subject", "currentsubject");
        String nameSQL = WfMultiLangUtils.getGeneralLangSQL("wf_hicomment", masterTableAlias, multiLangTableAlias, "factivityname", "name", "activityname");
        String senderNameSQL = WfMultiLangUtils.getGeneralLangSQL("wf_hicomment", masterTableAlias, multiLangTableAlias, "fsendername", "sendername", "sendername");
        StringBuilder sql = new StringBuilder();
        sql.append("select distinct top ").append(start + limit).append(" ");
        sql.append("a.ftaskid id,a.fbillno billno,").append(sourceNameSQL).append(", ").append(entityNameSQL).append(",");
        sql.append(startNameSQL).append(",").append(subjectSQL).append(",").append("a.fhandlestate handlestate,");
        sql.append(nameSQL).append(",").append(senderNameSQL).append(",").append("a.fcreatedate createdate ").append(", ").append("a.fdelegateid delegateid ");
        sql.append("from t_wf_hicomment a ");
        sql.append("inner join t_wf_hicomment_l b on a.fid = b.fid and b.flocaleid = ? ");
        sql.append("where a.fdelegateid > 0 ");
        sql.append("and a.ftype in ('message','comment','coordinate','converted','event','sugesstion') ");
        sql.append("and a.fexecutiontype in ('byHand','byAuto','byExpireAuto','skip','jump','enterBoundary','frozen','abandon','cancel','addSignBefore','compensation', ' ') ");
        sql.append("and a.fisdisplay = '1' and a.fendtype != 'mobile' ");
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(lang);
        if (!WfUtils.isEmpty(filterSql)) {
            sql.append(filterSql).append(" ");
            params.addAll(paramsList);
        }
        if (WfUtils.isEmpty(orderBy)) {
            sql.append(" order by a.fcreatedate desc");
        } else {
            sql.append(" order by ").append(orderBy);
        }
        try (DataSet ds = DB.queryDataSet((String)this.createAlgoKey(), (DBRoute)WfUtils.WFS, (String)sql.toString(), (Object[])params.toArray());){
            DynamicObjectCollection dynamicObjectCollection = ORM.create().toPlainDynamicObjectCollection(ds, start, limit);
            return dynamicObjectCollection;
        }
    }

    private long getDelegateTasksDataCountBySingleRelationQuery(String filterSql, List<Object> paramsList) {
        StringBuilder sql = new StringBuilder();
        sql.append("select count(distinct a.fid) count ");
        sql.append("from t_wf_hicomment a ");
        sql.append("left join t_wf_hicomment_l b on b.fid = a.fid and b.flocaleid = ? ");
        sql.append("where a.fdelegateid > 0 ");
        sql.append("and a.ftype in ('message','comment','coordinate','converted','event','sugesstion') ");
        sql.append("and a.fexecutiontype in ('byHand','byExpireAuto','skip','jump','enterBoundary','frozen','abandon','cancel','addSignBefore','compensation', ' ') ");
        sql.append("and a.fisdisplay = '1' and a.fendtype != 'mobile' ");
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(RequestContext.get().getLang().toString());
        if (!WfUtils.isEmpty(filterSql)) {
            sql.append(filterSql).append(" ");
            params.addAll(paramsList);
        }
        long count = 0L;
        try (DataSet ds = DB.queryDataSet((String)this.createAlgoKey(), (DBRoute)WfUtils.WFS, (String)sql.toString(), (Object[])params.toArray());){
            Iterator iter = ds.iterator();
            if (iter.hasNext()) {
                count = ((Row)iter.next()).getLong("count");
            }
        }
        return count;
    }

    @Override
    public DynamicObjectCollection getNoCodeFlowHandledTasksByAssigneeid(String uid, String billType, String entityNumber, int start, int limit, String filterSql, String showType, List<Object> paramsList, String orderBy) {
        String lang = RequestContext.get().getLang().toString();
        String endType = "";
        if ("mobile".equals(showType)) {
            endType = "pc";
        } else if ("pc".equals(showType)) {
            endType = "mobile";
        }
        boolean flag = WfUtils.isEmpty(entityNumber);
        String masterTableAlias = "a";
        String multiLangTableAlias = "b";
        String masterTableHicommentAlias = "d";
        String multiLangTableHicommentAlias = "e";
        String noCodeHiTaskInstEntityNumber = EntityNumberConstant.getHiTaskInstEntityNumber(SeparateStorageType.NOCODE.getKey());
        String sourceNameSQL = WfMultiLangUtils.getGeneralLangSQL(noCodeHiTaskInstEntityNumber, masterTableAlias, multiLangTableAlias, "fsourcename", "sourcename", "sourcename");
        String entityNameSQL = WfMultiLangUtils.getGeneralLangSQL(noCodeHiTaskInstEntityNumber, masterTableAlias, multiLangTableAlias, "fentityname", "entityname", "entityname");
        String startNameSQL = WfMultiLangUtils.getGeneralLangSQL(noCodeHiTaskInstEntityNumber, masterTableAlias, multiLangTableAlias, "FSTARTNAME", "startname", "startname");
        String subjectSQL = WfMultiLangUtils.getGeneralLangSQL(noCodeHiTaskInstEntityNumber, masterTableAlias, multiLangTableAlias, "FSUBJECT", "subject", "subject");
        String nameSQL = WfMultiLangUtils.getGeneralLangSQL(noCodeHiTaskInstEntityNumber, masterTableAlias, multiLangTableAlias, "FNAME", "activityName", "name");
        String senderNameSQL = WfMultiLangUtils.getGeneralLangSQL(noCodeHiTaskInstEntityNumber, masterTableAlias, multiLangTableAlias, "fsendername", "sendername", "sendername");
        String senderNameFormatSQL = WfMultiLangUtils.getGeneralLangSQL("wf_task", masterTableAlias, multiLangTableAlias, "fsendernameformat", "sendernameformat", "sendernameformat");
        String startNameFormatSQL = WfMultiLangUtils.getGeneralLangSQL("wf_task", masterTableAlias, multiLangTableAlias, "fstartnameformat", "startnameformat", "startnameformat");
        String presentAssigneeSQL = WfMultiLangUtils.getGeneralLangSQL(noCodeHiTaskInstEntityNumber, masterTableAlias, multiLangTableAlias, "fpresentassignee", "presentassignee", "presentassignee");
        String resultNameSQL = WfMultiLangUtils.getGeneralLangSQL(EntityNumberConstant.getHiCommentEntityNumber(SeparateStorageType.NOCODE.getKey()), masterTableHicommentAlias, multiLangTableHicommentAlias, "fresultname", "resultName", "resultname");
        String sql = "SELECT top " + (start + limit) + " a.fid id,a.fbusinesskey businesskey,a.fstarterid startUserId," + startNameSQL + ",a.fbusinesskey startUserImgUrl,a.fhandlestate handlestate," + sourceNameSQL + "," + entityNameSQL + ",a.fentitynumber entityNumber,a.fprocinstid procInstId,a.fprocdefid procDefId,a.fbusinesskey procDefName,a.fcreatedate createDate," + senderNameSQL + "," + senderNameFormatSQL + "," + startNameFormatSQL + ",a.fbillno billno,a.fcategory category,d.fresultnumber resultNumber," + resultNameSQL + "," + nameSQL + "," + subjectSQL + ",d.ftype d_type,d.FTIME ENDTIME, " + presentAssigneeSQL + ",a.ftaskdefkey activityId,a.fexecutionid executionId,'' nodeBusinessKey,'' nodeEntityNumber,a.fendtime  FROM " + TableNameConstant.getHiCommentTableName(SeparateStorageType.NOCODE.getKey()) + " d LEFT JOIN " + TableNameConstant.getHiCommentTableName(SeparateStorageType.NOCODE.getKey()) + "_l e on d.fid = e.fid and e.flocaleid = ? and d.FUSERID = ? and d.ftype != 'suggestion' INNER JOIN " + TableNameConstant.getHiTaskInstTableName(SeparateStorageType.NOCODE.getKey()) + " a ON a.fid = d.FTASKID LEFT JOIN " + TableNameConstant.getHiTaskInstTableName(SeparateStorageType.NOCODE.getKey()) + "_A f ON a.fid = f.fid INNER JOIN " + TableNameConstant.getHiTaskInstTableName(SeparateStorageType.NOCODE.getKey()) + "_l b ON a.FID = b.FID AND b.FLOCALEID = ? where d.FUSERID = ? and d.ftype != 'suggestion' and a.FEXECUTIONTYPE != ? and a.FISDISPLAY = '1'" + (WfUtils.isEmpty(endType) ? "" : " AND a.fendtype != ? ") + (WfUtils.isEmpty(billType) ? "" : " AND a.fbilltype = ? ") + (flag ? "" : "and a.fentitynumber=? ") + " and a.fprocesstype = ? " + (WfUtils.isNotEmpty(filterSql) ? " " + filterSql : " ") + " order by " + (WfUtils.isEmpty(orderBy) ? "" : orderBy + ",") + " d.FTIME desc";
        ArrayList<Object> params = new ArrayList<Object>();
        params.addAll(Arrays.asList(lang, Long.valueOf(uid), lang, Long.valueOf(uid), "byAuto"));
        if (WfUtils.isNotEmpty(endType)) {
            params.add(endType);
        }
        if (WfUtils.isNotEmpty(billType)) {
            params.add(billType);
        }
        if (!flag) {
            params.add(entityNumber);
        }
        params.add(ModelType.NoCodeFlow.name());
        params.addAll(paramsList);
        try (DataSet ds = DB.queryDataSet((String)"WfTaskCenter.wf_task.queryGridData", (DBRoute)WfUtils.WFS, (String)sql, (Object[])params.toArray());){
            DynamicObjectCollection ret = ORM.create().toPlainDynamicObjectCollection(ds, start, limit);
            HashSet<Long> procDefIds = new HashSet<Long>(ret.size());
            HashSet<Long> startUserIds = new HashSet<Long>(ret.size());
            ArrayList<Long> coordinateTaskIds = new ArrayList<Long>();
            for (DynamicObject dyObject : ret) {
                procDefIds.add(dyObject.getLong("procDefId"));
                startUserIds.add(dyObject.getLong("startUserId"));
                if (!"coordinate".equals(dyObject.getString("d_type"))) continue;
                coordinateTaskIds.add(dyObject.getLong("id"));
            }
            Map<Long, String> procdefMap = ProcessAssistantUtil.getProcdefNameByProcdefId(procDefIds);
            Map<String, UserInfo> userInfoMap = ProcessAssistantUtil.queryUserInfos(startUserIds);
            HashMap<String, DynamicObject> coordinateTaskInfos = new HashMap<String, DynamicObject>(coordinateTaskIds.size());
            if (CollectionUtils.isNotEmpty(coordinateTaskIds)) {
                QFilter q1 = new QFilter("type", "=", (Object)"coordinate");
                QFilter q2 = new QFilter("taskid", "in", coordinateTaskIds);
                QFilter q3 = new QFilter("userid", "=", (Object)Long.valueOf(uid));
                DynamicObject[] hiparticipants = BusinessDataServiceHelper.load((String)EntityNumberConstant.getHiIdentityLinkEntityNumber(SeparateStorageType.NOCODE.getKey()), (String)"id,taskid,createdate", (QFilter[])new QFilter[]{q1, q2, q3});
                if (hiparticipants != null && hiparticipants.length > 0) {
                    for (DynamicObject hiparticipant : hiparticipants) {
                        coordinateTaskInfos.put(hiparticipant.getString("taskid"), hiparticipant);
                    }
                }
            }
            for (DynamicObject d : ret) {
                String d_type;
                if (coordinateTaskInfos.get(d.getString("id")) != null) {
                    d.set("createdate", ((DynamicObject)coordinateTaskInfos.get(d.getString("id"))).get("createdate"));
                }
                if ("coordinate".equals(d_type = d.getString("d_type"))) {
                    d.set("HANDLESTATE", (Object)"handled");
                } else if ("forceReject".equals(d_type)) {
                    d.set("HANDLESTATE", (Object)d_type);
                }
                if (WfUtils.isNotEmptyForMap(procdefMap)) {
                    d.set("procDefName", (Object)procdefMap.get(d.getLong("procDefId")));
                }
                Long startUserId = d.getLong("startUserId");
                if (WfUtils.isNotEmptyForMap(userInfoMap) && WfUtils.isNotEmpty(startUserId)) {
                    UserInfo userInfo = userInfoMap.get(startUserId.toString());
                    d.set("startUserImgUrl", (Object)(userInfo != null ? userInfo.getImgUrl() : ""));
                }
                if (!"UserTask".equalsIgnoreCase(d.getString("category"))) continue;
                d.set("nodeBusinessKey", d.get("businessKey"));
                d.set("nodeEntityNumber", d.get("entityNumber"));
                HistoricProcessInstanceEntity hisProcInstEntity = (HistoricProcessInstanceEntity)this.getHistoricProcessInstanceEntityManager().findById(d.getLong("procInstId"));
                if (hisProcInstEntity == null) continue;
                d.set("businessKey", (Object)hisProcInstEntity.getBusinessKey());
                d.set("entityNumber", (Object)hisProcInstEntity.getEntitynumber());
            }
            Iterator iterator = ret;
            return iterator;
        }
    }

    @Override
    public DynamicObjectCollection getHandledTasks(EntityQueryParams entityQueryParams) {
        try (DataSet ds = this.historicTaskInstanceCollector.getHandledTasks(entityQueryParams);){
            if (ds == null) {
                DynamicObjectCollection dynamicObjectCollection = new DynamicObjectCollection(new DynamicObjectType("PlainObject"), null);
                return dynamicObjectCollection;
            }
            DynamicObjectCollection dynamicObjectCollection = ORM.create().toPlainDynamicObjectCollection(ds);
            return dynamicObjectCollection;
        }
    }

    @Override
    public Long getHandledTaskCount(EntityQueryParams entityQueryParams) {
        return this.historicTaskInstanceCollector.getHandledTaskCount(entityQueryParams);
    }

    @Override
    public DynamicObjectCollection getTransferTasks(EntityQueryParams entityQueryParams) {
        String queryFields = entityQueryParams.getMainEntityQueryParams().getQueryALLFields();
        QFilter[] qFilters = this.buildTransferQfilter(entityQueryParams);
        StringBuilder order = new StringBuilder();
        String orderby = entityQueryParams.getMainEntityQueryParams().getOrderBySql();
        if (WfUtils.isNotEmpty(orderby)) {
            order.append(orderby);
        } else {
            order.append("taskid desc");
        }
        try (DataSet ds = ORM.create().queryDataSet("algoKey", "wf_taskhandlelog", queryFields, qFilters, order.toString(), entityQueryParams.getStart(), entityQueryParams.getLimit());){
            DynamicObjectCollection resultDynamicObjectCollection;
            DynamicObjectCollection dynamicObjectCollection = resultDynamicObjectCollection = ORM.create().toPlainDynamicObjectCollection(ds);
            return dynamicObjectCollection;
        }
    }

    @Override
    public Long getTransferTaskCount(EntityQueryParams entityQueryParams) {
        QFilter[] qFilters = this.buildTransferQfilter(entityQueryParams);
        return ORM.create().count("algoKey-getTransferTaskCount", "wf_taskhandlelog", qFilters);
    }

    private QFilter[] buildTransferQfilter(EntityQueryParams entityQueryParams) {
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>();
        QFilter qFilter = new QFilter("ownerid", "=", (Object)entityQueryParams.getUserId()).and(new QFilter("type ", "=", (Object)"transfer")).and(new QFilter("executiontype", "=", (Object)"byHand")).and(new QFilter("isadminforward ", "=", (Object)"0")).and(new QFilter("endtime", "is not null", null)).and(new QFilter("processtype ", "!=", (Object)ModelType.NoCodeFlow.name())).and(new QFilter("endtype", "!=", (Object)"mobile"));
        qFilterList.add(qFilter);
        List<QFilter> params = entityQueryParams.getMainEntityQueryParams().getQFilter();
        if (params != null && params.size() > 0) {
            qFilterList.addAll(params);
        }
        return (QFilter[])qFilterList.stream().toArray(QFilter[]::new);
    }

    @Override
    public DynamicObjectCollection getDelegateTasks(EntityQueryParams entityQueryParams) {
        String queryFields = entityQueryParams.getMainEntityQueryParams().getQueryALLFields();
        QFilter[] qFilters = null;
        if (WfUtils.isNotEmpty(entityQueryParams.getUserId()) || WfUtils.isEmpty(entityQueryParams.getUserId()) && this.isQueryDelegate(entityQueryParams.getMainEntityQueryParams().getQFilter())) {
            qFilters = this.buildDelegateQfilter(entityQueryParams);
        }
        if (qFilters == null) {
            return null;
        }
        String mainOrderBy = entityQueryParams.getMainEntityQueryParams().getOrderBySql();
        StringBuilder order = new StringBuilder();
        if (WfUtils.isNotEmpty(mainOrderBy)) {
            order.append(mainOrderBy);
        } else {
            order.append("createdate desc");
        }
        try (DataSet ds = ORM.create().queryDataSet("algoKey", "wf_hicomment", queryFields, qFilters, order.toString(), entityQueryParams.getStart(), entityQueryParams.getLimit());){
            DynamicObjectCollection resultDynamicObjectCollection;
            DynamicObjectCollection dynamicObjectCollection = resultDynamicObjectCollection = ORM.create().toPlainDynamicObjectCollection(ds);
            return dynamicObjectCollection;
        }
    }

    @Override
    public Long getDelegateTaskCount(EntityQueryParams entityQueryParams) {
        QFilter[] qFilters = null;
        if (WfUtils.isNotEmpty(entityQueryParams.getUserId()) || WfUtils.isEmpty(entityQueryParams.getUserId()) && this.isQueryDelegate(entityQueryParams.getMainEntityQueryParams().getQFilter())) {
            qFilters = this.buildDelegateQfilter(entityQueryParams);
        }
        if (qFilters == null) {
            return 0L;
        }
        return ORM.create().count("algoKey-getdelegatehandled", "wf_hicomment", qFilters);
    }

    private QFilter[] buildDelegateQfilter(EntityQueryParams entityQueryParams) {
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>();
        Long userId = entityQueryParams.getUserId();
        ArrayList<String> type = new ArrayList<String>();
        type.add("message");
        type.add("comment");
        type.add("sugesstion");
        type.add("coordinate");
        type.add("converted");
        type.add("event");
        type.add("forceReject");
        List<QFilter> mainFilter = entityQueryParams.getMainEntityQueryParams().getQFilter();
        if (WfUtils.isNotEmpty(entityQueryParams.getUserId())) {
            QFilter qFilter = new QFilter("ownerid", "=", (Object)userId).and(new QFilter("type", "in", type)).and(new QFilter("executiontype", "=", (Object)"byHand")).and(new QFilter("delegateid", ">", (Object)0)).and(new QFilter("processtype ", "!=", (Object)ModelType.NoCodeFlow.name())).and(new QFilter("display", "=", (Object)"1")).and(new QFilter("endtype", "!=", (Object)"mobile"));
            qFilterList.add(qFilter);
            if (mainFilter != null && mainFilter.size() > 0) {
                qFilterList.addAll(mainFilter);
            }
        } else {
            ArrayList<String> executionType = new ArrayList<String>();
            executionType.add("byHand");
            executionType.add("byExpireAuto");
            executionType.add("skip");
            executionType.add("forceReject");
            executionType.add("jump");
            executionType.add("enterBoundary");
            executionType.add("frozen");
            executionType.add("abandon");
            executionType.add("cancel");
            executionType.add("addSignBefore");
            executionType.add("compensation");
            QFilter qFilter = new QFilter("type", "in", type).and(new QFilter("executiontype", "in", executionType)).and(new QFilter("display", "=", (Object)"1")).and(new QFilter("endtype", "!=", (Object)"mobile"));
            for (int i = 0; i < mainFilter.size(); ++i) {
                qFilterList.add(mainFilter.get(i));
                if (i != 0) continue;
                qFilterList.add(qFilter);
            }
        }
        return (QFilter[])qFilterList.stream().toArray(QFilter[]::new);
    }

    private boolean isQueryDelegate(List<QFilter> qFilters) {
        for (QFilter qFilter : qFilters) {
            QFilter[] q = qFilter.recombine();
            for (int i = 0; i < q.length; ++i) {
                if (q[i].getProperty().equals("delegateid")) {
                    return true;
                }
                List re = q[i].getNests(false);
                if (re == null || re.size() <= 0) continue;
                for (QFilter.QFilterNest filter : re) {
                    if (!filter.getFilter().getProperty().equals("delegateid")) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public HistoricTaskInstanceEntity findRecentlyParentTaskByActId(Long procInstId, String actId) {
        if (WfUtils.isEmpty(procInstId) || WfUtils.isEmpty(actId)) {
            return null;
        }
        EntityQueryBuilder queryBuilder = this.createQueryBuilder();
        queryBuilder.addFilter("processInstanceId", "=", procInstId);
        queryBuilder.addFilter("taskDefinitionKey", "=", actId);
        queryBuilder.addFilter("category", "=", "YunzhijiaTask");
        queryBuilder.addFilter("parentTaskId", "=", 0L);
        queryBuilder.addFilter("endTime", "is not null", null);
        queryBuilder.setLimit(1).orderBy(String.format("%s desc", "endTime"));
        List list = this.findByQueryBuilder(queryBuilder);
        if (WfUtils.isEmptyForCollection(list)) {
            return null;
        }
        return (HistoricTaskInstanceEntity)this.findByQueryBuilder(queryBuilder).get(0);
    }
}

