/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.persistence.entity.history;

import java.util.List;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.db.EntityQueryBuilder;
import kd.bos.workflow.engine.impl.persistence.entity.AbstractEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricTrdDataSourceRecordEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricTrdDataSourceRecordEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricTrdDataSourceRecordEntityManager;

public class HistoricTrdDataSourceRecordEntityManagerImpl
extends AbstractEntityManager<HistoricTrdDataSourceRecordEntity>
implements HistoricTrdDataSourceRecordEntityManager {
    public HistoricTrdDataSourceRecordEntityManagerImpl(ProcessEngineConfigurationImpl processEngineConfiguration) {
        super(processEngineConfiguration);
    }

    @Override
    public Class<? extends HistoricTrdDataSourceRecordEntity> getManagedEntityClass() {
        return HistoricTrdDataSourceRecordEntityImpl.class;
    }

    @Override
    public String getSelectFields() {
        return "id,createdate,entitynumber,businesskey,processinstanceid,sourcetype,sourcedetailsjson";
    }

    @Override
    public String getEntityName() {
        return "wf_trddatasourcerecord";
    }

    @Override
    public String getTableName() {
        return "t_wf_trddatasourcerecord";
    }

    @Override
    public HistoricTrdDataSourceRecordEntity create(String entityNumber, String businessKey, Long procInstId, String sourceType, String sourceDetailsJson) {
        HistoricTrdDataSourceRecordEntity recordEntity = (HistoricTrdDataSourceRecordEntity)this.create();
        recordEntity.setEntityNumber(entityNumber);
        recordEntity.setBusinesskey(businessKey);
        recordEntity.setProcessInstanceId(procInstId);
        recordEntity.setSourceType(sourceType);
        recordEntity.setSourceDetailsJson(sourceDetailsJson);
        return recordEntity;
    }

    @Override
    public HistoricTrdDataSourceRecordEntity findLatestRecordByEntityNumberAndBusinessKey(String entityNumber, String businessKey) {
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter("businessKey", businessKey).addFilter("entitynumber", entityNumber).orderBy("createDate desc ");
        List list = this.findByQueryBuilder(eb);
        return list != null && !list.isEmpty() ? (HistoricTrdDataSourceRecordEntity)list.get(0) : null;
    }

    @Override
    public List<HistoricTrdDataSourceRecordEntity> findByProcessInstanceId(Long processInstanceId) {
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter("processInstanceId", processInstanceId);
        return this.findByQueryBuilder(eb);
    }

    @Override
    public void deleteHistoricTrdDataSourceRecordByProcessInstanceId(Long historicProcessInstanceId) {
        List<HistoricTrdDataSourceRecordEntity> list = this.findByProcessInstanceId(historicProcessInstanceId);
        for (HistoricTrdDataSourceRecordEntity entity : list) {
            this.delete(entity);
        }
    }
}

